/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.ide.ui.customization.NonCustomizableAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ActionUrl
implements JDOMExternalizable {
    public static final int ADDED = 1;
    public static final int DELETED = -1;
    public static final int MOVE = 2;
    @NonNls
    private static final String IS_GROUP = "is_group";
    @NonNls
    private static final String SEPARATOR = "seperator";
    @NonNls
    private static final String IS_ACTION = "is_action";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String ACTION_TYPE = "action_type";
    @NonNls
    private static final String POSITION = "position";
    @NonNls
    private static final String FORCE_POPUP = "forse_popup";
    private static final int TYPE_NONE = 0;
    private static final int TYPE_SEPARATOR = 1;
    private static final int TYPE_ACTION = 2;
    private static final int TYPE_GROUP = 3;
    private static final int TYPE_POPUP_GROUP = 4;
    @NotNull
    private ArrayList<String> myGroupPath;
    @Nullable
    private String myComponentId;
    private int myComponentType;
    @Nullable
    private Object myComponent;
    private int myActionType;
    private int myAbsolutePosition;
    private int myInitialPosition;

    public ActionUrl() {
        this.myInitialPosition = -1;
        this.myGroupPath = new ArrayList();
    }

    public ActionUrl(@NotNull ArrayList<String> groupPath, @Nullable Object component2, int actionType, int position) {
        if (groupPath == null) {
            ActionUrl.$$$reportNull$$$0(0);
        }
        this.myInitialPosition = -1;
        this.myGroupPath = groupPath;
        this.setComponent(component2);
        this.myActionType = actionType;
        this.myAbsolutePosition = position;
    }

    private ActionUrl(@NotNull ArrayList<String> groupPath, @Nullable String componentId, int componentType, @Nullable Object component2, int actionType, int absolutePosition, int initialPosition) {
        if (groupPath == null) {
            ActionUrl.$$$reportNull$$$0(1);
        }
        this.myInitialPosition = -1;
        this.myGroupPath = groupPath;
        this.myComponentId = componentId;
        this.myComponentType = componentType;
        this.myComponent = component2;
        this.myActionType = actionType;
        this.myAbsolutePosition = absolutePosition;
        this.myInitialPosition = initialPosition;
    }

    @NotNull
    public ArrayList<String> getGroupPath() {
        ArrayList<String> arrayList = this.myGroupPath;
        if (arrayList == null) {
            ActionUrl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void setGroupPath(@NotNull ArrayList<String> groupPath) {
        if (groupPath == null) {
            ActionUrl.$$$reportNull$$$0(3);
        }
        this.myGroupPath = groupPath;
    }

    public String getParentGroup() {
        return this.myGroupPath.get(this.myGroupPath.size() - 1);
    }

    public String getRootGroup() {
        return !this.myGroupPath.isEmpty() ? this.myGroupPath.get(1) : "";
    }

    @Nullable
    public String getComponentId() {
        return this.myComponentId;
    }

    @Nullable
    public Object getComponent() {
        if (this.myComponent != null || this.myComponentType == 0) {
            return this.myComponent;
        }
        switch (this.myComponentType) {
            case 1: {
                this.myComponent = Separator.getInstance();
                break;
            }
            case 2: {
                this.myComponent = this.myComponentId;
                break;
            }
            case 3: 
            case 4: {
                Group group2;
                Objects.requireNonNull(this.myComponentId);
                AnAction action2 = ActionManager.getInstance().getActionOrStub(this.myComponentId);
                if (action2 instanceof ActionGroup) {
                    ActionGroup o = (ActionGroup)action2;
                    group2 = ActionsTreeUtil.createGroup(o, true, null);
                } else {
                    group2 = new Group(this.myComponentId, this.myComponentId);
                }
                Group group3 = group2;
                group3.setForceShowAsPopup(this.myComponentType == 4);
                this.myComponent = group3;
            }
        }
        return this.myComponent;
    }

    public void setComponent(@Nullable Object c) {
        String o;
        Group o2;
        this.myComponent = c;
        int n = c instanceof Separator ? 1 : (c instanceof String || c instanceof AnAction ? 2 : (c instanceof Group ? ((o2 = (Group)c).isForceShowAsPopup() ? 4 : 3) : (this.myComponentType = 0)));
        this.myComponentId = c instanceof String ? (o = (String)c) : (c instanceof Group ? (StringUtil.isEmpty((String)(o2 = (Group)c).getId()) ? o2.getName() : o2.getId()) : null);
    }

    @Nullable
    public AnAction getComponentAction() {
        AnAction action2 = this.calculateComponentAction();
        return action2 instanceof NonCustomizableAction ? null : action2;
    }

    @Nullable
    private AnAction calculateComponentAction() {
        Object component2 = this.getComponent();
        if (component2 instanceof Separator) {
            Separator o = (Separator)component2;
            return o;
        }
        if (component2 instanceof String) {
            String o = (String)component2;
            return ActionManager.getInstance().getAction(o);
        }
        if (component2 instanceof Group) {
            Group o = (Group)component2;
            String id2 = o.getId();
            if (StringUtil.isEmpty((String)id2)) {
                return o.constructActionGroup(true);
            }
            return ActionManager.getInstance().getAction(id2);
        }
        return null;
    }

    public int getActionType() {
        return this.myActionType;
    }

    public void setActionType(int actionType) {
        this.myActionType = actionType;
    }

    public int getAbsolutePosition() {
        return this.myAbsolutePosition;
    }

    public void setAbsolutePosition(int absolutePosition) {
        this.myAbsolutePosition = absolutePosition;
    }

    public int getInitialPosition() {
        return this.myInitialPosition;
    }

    public void setInitialPosition(int initialPosition) {
        this.myInitialPosition = initialPosition;
    }

    public void readExternal(Element element) throws InvalidDataException {
        String actionTypeString;
        this.myGroupPath = new ArrayList();
        for (Element o : element.getChildren(PATH)) {
            this.myGroupPath.add(o.getAttributeValue(VALUE));
        }
        this.myComponentId = element.getAttributeValue(VALUE);
        int n = element.getAttributeValue(IS_ACTION) != null ? 2 : (element.getAttributeValue(SEPARATOR) != null ? 1 : (this.myComponentType = element.getAttributeValue(IS_GROUP) != null ? 3 : 0));
        if (this.myComponentType == 3 && Boolean.parseBoolean(element.getAttributeValue(FORCE_POPUP))) {
            this.myComponentType = 4;
        }
        this.myActionType = (actionTypeString = element.getAttributeValue(ACTION_TYPE)) == null ? -1 : Integer.parseInt(actionTypeString);
        this.myAbsolutePosition = Integer.parseInt(element.getAttributeValue(POSITION));
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (String s : this.myGroupPath) {
            Element path = new Element(PATH);
            path.setAttribute(VALUE, s);
            element.addContent(path);
        }
        switch (this.myComponentType) {
            case 1: {
                element.setAttribute(SEPARATOR, Boolean.TRUE.toString());
                break;
            }
            case 2: {
                element.setAttribute(VALUE, StringUtil.notNullize((String)this.myComponentId));
                element.setAttribute(IS_ACTION, Boolean.TRUE.toString());
                break;
            }
            case 3: 
            case 4: {
                element.setAttribute(VALUE, StringUtil.notNullize((String)this.myComponentId));
                element.setAttribute(IS_GROUP, Boolean.TRUE.toString());
                element.setAttribute(FORCE_POPUP, Boolean.toString(this.myComponentType == 4));
            }
        }
        element.setAttribute(ACTION_TYPE, Integer.toString(this.myActionType));
        element.setAttribute(POSITION, Integer.toString(this.myAbsolutePosition));
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    @NotNull
    public ActionUrl copy() {
        return new ActionUrl(new ArrayList<String>(this.myGroupPath), this.myComponentId, this.myComponentType, this.myComponent, this.myActionType, this.myAbsolutePosition, this.myInitialPosition);
    }

    @NotNull
    public ActionUrl getInverted() {
        ActionUrl copy = this.copy();
        if (this.myActionType == 1 || this.myActionType == -1) {
            copy.setActionType(-this.myActionType);
        } else {
            copy.setInitialPosition(this.myAbsolutePosition);
            copy.setAbsolutePosition(this.myInitialPosition);
        }
        ActionUrl actionUrl = copy;
        if (actionUrl == null) {
            ActionUrl.$$$reportNull$$$0(4);
        }
        return actionUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionUrl)) {
            return false;
        }
        ActionUrl url = (ActionUrl)o;
        return this.myComponentType == url.myComponentType && this.myActionType == url.myActionType && this.myAbsolutePosition == url.myAbsolutePosition && this.myInitialPosition == url.myInitialPosition && this.myGroupPath.equals(url.myGroupPath) && Objects.equals(this.myComponentId, url.myComponentId);
    }

    public int hashCode() {
        int result2 = this.myGroupPath.hashCode();
        result2 = 31 * result2 + Objects.hashCode(this.myComponentId);
        result2 = 31 * result2 + this.myComponentType;
        result2 = 31 * result2 + this.myActionType;
        result2 = 31 * result2 + this.myAbsolutePosition;
        result2 = 31 * result2 + this.myInitialPosition;
        return result2;
    }

    public String toString() {
        return "ActionUrl{myGroupPath=" + String.valueOf(this.myGroupPath) + ", myComponentId='" + this.myComponentId + "', myComponentType=" + this.myComponentType + ", myComponent=" + String.valueOf(this.myComponent) + ", myActionType=" + this.myActionType + ", myAbsolutePosition=" + this.myAbsolutePosition + ", myInitialPosition=" + this.myInitialPosition + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/customization/ActionUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/customization/ActionUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInverted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setGroupPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

