/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAnnouncingMode;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NotificationConfiguration", storages={@Storage(value="notifications.xml")}, category=SettingsCategory.UI)
public final class NotificationsConfigurationImpl
extends NotificationsConfiguration
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(NotificationsConfigurationImpl.class);
    private static final String SHOW_BALLOONS_ATTRIBUTE = "showBalloons";
    private static final String SYSTEM_NOTIFICATIONS_ATTRIBUTE = "systemNotifications";
    private static final String NOTIFICATION_ANNOUNCING_MODE_ATTRIBUTE = "notificationsAnnouncingMode";
    private static final Comparator<NotificationSettings> NOTIFICATION_SETTINGS_COMPARATOR = (o1, o2) -> o1.getGroupId().compareToIgnoreCase(o2.getGroupId());
    private final Map<String, NotificationSettings> myIdToSettingsMap = new HashMap<String, NotificationSettings>();
    private final Map<String, String> myToolWindowCapable = new HashMap<String, String>();
    public boolean SHOW_BALLOONS = true;
    public boolean SYSTEM_NOTIFICATIONS = true;
    private NotificationAnnouncingMode NOTIFICATION_ANNOUNCING_MODE;

    public static NotificationsConfigurationImpl getInstanceImpl() {
        return (NotificationsConfigurationImpl)NotificationsConfigurationImpl.getNotificationsConfiguration();
    }

    public synchronized boolean hasToolWindowCapability(@NotNull String groupId) {
        if (groupId == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(0);
        }
        return this.getToolWindowId(groupId) != null || this.myToolWindowCapable.containsKey(groupId);
    }

    @Nullable
    public String getToolWindowId(@NotNull String groupId) {
        NotificationGroup group2;
        if (groupId == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(1);
        }
        return (group2 = NotificationGroup.findRegisteredGroup((String)groupId)) == null ? null : group2.getToolWindowId();
    }

    public synchronized NotificationSettings[] getAllSettings() {
        HashSet<NotificationSettings> settings = new HashSet<NotificationSettings>(this.myIdToSettingsMap.values());
        for (NotificationGroup group2 : NotificationGroup.Companion.getAllRegisteredGroups()) {
            if (group2.getDisplayId().startsWith("LIGHTWEIGHT") || group2.isHideFromSettings()) continue;
            settings.add(NotificationsConfigurationImpl.getSettings(group2.getDisplayId()));
        }
        NotificationSettings[] result2 = settings.toArray(new NotificationSettings[0]);
        Arrays.sort(result2, NOTIFICATION_SETTINGS_COMPARATOR);
        return result2;
    }

    public static void remove(String ... toRemove) {
        NotificationsConfigurationImpl.getInstanceImpl().doRemove(toRemove);
    }

    private synchronized void doRemove(String ... toRemove) {
        for (String groupId : toRemove) {
            this.myIdToSettingsMap.remove(groupId);
            this.myToolWindowCapable.remove(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static NotificationSettings getSettings(@NotNull String groupId) {
        NotificationSettings settings;
        NotificationsConfigurationImpl impl;
        if (groupId == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(2);
        }
        NotificationsConfigurationImpl notificationsConfigurationImpl = impl = NotificationsConfigurationImpl.getInstanceImpl();
        synchronized (notificationsConfigurationImpl) {
            settings = impl.myIdToSettingsMap.get(groupId);
        }
        NotificationSettings notificationSettings = settings == null ? NotificationsConfigurationImpl.getDefaultSettings(groupId) : settings;
        if (notificationSettings == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(3);
        }
        return notificationSettings;
    }

    @NotNull
    private static NotificationSettings getDefaultSettings(String groupId) {
        NotificationGroup group2 = NotificationGroup.findRegisteredGroup((String)groupId);
        if (group2 != null) {
            return new NotificationSettings(groupId, group2.getDisplayType(), group2.isLogByDefault(), false);
        }
        return new NotificationSettings(groupId, NotificationDisplayType.BALLOON, true, false);
    }

    public synchronized void dispose() {
        this.myIdToSettingsMap.clear();
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(4);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(5);
        }
        this.register(groupDisplayName, displayType, true);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(6);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(7);
        }
        this.register(groupDisplayName, displayType, shouldLog, false);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(8);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(9);
        }
        this.register(groupDisplayName, displayType, shouldLog, shouldReadAloud, null);
    }

    public void register(@NotNull String groupDisplayName, @NotNull NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud, @Nullable String toolWindowId) {
        if (groupDisplayName == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(10);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(11);
        }
        if (!this.isRegistered(groupDisplayName)) {
            new NotificationGroup(groupDisplayName, displayType, shouldLog, toolWindowId);
            this.changeSettings(groupDisplayName, displayType, shouldLog, shouldReadAloud);
        } else if (displayType == NotificationDisplayType.TOOL_WINDOW && !this.hasToolWindowCapability(groupDisplayName)) {
            this.changeSettings(NotificationsConfigurationImpl.getSettings(groupDisplayName).withDisplayType(NotificationDisplayType.TOOL_WINDOW));
            this.myToolWindowCapable.put(groupDisplayName, null);
        }
    }

    public boolean areNotificationsEnabled() {
        return this.SHOW_BALLOONS;
    }

    @NotNull
    public NotificationAnnouncingMode getNotificationAnnouncingMode() {
        NotificationAnnouncingMode notificationAnnouncingMode = this.NOTIFICATION_ANNOUNCING_MODE != null ? this.NOTIFICATION_ANNOUNCING_MODE : NotificationAnnouncingMode.MEDIUM;
        if (notificationAnnouncingMode == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(12);
        }
        return notificationAnnouncingMode;
    }

    public void setNotificationAnnouncingMode(@NotNull NotificationAnnouncingMode mode) {
        if (mode == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(13);
        }
        this.NOTIFICATION_ANNOUNCING_MODE = mode;
    }

    @NotNull
    public NotificationDisplayType getDisplayType(@NotNull String groupId) {
        if (groupId == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(14);
        }
        NotificationDisplayType notificationDisplayType = NotificationsConfigurationImpl.getSettings(groupId).getDisplayType();
        if (notificationDisplayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(15);
        }
        return notificationDisplayType;
    }

    public void setDisplayType(@NotNull String groupId, @NotNull NotificationDisplayType displayType) {
        if (groupId == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(16);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(17);
        }
        this.changeSettings(NotificationsConfigurationImpl.getSettings(groupId).withDisplayType(displayType));
    }

    public void changeSettings(@NotNull String groupId, @NotNull NotificationDisplayType displayType, boolean shouldLog, boolean shouldReadAloud) {
        if (groupId == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(18);
        }
        if (displayType == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(19);
        }
        this.changeSettings(new NotificationSettings(groupId, displayType, shouldLog, shouldReadAloud));
    }

    public synchronized void changeSettings(@NotNull NotificationSettings settings) {
        String groupDisplayName;
        if (settings == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(20);
        }
        if (settings.equals(NotificationsConfigurationImpl.getDefaultSettings(groupDisplayName = settings.getGroupId()))) {
            this.myIdToSettingsMap.remove(groupDisplayName);
        } else {
            this.myIdToSettingsMap.put(groupDisplayName, settings);
        }
    }

    public synchronized boolean isRegistered(@NotNull String id2) {
        if (id2 == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(21);
        }
        return this.myIdToSettingsMap.containsKey(id2) || NotificationGroup.isGroupRegistered((String)id2);
    }

    public synchronized Element getState() {
        Element element = new Element("NotificationsConfiguration");
        NotificationSettings[] sortedNotifications = this.myIdToSettingsMap.values().toArray(new NotificationSettings[0]);
        Arrays.sort(sortedNotifications, NOTIFICATION_SETTINGS_COMPARATOR);
        for (NotificationSettings settings : sortedNotifications) {
            element.addContent(settings.save());
        }
        if (!this.SHOW_BALLOONS) {
            element.setAttribute(SHOW_BALLOONS_ATTRIBUTE, "false");
        }
        if (!this.SYSTEM_NOTIFICATIONS) {
            element.setAttribute(SYSTEM_NOTIFICATIONS_ATTRIBUTE, "false");
        }
        if (this.NOTIFICATION_ANNOUNCING_MODE != null) {
            element.setAttribute(NOTIFICATION_ANNOUNCING_MODE_ATTRIBUTE, this.NOTIFICATION_ANNOUNCING_MODE.getStringValue());
        }
        return element;
    }

    public synchronized void loadState(@NotNull Element state2) {
        if (state2 == null) {
            NotificationsConfigurationImpl.$$$reportNull$$$0(22);
        }
        this.myIdToSettingsMap.clear();
        for (Element child : state2.getChildren("notification")) {
            NotificationSettings settings = NotificationSettings.Companion.load(child);
            if (settings == null) continue;
            String id2 = settings.getGroupId();
            LOG.assertTrue(!this.myIdToSettingsMap.containsKey(id2), (Object)String.format("Settings for '%s' already loaded!", id2));
            this.myIdToSettingsMap.put(id2, settings);
        }
        this.doRemove("Log Only");
        this.SHOW_BALLOONS = !"false".equals(state2.getAttributeValue(SHOW_BALLOONS_ATTRIBUTE));
        this.SYSTEM_NOTIFICATIONS = !"false".equals(state2.getAttributeValue(SYSTEM_NOTIFICATIONS_ATTRIBUTE));
        this.NOTIFICATION_ANNOUNCING_MODE = NotificationAnnouncingMode.get((String)state2.getAttributeValue(NOTIFICATION_ANNOUNCING_MODE_ATTRIBUTE));
    }

    public synchronized void noStateLoaded() {
        this.loadState(new Element("element"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 12, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/NotificationsConfigurationImpl";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDisplayName";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/NotificationsConfigurationImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationAnnouncingMode";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasToolWindowCapability";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 3: 
            case 12: 
            case 15: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setNotificationAnnouncingMode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "changeSettings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isRegistered";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 12, 15 -> new IllegalStateException(string);
        };
    }

    static final class MyNotificationListener
    implements Notifications {
        MyNotificationListener() {
        }

        public void notify(@NotNull Notification notification2) {
            if (notification2 == null) {
                MyNotificationListener.$$$reportNull$$$0(0);
            }
            NotificationsConfigurationImpl.getInstanceImpl().notify(notification2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/notification/impl/NotificationsConfigurationImpl$MyNotificationListener", "notify"));
        }
    }
}

