/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.CSSFontResolver;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NotificationsUtil {
    private static final Logger LOG = Logger.getInstance(NotificationsUtil.class);
    private static final int TITLE_LIMIT = 1000;
    private static final int CONTENT_LIMIT = 10000;
    @NlsSafe
    private static final String P_TAG = "<p/>";
    @NlsSafe
    private static final String BR_TAG = "<br>";

    @NotNull
    @Nls
    public static String buildHtml(@NotNull Notification notification2, @Nullable String style, boolean isContent, @Nullable Color color, @Nullable String contentStyle) {
        String content2;
        if (notification2 == null) {
            NotificationsUtil.$$$reportNull$$$0(0);
        }
        String title2 = !isContent ? notification2.getTitle() : "";
        String subtitle = !isContent ? notification2.getSubtitle() : null;
        String string = content2 = isContent ? notification2.getContent() : "";
        if (title2.length() > 1000 || StringUtil.length((CharSequence)subtitle) > 1000 || content2.length() > 10000) {
            LOG.info("Too large notification " + String.valueOf(notification2) + " of " + String.valueOf(notification2.getClass()) + "\nListener=" + String.valueOf(notification2.getListener()) + "\nTitle=" + title2 + "\nSubtitle=" + subtitle + "\nContent=" + content2);
            title2 = StringUtil.trimLog((String)title2, (int)1000);
            subtitle = StringUtil.trimLog((String)StringUtil.notNullize((String)subtitle), (int)1000);
            content2 = StringUtil.trimLog((String)content2, (int)10000);
        }
        if (isContent) {
            content2 = StringUtil.replace((String)content2, (String)P_TAG, (String)BR_TAG);
        }
        boolean boldTitle = false;
        if (!Notification.isEmpty((String)title2) || !Notification.isEmpty((String)subtitle)) {
            boldTitle = !Notification.isEmpty((String)notification2.getContent());
        }
        String colorText = color == null ? null : "#" + ColorUtil.toHex((Color)color);
        return NotificationsUtil.buildHtml(title2, subtitle, boldTitle, content2, style, isContent ? null : colorText, (String)((Object)(isContent ? colorText : null)), contentStyle);
    }

    @NotNull
    @Nls
    public static String buildFullContent(@NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationsUtil.$$$reportNull$$$0(1);
        }
        String content2 = StringUtil.replace((String)notification2.getContent(), (String)P_TAG, (String)BR_TAG);
        return NotificationsUtil.buildHtml(null, null, false, content2, null, null, null, null);
    }

    @NotNull
    @Nls
    public static String buildStatusMessage(@NotNull Notification notification2) {
        List actions;
        Object message;
        if (notification2 == null) {
            NotificationsUtil.$$$reportNull$$$0(2);
        }
        Object title2 = notification2.getTitle();
        String subtitle = notification2.getSubtitle();
        if (StringUtil.isNotEmpty((String)title2) && StringUtil.isNotEmpty((String)subtitle)) {
            title2 = (String)title2 + " (" + subtitle + ")";
        }
        title2 = StringUtil.first((String)title2, (int)1000, (boolean)true);
        String content2 = StringUtil.first((String)notification2.getContent(), (int)1000, (boolean)true);
        if (StringUtil.isNotEmpty((String)title2)) {
            message = title2;
            if (StringUtil.isNotEmpty((String)content2)) {
                message = (String)message + ": ";
                message = (String)message + content2;
            }
        } else {
            message = content2;
        }
        if (!(actions = notification2.getActions()).isEmpty()) {
            message = (String)message + " // ";
            message = (String)message + StringUtil.join((Collection)actions, action2 -> action2.getTemplateText(), (String)" // ");
        }
        message = StringUtil.replace((String)message, (String)"<a href=", (String)" // <a href=");
        message = StringUtil.stripHtml((String)message, (String)" ");
        message = StringUtil.replace((String)message, (String)"\n", (String)" ");
        message = StringUtil.replace((String)message, (String)"&nbsp;", (String)" ");
        message = StringUtil.replace((String)message, (String)"&raquo;", (String)">>");
        message = StringUtil.replace((String)message, (String)"&laquo;", (String)"<<");
        message = StringUtil.replace((String)message, (String)"&hellip;", (String)"...");
        message = StringUtil.unescapeXmlEntities((String)message);
        Object object = message = StringUtil.collapseWhiteSpace((CharSequence)message);
        if (object == null) {
            NotificationsUtil.$$$reportNull$$$0(3);
        }
        return object;
    }

    @NotNull
    @Nls
    public static String buildHtml(@Nullable @Nls String title2, @Nullable @Nls String subtitle, boolean boldTitle, @Nullable @Nls String content2, @Nullable String style, @Nullable String titleColor, @Nullable String contentColor, @Nullable String contentStyle) {
        if (Notification.isEmpty((String)title2) && !Notification.isEmpty((String)subtitle)) {
            title2 = subtitle;
            subtitle = null;
        } else if (!Notification.isEmpty((String)title2) && !Notification.isEmpty((String)subtitle)) {
            title2 = (String)title2 + ":";
        }
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        if (!Notification.isEmpty((String)title2)) {
            if (boldTitle) {
                HtmlChunk.Element titleChunk = HtmlChunk.raw((String)title2).bold();
                if (StringUtil.isNotEmpty((String)titleColor)) {
                    titleChunk = titleChunk.attr("color", titleColor);
                }
                htmlBuilder.append((HtmlChunk)titleChunk);
            } else {
                htmlBuilder.append((HtmlChunk)(StringUtil.isNotEmpty((String)titleColor) ? HtmlChunk.span().attr("color", titleColor).addText((String)title2) : HtmlChunk.raw((String)title2)));
            }
        }
        if (!Notification.isEmpty((String)subtitle)) {
            htmlBuilder.nbsp().append((HtmlChunk)(StringUtil.isNotEmpty((String)titleColor) ? HtmlChunk.span().attr("color", titleColor).addText(subtitle) : HtmlChunk.raw((String)subtitle)));
        }
        if (!Notification.isEmpty((String)content2)) {
            HtmlChunk.Element contentChunk = HtmlChunk.raw((String)content2).wrapWith(HtmlChunk.div());
            if (StringUtil.isNotEmpty((String)contentStyle)) {
                contentChunk = contentChunk.style(contentStyle);
            }
            if (StringUtil.isNotEmpty((String)contentColor)) {
                contentChunk = contentChunk.attr("color", contentColor);
            }
            htmlBuilder.append((HtmlChunk)contentChunk);
        }
        String string = StringUtil.isNotEmpty((String)style) ? htmlBuilder.wrapWith(HtmlChunk.div((String)style)).wrapWith(HtmlChunk.html()).toString() : htmlBuilder.wrapWithHtmlBody().toString();
        if (string == null) {
            NotificationsUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static String getFontStyle() {
        String fontName = NotificationsUtil.getFontName();
        return StringUtil.isEmpty((String)fontName) ? null : "font-family:" + fontName + ";";
    }

    @NotNull
    public static Float getFontSize() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            Float f = Float.valueOf(uiSettings.getFontSize2D());
            if (f == null) {
                NotificationsUtil.$$$reportNull$$$0(5);
            }
            return f;
        }
        Float f = Float.valueOf(StartupUiUtil.getLabelFont().getSize2D());
        if (f == null) {
            NotificationsUtil.$$$reportNull$$$0(6);
        }
        return f;
    }

    @Nullable
    public static String getFontName() {
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getOverrideLafFonts()) {
            return uiSettings.getFontFace();
        }
        return StartupUiUtil.getLabelFont().getName();
    }

    @Nullable
    public static HyperlinkListener wrapListener(final @NotNull Notification notification2) {
        NotificationListener listener2;
        if (notification2 == null) {
            NotificationsUtil.$$$reportNull$$$0(7);
        }
        if ((listener2 = notification2.getListener()) == null) {
            return null;
        }
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener listener1;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (listener1 = notification2.getListener()) != null) {
                    NotificationCollector.getInstance().logHyperlinkClicked(notification2);
                    listener1.hyperlinkUpdate(notification2, e);
                }
            }
        };
    }

    public static void configureHtmlEditorKit(@NotNull JEditorPane editorPane2, boolean notificationColor) {
        if (editorPane2 == null) {
            NotificationsUtil.$$$reportNull$$$0(8);
        }
        HTMLEditorKit kit2 = new HTMLEditorKitBuilder().withWordWrapViewFactory().withFontResolver(new CSSFontResolver(){

            @NotNull
            public Font getFont(@NotNull Font defaultFont, @NotNull AttributeSet attributeSet) {
                if (defaultFont == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (attributeSet == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ("a".equalsIgnoreCase(String.valueOf(attributeSet.getAttribute(AttributeSet.NameAttribute)))) {
                    Font font = UIUtil.getLabelFont();
                    if (font == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return font;
                }
                Font font = defaultFont;
                if (font == null) {
                    2.$$$reportNull$$$0(3);
                }
                return font;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defaultFont";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributeSet";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/notification/impl/ui/NotificationsUtil$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/notification/impl/ui/NotificationsUtil$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFont";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getFont";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        }).build();
        String color = ColorUtil.toHtmlColor((Color)(notificationColor ? NotificationsUtil.getLinkButtonForeground() : JBUI.CurrentTheme.Link.Foreground.ENABLED));
        kit2.getStyleSheet().addRule("a {color: " + color + "}");
        editorPane2.setEditorKit(kit2);
    }

    @NotNull
    public static Color getLinkButtonForeground() {
        JBColor jBColor = JBColor.namedColor((String)"Notification.linkForeground", (Color)JBUI.CurrentTheme.Link.Foreground.ENABLED);
        if (jBColor == null) {
            NotificationsUtil.$$$reportNull$$$0(9);
        }
        return jBColor;
    }

    @NotNull
    public static Color getMoreButtonForeground() {
        JBColor jBColor = JBColor.namedColor((String)"Notification.MoreButton.foreground", (Color)new JBColor(0x666666, 0x8C8C8C));
        if (jBColor == null) {
            NotificationsUtil.$$$reportNull$$$0(10);
        }
        return jBColor;
    }

    @NotNull
    public static Color getMoreButtonBackground() {
        JBColor jBColor = JBColor.namedColor((String)"Notification.MoreButton.background", (Color)new JBColor(0xE3E3E3, 3816509));
        if (jBColor == null) {
            NotificationsUtil.$$$reportNull$$$0(11);
        }
        return jBColor;
    }

    @NotNull
    public static Icon getIcon(@NotNull Notification notification2) {
        Icon icon2;
        if (notification2 == null) {
            NotificationsUtil.$$$reportNull$$$0(12);
        }
        if ((icon2 = notification2.getIcon()) != null) {
            Icon icon3 = icon2;
            if (icon3 == null) {
                NotificationsUtil.$$$reportNull$$$0(13);
            }
            return icon3;
        }
        Icon icon4 = switch (notification2.getType()) {
            default -> throw new MatchException(null, null);
            case NotificationType.WARNING -> AllIcons.General.BalloonWarning;
            case NotificationType.ERROR -> AllIcons.General.BalloonError;
            case NotificationType.INFORMATION, NotificationType.IDE_UPDATE -> AllIcons.General.BalloonInformation;
        };
        if (icon4 == null) {
            NotificationsUtil.$$$reportNull$$$0(14);
        }
        return icon4;
    }

    @NotNull
    public static MessageType getMessageType(@NotNull Notification notification2) {
        if (notification2 == null) {
            NotificationsUtil.$$$reportNull$$$0(15);
        }
        MessageType messageType = switch (notification2.getType()) {
            default -> throw new MatchException(null, null);
            case NotificationType.WARNING -> MessageType.WARNING;
            case NotificationType.ERROR -> MessageType.ERROR;
            case NotificationType.INFORMATION, NotificationType.IDE_UPDATE -> MessageType.INFO;
        };
        if (messageType == null) {
            NotificationsUtil.$$$reportNull$$$0(16);
        }
        return messageType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9, 10, 11, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/notification/impl/ui/NotificationsUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/notification/impl/ui/NotificationsUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStatusMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtml";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontSize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkButtonForeground";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoreButtonForeground";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoreButtonBackground";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildHtml";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildFullContent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildStatusMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureHtmlEditorKit";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMessageType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9, 10, 11, 13, 14, 16 -> new IllegalStateException(string);
        };
    }
}

