/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ActionPresentationDecorator {
    private static final Logger LOG = Logger.getInstance(ActionPresentationDecorator.class);
    @Nullable
    private static volatile ActionPresentationDecorator ourInstance;

    @NotNull
    @NlsActions.ActionText
    public abstract String decorateText(@NotNull AnAction var1, @NotNull @NlsActions.ActionText String var2);

    @RequiresEdt
    public static void setInstance(@Nullable ActionPresentationDecorator actionPresentationDecorator) {
        ActionPresentationDecorator decorator;
        ThreadingAssertions.assertEventDispatchThread();
        LOG.info("ActionPresentationDecorator is set to " + String.valueOf(decorator));
        ourInstance = decorator;
    }

    @Nullable
    public static ActionPresentationDecorator getInstance() {
        return ourInstance;
    }

    @RequiresEdt
    @Contract(value="_,!null->!null;_,null->null")
    @NlsActions.ActionText
    public static String decorateTextIfNeeded(@NotNull AnAction action2, @NlsActions.ActionText String text2) {
        if (action2 == null) {
            ActionPresentationDecorator.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ActionPresentationDecorator instance = ourInstance;
        return instance == null || text2 == null ? text2 : instance.decorateText(action2, text2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/impl/ActionPresentationDecorator", "decorateTextIfNeeded"));
    }
}

