/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.apple.eawt.event.GestureAdapter;
import com.apple.eawt.event.GestureListener;
import com.apple.eawt.event.GesturePhaseEvent;
import com.apple.eawt.event.GestureUtilities;
import com.apple.eawt.event.MagnificationEvent;
import com.apple.eawt.event.SwipeEvent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import java.awt.Component;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

final class MacGestureAdapter
extends GestureAdapter {
    double magnification;
    private final IdeFrame myFrame;
    private final MouseGestureManager myManager;
    private ZoomableViewport myMagnifyingViewport;

    MacGestureAdapter(MouseGestureManager manager2, IdeFrame frame) {
        this.myFrame = frame;
        this.magnification = 0.0;
        this.myManager = manager2;
        GestureUtilities.addGestureListenerTo((JComponent)frame.getComponent(), (GestureListener)this);
    }

    public void gestureBegan(GesturePhaseEvent event) {
        Magnificator magnificator;
        this.magnification = 0.0;
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point mouse = new Point(pointerInfo.getLocation());
        SwingUtilities.convertPointFromScreen(mouse, this.myFrame.getComponent());
        List<Component> componentsUnderMouse = this.getAllComponentsAt(this.myFrame.getComponent(), mouse.x, mouse.y);
        ZoomableViewport viewport = MacGestureAdapter.findMagnifyingViewport(componentsUnderMouse);
        if (viewport != null && (magnificator = viewport.getMagnificator()) != null) {
            Point at = new Point(pointerInfo.getLocation());
            SwingUtilities.convertPointFromScreen(at, (JComponent)viewport);
            viewport.magnificationStarted(at);
            this.myMagnifyingViewport = viewport;
        }
    }

    public void gestureEnded(GesturePhaseEvent event) {
        if (this.myMagnifyingViewport != null) {
            this.myMagnifyingViewport.magnificationFinished(this.magnification);
            this.myMagnifyingViewport = null;
            this.magnification = 0.0;
        }
    }

    public void swipedLeft(SwipeEvent event) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction forward = actionManager.getAction("Forward");
        if (forward == null) {
            return;
        }
        actionManager.tryToExecute(forward, (InputEvent)MacGestureAdapter.createMouseEventWrapper(this.myFrame), null, null, false);
    }

    public void swipedRight(SwipeEvent event) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction back = actionManager.getAction("Back");
        if (back == null) {
            return;
        }
        actionManager.tryToExecute(back, (InputEvent)MacGestureAdapter.createMouseEventWrapper(this.myFrame), null, null, false);
    }

    private static MouseEvent createMouseEventWrapper(IdeFrame frame) {
        return new MouseEvent(frame.getComponent(), 1001, System.currentTimeMillis(), 0, 0, 0, 0, false, 0);
    }

    public void magnify(MagnificationEvent event) {
        this.myManager.activateTrackpad();
        this.magnification += event.getMagnification();
        if (this.myMagnifyingViewport != null) {
            this.myMagnifyingViewport.magnify(this.magnification);
        }
    }

    public void remove(JComponent cmp) {
        GestureUtilities.removeGestureListenerFrom((JComponent)cmp, (GestureListener)this);
    }

    public List<Component> getAllComponentsAt(Component parent, int x, int y) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (!parent.contains(x, y)) {
            return components;
        }
        if (parent instanceof Container) {
            Component[] comps = ((Container)parent).getComponents();
            for (int i2 = comps.length - 1; i2 >= 0; --i2) {
                Component comp = comps[i2];
                if (comp == null || !comp.isVisible()) continue;
                Point loc = comp.getLocation();
                if (!comp.contains(x - loc.x, y - loc.y)) continue;
                components.add(comp);
                if (!(comp instanceof Container)) continue;
                components.addAll(this.getAllComponentsAt(comp, x - loc.x, y - loc.y));
            }
        }
        components.add(parent);
        return components;
    }

    private static ZoomableViewport findMagnifyingViewport(List<Component> components) {
        for (Component comp : components) {
            ZoomableViewport viewport = (ZoomableViewport)SwingUtilities.getAncestorOfClass(ZoomableViewport.class, comp);
            if (viewport == null || viewport.getMagnificator() == null) continue;
            return viewport;
        }
        return null;
    }
}

