/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.StubItem;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.MacMenuSettings;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0007J\b\u0010\u000f\u001a\u00020\u000bH\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0007J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\tR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/actionSystem/impl/SubElementSelector;", "", "owner", "Lcom/intellij/openapi/actionSystem/impl/ActionMenu;", "<init>", "(Lcom/intellij/openapi/actionSystem/impl/ActionMenu;)V", "stubItem", "Lcom/intellij/openapi/actionSystem/impl/StubItem;", "getStubItem$annotations", "()V", "ignoreNextSelectionRequest", "", "timeoutMs", "", "cancelIgnoringOfNextSelectionRequest", "selectSubElementIfNecessary", "cancelNextSelection", "shouldIgnoreNextSelectionRequest", "", "shouldIgnoreNextSelectionRequestSinceTimestamp", "", "shouldIgnoreNextSelectionRequestTimeoutMs", "currentRequestId", "selectFirstEnabledElement", "requestId", "Companion", "intellij.platform.ide.impl"})
final class SubElementSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActionMenu owner;
    @JvmField
    @Nullable
    public StubItem stubItem;
    private boolean shouldIgnoreNextSelectionRequest;
    private long shouldIgnoreNextSelectionRequestSinceTimestamp;
    private int shouldIgnoreNextSelectionRequestTimeoutMs;
    private int currentRequestId;
    private static final boolean isForceDisabled = MacMenuSettings.isSystemMenu || !Registry.Companion.is("ide.popup.menu.navigation.keyboard.selectFirstEnabledSubItem", false);

    public SubElementSelector(@NotNull ActionMenu owner) {
        Intrinsics.checkNotNullParameter((Object)((Object)owner), (String)"owner");
        this.owner = owner;
        this.shouldIgnoreNextSelectionRequestSinceTimestamp = -1L;
        this.shouldIgnoreNextSelectionRequestTimeoutMs = -1;
        this.currentRequestId = -1;
        if (isForceDisabled) {
            throw new IllegalStateException("Attempt to create an instance of ActionMenu.SubElementSelector class when it is force disabled");
        }
    }

    public static /* synthetic */ void getStubItem$annotations() {
    }

    @RequiresEdt
    public final void ignoreNextSelectionRequest(int timeoutMs) {
        this.shouldIgnoreNextSelectionRequest = true;
        this.shouldIgnoreNextSelectionRequestTimeoutMs = timeoutMs;
        this.shouldIgnoreNextSelectionRequestSinceTimestamp = timeoutMs >= 0 ? System.currentTimeMillis() : -1L;
    }

    @RequiresEdt
    public final void ignoreNextSelectionRequest() {
        this.ignoreNextSelectionRequest(-1);
    }

    @RequiresEdt
    public final void cancelIgnoringOfNextSelectionRequest() {
        this.shouldIgnoreNextSelectionRequest = false;
        this.shouldIgnoreNextSelectionRequestSinceTimestamp = -1L;
        this.shouldIgnoreNextSelectionRequestTimeoutMs = -1;
    }

    @RequiresEdt
    public final void selectSubElementIfNecessary() {
        boolean shouldIgnoreThisSelectionRequest = this.shouldIgnoreNextSelectionRequest ? (this.shouldIgnoreNextSelectionRequestTimeoutMs >= 0 ? System.currentTimeMillis() - this.shouldIgnoreNextSelectionRequestSinceTimestamp <= (long)this.shouldIgnoreNextSelectionRequestTimeoutMs : true) : false;
        this.cancelIgnoringOfNextSelectionRequest();
        if (shouldIgnoreThisSelectionRequest) {
            return;
        }
        ++this.currentRequestId;
        int thisRequestId = this.currentRequestId;
        SwingUtilities.invokeLater(() -> SubElementSelector.selectSubElementIfNecessary$lambda$0(this, thisRequestId));
    }

    @RequiresEdt
    public final void cancelNextSelection() {
        ++this.currentRequestId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresEdt
    private final void selectFirstEnabledElement(int requestId) {
        MenuElement[] menuElementArray;
        if (requestId != this.currentRequestId) {
            return;
        }
        if (!this.owner.isSelected()) {
            return;
        }
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] currentSelectedPath = menuSelectionManager.getSelectedPath();
        if (currentSelectedPath.length < 2) {
            return;
        }
        MenuElement lastElementInCurrentPath = currentSelectedPath[currentSelectedPath.length - 1];
        if (lastElementInCurrentPath == this.stubItem) {
            menuElementArray = (MenuElement[])currentSelectedPath.clone();
        } else if (lastElementInCurrentPath == this.owner.getPopupMenu()) {
            Intrinsics.checkNotNull((Object)currentSelectedPath);
            MenuElement[] menuElementArray2 = Arrays.copyOf(currentSelectedPath, currentSelectedPath.length + 1);
            Intrinsics.checkNotNullExpressionValue((Object)menuElementArray2, (String)"copyOf(...)");
            menuElementArray = menuElementArray2;
        } else {
            if (currentSelectedPath[currentSelectedPath.length - 2] != this.owner.getPopupMenu()) return;
            Component[] componentArray = this.owner.getMenuComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getMenuComponents(...)");
            Object[] objectArray = componentArray;
            MenuElement menuElement = lastElementInCurrentPath;
            Intrinsics.checkNotNull((Object)menuElement);
            if (ArraysKt.contains((Object[])objectArray, (Object)menuElement.getComponent())) return;
            menuElementArray = (MenuElement[])currentSelectedPath.clone();
        }
        MenuElement[] newSelectionPath = menuElementArray;
        Component[] menuComponents = this.owner.getMenuComponents();
        Intrinsics.checkNotNull((Object)menuComponents);
        for (Component component2 : menuComponents) {
            if (Intrinsics.areEqual((Object)component2, (Object)this.stubItem) || !component2.isEnabled() || !(component2 instanceof JMenuItem)) continue;
            newSelectionPath[newSelectionPath.length - 1] = component2;
            menuSelectionManager.setSelectedPath(newSelectionPath);
            return;
        }
    }

    private static final void selectSubElementIfNecessary$lambda$0(SubElementSelector this$0, int $thisRequestId) {
        this$0.selectFirstEnabledElement($thisRequestId);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/actionSystem/impl/SubElementSelector$Companion;", "", "<init>", "()V", "isForceDisabled", "", "()Z", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isForceDisabled() {
            return isForceDisabled;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

