/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00102\u00020\u0001:\u0006\u000b\f\r\u000e\u000f\u0010B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\tH\u0016\u0082\u0001\u0005\u0011\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "", "<init>", "()V", "writeConfigMarkerFile", "", "configDir", "Ljava/nio/file/Path;", "getStringPresentation", "", "toString", "StartWithCleanConfig", "MigrateFromCustomPlace", "MigratePluginsFromCustomPlace", "SetProperties", "MergeConfigs", "Companion", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$MergeConfigs;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigrateFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigratePluginsFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption$StartWithCleanConfig;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCustomConfigMigrationOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomConfigMigrationOption.kt\ncom/intellij/openapi/application/CustomConfigMigrationOption\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,141:1\n13#2:142\n*S KotlinDebug\n*F\n+ 1 CustomConfigMigrationOption.kt\ncom/intellij/openapi/application/CustomConfigMigrationOption\n*L\n71#1:142\n*E\n"})
public abstract sealed class CustomConfigMigrationOption {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;
    @NotNull
    private static final String IMPORT_PREFIX = "import ";
    @NotNull
    private static final String MIGRATE_PLUGINS_PREFIX = "migrate-plugins ";
    @NotNull
    private static final String PROPERTIES_PREFIX = "properties ";
    @NotNull
    private static final String MERGE_CONFIGS_COMMAND = "merge-configs";

    private CustomConfigMigrationOption() {
    }

    @JvmOverloads
    public final void writeConfigMarkerFile(@NotNull Path configDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        Path markerFile = Companion.getCustomConfigMarkerFilePath(configDir);
        if (Files.exists(markerFile, new LinkOption[0])) {
            log.error("Marker file " + markerFile + " shouldn't exist");
        }
        NioFiles.createDirectories((Path)markerFile.getParent());
        Files.writeString(markerFile, (CharSequence)this.getStringPresentation(), Charsets.UTF_8, new OpenOption[0]);
    }

    public static /* synthetic */ void writeConfigMarkerFile$default(CustomConfigMigrationOption customConfigMigrationOption, Path path, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeConfigMarkerFile");
        }
        if ((n & 1) != 0) {
            Path path2 = PathManager.getOriginalConfigDir();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getOriginalConfigDir(...)");
            path = path2;
        }
        customConfigMigrationOption.writeConfigMarkerFile(path);
    }

    @NotNull
    public abstract String getStringPresentation();

    @NotNull
    public String toString() {
        return this.getStringPresentation();
    }

    @JvmOverloads
    public final void writeConfigMarkerFile() throws IOException {
        CustomConfigMigrationOption.writeConfigMarkerFile$default(this, null, 1, null);
    }

    @JvmStatic
    @Nullable
    public static final CustomConfigMigrationOption readCustomConfigMigrationOptionAndRemoveMarkerFile(@NotNull Path configDir) {
        return Companion.readCustomConfigMigrationOptionAndRemoveMarkerFile(configDir);
    }

    public /* synthetic */ CustomConfigMigrationOption(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CustomConfigMigrationOption.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "IMPORT_PREFIX", "", "MIGRATE_PLUGINS_PREFIX", "PROPERTIES_PREFIX", "MERGE_CONFIGS_COMMAND", "readCustomConfigMigrationOptionAndRemoveMarkerFile", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "configDir", "Ljava/nio/file/Path;", "removeMarkerFile", "", "markerFile", "getCustomConfigMarkerFilePath", "doesCustomConfigMarkerExist", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final CustomConfigMigrationOption readCustomConfigMigrationOptionAndRemoveMarkerFile(@NotNull Path configDir) {
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            Path markerFile = this.getCustomConfigMarkerFilePath(configDir);
            if (!Files.exists(markerFile, new LinkOption[0])) {
                return null;
            }
            try {
                CustomConfigMigrationOption customConfigMigrationOption;
                List<String> lines = Files.readAllLines(markerFile);
                Intrinsics.checkNotNull(lines);
                String line = (String)CollectionsKt.firstOrNull(lines);
                Object object = line;
                if (object == null || object.length() == 0) {
                    customConfigMigrationOption = StartWithCleanConfig.INSTANCE;
                } else if (StringsKt.startsWith$default((String)line, (String)CustomConfigMigrationOption.IMPORT_PREFIX, (boolean)false, (int)2, null)) {
                    MigrateFromCustomPlace migrateFromCustomPlace;
                    Path path = markerFile.getFileSystem().getPath(StringsKt.removePrefix((String)line, (CharSequence)CustomConfigMigrationOption.IMPORT_PREFIX), new String[0]);
                    if (Files.exists(path, new LinkOption[0])) {
                        Intrinsics.checkNotNull((Object)path);
                        migrateFromCustomPlace = new MigrateFromCustomPlace(path);
                    } else {
                        log.warn(markerFile + " points to non-existent config: [" + lines + "]");
                        migrateFromCustomPlace = null;
                    }
                    customConfigMigrationOption = migrateFromCustomPlace;
                } else if (StringsKt.startsWith$default((String)line, (String)CustomConfigMigrationOption.MIGRATE_PLUGINS_PREFIX, (boolean)false, (int)2, null)) {
                    Path path = markerFile.getFileSystem().getPath(StringsKt.removePrefix((String)line, (CharSequence)CustomConfigMigrationOption.MIGRATE_PLUGINS_PREFIX), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
                    customConfigMigrationOption = new MigratePluginsFromCustomPlace(path);
                } else if (StringsKt.startsWith$default((String)line, (String)CustomConfigMigrationOption.PROPERTIES_PREFIX, (boolean)false, (int)2, null)) {
                    char[] cArray = new char[]{' '};
                    List properties = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)line, (CharSequence)CustomConfigMigrationOption.PROPERTIES_PREFIX), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    customConfigMigrationOption = new SetProperties(properties);
                } else if (Intrinsics.areEqual((Object)line, (Object)CustomConfigMigrationOption.MERGE_CONFIGS_COMMAND)) {
                    customConfigMigrationOption = MergeConfigs.INSTANCE;
                } else {
                    log.error("Invalid format of " + markerFile + ": " + lines);
                    customConfigMigrationOption = null;
                }
                object = customConfigMigrationOption;
                return object;
            }
            catch (Exception exception) {
                log.warn("Couldn't load content of " + markerFile);
                CustomConfigMigrationOption customConfigMigrationOption = null;
                return customConfigMigrationOption;
            }
            finally {
                this.removeMarkerFile(markerFile);
            }
        }

        private final void removeMarkerFile(Path markerFile) {
            try {
                Files.delete(markerFile);
            }
            catch (Exception e) {
                log.warn("Couldn't delete the custom config migration file " + markerFile, (Throwable)e);
            }
        }

        @VisibleForTesting
        @NotNull
        public final Path getCustomConfigMarkerFilePath(@NotNull Path configDir) {
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            Path path = configDir.resolve("migrate.config");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        public final boolean doesCustomConfigMarkerExist(@NotNull Path configDir) {
            Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.exists(this.getCustomConfigMarkerFilePath(configDir), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$MergeConfigs;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "<init>", "()V", "getStringPresentation", "", "intellij.platform.ide.impl"})
    public static final class MergeConfigs
    extends CustomConfigMigrationOption {
        @NotNull
        public static final MergeConfigs INSTANCE = new MergeConfigs();

        private MergeConfigs() {
            super(null);
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.MERGE_CONFIGS_COMMAND;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigrateFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "location", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getLocation", "()Ljava/nio/file/Path;", "getStringPresentation", "", "intellij.platform.ide.impl"})
    public static final class MigrateFromCustomPlace
    extends CustomConfigMigrationOption {
        @NotNull
        private final Path location;

        public MigrateFromCustomPlace(@NotNull Path location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            super(null);
            this.location = location;
        }

        @NotNull
        public final Path getLocation() {
            return this.location;
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.IMPORT_PREFIX + StringsKt.replace$default((String)((Object)this.location).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$MigratePluginsFromCustomPlace;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "configLocation", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getConfigLocation", "()Ljava/nio/file/Path;", "getStringPresentation", "", "intellij.platform.ide.impl"})
    public static final class MigratePluginsFromCustomPlace
    extends CustomConfigMigrationOption {
        @NotNull
        private final Path configLocation;

        public MigratePluginsFromCustomPlace(@NotNull Path configLocation) {
            Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
            super(null);
            this.configLocation = configLocation;
        }

        @NotNull
        public final Path getConfigLocation() {
            return this.configLocation;
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.MIGRATE_PLUGINS_PREFIX + StringsKt.replace$default((String)((Object)this.configLocation).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\u0004H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$SetProperties;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "properties", "", "", "<init>", "(Ljava/util/List;)V", "getProperties", "()Ljava/util/List;", "getStringPresentation", "intellij.platform.ide.impl"})
    public static final class SetProperties
    extends CustomConfigMigrationOption {
        @NotNull
        private final List<String> properties;

        public SetProperties(@NotNull List<String> properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            super(null);
            this.properties = properties;
        }

        @NotNull
        public final List<String> getProperties() {
            return this.properties;
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return CustomConfigMigrationOption.PROPERTIES_PREFIX + CollectionsKt.joinToString$default((Iterable)this.properties, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/application/CustomConfigMigrationOption$StartWithCleanConfig;", "Lcom/intellij/openapi/application/CustomConfigMigrationOption;", "<init>", "()V", "getStringPresentation", "", "toString", "intellij.platform.ide.impl"})
    public static final class StartWithCleanConfig
    extends CustomConfigMigrationOption {
        @NotNull
        public static final StartWithCleanConfig INSTANCE = new StartWithCleanConfig();

        private StartWithCleanConfig() {
            super(null);
        }

        @Override
        @NotNull
        public String getStringPresentation() {
            return "";
        }

        @Override
        @NotNull
        public String toString() {
            return "Start with clean config";
        }
    }
}

