/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.constraints;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.constraints.BaseConstrainedExecution;
import com.intellij.openapi.application.constraints.ConstrainedExecution;
import com.intellij.openapi.application.constraints.DisposableExpiration;
import com.intellij.openapi.application.constraints.ExpirableConstrainedExecution;
import com.intellij.openapi.application.constraints.Expiration;
import com.intellij.openapi.application.constraints.ExpirationKt;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b \u0018\u0000 )*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002()B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ7\u0010\u000f\u001a\u00028\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH$\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u000f\u001a\u00028\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0014\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H&J\n\u0010&\u001a\u0004\u0018\u00010\u000bH\u0014J\n\u0010'\u001a\u0004\u0018\u00010\bH\u0014R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010!\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b\"\u0010#\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/application/constraints/ExpirableConstrainedExecution;", "E", "Lcom/intellij/openapi/application/constraints/ConstrainedExecution;", "Lcom/intellij/openapi/application/constraints/BaseConstrainedExecution;", "constraints", "", "Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;", "cancellationConditions", "Ljava/util/function/BooleanSupplier;", "expirationSet", "", "Lcom/intellij/openapi/application/constraints/Expiration;", "<init>", "([Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;[Ljava/util/function/BooleanSupplier;Ljava/util/Set;)V", "[Ljava/util/function/BooleanSupplier;", "cloneWith", "([Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;[Ljava/util/function/BooleanSupplier;Ljava/util/Set;)Lcom/intellij/openapi/application/constraints/ConstrainedExecution;", "([Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;)Lcom/intellij/openapi/application/constraints/ConstrainedExecution;", "withConstraint", "constraint", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;Lcom/intellij/openapi/Disposable;)Lcom/intellij/openapi/application/constraints/ConstrainedExecution;", "expireWith", "(Lcom/intellij/openapi/Disposable;)Lcom/intellij/openapi/application/constraints/ConstrainedExecution;", "cancelIf", "condition", "(Ljava/util/function/BooleanSupplier;)Lcom/intellij/openapi/application/constraints/ConstrainedExecution;", "dispatchLaterUnconstrained", "", "runnable", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "compositeExpiration", "getCompositeExpiration", "()Lcom/intellij/openapi/application/constraints/Expiration;", "compositeExpiration$delegate", "Lkotlin/Lazy;", "composeExpiration", "composeCancellationCondition", "ExpirableContextConstraint", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nExpirableConstrainedExecution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpirableConstrainedExecution.kt\ncom/intellij/openapi/application/constraints/ExpirableConstrainedExecution\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,120:1\n12970#2,2:121\n*S KotlinDebug\n*F\n+ 1 ExpirableConstrainedExecution.kt\ncom/intellij/openapi/application/constraints/ExpirableConstrainedExecution\n*L\n61#1:121,2\n*E\n"})
public abstract class ExpirableConstrainedExecution<E extends ConstrainedExecution<E>>
extends BaseConstrainedExecution<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BooleanSupplier[] cancellationConditions;
    @NotNull
    private final Set<Expiration> expirationSet;
    @NotNull
    private final Lazy compositeExpiration$delegate;

    public ExpirableConstrainedExecution(@NotNull ConstrainedExecution.ContextConstraint[] constraints, @NotNull BooleanSupplier[] cancellationConditions, @NotNull Set<? extends Expiration> expirationSet) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)cancellationConditions, (String)"cancellationConditions");
        Intrinsics.checkNotNullParameter(expirationSet, (String)"expirationSet");
        super(constraints);
        this.cancellationConditions = cancellationConditions;
        this.expirationSet = expirationSet;
        this.compositeExpiration$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> ExpirableConstrainedExecution.compositeExpiration_delegate$lambda$0(this));
    }

    @NotNull
    protected abstract E cloneWith(@NotNull ConstrainedExecution.ContextConstraint[] var1, @NotNull BooleanSupplier[] var2, @NotNull Set<? extends Expiration> var3);

    @Override
    @NotNull
    protected E cloneWith(@NotNull ConstrainedExecution.ContextConstraint[] constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return this.cloneWith(constraints, this.cancellationConditions, this.expirationSet);
    }

    @Override
    @NotNull
    public E withConstraint(@NotNull ConstrainedExecution.ContextConstraint constraint, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        DisposableExpiration expirableHandle = new DisposableExpiration(parentDisposable);
        ExpirableContextConstraint expirableConstraint = new ExpirableContextConstraint(constraint, expirableHandle);
        return this.cloneWith((ConstrainedExecution.ContextConstraint[])ArraysKt.plus((Object[])this.getConstraints(), (Object)expirableConstraint), this.cancellationConditions, SetsKt.plus(this.expirationSet, (Object)expirableHandle));
    }

    @Override
    @NotNull
    public E expireWith(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        DisposableExpiration expirableHandle = new DisposableExpiration(parentDisposable);
        if (this.expirationSet.contains(expirableHandle)) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type E of com.intellij.openapi.application.constraints.ExpirableConstrainedExecution");
            return (E)this;
        }
        return this.cloneWith(this.getConstraints(), this.cancellationConditions, SetsKt.plus(this.expirationSet, (Object)expirableHandle));
    }

    @Override
    @NotNull
    public E cancelIf(@NotNull BooleanSupplier condition) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        return this.cloneWith(this.getConstraints(), (BooleanSupplier[])ArraysKt.plus((Object[])this.cancellationConditions, (Object)condition), this.expirationSet);
    }

    public abstract void dispatchLaterUnconstrained(@NotNull Runnable var1);

    private final Expiration getCompositeExpiration() {
        Lazy lazy = this.compositeExpiration$delegate;
        return (Expiration)lazy.getValue();
    }

    @Override
    @Nullable
    protected Expiration composeExpiration() {
        return this.getCompositeExpiration();
    }

    @Override
    @Nullable
    protected BooleanSupplier composeCancellationCondition() {
        Object[] conditions = this.cancellationConditions;
        return switch (conditions.length) {
            case 0 -> null;
            case 1 -> (BooleanSupplier)ArraysKt.single((Object[])conditions);
            default -> () -> ExpirableConstrainedExecution.composeCancellationCondition$lambda$0((BooleanSupplier[])conditions);
        };
    }

    private static final Expiration compositeExpiration_delegate$lambda$0(ExpirableConstrainedExecution this$0) {
        return ExpirationKt.composeExpiration(Expiration.Companion, (Collection<? extends Expiration>)this$0.expirationSet);
    }

    private static final boolean composeCancellationCondition$lambda$0(BooleanSupplier[] $conditions) {
        boolean bl;
        block1: {
            BooleanSupplier[] $this$any$iv = $conditions;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                BooleanSupplier element$iv;
                BooleanSupplier it = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!it.getAsBoolean()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/application/constraints/ExpirableConstrainedExecution$Companion;", "", "<init>", "()V", "RunOnce", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\bJ\u0017\u0010\t\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/application/constraints/ExpirableConstrainedExecution$Companion$RunOnce;", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "<init>", "()V", "hasRun", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "invoke", "block", "intellij.platform.ide.impl"})
        public static final class RunOnce
        implements Function1<Function0<? extends Unit>, Unit> {
            @NotNull
            private final AtomicBoolean hasRun = new AtomicBoolean();

            public final boolean hasRun() {
                return this.hasRun.get();
            }

            public void invoke(@NotNull Function0<Unit> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                if (!this.hasRun.getAndSet(true)) {
                    block.invoke();
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/application/constraints/ExpirableConstrainedExecution$ExpirableContextConstraint;", "Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;", "constraint", "expiration", "Lcom/intellij/openapi/application/constraints/Expiration;", "<init>", "(Lcom/intellij/openapi/application/constraints/ExpirableConstrainedExecution;Lcom/intellij/openapi/application/constraints/ConstrainedExecution$ContextConstraint;Lcom/intellij/openapi/application/constraints/Expiration;)V", "isCorrectContext", "", "schedule", "", "runnable", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "toString", "", "intellij.platform.ide.impl"})
    public final class ExpirableContextConstraint
    implements ConstrainedExecution.ContextConstraint {
        @NotNull
        private final ConstrainedExecution.ContextConstraint constraint;
        @NotNull
        private final Expiration expiration;

        public ExpirableContextConstraint(@NotNull ConstrainedExecution.ContextConstraint constraint, Expiration expiration) {
            Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
            Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
            this.constraint = constraint;
            this.expiration = expiration;
        }

        @Override
        public boolean isCorrectContext() {
            return this.expiration.isExpired() || this.constraint.isCorrectContext();
        }

        @Override
        public void schedule(@NotNull Runnable runnable2) {
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            Companion.RunOnce runOnce = new Companion.RunOnce();
            Runnable invokeWhenCompletelyExpiredRunnable2 = new Runnable(this, runOnce, ExpirableConstrainedExecution.this, runnable2){
                final /* synthetic */ ExpirableContextConstraint this$0;
                final /* synthetic */ Companion.RunOnce $runOnce;
                final /* synthetic */ ExpirableConstrainedExecution<E> this$1;
                final /* synthetic */ Runnable $runnable;
                {
                    this.this$0 = $receiver;
                    this.$runOnce = $runOnce;
                    this.this$1 = $receiver2;
                    this.$runnable = $runnable;
                }

                public void run() {
                    if (ExpirableContextConstraint.access$getExpiration$p(this.this$0).isExpired()) {
                        this.$runOnce.invoke((Function0<Unit>)((Function0)() -> schedule.invokeWhenCompletelyExpiredRunnable.1.run$lambda$0(this.$runnable)));
                    } else if (!this.$runOnce.hasRun()) {
                        this.this$1.dispatchLaterUnconstrained(this);
                    }
                }

                private static final Unit run$lambda$0(Runnable $runnable) {
                    $runnable.run();
                    return Unit.INSTANCE;
                }
            };
            Expiration.Handle expirationHandle = this.expiration.invokeOnExpiration(invokeWhenCompletelyExpiredRunnable2);
            if (!runOnce.hasRun()) {
                this.constraint.schedule(() -> ExpirableContextConstraint.schedule$lambda$0(runOnce, expirationHandle, runnable2));
            }
        }

        @Override
        @NotNull
        public String toString() {
            return this.constraint.toString();
        }

        private static final void schedule$lambda$0(Companion.RunOnce $runOnce, Expiration.Handle $expirationHandle, Runnable $runnable) {
            $runOnce.invoke((Function0<Unit>)((Function0)() -> ExpirableContextConstraint.schedule$lambda$0$0($expirationHandle, $runnable)));
        }

        private static final Unit schedule$lambda$0$0(Expiration.Handle $expirationHandle, Runnable $runnable) {
            $expirationHandle.unregisterHandler();
            $runnable.run();
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Expiration access$getExpiration$p(ExpirableContextConstraint $this) {
            return $this.expiration;
        }
    }
}

