/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.CurrentEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditorAndState {
    private final FileEditorState myState;
    private final VirtualFile myVirtualFile;

    @Nullable
    static EditorAndState getStateFor(@Nullable Project project2, @NotNull CurrentEditorProvider editorProvider) {
        FileEditor editor2;
        if (editorProvider == null) {
            EditorAndState.$$$reportNull$$$0(0);
        }
        if ((editor2 = editorProvider.getCurrentEditor(project2)) == null) {
            return null;
        }
        if (!editor2.isValid()) {
            return null;
        }
        return new EditorAndState(editor2, editor2.getState(FileEditorStateLevel.UNDO));
    }

    EditorAndState(FileEditor editor2, FileEditorState state2) {
        this.myVirtualFile = editor2.getFile();
        this.myState = state2;
    }

    boolean canBeAppliedTo(FileEditor editor2) {
        if (editor2 == null) {
            return false;
        }
        if (!Objects.equals(this.myVirtualFile, editor2.getFile())) {
            return false;
        }
        if (this.myState == null) {
            return false;
        }
        FileEditorState currentState = editor2.getState(FileEditorStateLevel.UNDO);
        return this.myState.getClass() == currentState.getClass();
    }

    FileEditorState getState() {
        return this.myState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorProvider", "com/intellij/openapi/command/impl/EditorAndState", "getStateFor"));
    }
}

