/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.awt.datatransfer.Transferable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CopyAction
extends TextComponentEditorAction
implements HintManagerImpl.ActionToIgnore {
    private static final String SKIP_COPY_AND_CUT_FOR_EMPTY_SELECTION_KEY = "editor.skip.copy.and.cut.for.empty.selection";
    public static final String SKIP_SELECTING_LINE_AFTER_COPY_EMPTY_SELECTION_KEY = "editor.skip.selecting.line.after.copy.empty.selection";

    public CopyAction() {
        super(new Handler(), false);
    }

    @Nullable
    public static SelectionToCopy prepareSelectionToCut(@NotNull Editor editor2) {
        if (editor2 == null) {
            CopyAction.$$$reportNull$$$0(0);
        }
        return CopyAction.prepareSelectionToCopy(editor2, false, false);
    }

    @Nullable
    private static SelectionToCopy prepareSelectionToCopy(@NotNull Editor editor2) {
        if (editor2 == null) {
            CopyAction.$$$reportNull$$$0(1);
        }
        boolean moveCaretToSelectionStart = CopyAction.isCopyFromEmptySelectionToMoveCaretToLineStart();
        boolean preserveOriginalCaretState = !CopyAction.isCopyFromEmptySelectionToSelectLine();
        return CopyAction.prepareSelectionToCopy(editor2, moveCaretToSelectionStart, preserveOriginalCaretState);
    }

    @Nullable
    private static SelectionToCopy prepareSelectionToCopy(@NotNull Editor editor2, boolean isToMoveCaretToSelectionStart, boolean isToPreserveOriginalCaretState) {
        if (editor2 == null) {
            CopyAction.$$$reportNull$$$0(2);
        }
        if (editor2.getSelectionModel().hasSelection(true)) {
            return new SelectionToCopy(EditorCopyPasteHelper.CopyPasteOptions.DEFAULT, null);
        }
        if (CopyAction.isSkipCopyPasteForEmptySelection()) {
            return null;
        }
        CaretModel caretModel = editor2.getCaretModel();
        List originalCaretState = isToPreserveOriginalCaretState ? caretModel.getCaretsAndSelections() : null;
        caretModel.runForEachCaret(caret -> {
            EditorActionUtil.selectEntireLines(caret);
            if (isToMoveCaretToSelectionStart && caret.hasSelection()) {
                caret.moveToVisualPosition(caret.getSelectionStartPosition());
            }
        });
        EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions = new EditorCopyPasteHelper.CopyPasteOptions(true);
        return new SelectionToCopy(copyPasteOptions, originalCaretState);
    }

    public static void copyToClipboard(@NotNull Editor editor2, @NotNull DataContext dataContext2, @NotNull TransferableProvider transferableProvider) {
        SelectionToCopy selectionToCopy;
        if (editor2 == null) {
            CopyAction.$$$reportNull$$$0(3);
        }
        if (dataContext2 == null) {
            CopyAction.$$$reportNull$$$0(4);
        }
        if (transferableProvider == null) {
            CopyAction.$$$reportNull$$$0(5);
        }
        if ((selectionToCopy = SelectionToCopy.fromDataContext(dataContext2)) == null) {
            selectionToCopy = CopyAction.prepareSelectionToCopy(editor2);
            if (selectionToCopy == null) {
                return;
            }
            if (selectionToCopy.copyPasteOptions().isCopiedFromEmptySelection()) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.copy.line");
            }
        }
        CopyAction.copyToClipboard(editor2, transferableProvider, selectionToCopy);
    }

    public static void copyToClipboard(@NotNull Editor editor2, @NotNull TransferableProvider transferableProvider, @NotNull SelectionToCopy selectionToCopy) {
        Transferable transferable;
        if (editor2 == null) {
            CopyAction.$$$reportNull$$$0(6);
        }
        if (transferableProvider == null) {
            CopyAction.$$$reportNull$$$0(7);
        }
        if (selectionToCopy == null) {
            CopyAction.$$$reportNull$$$0(8);
        }
        if ((transferable = transferableProvider.getSelection(editor2, selectionToCopy.copyPasteOptions())) != null) {
            EditorEx ex;
            CopyPasteManager.getInstance().setContents(transferable);
            if (editor2 instanceof EditorEx && (ex = (EditorEx)editor2).isStickySelection()) {
                ex.setStickySelection(false);
            }
        }
        CopyAction.restoreCaretStateIfNeeded(editor2, selectionToCopy);
    }

    private static void restoreCaretStateIfNeeded(@NotNull Editor editor2, @NotNull SelectionToCopy selectionToCopy) {
        List<CaretState> originalCaretState;
        if (editor2 == null) {
            CopyAction.$$$reportNull$$$0(9);
        }
        if (selectionToCopy == null) {
            CopyAction.$$$reportNull$$$0(10);
        }
        if ((originalCaretState = selectionToCopy.caretStateToRestore()) != null) {
            Project project2 = editor2.getProject();
            if (project2 != null) {
                CopyAction.highlightSelections(editor2, project2);
            }
            editor2.getCaretModel().setCaretsAndSelections(originalCaretState);
        }
    }

    private static void highlightSelections(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            CopyAction.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            CopyAction.$$$reportNull$$$0(12);
        }
        if (editor2 instanceof TextComponentEditor) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        editor2.getCaretModel().runForEachCaret(caret -> {
            if (caret.hasSelection()) {
                highlightManager.addOccurrenceHighlight(editor2, caret.getSelectionStart(), caret.getSelectionEnd(), EditorColors.SEARCH_RESULT_ATTRIBUTES, 3, null);
            }
        });
    }

    public static boolean isSkipCopyPasteForEmptySelection() {
        return AdvancedSettings.getBoolean((String)SKIP_COPY_AND_CUT_FOR_EMPTY_SELECTION_KEY);
    }

    public static boolean isCopyFromEmptySelectionToSelectLine() {
        return !AdvancedSettings.getBoolean((String)SKIP_SELECTING_LINE_AFTER_COPY_EMPTY_SELECTION_KEY);
    }

    public static boolean isCopyFromEmptySelectionToMoveCaretToLineStart() {
        return Registry.is((String)"editor.action.copy.entireLineFromEmptySelection.moveCaretToLineStart");
    }

    @Nullable
    public static Transferable getSelection(@NotNull Editor editor2) {
        AnAction action2;
        if (editor2 == null) {
            CopyAction.$$$reportNull$$$0(13);
        }
        if (!((action2 = ActionManager.getInstance().getAction("EditorCopy")) instanceof EditorAction)) {
            return null;
        }
        TransferableProvider provider = (TransferableProvider)((EditorAction)action2).getHandlerOfType(TransferableProvider.class);
        return provider == null ? null : provider.getSelection(editor2, EditorCopyPasteHelper.CopyPasteOptions.DEFAULT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferableProvider";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionToCopy";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/CopyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareSelectionToCut";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareSelectionToCopy";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToClipboard";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreCaretStateIfNeeded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightSelections";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Handler
    extends EditorActionHandler {
        public void doExecute(@NotNull Editor editor2, @Nullable Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            CopyAction.copyToClipboard(editor2, dataContext2, (arg_0, arg_1) -> ((EditorCopyPasteHelper)EditorCopyPasteHelper.getInstance()).getSelectionTransferable(arg_0, arg_1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/CopyAction$Handler", "doExecute"));
        }
    }

    public record SelectionToCopy(@NotNull EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions, @Nullable List<CaretState> caretStateToRestore) {
        @NotNull
        private final EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions;
        @NotNull
        private static final DataKey<SelectionToCopy> KEY = DataKey.create((String)"CopyAction.SelectionToCopy.KEY");

        public SelectionToCopy(@NotNull EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions, @Nullable List<CaretState> caretStateToRestore) {
            if (copyPasteOptions == null) {
                SelectionToCopy.$$$reportNull$$$0(0);
            }
        }

        @Nullable
        public static SelectionToCopy fromDataContext(@NotNull DataContext dataContext2) {
            if (dataContext2 == null) {
                SelectionToCopy.$$$reportNull$$$0(1);
            }
            return (SelectionToCopy)KEY.getData(dataContext2);
        }

        @NotNull
        public DataContext extendDataContext(@NotNull DataContext dataContext2) {
            if (dataContext2 == null) {
                SelectionToCopy.$$$reportNull$$$0(2);
            }
            DataContext dataContext3 = CustomizedDataContext.withSnapshot((DataContext)dataContext2, sink -> sink.set(KEY, (Object)this));
            if (dataContext3 == null) {
                SelectionToCopy.$$$reportNull$$$0(3);
            }
            return dataContext3;
        }

        @NotNull
        public EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions() {
            EditorCopyPasteHelper.CopyPasteOptions copyPasteOptions = this.copyPasteOptions;
            if (copyPasteOptions == null) {
                SelectionToCopy.$$$reportNull$$$0(4);
            }
            return copyPasteOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copyPasteOptions";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/actions/CopyAction$SelectionToCopy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/actions/CopyAction$SelectionToCopy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extendDataContext";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyPasteOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromDataContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "extendDataContext";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static interface TransferableProvider {
        @Nullable
        public Transferable getSelection(@NotNull Editor var1, @NotNull EditorCopyPasteHelper.CopyPasteOptions var2);
    }
}

