/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.InlayKeys;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.util.DocumentUtil;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class InlineInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, InlineInlayImpl<?>> {
    final int myPriority;

    InlineInlayImpl(@NotNull EditorImpl editor2, int offset, boolean relatesToPrecedingText, int priority, @NotNull R renderer2) {
        if (editor2 == null) {
            InlineInlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer2 == null) {
            InlineInlayImpl.$$$reportNull$$$0(1);
        }
        super(editor2, offset, relatesToPrecedingText, renderer2);
        this.myPriority = priority;
    }

    @Override
    public RangeMarkerTree<InlineInlayImpl<?>> getTree() {
        return this.myEditor.getInlayModel().myInlineElementsTree;
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            InlineInlayImpl.$$$reportNull$$$0(2);
        }
        this.myEditor.getInlayModel().myPutMergedIntervalsAtBeginning = this.intervalStart() == e.getOffset();
        super.changedUpdateImpl(e);
        if (this.isValid() && DocumentUtil.isInsideSurrogatePair((Document)this.getDocument(), (int)this.intervalStart())) {
            this.invalidate();
        }
    }

    protected void onReTarget(@NotNull DocumentEvent e) {
        if (e == null) {
            InlineInlayImpl.$$$reportNull$$$0(3);
        }
        InlayModelImpl inlayModel = this.myEditor.getInlayModel();
        boolean bl = inlayModel.myPutMergedIntervalsAtBeginning = this.intervalStart() == e.getMoveOffset() + e.getNewLength();
        if (DocumentUtil.isInsideSurrogatePair((Document)this.getDocument(), (int)this.getOffset())) {
            inlayModel.myMoveInProgress = true;
            try {
                this.invalidate();
            }
            finally {
                inlayModel.myMoveInProgress = false;
            }
        }
    }

    @Override
    public void dispose() {
        if (this.isValid()) {
            int offset = this.getOffset();
            List<Inlay<?>> inlays = this.myEditor.getInlayModel().getInlineElementsInRange(offset, offset);
            this.putUserData(InlayKeys.ORDER_BEFORE_DISPOSAL, inlays.indexOf((Object)this));
            this.putUserData(InlayKeys.ID_BEFORE_DISPOSAL, this.getId());
        }
        super.dispose();
    }

    @Override
    void doUpdate() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels <= 0) {
            throw PluginException.createByClass((String)("Positive width should be defined for an inline element by " + String.valueOf(this.myRenderer)), null, (Class)this.myRenderer.getClass());
        }
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        Inlay.Placement placement = Inlay.Placement.INLINE;
        if (placement == null) {
            InlineInlayImpl.$$$reportNull$$$0(4);
        }
        return placement;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        int offset = this.getOffset();
        VisualPosition pos = this.myEditor.offsetToVisualPosition(offset);
        List<Inlay<?>> inlays = this.myEditor.getInlayModel().getInlineElementsInRange(offset, offset);
        int order = inlays.indexOf((Object)this);
        return new VisualPosition(pos.line, pos.column + order, true);
    }

    @Override
    Point getPosition() {
        VisualPosition pos = this.getVisualPosition();
        return this.myEditor.visualPositionToXY(pos);
    }

    public int getHeightInPixels() {
        return this.myEditor.getLineHeight();
    }

    int getOrder() {
        Integer value = (Integer)this.getUserData(InlayKeys.ORDER_BEFORE_DISPOSAL);
        return value == null ? -1 : value;
    }

    @NotNull
    public InlayProperties getProperties() {
        InlayProperties inlayProperties = new InlayProperties().relatesToPrecedingText(this.isRelatedToPrecedingText()).priority(this.myPriority);
        if (inlayProperties == null) {
            InlineInlayImpl.$$$reportNull$$$0(5);
        }
        return inlayProperties;
    }

    public String toString() {
        return "[Inline inlay, offset=" + this.getOffset() + ", width=" + this.myWidthInPixels + ", renderer=" + String.valueOf(this.myRenderer) + "]" + (this.isValid() ? "" : "(invalid)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InlineInlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlineInlayImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlacement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onReTarget";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

