/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldUtil;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.LazyUiDisposableKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTextFieldImpl
implements FileTextField,
Disposable {
    private final JTextField myPathTextField;
    private FileTextFieldUtil.CompletionResult myCurrentCompletion;
    private JBPopup myCurrentPopup;
    private JBPopup myNoSuggestionsPopup;
    private JList<FileLookup.LookupFile> myList;
    private MergingUpdateQueue myUiUpdater;
    private boolean myPathIsUpdating;
    private FileLookup.Finder myFinder;
    private FileLookup.LookupFilter myFilter;
    protected boolean myAutopopup = false;
    private CancelAction myCancelAction;
    private final Set<Action> myDisabledTextActions;
    private volatile Map<String, String> myMacroMap;

    public FileTextFieldImpl(JTextField field, FileLookup.Finder finder, FileLookup.LookupFilter filter2, Map<String, String> macroMap, Disposable parent) {
        this.myPathTextField = field;
        this.myMacroMap = new TreeMap<String, String>(macroMap);
        InputMap listMap = (InputMap)UIManager.getDefaults().get("List.focusInputMap");
        KeyStroke[] listKeys = listMap.keys();
        this.myDisabledTextActions = new HashSet<Action>();
        for (KeyStroke eachListStroke : listKeys) {
            Action textAction;
            Object textActionID;
            String listActionID = (String)listMap.get(eachListStroke);
            if (!"selectNextRow".equals(listActionID) && !"selectPreviousRow".equals(listActionID) || (textActionID = field.getInputMap().get(eachListStroke)) == null || (textAction = field.getActionMap().get(textActionID)) == null) continue;
            this.myDisabledTextActions.add(textAction);
        }
        FileTextFieldImpl assigned = (FileTextFieldImpl)this.myPathTextField.getClientProperty("fileTextField");
        if (assigned != null) {
            assigned.myFinder = finder;
            assigned.myFilter = filter2;
            return;
        }
        this.myPathTextField.putClientProperty("fileTextField", this);
        boolean headless = ApplicationManager.getApplication().isUnitTestMode();
        this.myUiUpdater = new MergingUpdateQueue("FileTextField.UiUpdater", 200, false, (JComponent)this.myPathTextField);
        if (!headless) {
            UiNotifyConnector.installOn((Component)this.myPathTextField, (Activatable)this.myUiUpdater);
        }
        this.myFinder = finder;
        this.myFilter = filter2;
        this.myPathTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileTextFieldImpl.this.processTextChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl$1", "textChanged"));
            }
        });
        this.myPathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FileTextFieldImpl.this.processListSelection(e);
            }
        });
        this.myPathTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileTextFieldImpl.this.closePopup();
            }
        });
        this.myCancelAction = new CancelAction();
        LazyUiDisposableKt.lazyUiDisposable((Disposable)parent, (JComponent)field, (Object)this, (child, project2) -> {
            Disposer.register((Disposable)child, (Disposable)this.myUiUpdater);
            return Unit.INSTANCE;
        });
    }

    public void resetMacroMap(Map<String, String> macroMap) {
        this.myMacroMap = new TreeMap<String, String>(macroMap);
    }

    public void dispose() {
        this.myUiUpdater = null;
    }

    private void processTextChanged() {
        if (this.myAutopopup && !this.isPathUpdating()) {
            this.hideCurrentPopup();
            this.suggestCompletion(false, false);
        }
        this.onTextChanged(this.getTextFieldText());
    }

    protected void onTextChanged(String newValue) {
    }

    private void suggestCompletion(final boolean selectReplacedText, final boolean isExplicitCall) {
        int index;
        if (isExplicitCall) {
            this.myAutopopup = true;
        }
        if (!this.getField().isFocusOwner()) {
            return;
        }
        FileLookup.LookupFile preselected = null;
        if (this.myList != null && this.myCurrentCompletion != null && (index = this.myList.getSelectedIndex()) >= 0 && index < this.myList.getModel().getSize()) {
            preselected = this.myList.getSelectedValue();
        }
        final FileLookup.LookupFile _preselected = preselected;
        this.myUiUpdater.queue(new Update("textField.suggestCompletion"){

            public void run() {
                String completionBase = FileTextFieldImpl.this.getCompletionBase();
                if (completionBase == null) {
                    return;
                }
                FileLookup.LookupFile file2 = FileTextFieldImpl.this.myFinder.find(completionBase);
                if (file2 != null && file2.exists() && !file2.isDirectory()) {
                    return;
                }
                boolean showAdText = completionBase.length() != FileTextFieldImpl.this.myPathTextField.getText().length();
                EmptyProgressIndicator indicator2 = new EmptyProgressIndicator(ModalityState.stateForComponent((Component)FileTextFieldImpl.this.myPathTextField));
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    FileTextFieldUtil.CompletionResult result2 = (FileTextFieldUtil.CompletionResult)ProgressManager.getInstance().runProcess(() -> FileTextFieldUtil.processCompletion(completionBase, FileTextFieldImpl.this.myFinder, FileTextFieldImpl.this.myFilter, FileTextFieldImpl.this.myMacroMap, _preselected), (ProgressIndicator)indicator2);
                    SwingUtilities.invokeLater(() -> {
                        if (completionBase.equals(FileTextFieldImpl.this.getCompletionBase())) {
                            FileTextFieldImpl.this.selectCompletionRemoveText(result2, selectReplacedText);
                            FileTextFieldImpl.this.showCompletionPopup(result2, isExplicitCall, showAdText);
                        }
                    });
                });
            }
        });
    }

    private void selectCompletionRemoveText(FileTextFieldUtil.CompletionResult result2, boolean selectReplacedText) {
        int pos = this.myPathTextField.getCaretPosition();
        if (!result2.variants.isEmpty() && selectReplacedText) {
            this.myPathTextField.setCaretPosition(this.myPathTextField.getText().length());
            this.myPathTextField.moveCaretPosition(pos);
        }
    }

    private void showCompletionPopup(FileTextFieldUtil.CompletionResult result2, boolean isExplicit, boolean showAdText) {
        if (this.myList == null) {
            this.myList = new JBList();
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer((ListCellRenderer<FileLookup.LookupFile>)new GroupedItemsListRenderer((ListItemDescriptor)new ListItemDescriptorAdapter<FileLookup.LookupFile>(){

                public String getTextFor(FileLookup.LookupFile file2) {
                    return FileTextFieldUtil.getLookupString(file2, FileTextFieldImpl.this.myFinder, FileTextFieldImpl.this.myCurrentCompletion);
                }

                public Icon getIconFor(FileLookup.LookupFile value) {
                    return value.getIcon();
                }

                @NlsContexts.Separator
                @Nullable
                private String getSeparatorAboveOf(FileLookup.LookupFile file2) {
                    FileLookup.LookupFile prev;
                    if (FileTextFieldImpl.this.myCurrentCompletion == null) {
                        return null;
                    }
                    int fileIndex = FileTextFieldImpl.this.myCurrentCompletion.variants.indexOf(file2);
                    if (fileIndex > 0 && !FileTextFieldImpl.this.myCurrentCompletion.macros.contains(file2) && FileTextFieldImpl.this.myCurrentCompletion.macros.contains(prev = FileTextFieldImpl.this.myCurrentCompletion.variants.get(fileIndex - 1))) {
                        return "";
                    }
                    if (FileTextFieldImpl.this.myCurrentCompletion.kidsAfterSeparator.indexOf(file2) == 0 && !FileTextFieldImpl.this.myCurrentCompletion.siblings.isEmpty()) {
                        FileLookup.LookupFile parent = file2.getParent();
                        return parent != null ? parent.getName() : "";
                    }
                    if (!FileTextFieldImpl.this.myCurrentCompletion.macros.isEmpty() && fileIndex == 0) {
                        return FileTextFieldImpl.this.getPathVariablesSeparatorText();
                    }
                    return null;
                }

                public boolean hasSeparatorAboveOf(FileLookup.LookupFile value) {
                    return this.getSeparatorAboveOf(value) != null;
                }

                public String getCaptionAboveOf(FileLookup.LookupFile value) {
                    return this.getSeparatorAboveOf(value);
                }
            }));
        }
        if (this.myCurrentPopup != null) {
            this.closePopup();
        }
        this.myCurrentCompletion = result2;
        if (result2.variants.isEmpty()) {
            this.showNoSuggestions(isExplicit);
            return;
        }
        this.myList.setModel((ListModel<FileLookup.LookupFile>)new AbstractListModel<FileLookup.LookupFile>(){

            @Override
            public int getSize() {
                return FileTextFieldImpl.this.myCurrentCompletion.variants.size();
            }

            @Override
            public FileLookup.LookupFile getElementAt(int index) {
                return FileTextFieldImpl.this.myCurrentCompletion.variants.get(index);
            }
        });
        this.myList.getSelectionModel().clearSelection();
        String adText = null;
        if (showAdText) {
            String strokeText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("EditorChooseLookupItemReplace"));
            adText = IdeBundle.message((String)"file.chooser.completion.ad.text", (Object[])new Object[]{strokeText});
        }
        this.myCurrentPopup = new PopupChooserBuilder(this.myList).addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    7.$$$reportNull$$$0(0);
                }
                FileTextFieldImpl.this.myPathTextField.registerKeyboardAction(FileTextFieldImpl.this.myCancelAction, KeyStroke.getKeyStroke(27, 0), 2);
                for (Action each : FileTextFieldImpl.this.myDisabledTextActions) {
                    each.setEnabled(false);
                }
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    7.$$$reportNull$$$0(1);
                }
                FileTextFieldImpl.this.myPathTextField.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
                for (Action each : FileTextFieldImpl.this.myDisabledTextActions) {
                    each.setEnabled(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setRequestFocus(false).setAdText(adText).setAutoSelectIfEmpty(false).setResizable(false).setCancelCallback(() -> {
            int caret = this.myPathTextField.getCaretPosition();
            this.myPathTextField.setSelectionStart(caret);
            this.myPathTextField.setSelectionEnd(caret);
            this.myPathTextField.setFocusTraversalKeysEnabled(true);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getField(), true));
            return Boolean.TRUE;
        }).setItemChosenCallback(() -> this.processChosenFromCompletion(false)).setCancelKeyEnabled(false).setAlpha(0.1f).setFocusOwners(new Component[]{this.myPathTextField}).createPopup();
        if (result2.preselected != null) {
            this.myList.setSelectedValue(result2.preselected, false);
        }
        this.myPathTextField.setFocusTraversalKeysEnabled(false);
        this.myCurrentPopup.showInScreenCoordinates((Component)this.getField(), FileTextFieldImpl.getLocationForCaret(this.myPathTextField));
    }

    private void processChosenFromCompletion(boolean nameOnly) {
        FileTextFieldUtil.processChosenFromCompletion(this.getSelectedFileFromCompletionPopup(), new FileTextFieldUtil.TextFieldDocumentOwner(this.myPathTextField, this::setTextToFile), this.myFinder, nameOnly);
    }

    @NlsContexts.Separator
    @NotNull
    protected String getPathVariablesSeparatorText() {
        String string = IdeBundle.message((String)"file.chooser.completion.path.variables.text", (Object[])new Object[0]);
        if (string == null) {
            FileTextFieldImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    private void showNoSuggestions(boolean isExplicit) {
        this.hideCurrentPopup();
        if (!isExplicit) {
            return;
        }
        JComponent message = HintUtil.createErrorLabel(IdeBundle.message((String)"file.chooser.completion.no.suggestions", (Object[])new Object[0]));
        this.myNoSuggestionsPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(message, message).setRequestFocus(false).setResizable(false).setAlpha(0.1f).setFocusOwners(new Component[]{this.myPathTextField}).createPopup();
        this.myNoSuggestionsPopup.showInScreenCoordinates((Component)this.getField(), FileTextFieldImpl.getLocationForCaret(this.myPathTextField));
    }

    private void hideCurrentPopup() {
        if (this.myCurrentPopup != null) {
            this.myCurrentPopup.cancel();
            this.myCurrentPopup = null;
        }
        if (this.myNoSuggestionsPopup != null) {
            this.myNoSuggestionsPopup.cancel();
            this.myNoSuggestionsPopup = null;
        }
    }

    private static Point getLocationForCaret(JTextComponent pathTextField) {
        Point point;
        int position = pathTextField.getCaretPosition();
        try {
            Rectangle2D rec = pathTextField.modelToView2D(position);
            point = new Point((int)rec.getMaxX(), (int)rec.getMaxY());
        }
        catch (BadLocationException e) {
            point = pathTextField.getCaret().getMagicCaretPosition();
        }
        SwingUtilities.convertPointToScreen(point, pathTextField);
        point.y += 2;
        return point;
    }

    @Nullable
    public FileLookup.LookupFile getFile() {
        String text2 = this.getTextFieldText();
        return text2 != null ? this.myFinder.find(text2) : null;
    }

    protected void setTextToFile(FileLookup.LookupFile file2) {
        Object text2 = file2.getAbsolutePath();
        if (file2.isDirectory() && !((String)text2).endsWith(this.myFinder.getSeparator())) {
            text2 = (String)text2 + this.myFinder.getSeparator();
        }
        this.myPathTextField.setText((String)text2);
    }

    private void processListSelection(KeyEvent e) {
        Action action2;
        Object object;
        if (this.togglePopup(e)) {
            return;
        }
        if (!this.isPopupShowing()) {
            return;
        }
        InputMap map2 = this.myPathTextField.getInputMap(2);
        if (map2 != null && (object = map2.get(KeyStroke.getKeyStrokeForEvent(e))) instanceof Action && (action2 = (Action)object).isEnabled()) {
            action2.actionPerformed(new ActionEvent(this, 1001, "action"));
            e.consume();
            return;
        }
        Object action3 = FileTextFieldImpl.getAction(e, this.myList);
        if ("selectNextRow".equals(action3)) {
            if (this.ensureSelectionExists()) {
                ScrollingUtil.moveDown(this.myList, (int)e.getModifiersEx());
                e.consume();
            }
        } else if ("selectPreviousRow".equals(action3)) {
            ScrollingUtil.moveUp(this.myList, (int)e.getModifiersEx());
            e.consume();
        } else if ("scrollDown".equals(action3)) {
            ScrollingUtil.movePageDown(this.myList);
            e.consume();
        } else if ("scrollUp".equals(action3)) {
            ScrollingUtil.movePageUp(this.myList);
            e.consume();
        } else if (this.getSelectedFileFromCompletionPopup() != null && (e.getKeyCode() == 10 || e.getKeyCode() == 9) && e.getModifiersEx() == 0) {
            this.hideCurrentPopup();
            e.consume();
            this.processChosenFromCompletion(e.getKeyCode() == 9);
        }
    }

    @Nullable
    private FileLookup.LookupFile getSelectedFileFromCompletionPopup() {
        return this.myList != null ? this.myList.getSelectedValue() : null;
    }

    private boolean ensureSelectionExists() {
        if ((this.myList.getSelectedIndex() < 0 || this.myList.getSelectedIndex() >= this.myList.getModel().getSize()) && this.myList.getModel().getSize() >= 0) {
            this.myList.setSelectedIndex(0);
            return false;
        }
        return true;
    }

    private boolean togglePopup(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        Object action2 = ((InputMap)UIManager.get("ComboBox.ancestorInputMap")).get(stroke);
        if ("selectNext".equals(action2)) {
            return !this.isPopupShowing();
        }
        if ("togglePopup".equals(action2)) {
            if (this.isPopupShowing()) {
                this.closePopup();
            } else {
                this.suggestCompletion(true, true);
            }
            return true;
        }
        KeymapManager manager2 = KeymapManager.getInstance();
        if (manager2 != null) {
            Keymap active = manager2.getActiveKeymap();
            for (String id2 : active.getActionIds(stroke)) {
                if (!"CodeCompletion".equals(id2)) continue;
                this.suggestCompletion(true, true);
            }
        }
        return false;
    }

    private static Object getAction(KeyEvent e, JComponent comp) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        return comp.getInputMap().get(stroke);
    }

    public JTextField getField() {
        return this.myPathTextField;
    }

    public boolean isPopupDisplayed() {
        return this.myCurrentPopup != null && this.myCurrentPopup.isVisible();
    }

    public FileLookup.Finder getFinder() {
        return this.myFinder;
    }

    private boolean isPopupShowing() {
        return this.myCurrentPopup != null && this.myList != null && this.myList.isShowing();
    }

    private void closePopup() {
        this.hideCurrentPopup();
        this.myCurrentCompletion = null;
    }

    @Nullable
    public String getTextFieldText() {
        return this.myPathTextField.getText();
    }

    public final void setText(final String text2, boolean now, final @Nullable Runnable onDone) {
        Update update2 = new Update("pathFromTree"){

            public void run() {
                FileTextFieldImpl.this.myPathIsUpdating = true;
                FileTextFieldImpl.this.getField().setText(text2);
                FileTextFieldImpl.this.myPathIsUpdating = false;
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        if (now) {
            update2.run();
        } else {
            this.myUiUpdater.queue(update2);
        }
    }

    public boolean isPathUpdating() {
        return this.myPathIsUpdating;
    }

    @Nullable
    public String getCompletionBase() {
        String text2 = this.getTextFieldText();
        if (text2 == null) {
            return null;
        }
        int pos = this.myPathTextField.getCaretPosition();
        return pos < text2.length() ? text2.substring(0, pos) : text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileChooser/ex/FileTextFieldImpl", "getPathVariablesSeparatorText"));
    }

    private final class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FileTextFieldImpl.this.myCurrentPopup != null) {
                FileTextFieldImpl.this.myAutopopup = false;
                FileTextFieldImpl.this.hideCurrentPopup();
            }
        }
    }
}

