/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.keymap.impl.BundledKeymapBean;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\b\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0012\u0010\t\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006\n"}, d2={"getEffectiveFile", "", "bean", "Lcom/intellij/openapi/keymap/impl/BundledKeymapBean;", "getKeymapName", "osName", "isKnownLinuxKeymap", "", "keymapName", "isKnownMacOSKeymap", "intellij.platform.ide.impl"})
public final class DefaultKeymapKt {
    @NotNull
    public static final String getEffectiveFile(@NotNull BundledKeymapBean bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        String string = bean.file;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file");
        return "keymaps/" + StringsKt.replace$default((String)string, (String)"$OS$", (String)DefaultKeymapKt.osName(), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getKeymapName(@NotNull BundledKeymapBean bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        String string = FileUtilRt.getNameWithoutExtension((String)bean.file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        return StringsKt.removePrefix((String)string, (CharSequence)"$OS$/");
    }

    private static final String osName() {
        return SystemInfoRt.isMac ? "macos" : (SystemInfoRt.isWindows ? "windows" : (SystemInfoRt.isLinux ? "linux" : "other"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isKnownLinuxKeymap(String keymapName) {
        String string = keymapName;
        if (string == null) return false;
        switch (string.hashCode()) {
            case -153522550: {
                if (string.equals("Default for GNOME")) return true;
                return false;
            }
            case 192022326: {
                if (string.equals("Default for KDE")) return true;
                return false;
            }
            case 1658131578: {
                if (!string.equals("Default for XWin")) return false;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isKnownMacOSKeymap(String keymapName) {
        String string = keymapName;
        if (string == null) return false;
        switch (string.hashCode()) {
            case -187773587: {
                if (string.equals("Mac OS X")) return true;
                return false;
            }
            case 84329029: {
                if (string.equals("Xcode")) return true;
                return false;
            }
            case 967362973: {
                if (string.equals("Visual Assist OSX")) return true;
                return false;
            }
            case -1215808018: {
                if (string.equals("Visual Studio for Mac")) return true;
                return false;
            }
            case 1976263100: {
                if (string.equals("Sublime Text (Mac OS X)")) return true;
                return false;
            }
            case -1325174134: {
                if (string.equals("Visual Studio OSX")) return true;
                return false;
            }
            case -2123256501: {
                if (string.equals("QtCreator (Mac OS X)")) return true;
                return false;
            }
            case -220065762: {
                if (string.equals("VSCode OSX")) return true;
                return false;
            }
            case 64263497: {
                if (string.equals("macOS System Shortcuts")) return true;
                return false;
            }
            case -1650442035: {
                if (string.equals("Eclipse (Mac OS X)")) return true;
                return false;
            }
            case -1087610798: {
                if (string.equals("Mac OS X 10.5+")) return true;
                return false;
            }
            case 984080664: {
                if (!string.equals("ReSharper OSX")) return false;
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean access$isKnownLinuxKeymap(String keymapName) {
        return DefaultKeymapKt.isKnownLinuxKeymap(keymapName);
    }

    public static final /* synthetic */ boolean access$isKnownMacOSKeymap(String keymapName) {
        return DefaultKeymapKt.isKnownMacOSKeymap(keymapName);
    }

    public static final /* synthetic */ String access$osName() {
        return DefaultKeymapKt.osName();
    }
}

