/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.CommonBundle;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleConfigurableEditor
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(SingleConfigurableEditor.class);
    private Project myProject;
    private Configurable myConfigurable;
    private JComponent myCenterPanel;
    private final String myDimensionKey;
    private final boolean myShowApplyButton;
    private boolean mySaveAllOnClose;

    public SingleConfigurableEditor(@Nullable Project project2, @NotNull Configurable configurable, String dimensionKey, boolean showApplyButton, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (configurable == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(0);
        }
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(1);
        }
        super(project2, true, ideModalityType);
        this.myDimensionKey = dimensionKey;
        this.myShowApplyButton = showApplyButton;
        String title2 = SingleConfigurableEditor.createTitleString(configurable);
        if (project2 != null && project2.isDefault()) {
            title2 = IdeUICustomization.getInstance().projectMessage("title.for.new.projects", new Object[]{title2});
        }
        this.setTitle(title2);
        this.myProject = project2;
        this.init(configurable);
    }

    protected void init(@NotNull Configurable configurable) {
        if (configurable == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(2);
        }
        this.myConfigurable = configurable;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(Component parent, @NotNull Configurable configurable, String dimensionServiceKey, boolean showApplyButton, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (configurable == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(3);
        }
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(4);
        }
        super(null, parent, true, ideModalityType);
        this.myDimensionKey = dimensionServiceKey;
        this.myShowApplyButton = showApplyButton;
        this.setTitle(SingleConfigurableEditor.createTitleString(configurable));
        this.init(configurable);
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable, String dimensionKey, boolean showApplyButton) {
        this(project2, configurable, dimensionKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable, String dimensionServiceKey, boolean showApplyButton) {
        this(parent, configurable, dimensionServiceKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable, String dimensionKey, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(5);
        }
        this(project2, configurable, dimensionKey, true, ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable, String dimensionKey) {
        this(project2, configurable, dimensionKey, true);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable, String dimensionServiceKey) {
        this(parent, configurable, dimensionServiceKey, true);
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        if (ideModalityType == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(6);
        }
        this(project2, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable), ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project2, Configurable configurable) {
        this(project2, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable) {
        this(parent, configurable, ShowSettingsUtilImpl.createDimensionKey(configurable));
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NlsContexts.DialogTitle
    private static String createTitleString(@NotNull Configurable configurable) {
        String displayName;
        if (configurable == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(7);
        }
        LOG.assertTrue((displayName = configurable.getDisplayName()) != null, (Object)configurable.getClass().getName());
        return displayName.replaceAll("\n", " ");
    }

    protected String getDimensionServiceKey() {
        return this.myDimensionKey != null ? this.myDimensionKey : super.getDimensionServiceKey();
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        if (this.myShowApplyButton) {
            actions.add((Object)new ApplyAction());
        }
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            SingleConfigurableEditor.$$$reportNull$$$0(8);
        }
        return actionArray;
    }

    @Nullable
    protected String getHelpId() {
        return this.myConfigurable.getHelpTopic();
    }

    protected void doOKAction() {
        try {
            if (this.myConfigurable.isModified()) {
                this.myConfigurable.apply();
                this.mySaveAllOnClose = true;
            }
        }
        catch (ConfigurationException e) {
            if (e.getMessage() != null) {
                if (this.myProject != null) {
                    Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog((Component)this.getRootPane(), (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
            }
            return;
        }
        super.doOKAction();
    }

    protected static String createDimensionKey(Configurable configurable) {
        String displayName = configurable.getDisplayName();
        displayName = displayName.replaceAll("\n", "_").replaceAll(" ", "_");
        return "#" + displayName;
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        Configurable configurable = this.myConfigurable;
        JComponent preferred = configurable == null ? null : configurable.getPreferredFocusedComponent();
        return preferred == null ? IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel) : preferred;
    }

    public void dispose() {
        super.dispose();
        this.myConfigurable.disposeUIResources();
        this.myConfigurable = null;
        if (this.mySaveAllOnClose) {
            SaveAndSyncHandler.getInstance().scheduleSave(new SaveAndSyncHandler.SaveTask(this.myProject, true));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModalityType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/ex/SingleConfigurableEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/ex/SingleConfigurableEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTitleString";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    protected class ApplyAction
    extends DialogWrapper.DialogWrapperAction {
        private final Alarm myUpdateAlarm;

        public ApplyAction() {
            super((DialogWrapper)SingleConfigurableEditor.this, CommonBundle.getApplyButtonText());
            this.myUpdateAlarm = new Alarm(SingleConfigurableEditor.this.getDisposable());
            this.setEnabled(false);
            Runnable updateRequest = new Runnable(){

                @Override
                public void run() {
                    if (!SingleConfigurableEditor.this.isShowing()) {
                        return;
                    }
                    try {
                        ApplyAction.this.setEnabled(SingleConfigurableEditor.this.myConfigurable != null && SingleConfigurableEditor.this.myConfigurable.isModified());
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                    ApplyAction.this.addUpdateRequest(this);
                }
            };
            SwingUtilities.invokeLater(() -> {
                if (SingleConfigurableEditor.this.myConfigurable != null) {
                    this.addUpdateRequest(updateRequest);
                }
            });
        }

        private void addUpdateRequest(Runnable updateRequest) {
            Window window = SingleConfigurableEditor.this.getWindow();
            this.myUpdateAlarm.addRequest(updateRequest, 500, window == null ? ModalityState.nonModal() : ModalityState.stateForComponent((Component)window));
        }

        protected void doAction(ActionEvent event) {
            try {
                if (SingleConfigurableEditor.this.myConfigurable.isModified()) {
                    SingleConfigurableEditor.this.myConfigurable.apply();
                    SingleConfigurableEditor.this.mySaveAllOnClose = true;
                    SingleConfigurableEditor.this.setCancelButtonText(CommonBundle.getCloseButtonText());
                }
            }
            catch (ConfigurationException e) {
                if (SingleConfigurableEditor.this.myProject != null) {
                    Messages.showMessageDialog((Project)SingleConfigurableEditor.this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
                Messages.showMessageDialog((Component)SingleConfigurableEditor.this.getRootPane(), (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
            }
        }
    }
}

