/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.newEditor.ConfigurableController;
import com.intellij.openapi.options.newEditor.ConfigurableEditor;
import com.intellij.openapi.options.newEditor.SimpleBanner;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SingleSettingEditor
extends ConfigurableEditor {
    private final SimpleBanner myBanner = new SimpleBanner(){

        @Override
        Dimension getPreferredLeftPanelSize(Dimension size2) {
            return new Dimension(size2.width, JBUIScale.scale((int)35));
        }
    };
    private final Map<Configurable, ConfigurableController> myControllers = new HashMap<Configurable, ConfigurableController>();
    private ConfigurableController myLastController;
    private Dimension myDialogInitSize;

    SingleSettingEditor(Disposable parent, Configurable configurable) {
        super(parent);
        this.add((Component)this.myBanner, "North");
        this.myBanner.setVisible(false);
        this.init(configurable, false);
        if (configurable instanceof Configurable.SingleEditorConfiguration) {
            Configurable.SingleEditorConfiguration singleEditorConfiguration = (Configurable.SingleEditorConfiguration)configurable;
            this.myDialogInitSize = singleEditorConfiguration.getDialogInitialSize();
        }
    }

    @Override
    void postUpdateCurrent(Configurable configurable) {
        ConfigurableController controller;
        if (this.myLastController != null) {
            this.myLastController.setBanner(null);
            this.myLastController = null;
        }
        if ((controller = ConfigurableController.getOrCreate(configurable, this.myControllers)) != null) {
            this.myLastController = controller;
            controller.setBanner(this.myBanner);
        }
        this.myBanner.setVisible(this.myBanner.canShow());
    }

    @Override
    @Nullable
    public Dimension getDialogInitialSize() {
        return this.myDialogInitSize;
    }
}

