/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.util.ApplicationKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0001\u0018\u0000 \u00182\u00020\u00012\u00020\u0002:\u0003\u0018\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/progress/impl/ProgressSuspenderTracker;", "Lcom/intellij/openapi/progress/impl/ProgressSuspender$SuspenderListener;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "suspenderTrackers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/progress/impl/ProgressSuspender;", "Lcom/intellij/openapi/progress/impl/ProgressSuspenderTracker$SuspenderListener;", "indicatorTrackers", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lcom/intellij/openapi/progress/impl/ProgressSuspenderTracker$IndicatorListener;", "startTracking", "", "progressSuspender", "listener", "stopTracking", "indicator", "suspendedStatusChanged", "suspender", "suspendableProgressAppeared", "progressIndicator", "suspendableProgressRemoved", "dispose", "Companion", "SuspenderListener", "IndicatorListener", "intellij.platform.ide.impl"})
public final class ProgressSuspenderTracker
implements ProgressSuspender.SuspenderListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<ProgressSuspender, SuspenderListener> suspenderTrackers = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<ProgressIndicator, IndicatorListener> indicatorTrackers = new ConcurrentHashMap();

    public ProgressSuspenderTracker() {
        MessageBusConnection messageBusConnection = ApplicationKt.getApplication().getMessageBus().connect((Disposable)this);
        Topic<ProgressSuspender.SuspenderListener> topic = ProgressSuspender.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    public final void startTracking(@NotNull ProgressSuspender progressSuspender, @NotNull SuspenderListener listener2) {
        Intrinsics.checkNotNullParameter((Object)progressSuspender, (String)"progressSuspender");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ((Map)this.suspenderTrackers).put(progressSuspender, listener2);
    }

    public final void stopTracking(@NotNull ProgressSuspender progressSuspender) {
        Intrinsics.checkNotNullParameter((Object)progressSuspender, (String)"progressSuspender");
        this.suspenderTrackers.remove(progressSuspender);
    }

    public final void startTracking(@NotNull ProgressIndicator indicator2, @NotNull IndicatorListener listener2) {
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ((Map)this.indicatorTrackers).put(indicator2, listener2);
    }

    public final void stopTracking(@NotNull ProgressIndicator indicator2) {
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        this.indicatorTrackers.remove(indicator2);
    }

    @Override
    public void suspendedStatusChanged(@NotNull ProgressSuspender suspender) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)suspender, (String)"suspender");
            SuspenderListener suspenderListener = this.suspenderTrackers.get(suspender);
            if (suspenderListener == null) break block0;
            suspenderListener.onStateChanged(suspender);
        }
    }

    @Override
    public void suspendableProgressAppeared(@NotNull ProgressSuspender suspender, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)suspender, (String)"suspender");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        IndicatorListener indicatorListener = this.indicatorTrackers.get(progressIndicator);
        if (indicatorListener == null) {
            return;
        }
        IndicatorListener listener2 = indicatorListener;
        listener2.suspenderAdded(suspender);
        this.startTracking(suspender, (SuspenderListener)listener2);
    }

    @Override
    public void suspendableProgressRemoved(@NotNull ProgressSuspender suspender, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)suspender, (String)"suspender");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        IndicatorListener indicatorListener = this.indicatorTrackers.get(progressIndicator);
        if (indicatorListener == null) {
            return;
        }
        IndicatorListener listener2 = indicatorListener;
        this.stopTracking(suspender);
        listener2.suspenderRemoved();
    }

    public void dispose() {
        this.suspenderTrackers.clear();
        this.indicatorTrackers.clear();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/progress/impl/ProgressSuspenderTracker$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/progress/impl/ProgressSuspenderTracker;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nProgressSuspenderTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressSuspenderTracker.kt\ncom/intellij/openapi/progress/impl/ProgressSuspenderTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,70:1\n42#2,3:71\n*S KotlinDebug\n*F\n+ 1 ProgressSuspenderTracker.kt\ncom/intellij/openapi/progress/impl/ProgressSuspenderTracker$Companion\n*L\n58#1:71,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProgressSuspenderTracker getInstance() {
            boolean $i$f$service = false;
            Class<ProgressSuspenderTracker> serviceClass$iv = ProgressSuspenderTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ProgressSuspenderTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/progress/impl/ProgressSuspenderTracker$IndicatorListener;", "Lcom/intellij/openapi/progress/impl/ProgressSuspenderTracker$SuspenderListener;", "suspenderAdded", "", "suspender", "Lcom/intellij/openapi/progress/impl/ProgressSuspender;", "suspenderRemoved", "intellij.platform.ide.impl"})
    public static interface IndicatorListener
    extends SuspenderListener {
        public void suspenderAdded(@NotNull ProgressSuspender var1);

        public void suspenderRemoved();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/progress/impl/ProgressSuspenderTracker$SuspenderListener;", "", "onStateChanged", "", "suspender", "Lcom/intellij/openapi/progress/impl/ProgressSuspender;", "intellij.platform.ide.impl"})
    public static interface SuspenderListener {
        public void onStateChanged(@NotNull ProgressSuspender var1);
    }
}

