/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.InternalThreading;
import com.intellij.openapi.progress.util.ForcedEvent;
import com.intellij.openapi.progress.util.TerminalEvent;
import com.intellij.openapi.progress.util.TransferredWriteActionWrapper;
import com.intellij.platform.locking.impl.IntelliJLockingUtil;
import java.awt.AWTEvent;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/progress/util/EternalEventStealer;", "", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "counter", "", "specialEvents", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/intellij/openapi/progress/util/ForcedEvent;", "dispatchAllEventsForTimeout", "", "timeoutMillis", "", "deferred", "Lkotlinx/coroutines/Deferred;", "intellij.platform.ide.impl"})
final class EternalEventStealer {
    private int counter;
    @NotNull
    private final LinkedBlockingQueue<ForcedEvent> specialEvents;

    public EternalEventStealer(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.specialEvents = new LinkedBlockingQueue();
        IdeEventQueue.Companion.getInstance().addPostEventListener((Function1<? super AWTEvent, Boolean>)((Function1)arg_0 -> EternalEventStealer._init_$lambda$0(this, arg_0)), disposable);
    }

    public final void dispatchAllEventsForTimeout(long timeoutMillis, @NotNull Deferred<?> deferred2) {
        Intrinsics.checkNotNullParameter(deferred2, (String)"deferred");
        long initialMark = System.nanoTime();
        int n = this.counter;
        this.counter = n + 1;
        int id2 = n;
        deferred2.invokeOnCompletion(arg_0 -> EternalEventStealer.dispatchAllEventsForTimeout$lambda$0(this, id2, arg_0));
        long currentMark;
        long elapsedSinceStartNanos;
        long toSleep;
        while ((toSleep = timeoutMillis - (elapsedSinceStartNanos = (currentMark = System.nanoTime()) - initialMark) / (long)1000000) > 0L) {
            if (deferred2.isCompleted()) {
                return;
            }
            try {
                ForcedEvent event;
                ForcedEvent forcedEvent = this.specialEvents.poll();
                if (forcedEvent == null) {
                    forcedEvent = this.specialEvents.poll(toSleep, TimeUnit.MILLISECONDS);
                }
                if ((event = forcedEvent) instanceof TerminalEvent) {
                    if (((TerminalEvent)event).getId() != id2) continue;
                    return;
                }
                if (event instanceof TransferredWriteActionWrapper) {
                    IntelliJLockingUtil.getGlobalThreadingSupport().relaxPreventiveLockingActions(() -> EternalEventStealer.dispatchAllEventsForTimeout$lambda$1(event));
                    continue;
                }
                if (event == null) continue;
                throw new NoWhenBranchMatchedException();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return;
    }

    private static final boolean _init_$lambda$0(EternalEventStealer this$0, AWTEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof InternalThreading.TransferredWriteActionEvent) {
            this$0.specialEvents.add(TransferredWriteActionWrapper.box-impl(TransferredWriteActionWrapper.constructor-impl((InternalThreading.TransferredWriteActionEvent)event)));
        }
        return false;
    }

    private static final Unit dispatchAllEventsForTimeout$lambda$0(EternalEventStealer this$0, int $id, Throwable it) {
        this$0.specialEvents.add(new TerminalEvent($id));
        return Unit.INSTANCE;
    }

    private static final Unit dispatchAllEventsForTimeout$lambda$1(ForcedEvent $event) {
        ((TransferredWriteActionWrapper)$event).unbox-impl().execute();
        return Unit.INSTANCE;
    }
}

