/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.ProgressDialogUIKt;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.platform.ide.progress.CancellableTaskCancellation;
import com.intellij.platform.ide.progress.NonCancellableTaskCancellation;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.util.progress.ProgressState;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eJ\u0015\u0010\u001f\u001a\u00020\u00192\r\u0010 \u001a\t\u0018\u00010!\u00a2\u0006\u0002\b\"J\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%J3\u0010#\u001a\u00020\u00192\b\u0010&\u001a\u0004\u0018\u00010'2\r\u0010(\u001a\t\u0018\u00010!\u00a2\u0006\u0002\b)2\r\u0010*\u001a\t\u0018\u00010!\u00a2\u0006\u0002\b)\u00a2\u0006\u0002\u0010+R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/progress/util/ProgressDialogUI;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "titlePanel", "Lcom/intellij/ui/TitlePanel;", "textLabel", "Ljavax/swing/JLabel;", "detailsLabel", "Lcom/intellij/ui/components/JBLabel;", "progressBar", "Ljavax/swing/JProgressBar;", "getProgressBar", "()Ljavax/swing/JProgressBar;", "cancelButton", "Ljavax/swing/JButton;", "getCancelButton", "()Ljavax/swing/JButton;", "backgroundButton", "getBackgroundButton", "dispose", "", "initCancellation", "cancellation", "Lcom/intellij/platform/ide/progress/TaskCancellation;", "cancelAction", "Lkotlin/Function0;", "updateTitle", "title", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "updateProgress", "state", "Lcom/intellij/platform/util/progress/ProgressState;", "fraction", "", "text", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "details", "(Ljava/lang/Double;Ljava/lang/String;Ljava/lang/String;)V", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nProgressDialogUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgressDialogUI.kt\ncom/intellij/openapi/progress/util/ProgressDialogUI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class ProgressDialogUI
implements Disposable {
    @NotNull
    private final JPanel panel = new JPanel();
    @NotNull
    private final TitlePanel titlePanel = new TitlePanel();
    @NotNull
    private final JLabel textLabel = new JLabel(" ");
    @NotNull
    private final JBLabel detailsLabel = new JBLabel("");
    @NotNull
    private final JProgressBar progressBar = new JProgressBar();
    @NotNull
    private final JButton cancelButton = new JButton();
    @NotNull
    private final JButton backgroundButton = new JButton();

    public ProgressDialogUI() {
        this.titlePanel.setActive(true);
        this.detailsLabel.setComponentStyle(UIUtil.ComponentStyle.REGULAR);
        if (SystemInfoRt.isMac) {
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)((Component)this.detailsLabel));
        }
        this.detailsLabel.setForeground(UIUtil.getContextHelpForeground());
        this.progressBar.putClientProperty("html.disable", false);
        this.progressBar.setMaximum(100);
        this.cancelButton.setText(CommonBundle.getCancelButtonText());
        DialogUtil.registerMnemonic((AbstractButton)this.cancelButton, (char)'&');
        this.backgroundButton.setText(CommonBundle.message((String)"button.background", (Object[])new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.backgroundButton, (char)'&');
        JPanel progressPanel = new JPanel();
        progressPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, (Insets)JBInsets.emptyInsets(), -1, -1, false, false));
        progressPanel.setPreferredSize(new Dimension(SystemInfoRt.isMac ? 350 : JBUIScale.scale((int)450), -1));
        progressPanel.add((Component)this.textLabel, ProgressDialogUIKt.gridConstraints$default(0, 0, 0, 0, 0, 0, 0, new Dimension(0, -1), 126, null));
        progressPanel.add((Component)new JLabel(" "), ProgressDialogUIKt.gridConstraints$default(0, 1, 0, 8, 0, 0, 0, null, 196, null));
        progressPanel.add((Component)this.progressBar, ProgressDialogUIKt.gridConstraints$default(1, 0, 2, 0, 0, 0, 0, null, 250, null));
        progressPanel.add((Component)this.detailsLabel, ProgressDialogUIKt.gridConstraints$default(2, 0, 0, 9, 0, 0, 0, new Dimension(0, -1), 118, null));
        progressPanel.add((Component)new JLabel(" "), ProgressDialogUIKt.gridConstraints$default(2, 1, 0, 8, 0, 0, 0, null, 196, null));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBInsets.emptyInsets(), -1, -1, false, false));
        buttonPanel.add((Component)this.cancelButton, ProgressDialogUIKt.gridConstraints$default(0, 0, 0, 0, 0, 3, 0, null, 222, null));
        buttonPanel.add((Component)this.backgroundButton, ProgressDialogUIKt.gridConstraints$default(1, 0, 0, 0, 0, 3, 0, null, 222, null));
        JPanel progressAndButtonPanel = new JPanel();
        progressAndButtonPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, (Insets)new JBInsets(6, 10, 10, 10), -1, -1, false, false));
        progressAndButtonPanel.setOpaque(false);
        progressAndButtonPanel.add((Component)progressPanel, ProgressDialogUIKt.gridConstraints$default(0, 0, 0, 0, 0, 0, 2, null, 190, null));
        progressAndButtonPanel.add((Component)buttonPanel, ProgressDialogUIKt.gridConstraints$default(0, 1, 0, 0, 0, 1, 2, null, 156, null));
        this.panel.setLayout((LayoutManager)new GridLayoutManager(2, 1, (Insets)JBInsets.emptyInsets(), -1, -1, false, false));
        this.panel.add((Component)this.titlePanel, ProgressDialogUIKt.gridConstraints$default(0, 0, 0, 0, 0, 0, 0, null, 254, null));
        this.panel.add((Component)progressAndButtonPanel, ProgressDialogUIKt.gridConstraints$default(1, 0, 0, 0, 3, 3, 3, null, 142, null));
        if (ExperimentalUI.Companion.isNewUI()) {
            this.panel.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
            progressPanel.setOpaque(false);
            this.progressBar.setOpaque(false);
            buttonPanel.setOpaque(false);
            this.cancelButton.setOpaque(false);
            this.backgroundButton.setOpaque(false);
        }
        TitlePanel titlePanel = this.titlePanel;
        WindowMoveListener moveListener2 = new WindowMoveListener(titlePanel){

            protected Component getView(Component component2) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                Container container = SwingUtilities.getAncestorOfClass(DialogWrapperDialog.class, component2);
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getAncestorOfClass(...)");
                return container;
            }
        };
        moveListener2.installTo((Component)this.titlePanel);
    }

    @NotNull
    public final JPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @NotNull
    public final JButton getCancelButton() {
        return this.cancelButton;
    }

    @NotNull
    public final JButton getBackgroundButton() {
        return this.backgroundButton;
    }

    public void dispose() {
        UIUtil.disposeProgress((JProgressBar)this.progressBar);
        UIUtil.dispose((Component)((Component)this.titlePanel));
        UIUtil.dispose((Component)this.backgroundButton);
        UIUtil.dispose((Component)this.cancelButton);
    }

    public final void initCancellation(@NotNull TaskCancellation cancellation, @NotNull Function0<Unit> cancelAction) {
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        Intrinsics.checkNotNullParameter(cancelAction, (String)"cancelAction");
        TaskCancellation taskCancellation = cancellation;
        if (taskCancellation instanceof NonCancellableTaskCancellation) {
            this.cancelButton.setVisible(false);
        } else if (taskCancellation instanceof CancellableTaskCancellation) {
            String it;
            String string = ((CancellableTaskCancellation)cancellation).getButtonText();
            if (string != null) {
                it = string;
                boolean bl = false;
                this.cancelButton.setText(it);
            }
            String string2 = ((CancellableTaskCancellation)cancellation).getTooltipText();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                this.cancelButton.setToolTipText(it);
            }
            ActionListener buttonListener = arg_0 -> ProgressDialogUI.initCancellation$lambda$2(cancelAction, this, arg_0);
            this.cancelButton.addActionListener(buttonListener);
            this.cancelButton.registerKeyboardAction(buttonListener, KeyStroke.getKeyStroke(27, 0), 1);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTitle(@Nullable String title2) {
        String string;
        TitlePanel titlePanel;
        block4: {
            block3: {
                void p0;
                String string2;
                EDT.assertIsEdt();
                titlePanel = this.titlePanel;
                string = title2;
                if (string == null) break block3;
                String string3 = string2 = string;
                TitlePanel titlePanel2 = titlePanel;
                boolean bl = false;
                boolean bl2 = ((CharSequence)p0).length() > 0;
                titlePanel = titlePanel2;
                string = bl2 ? string2 : null;
                if (string != null) break block4;
            }
            string = " ";
        }
        titlePanel.setText(string);
    }

    public final void updateProgress(@NotNull ProgressState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.updateProgress(state2.getFraction(), state2.getText(), state2.getDetails());
    }

    public final void updateProgress(@Nullable Double fraction, @Nullable String text2, @Nullable String details) {
        EDT.assertIsEdt();
        this.textLabel.setText(ProgressDialogUIKt.access$fitTextToLabel(text2, this.textLabel));
        this.detailsLabel.setText(ProgressDialogUIKt.access$fitTextToLabel(details, (JLabel)this.detailsLabel));
        if (this.progressBar.isShowing()) {
            if (fraction == null) {
                this.progressBar.setIndeterminate(true);
            } else {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue((int)(fraction * (double)100));
            }
        }
    }

    private static final void initCancellation$lambda$2(Function0 $cancelAction, ProgressDialogUI this$0, ActionEvent it) {
        $cancelAction.invoke();
        this$0.cancelButton.setEnabled(false);
    }
}

