/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.TypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TimedOutCallback;
import com.intellij.openapi.util.registry.Registry;
import java.awt.AWTKeyStroke;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class ActionCommand
extends TypeCommand {
    public static final String PREFIX = "%action";

    public ActionCommand(String text2, int line) {
        super(text2, line, true);
    }

    @Override
    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            ActionCommand.$$$reportNull$$$0(0);
        }
        String actionName = this.getText().substring(PREFIX.length()).trim();
        ActionManager am = ActionManager.getInstance();
        AnAction targetAction = am.getAction(actionName);
        if (targetAction == null) {
            this.dumpError(context, "Unknown action: " + actionName);
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                ActionCommand.$$$reportNull$$$0(1);
            }
            return promise;
        }
        if (!context.isUseDirectActionCall()) {
            Shortcut[] sc = KeymapUtil.getActiveKeymapShortcuts((String)actionName).getShortcuts();
            KeyStroke stroke = null;
            for (Shortcut each : sc) {
                if (!(each instanceof KeyboardShortcut)) continue;
                KeyboardShortcut ks = (KeyboardShortcut)each;
                KeyStroke first = ks.getFirstKeyStroke();
                KeyStroke second = ks.getSecondKeyStroke();
                if (second != null) continue;
                stroke = KeyStroke.getKeyStroke(first.getKeyCode(), first.getModifiers(), false);
                break;
            }
            if (stroke != null) {
                TimedOutCallback result2 = new TimedOutCallback(Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Timed out calling action id=" + actionName, new Throwable(), true){

                    protected void dumpError() {
                        context.error(this.getMessage(), ActionCommand.this.getLine());
                    }
                };
                context.message("Invoking action via shortcut: " + String.valueOf(stroke), this.getLine());
                KeyStroke finalStroke = stroke;
                ActionCommand.inWriteSafeContext(() -> this.lambda$_execute$1(context, targetAction, actionName, (ActionCallback)result2, finalStroke));
                Promise promise = Promises.toPromise((ActionCallback)result2);
                if (promise == null) {
                    ActionCommand.$$$reportNull$$$0(2);
                }
                return promise;
            }
        }
        InputEvent input = ActionCommand.getInputEvent(actionName);
        ActionCallback result3 = new ActionCallback();
        context.getRobot().delay(Registry.intValue((String)"actionSystem.playback.delay"));
        ApplicationManager.getApplication().invokeLater(() -> am.tryToExecute(targetAction, input, null, null, false).doWhenProcessed(result3.createSetDoneRunnable()), ModalityState.any());
        Promise promise = Promises.toPromise((ActionCallback)result3);
        if (promise == null) {
            ActionCommand.$$$reportNull$$$0(3);
        }
        return promise;
    }

    public static InputEvent getInputEvent(String actionName) {
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionName).getShortcuts();
        AWTKeyStroke keyStroke = null;
        for (Shortcut each : shortcuts) {
            if (!(each instanceof KeyboardShortcut)) continue;
            keyStroke = ((KeyboardShortcut)each).getFirstKeyStroke();
            break;
        }
        if (keyStroke != null) {
            return new KeyEvent(JOptionPane.getRootFrame(), 401, System.currentTimeMillis(), keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar(), 1);
        }
        return new MouseEvent(JOptionPane.getRootFrame(), 501, 0L, 0, 0, 0, 1, false, 1);
    }

    private /* synthetic */ void lambda$_execute$1(final PlaybackContext context, final AnAction targetAction, final String actionName, final ActionCallback result2, KeyStroke finalStroke) {
        final Disposable disposable = Disposer.newDisposable();
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                if (action2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (context.isDisposed()) {
                        Disposer.dispose((Disposable)disposable);
                        return;
                    }
                    if (targetAction.equals(action2)) {
                        context.message("Performed action: " + actionName, context.getCurrentLine());
                        Disposer.dispose((Disposable)disposable);
                        result2.setDone();
                    }
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/ui/playback/commands/ActionCommand$2";
                objectArray[2] = "beforeActionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        context.runPooledThread(() -> this.type(context.getRobot(), finalStroke));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/playback/commands/ActionCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/playback/commands/ActionCommand";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

