/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public abstract class HandleType {
    private final String myName;
    private final boolean myUseVcs;
    public static final HandleType USE_FILE_SYSTEM = new HandleType(IdeBundle.message((String)"handle.ro.file.status.type.using.file.system", (Object[])new Object[0]), false){

        @Override
        public void processFiles(@NotNull Collection<? extends VirtualFile> files2, @Nullable String changelist, boolean setChangeListActive) {
            if (files2 == null) {
                1.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                ArrayList<VirtualFile> toRefresh = new ArrayList<VirtualFile>(files2.size());
                for (VirtualFile file2 : files2) {
                    try {
                        ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file2, (boolean)false);
                        toRefresh.add(file2);
                    }
                    catch (IOException iOException) {}
                }
                if (!toRefresh.isEmpty()) {
                    RefreshQueue.getInstance().refresh(false, false, null, toRefresh);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/readOnlyHandler/HandleType$1", "processFiles"));
        }
    };

    protected HandleType(String name2, boolean useVcs) {
        this.myName = name2;
        this.myUseVcs = useVcs;
    }

    public String toString() {
        return this.myName;
    }

    public boolean getUseVcs() {
        return this.myUseVcs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandleType that = (HandleType)o;
        if (this.myUseVcs != that.myUseVcs) {
            return false;
        }
        return !(this.myName != null ? !this.myName.equals(that.myName) : that.myName != null);
    }

    public int hashCode() {
        int result2 = this.myName != null ? this.myName.hashCode() : 0;
        result2 = 31 * result2 + (this.myUseVcs ? 1 : 0);
        return result2;
    }

    public abstract void processFiles(@NotNull Collection<? extends VirtualFile> var1, @Nullable String var2, boolean var3);

    public @Unmodifiable List<String> getChangelists() {
        return Collections.emptyList();
    }

    @Nullable
    public String getDefaultChangelist() {
        return null;
    }
}

