/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.FilePartNodeRoot;
import com.intellij.openapi.vfs.impl.UrlPartNode;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class FilePartNode {
    public static final FilePartNode[] EMPTY_ARRAY = new FilePartNode[0];
    protected static final int JAR_SEPARATOR_NAME_ID = -2;
    private final int nameId;
    FilePartNode @NotNull [] children;
    private Object leaves;
    @NotNull
    volatile Object fileOrUrl;
    @NotNull
    final NewVirtualFileSystem fs;

    FilePartNode(int nameId, @NotNull Object fileOrUrl, @NotNull NewVirtualFileSystem fs) {
        if (fileOrUrl == null) {
            FilePartNode.$$$reportNull$$$0(0);
        }
        if (fs == null) {
            FilePartNode.$$$reportNull$$$0(1);
        }
        this.children = EMPTY_ARRAY;
        assert (nameId > 0 || nameId == -2) : nameId + "; " + String.valueOf(this.getClass());
        this.nameId = nameId;
        this.fs = fs;
        this.fileOrUrl = fileOrUrl;
        if (fileOrUrl instanceof VirtualFile) {
            VirtualFile file2 = (VirtualFile)fileOrUrl;
            assert (file2.getFileSystem() == this.fs) : "myFs=" + String.valueOf(this.fs) + "; myFile().getFileSystem()=" + String.valueOf(file2.getFileSystem()) + "; " + String.valueOf(fileOrUrl);
            if (file2.getParent() == null && fs instanceof ArchiveFileSystem) assert (nameId == -2) : nameId;
        }
    }

    protected FilePartNode(@NotNull NewVirtualFileSystem fs) {
        if (fs == null) {
            FilePartNode.$$$reportNull$$$0(2);
        }
        this.children = EMPTY_ARRAY;
        this.nameId = -1;
        this.fileOrUrl = "";
        this.fs = fs;
    }

    @TestOnly
    @NotNull
    public Object getFileOrUrl() {
        Object object = this.fileOrUrl;
        if (object == null) {
            FilePartNode.$$$reportNull$$$0(3);
        }
        return object;
    }

    private VirtualFile fileOrNull() {
        return FilePartNode.fileOrNull(this.fileOrUrl);
    }

    @NotNull
    private String url() {
        return FilePartNode.urlOf(this.fileOrUrl);
    }

    boolean isUrlBased() {
        return this.fileOrUrl instanceof String;
    }

    @Nullable
    static VirtualFile fileOrNull(@NotNull Object fileOrUrl) {
        if (fileOrUrl == null) {
            FilePartNode.$$$reportNull$$$0(4);
        }
        return fileOrUrl instanceof VirtualFile ? (VirtualFile)fileOrUrl : null;
    }

    @NotNull
    static String urlOf(@NotNull Object fileOrUrl) {
        if (fileOrUrl == null) {
            FilePartNode.$$$reportNull$$$0(5);
        }
        String string = fileOrUrl instanceof VirtualFile ? ((VirtualFile)fileOrUrl).getUrl() : (String)fileOrUrl;
        if (string == null) {
            FilePartNode.$$$reportNull$$$0(6);
        }
        return string;
    }

    void addLeaf(@NotNull VirtualFilePointerImpl pointer) {
        Object leaves;
        if (pointer == null) {
            FilePartNode.$$$reportNull$$$0(7);
        }
        Object[] newLeaves = (leaves = this.leaves) == null ? pointer : (leaves instanceof VirtualFilePointerImpl ? new VirtualFilePointerImpl[]{(VirtualFilePointerImpl)((Object)leaves), pointer} : ArrayUtil.append((Object[])((VirtualFilePointerImpl[])leaves), (Object)pointer));
        this.associate(newLeaves);
    }

    int removeLeaf(@NotNull VirtualFilePointerImpl pointer) {
        Object leaves;
        if (pointer == null) {
            FilePartNode.$$$reportNull$$$0(8);
        }
        if ((leaves = this.leaves) == null) {
            return 0;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            if (leaves == pointer) {
                this.leaves = null;
                return 0;
            }
            return 1;
        }
        VirtualFilePointerImpl[] newLeaves = (VirtualFilePointerImpl[])ArrayUtil.remove((Object[])((VirtualFilePointerImpl[])leaves), (Object)((Object)pointer));
        if (newLeaves.length == 0) {
            newLeaves = null;
        }
        this.leaves = newLeaves;
        return newLeaves == null ? 0 : newLeaves.length;
    }

    @NotNull
    static CharSequence fromNameId(int nameId) {
        String string = nameId == -2 ? "!/" : FSRecords.getInstance().getNameByNameId(nameId);
        if (string == null) {
            FilePartNode.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    CharSequence getName() {
        return FilePartNode.fromNameId(this.nameId);
    }

    public String toString() {
        return "FilePartNode: '" + String.valueOf(this.getName()) + "'; children: " + this.children.length + "; fs=" + String.valueOf(this.fs) + "; myFileOrUrl=" + String.valueOf(this.fileOrUrl) + "; " + String.valueOf(this.fileOrUrl.getClass());
    }

    static int getNameId(@NotNull VirtualFile file2) {
        VirtualFileSystem fs;
        if (file2 == null) {
            FilePartNode.$$$reportNull$$$0(10);
        }
        if ((fs = file2.getFileSystem()) instanceof ArchiveFileSystem && file2.getParent() == null) {
            return -2;
        }
        return ((VirtualFileSystemEntry)file2).getNameId();
    }

    @Contract(value="_, _, true, _ -> !null")
    FilePartNode findChildByNameId(@Nullable VirtualFile file2, int nameId, boolean createIfNotFound, @NotNull NewVirtualFileSystem childFs) {
        if (childFs == null) {
            FilePartNode.$$$reportNull$$$0(11);
        }
        if (nameId <= 0 && nameId != -2) {
            throw new IllegalArgumentException("invalid argument nameId: " + nameId);
        }
        for (FilePartNode child : this.children) {
            if (!child.nameEqualTo(nameId, childFs)) continue;
            return child;
        }
        if (createIfNotFound) {
            int index;
            CharSequence name2 = FilePartNode.fromNameId(nameId);
            int n = index = this.children.length == 0 ? -1 : this.binarySearchChildByName(name2);
            if (index >= 0) {
                FilePartNode child = this.children[index];
                throw new AssertionError((Object)(index + " : child= '" + String.valueOf(child) + "'; child.nameEqualTo(nameId)=" + child.nameEqualTo(nameId, childFs) + "; child.getClass()=" + String.valueOf(child.getClass()) + "; child.nameId=" + child.nameId + "; child.getName()='" + String.valueOf(child.getName()) + "'; nameId=" + nameId + "; name='" + String.valueOf(name2) + "'; compare(child) = " + StringUtil.compare((CharSequence)child.getName(), (CharSequence)name2, (!this.isCaseSensitive() ? 1 : 0) != 0) + "; UrlPart.nameEquals: " + StringUtilRt.equal((CharSequence)child.getName(), (CharSequence)FilePartNode.fromNameId(nameId), (boolean)SystemInfoRt.isFileSystemCaseSensitive) + "; name.equals(child.getName())=" + child.getName().equals(name2) + "; file=" + String.valueOf(file2) + "; this.isCaseSensitive()=" + this.isCaseSensitive()));
            }
            Object fileOrUrl = file2;
            if (fileOrUrl == null) {
                fileOrUrl = this.nameId == -1 ? name2.toString() : FilePartNode.childUrl(this.url(), name2, childFs);
            }
            FilePartNode child = new FilePartNode(nameId, fileOrUrl, childFs);
            this.children = (FilePartNode[])ArrayUtil.insert((Object[])this.children, (int)(-index - 1), (Object)child);
            return child;
        }
        return null;
    }

    boolean nameEqualTo(int nameId, @NotNull NewVirtualFileSystem childFs) {
        if (childFs == null) {
            FilePartNode.$$$reportNull$$$0(12);
        }
        if (this.nameId == nameId) {
            return true;
        }
        boolean caseSensitive = childFs.isCaseSensitive();
        if (caseSensitive) {
            return false;
        }
        return StringUtilRt.equal((CharSequence)this.getName(), (CharSequence)FilePartNode.fromNameId(nameId), (boolean)caseSensitive);
    }

    int binarySearchChildByName(@NotNull CharSequence name2) {
        if (name2 == null) {
            FilePartNode.$$$reportNull$$$0(13);
        }
        boolean ignoreCase = !this.isCaseSensitive();
        return ObjectUtils.binarySearch((int)0, (int)this.children.length, i2 -> {
            FilePartNode child = this.children[i2];
            CharSequence childName = child.getName();
            return StringUtil.compare((CharSequence)childName, (CharSequence)name2, (boolean)ignoreCase);
        });
    }

    void addRecursiveDirectoryPtrTo(@NotNull MultiMap<? super VirtualFilePointerListener, ? super VirtualFilePointerImpl> toFirePointers) {
        if (toFirePointers == null) {
            FilePartNode.$$$reportNull$$$0(14);
        }
        this.processPointers(pointer -> {
            if (pointer.isRecursive()) {
                toFirePointers.putValue((Object)pointer.myListener, (Object)pointer);
            }
        });
    }

    void doCheckConsistency(@Nullable VirtualFile parent, @NotNull String name2, @NotNull String urlFromRoot) {
        if (name2 == null) {
            FilePartNode.$$$reportNull$$$0(15);
        }
        if (urlFromRoot == null) {
            FilePartNode.$$$reportNull$$$0(16);
        }
        VirtualFile myFile = this.fileOrNull();
        if (!(this instanceof FilePartNodeRoot)) {
            if (myFile == null) {
                String myUrl = this.url();
                String expectedUrl = StringUtil.trimEnd((String)urlFromRoot, (char)'/');
                String actualUrl = StringUtil.trimEnd((String)myUrl, (char)'/');
                assert (FileUtil.namesEqual((String)actualUrl, (String)expectedUrl)) : "Expected url: '" + expectedUrl + "' but got: '" + actualUrl + "'; parent=" + String.valueOf(parent) + "; name=" + name2 + "; urlFromParent=" + urlFromRoot;
            } else assert (Comparing.equal((Object)FilePartNode.getParentThroughJar(myFile, this.fs), (Object)parent)) : "parent: " + String.valueOf(parent) + "\n myFile: " + String.valueOf(myFile) + "\n getParentThroughJar(myFile, myFS): " + String.valueOf(FilePartNode.getParentThroughJar(myFile, this.fs)) + "\n myFS: " + String.valueOf(this.fs) + "\n myFile.getParent(): " + String.valueOf(myFile.getParent()) + "\n this: " + String.valueOf(this);
        }
        assert (!"..".equals(name2) && !".".equals(name2)) : "url must not contain '.' or '..' but got: " + String.valueOf(this);
        String prevChildName = "";
        Set childNames = CollectionFactory.createFilePathSet((int)this.children.length, (boolean)this.isCaseSensitive());
        for (int i2 = 0; i2 < this.children.length; ++i2) {
            String childUrlFromRoot;
            FilePartNode child = this.children[i2];
            String childName = child.getName().toString();
            boolean added = childNames.add(childName);
            assert (added) : "'" + childName + "' is already in the childNames set (" + String.valueOf(childNames) + "). isCaseSensitive()=" + this.isCaseSensitive() + ";\n all children=" + Arrays.toString(this.children);
            boolean needSeparator = !urlFromRoot.isEmpty() && !urlFromRoot.endsWith("/") && !childName.equals("!/");
            String string = childUrlFromRoot = needSeparator ? urlFromRoot + "/" + childName : urlFromRoot + childName;
            if (child.fs != this.fs) {
                childUrlFromRoot = child.fs.getProtocol() + StringUtil.trimStart((String)childUrlFromRoot, (String)this.fs.getProtocol());
            }
            child.doCheckConsistency(myFile, childName, childUrlFromRoot);
            if (i2 != 0) assert (StringUtil.compare((String)prevChildName, (String)childName, (!this.isCaseSensitive() ? 1 : 0) != 0) < 0) : "children[" + i2 + "] = " + String.valueOf(child) + "; [-1] = " + String.valueOf(this.children[i2 - 1]) + "; isCaseSensitive()=" + this.isCaseSensitive();
            assert (this.fs instanceof LocalFileSystem && (child.fs instanceof ArchiveFileSystem || child.fs instanceof LocalFileSystem) || this.fs instanceof ArchiveFileSystem && child.fs instanceof ArchiveFileSystem) : "this: " + String.valueOf(this) + "; fs=" + String.valueOf(this.fs) + "; child[" + i2 + "] = " + String.valueOf(child) + "; fs=" + String.valueOf(child.fs);
            assert (!(this instanceof UrlPartNode) || child instanceof UrlPartNode) : "this: " + String.valueOf(this) + "; fs=" + String.valueOf(this.fs) + "; child[" + i2 + "] = " + String.valueOf(child) + "; fs=" + String.valueOf(child.fs);
            prevChildName = childName;
        }
        int[] leafNumber = new int[1];
        this.processPointers(p -> {
            assert (p.myNode == this);
            leafNumber[0] = leafNumber[0] + 1;
        });
        int useCount = leafNumber[0];
        assert (useCount == 0 == (this.leaves == null)) : useCount + " - " + String.valueOf(this.leaves instanceof VirtualFilePointerImpl ? this.leaves : Arrays.toString((Object[])((VirtualFilePointerImpl[])this.leaves)));
        if (this.fileOrUrl instanceof String) {
            String nameFromPath;
            String myPath = VfsUtilCore.urlToPath((String)this.url());
            String string = nameFromPath = this.nameId == -2 || myPath.endsWith("!/") ? "!/" : PathUtil.getFileName((String)myPath);
            if (!myPath.isEmpty() && nameFromPath.isEmpty()) {
                nameFromPath = "/";
            }
            assert (StringUtilRt.equal((CharSequence)nameFromPath, (CharSequence)name2, (boolean)this.isCaseSensitive())) : "fileAndUrl: " + String.valueOf(this.fileOrUrl) + "; but this: " + String.valueOf(this) + "; nameFromPath: " + nameFromPath + "; name: " + name2 + "; myPath: " + myPath + "; url: " + this.url() + ";";
            if (myFile != null) {
                String fileName;
                String string2 = fileName = myFile.getParent() == null && myFile.getFileSystem() instanceof ArchiveFileSystem ? "!/" : myFile.getName();
                assert (fileName.equals(name2)) : "fileAndUrl: " + String.valueOf(this.fileOrUrl) + "; but this: " + String.valueOf(this);
                assert (myFile.getFileSystem() == this.fs);
            }
        }
    }

    @VisibleForTesting
    public void update(@NotNull FilePartNode parent, @NotNull FilePartNodeRoot root, @NotNull String debugSource, @Nullable Object debugInvalidationReason) {
        if (parent == null) {
            FilePartNode.$$$reportNull$$$0(17);
        }
        if (root == null) {
            FilePartNode.$$$reportNull$$$0(18);
        }
        if (debugSource == null) {
            FilePartNode.$$$reportNull$$$0(19);
        }
        boolean oldCaseSensitive = this.isCaseSensitive();
        Object fileOrUrl = this.fileOrUrl;
        VirtualFile file2 = FilePartNode.fileOrNull(fileOrUrl);
        boolean changed = false;
        boolean nameChanged = false;
        boolean fileIsValid = false;
        if (file2 != null) {
            fileIsValid = file2.isValid();
            if (fileIsValid && file2.getParent() == null && file2.getFileSystem() instanceof ArchiveFileSystem) {
                VirtualFile local = ((ArchiveFileSystem)file2.getFileSystem()).getLocalByEntry(file2);
                boolean bl = fileIsValid = local != null;
            }
            if (!fileIsValid) {
                file2 = null;
                changed = true;
            }
        }
        Object parentFileOrUrl = parent.fileOrUrl;
        String myName = this.getName().toString();
        Object url = null;
        String parentUrl = null;
        VirtualFile parentFile = FilePartNode.fileOrNull(parentFileOrUrl);
        if (file2 == null) {
            VirtualFile virtualFile = file2 = parentFile == null || !parentFile.isValid() ? null : FilePartNode.findChildThroughJar(parentFile, myName, this.fs);
            if (file2 == null) {
                parentUrl = FilePartNode.urlOf(parentFileOrUrl);
                url = FilePartNode.childUrl(parentUrl, myName, this.fs);
                nameChanged = !Comparing.strEqual((String)url, (String)FilePartNode.urlOf(fileOrUrl));
                changed |= nameChanged;
            } else {
                changed = true;
            }
            boolean bl = fileIsValid = file2 != null && file2.isValid();
        }
        if (parent.nameId != -1 && !(parentFileOrUrl instanceof VirtualFile) && file2 != null) {
            file2 = null;
            fileIsValid = false;
            url = FilePartNode.urlOf(fileOrUrl);
        }
        if (file2 != null) {
            if (fileIsValid) {
                nameChanged = !StringUtil.equals((CharSequence)file2.getNameSequence(), (CharSequence)myName);
                changed |= nameChanged;
            } else {
                file2 = null;
                changed = true;
                url = FilePartNode.urlOf(fileOrUrl);
            }
        }
        VirtualFile result2 = file2 == null ? url : file2;
        boolean bl = !Objects.equals(fileOrUrl, result2);
        FilePartNode thisNode = this;
        if (changed |= bl) {
            VirtualFile oldFile = FilePartNode.fileOrNull(fileOrUrl);
            if (oldFile != null && file2 == null && debugInvalidationReason != null) {
                ((VirtualFileSystemEntry)oldFile).appendInvalidationReason(debugSource, debugInvalidationReason);
            }
            this.fileOrUrl = result2;
            if (file2 != null && (this instanceof UrlPartNode || nameChanged)) {
                thisNode = this.replaceWithFPPN(file2, parent);
            }
        }
        if (file2 != null && !Objects.equals(FilePartNode.getParentThroughJar(file2, this.fs), parentFile)) {
            FilePartNode newNode = root.findOrCreateByFile((VirtualFile)file2).node;
            this.processPointers(p -> newNode.addLeaf((VirtualFilePointerImpl)((Object)p)));
            newNode.children = this.children;
            this.children = EMPTY_ARRAY;
            changed = true;
            parentUrl = FilePartNode.urlOf(parentFileOrUrl);
            root.removeEmptyNodesByPath(VfsUtilCore.urlToPath((String)FilePartNode.childUrl(parentUrl, myName, this.fs)));
            thisNode = newNode;
            nameChanged = true;
        }
        if (nameChanged) {
            String myOldPath = VfsUtilCore.urlToPath((String)FilePartNode.childUrl(parentUrl == null ? FilePartNode.urlOf(parentFileOrUrl) : parentUrl, myName, this.fs));
            String myNewPath = VfsUtilCore.urlToPath((String)FilePartNode.urlOf(result2));
            thisNode.fixUrlPartNodes(myOldPath, myNewPath);
        }
        FilePartNode[] children2 = thisNode.children;
        VirtualFile toReplaceParent = null;
        for (int i2 = 0; i2 < children2.length; ++i2) {
            VirtualFile childFile;
            FilePartNode child = children2[i2];
            if (changed) {
                child.update(thisNode, root, debugSource, debugInvalidationReason);
                if (i2 >= thisNode.children.length) break;
                child = thisNode.children[i2];
            }
            if (file2 != null || (childFile = child.fileOrNull()) == null) continue;
            toReplaceParent = FilePartNode.getParentThroughJar(childFile, child.fs);
        }
        if (toReplaceParent != null) {
            thisNode = this.replaceWithFPPN(toReplaceParent, parent);
        }
        VirtualFile newFile = thisNode.fileOrNull();
        boolean newCaseSensitive = thisNode.isCaseSensitive();
        if (newFile != null && newCaseSensitive != oldCaseSensitive) {
            Arrays.sort(thisNode.children, (c1, c2) -> StringUtil.compare((CharSequence)c1.getName(), (CharSequence)c2.getName(), (!newCaseSensitive ? 1 : 0) != 0));
        }
    }

    private void fixUrlPartNodes(@NotNull String oldPath, @NotNull String newPath) {
        if (oldPath == null) {
            FilePartNode.$$$reportNull$$$0(20);
        }
        if (newPath == null) {
            FilePartNode.$$$reportNull$$$0(21);
        }
        if (this instanceof UrlPartNode) {
            String protocol = this.fs.getProtocol();
            String myUrl = this.url();
            if (StringUtil.startsWith((CharSequence)myUrl, (int)(protocol.length() + "://".length()), (CharSequence)oldPath)) {
                this.fileOrUrl = protocol + "://" + newPath + myUrl.substring(protocol.length() + "://".length() + oldPath.length());
            }
        }
        for (FilePartNode child : this.children) {
            child.fixUrlPartNodes(oldPath, newPath);
        }
    }

    void replaceChildrenWithUPN() {
        this.children = (FilePartNode[])ContainerUtil.map((Object[])this.children, n -> n.replaceWithUPN(this), (Object[])EMPTY_ARRAY);
    }

    @NotNull
    private UrlPartNode replaceWithUPN(@NotNull FilePartNode parent) {
        if (parent == null) {
            FilePartNode.$$$reportNull$$$0(22);
        }
        if (this instanceof UrlPartNode) {
            UrlPartNode urlPartNode = (UrlPartNode)this;
            if (urlPartNode == null) {
                FilePartNode.$$$reportNull$$$0(23);
            }
            return urlPartNode;
        }
        if (this instanceof FilePartNodeRoot) {
            throw new IllegalArgumentException("invalid argument node: " + String.valueOf(this));
        }
        UrlPartNode newNode = new UrlPartNode(this.getName().toString(), parent.url(), this.fs);
        newNode.children = this.children;
        newNode.replaceChildrenWithUPN();
        this.processPointers(pointer -> newNode.addLeaf((VirtualFilePointerImpl)((Object)pointer)));
        this.leaves = null;
        UrlPartNode urlPartNode = newNode;
        if (urlPartNode == null) {
            FilePartNode.$$$reportNull$$$0(24);
        }
        return urlPartNode;
    }

    @NotNull
    FilePartNode replaceWithFPPN(@NotNull VirtualFile file2, @NotNull FilePartNode parent) {
        if (file2 == null) {
            FilePartNode.$$$reportNull$$$0(25);
        }
        if (parent == null) {
            FilePartNode.$$$reportNull$$$0(26);
        }
        int nameId = FilePartNode.getNameId(file2);
        parent.children = (FilePartNode[])ArrayUtil.remove((Object[])parent.children, (Object)this);
        FilePartNode newNode = parent.findChildByNameId(file2, nameId, true, (NewVirtualFileSystem)file2.getFileSystem());
        assert (newNode.nameId == nameId);
        newNode.children = this.children;
        this.processPointers(pointer -> newNode.addLeaf((VirtualFilePointerImpl)((Object)pointer)));
        this.leaves = null;
        FilePartNode filePartNode = newNode;
        if (filePartNode == null) {
            FilePartNode.$$$reportNull$$$0(27);
        }
        return filePartNode;
    }

    @NotNull
    static String childUrl(@NotNull String parentUrl, @NotNull CharSequence childName, @NotNull NewVirtualFileSystem fs) {
        if (parentUrl == null) {
            FilePartNode.$$$reportNull$$$0(28);
        }
        if (childName == null) {
            FilePartNode.$$$reportNull$$$0(29);
        }
        if (fs == null) {
            FilePartNode.$$$reportNull$$$0(30);
        }
        if (childName.equals("!/") && fs instanceof ArchiveFileSystem) {
            String string = VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)parentUrl), (char)'/')) + String.valueOf(childName);
            if (string == null) {
                FilePartNode.$$$reportNull$$$0(31);
            }
            return string;
        }
        Object object = parentUrl.isEmpty() ? VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)childName.toString()) : VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)parentUrl), (char)'/')) + "/" + String.valueOf(childName);
        if (object == null) {
            FilePartNode.$$$reportNull$$$0(32);
        }
        return object;
    }

    private void associate(@Nullable Object leaves) {
        this.leaves = leaves;
        if (leaves != null) {
            if (leaves instanceof VirtualFilePointerImpl) {
                ((VirtualFilePointerImpl)((Object)leaves)).myNode = this;
            } else {
                for (VirtualFilePointerImpl pointer : (VirtualFilePointerImpl[])leaves) {
                    pointer.myNode = this;
                }
            }
        }
    }

    VirtualFilePointerImpl getPointer(@Nullable VirtualFilePointerListener listener2) {
        VirtualFilePointerImpl[] array;
        Object leaves = this.leaves;
        if (leaves == null) {
            return null;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            VirtualFilePointerImpl leaf = (VirtualFilePointerImpl)((Object)leaves);
            return leaf.myListener == listener2 ? leaf : null;
        }
        for (VirtualFilePointerImpl pointer : array = (VirtualFilePointerImpl[])leaves) {
            if (pointer.myListener != listener2) continue;
            return pointer;
        }
        return null;
    }

    void addAllPointersTo(@NotNull Collection<? super VirtualFilePointerImpl> outList) {
        if (outList == null) {
            FilePartNode.$$$reportNull$$$0(33);
        }
        this.processPointers(p -> {
            if (p.myNode != null) {
                outList.add((VirtualFilePointerImpl)((Object)p));
            }
        });
    }

    void processPointers(@NotNull Consumer<? super VirtualFilePointerImpl> processor2) {
        VirtualFilePointerImpl[] pointers;
        Object leaves;
        if (processor2 == null) {
            FilePartNode.$$$reportNull$$$0(34);
        }
        if ((leaves = this.leaves) == null) {
            return;
        }
        if (leaves instanceof VirtualFilePointerImpl) {
            processor2.accept((VirtualFilePointerImpl)((Object)leaves));
            return;
        }
        for (VirtualFilePointerImpl pointer : pointers = (VirtualFilePointerImpl[])leaves) {
            processor2.accept(pointer);
        }
    }

    static VirtualFile getParentThroughJar(@NotNull VirtualFile file2, @NotNull NewVirtualFileSystem fs) {
        VirtualFile parent;
        if (file2 == null) {
            FilePartNode.$$$reportNull$$$0(35);
        }
        if (fs == null) {
            FilePartNode.$$$reportNull$$$0(36);
        }
        if ((parent = file2.getParent()) == null && fs instanceof ArchiveFileSystem) {
            parent = ((ArchiveFileSystem)fs).getLocalByEntry(file2);
        }
        return parent;
    }

    static VirtualFile findChildThroughJar(@NotNull VirtualFile file2, @NotNull String name2, @NotNull NewVirtualFileSystem childFs) {
        if (file2 == null) {
            FilePartNode.$$$reportNull$$$0(37);
        }
        if (name2 == null) {
            FilePartNode.$$$reportNull$$$0(38);
        }
        if (childFs == null) {
            FilePartNode.$$$reportNull$$$0(39);
        }
        VirtualFile child = name2.equals("!/") && childFs instanceof ArchiveFileSystem ? ((ArchiveFileSystem)childFs).getRootByLocal(file2) : file2.findChild(name2);
        return child;
    }

    boolean removeEmptyNodesByFile(@NotNull List<VirtualFile> parts) {
        if (parts == null) {
            FilePartNode.$$$reportNull$$$0(40);
        }
        if (parts.isEmpty()) {
            return this.children.length == 0;
        }
        VirtualFile file2 = parts.remove(parts.size() - 1);
        FilePartNode child = this.findChildByNameId(null, FilePartNode.getNameId(file2), false, (NewVirtualFileSystem)file2.getFileSystem());
        if (child == null) {
            return false;
        }
        boolean toRemove = child.removeEmptyNodesByFile(parts);
        if (toRemove) {
            this.children = this.children.length == 1 ? EMPTY_ARRAY : (FilePartNode[])ArrayUtil.remove((Object[])this.children, (Object)child);
            return this.children.length == 0 && this.leaves == null;
        }
        return false;
    }

    void removeEmptyNodesByPath(@NotNull String path) {
        NewVirtualFileSystem.PathFromRoot pair;
        if (path == null) {
            FilePartNode.$$$reportNull$$$0(41);
        }
        if ((pair = NewVirtualFileSystem.extractRootFromPath((NewVirtualFileSystem)this.fs, (String)path)) != null) {
            int rootIndex = this.binarySearchChildByName(pair.root().getNameSequence());
            if (rootIndex >= 0 && this.children[rootIndex].removeEmptyNodesByPath(FilePartNodeRoot.splitNames(pair.pathFromRoot()))) {
                this.children = this.children.length == 1 ? EMPTY_ARRAY : (FilePartNode[])ArrayUtil.remove((Object[])this.children, (int)rootIndex);
            }
        } else {
            this.removeEmptyNodesByPath(FilePartNodeRoot.splitNames(path));
        }
    }

    private boolean removeEmptyNodesByPath(@NotNull List<String> parts) {
        if (parts == null) {
            FilePartNode.$$$reportNull$$$0(42);
        }
        if (parts.isEmpty()) {
            return this.children.length == 0;
        }
        String name2 = parts.remove(parts.size() - 1);
        int index = this.binarySearchChildByName(name2);
        if (index < 0) {
            return false;
        }
        FilePartNode child = this.children[index];
        boolean toRemove = child.removeEmptyNodesByPath(parts);
        if (toRemove) {
            this.children = this.children.length == 1 ? EMPTY_ARRAY : (FilePartNode[])ArrayUtil.remove((Object[])this.children, (Object)child);
            return this.children.length == 0 && this.leaves == null;
        }
        return false;
    }

    boolean isCaseSensitive() {
        VirtualFile file2 = this.fileOrNull();
        return file2 == null ? this.fs.isCaseSensitive() : file2.isCaseSensitive();
    }

    private void print(StringBuilder buffer2, boolean recheck, String prefix) {
        buffer2.append(prefix).append(" ").append(this.getName()).append(" isCaseSensitive:").append(this.isCaseSensitive());
        VirtualFile file2 = this.fileOrNull();
        if (recheck && file2 != null && this.fs instanceof LocalFileSystem) {
            buffer2.append(" really parent sensitive: ").append(FileSystemUtil.readParentCaseSensitivity((File)new File(file2.getPath())));
        }
        buffer2.append("\n");
        for (FilePartNode child : this.children) {
            child.print(buffer2, recheck, prefix + "  ");
        }
    }

    StringBuilder print(boolean recheck) {
        StringBuilder buffer2 = new StringBuilder();
        this.print(buffer2, recheck, "");
        return buffer2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 9, 23, 24, 27, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrUrl";
                break;
            }
            case 1: 
            case 2: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/FilePartNode";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 10: 
            case 25: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childFs";
                break;
            }
            case 13: 
            case 15: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFirePointers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlFromRoot";
                break;
            }
            case 17: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSource";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUrl";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outList";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/FilePartNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileOrUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "urlOf";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNameId";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithUPN";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithFPPN";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "childUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 23: 
            case 24: 
            case 27: 
            case 31: 
            case 32: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileOrNull";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "urlOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeLeaf";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNameId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findChildByNameId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "nameEqualTo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "binarySearchChildByName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addRecursiveDirectoryPtrTo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCheckConsistency";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fixUrlPartNodes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithUPN";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithFPPN";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "childUrl";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addAllPointersTo";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processPointers";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getParentThroughJar";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findChildThroughJar";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyNodesByFile";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyNodesByPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 9, 23, 24, 27, 31, 32 -> new IllegalStateException(string);
        };
    }
}

