/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class IdentityVirtualFilePointer
extends VirtualFilePointerImpl
implements VirtualFilePointer,
Disposable {
    private final Map<String, IdentityVirtualFilePointer> myUrlToIdentity;
    private final VirtualFilePointerManagerImpl myVirtualFilePointerManager;
    private final VirtualFile myFile;
    private final String myUrl;

    IdentityVirtualFilePointer(VirtualFile file2, @NotNull String url, Map<String, IdentityVirtualFilePointer> urlToIdentity, @NotNull VirtualFilePointerManagerImpl virtualFilePointerManager, VirtualFilePointerListener listener2) {
        if (url == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(0);
        }
        if (virtualFilePointerManager == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(1);
        }
        super(listener2);
        this.myVirtualFilePointerManager = virtualFilePointerManager;
        this.myUrlToIdentity = urlToIdentity;
        this.myFile = file2;
        this.myUrl = url;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.getUrl();
        if (string == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public VirtualFile getFile() {
        return this.isValid() ? this.myFile : null;
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        String string = this.getUrl();
        if (string == null) {
            IdentityVirtualFilePointer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isValid() {
        return this.myFile == null || this.myFile.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = this.myVirtualFilePointerManager;
        synchronized (virtualFilePointerManagerImpl) {
            this.incrementUsageCount(-1);
            this.myUrlToIdentity.remove(this.myUrl);
        }
    }

    @Override
    public String toString() {
        return "identity: url='" + this.myUrl + "'; file=" + String.valueOf(this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFilePointerManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

