/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.impl.FrameBoundsConverter;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.WindowManagerImplKt;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.FramePeer;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0000\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u00a8\u0006\u0011"}, d2={"updateFrameInfo", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "frame", "Ljavax/swing/JFrame;", "lastNormalFrameBounds", "Ljava/awt/Rectangle;", "oldFrameInfo", "checkForNonsenseBounds", "", "name", "", "bounds", "height", "", "width", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFrameInfoHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameInfoHelper.kt\ncom/intellij/openapi/wm/impl/FrameInfoHelperKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,145:1\n13#2:146\n*S KotlinDebug\n*F\n+ 1 FrameInfoHelper.kt\ncom/intellij/openapi/wm/impl/FrameInfoHelperKt\n*L\n119#1:146\n*E\n"})
public final class FrameInfoHelperKt {
    @NotNull
    public static final FrameInfo updateFrameInfo(@NotNull ProjectFrameHelper frameHelper, @NotNull JFrame frame, @Nullable Rectangle lastNormalFrameBounds, @Nullable FrameInfo oldFrameInfo) {
        FrameInfo frameInfo;
        FrameInfo frameInfo2;
        boolean usePreviousBounds;
        Object peer;
        Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        int extendedState = frame.getExtendedState();
        if (SystemInfoRt.isMac && (peer = AWTAccessor.getComponentAccessor().getPeer(frame)) instanceof FramePeer) {
            extendedState = ((FramePeer)peer).getState();
        }
        boolean isInFullScreen = FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs() && frameHelper.isInFullScreen();
        boolean isMaximized = FrameInfoHelper.Companion.isMaximized(extendedState) || isInFullScreen;
        FrameInfoHelperKt.checkForNonsenseBounds("updateFrameInfo.lastNormalFrameBounds", lastNormalFrameBounds);
        FrameInfo frameInfo3 = oldFrameInfo;
        Rectangle oldBounds = frameInfo3 != null ? frameInfo3.getBounds() : null;
        FrameInfoHelperKt.checkForNonsenseBounds("updateFrameInfo.oldBounds", oldBounds);
        Rectangle frameBounds = frame.getBounds();
        FrameInfoHelperKt.checkForNonsenseBounds("updateFrameInfo.frameBounds", frameBounds);
        Rectangle newBounds = FrameBoundsConverter.convertToDeviceSpace(frame.getGraphicsConfiguration(), isMaximized && lastNormalFrameBounds != null ? lastNormalFrameBounds : frameBounds);
        boolean bl = usePreviousBounds = lastNormalFrameBounds == null && isMaximized && oldBounds != null && newBounds.contains(new Point((int)oldBounds.getCenterX(), (int)oldBounds.getCenterY()));
        if (WindowManagerImplKt.IDE_FRAME_EVENT_LOG.isDebugEnabled()) {
            WindowManagerImplKt.IDE_FRAME_EVENT_LOG.debug("Updating frame bounds: lastNormalFrameBounds = " + lastNormalFrameBounds + ", frame.bounds = " + frameBounds + ", frame screen = " + frame.getGraphicsConfiguration().getBounds() + ", scale = " + JBUIScale.sysScale((GraphicsConfiguration)frame.getGraphicsConfiguration()) + ", isMaximized = " + isMaximized + ", isInFullScreen = " + isInFullScreen + ", oldBounds = " + oldBounds + ", newBounds = " + newBounds + ", usePreviousBounds = " + usePreviousBounds);
        }
        if (!(usePreviousBounds || Intrinsics.areEqual((Object)oldBounds, (Object)newBounds) || ScreenUtil.intersectsVisibleScreen((Window)frame))) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(WindowInfoImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Frame bounds are invalid: " + newBounds);
        }
        if ((frameInfo2 = oldFrameInfo) == null) {
            frameInfo2 = frameInfo = new FrameInfo();
        }
        if (!usePreviousBounds) {
            frameInfo.setBounds(newBounds);
        }
        frameInfo.setExtendedState(extendedState);
        if (FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs()) {
            frameInfo.setFullScreen(isInFullScreen);
        }
        return frameInfo;
    }

    public static final void checkForNonsenseBounds(@NotNull String name2, @Nullable Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (bounds == null) {
            return;
        }
        if (bounds.height < 100 || bounds.width < 100) {
            WindowManagerImplKt.IDE_FRAME_EVENT_LOG.warn(new Throwable("The frame bounds '" + name2 + "' are suspiciously small: " + bounds));
        }
    }

    public static final void checkForNonsenseBounds(@NotNull String name2, int height, int width) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (height < 100 || width < 100) {
            WindowManagerImplKt.IDE_FRAME_EVENT_LOG.warn(new Throwable("The frame bounds '" + name2 + "' are suspiciously small: " + height + "x" + width));
        }
    }
}

