/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.ToolWindowExternalDecorator;
import com.intellij.openapi.wm.impl.ToolWindowExternalDecoratorBoundsHelper;
import com.intellij.openapi.wm.impl.ToolWindowExternalDecoratorKt;
import com.intellij.openapi.wm.impl.WindowedDecoratorKt;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.ClientProperty;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/wm/impl/WindowedDecorator;", "Lcom/intellij/openapi/ui/FrameWrapper;", "Lcom/intellij/openapi/wm/impl/ToolWindowExternalDecorator;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "component", "Lcom/intellij/toolWindow/InternalDecoratorImpl;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/toolWindow/InternalDecoratorImpl;)V", "boundsHelper", "Lcom/intellij/openapi/wm/impl/ToolWindowExternalDecoratorBoundsHelper;", "id", "getId", "()Ljava/lang/String;", "window", "Ljava/awt/Window;", "getWindow", "()Ljava/awt/Window;", "getToolWindowType", "Lcom/intellij/openapi/wm/ToolWindowType;", "apply", "", "info", "Lcom/intellij/openapi/wm/WindowInfo;", "setLocationRelativeTo", "parentFrame", "Ljava/awt/Component;", "value", "Ljava/awt/Rectangle;", "visibleWindowBounds", "getVisibleWindowBounds", "()Ljava/awt/Rectangle;", "setVisibleWindowBounds", "(Ljava/awt/Rectangle;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
public final class WindowedDecorator
extends FrameWrapper
implements ToolWindowExternalDecorator {
    @NotNull
    private final ToolWindowExternalDecoratorBoundsHelper boundsHelper;
    @NotNull
    private final String id;

    public WindowedDecorator(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title2, final @NotNull InternalDecoratorImpl component2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        super(project2, null, false, title2, (JComponent)((Object)component2), null, 38, null);
        this.boundsHelper = new ToolWindowExternalDecoratorBoundsHelper(this);
        this.id = component2.getToolWindowId();
        final Window frame = this.getFrame();
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (WindowedDecoratorKt.access$getLOG$p().isTraceEnabled()) {
                    WindowedDecoratorKt.access$getLOG$p().trace("Windowed tool window " + this.getId() + " moved to " + frame.getBounds() + ", scheduling bounds update");
                }
                component2.toolWindow.onMovedOrResized();
            }
        });
        ClientProperty.put((Window)frame, ToolWindowExternalDecorator.DECORATOR_PROPERTY, (Object)this);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Window getWindow() {
        return this.getFrame();
    }

    @Override
    @NotNull
    public ToolWindowType getToolWindowType() {
        return ToolWindowType.WINDOWED;
    }

    @Override
    public void apply(@NotNull WindowInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Rectangle bounds = info.getFloatingBounds();
        if (bounds != null) {
            if (WindowedDecoratorKt.access$getLOG$p().isDebugEnabled()) {
                WindowedDecoratorKt.access$getLOG$p().debug("Applying windowed tool window " + info.getId() + " bounds " + bounds);
            }
            this.getFrame().setBounds(bounds);
        } else if (WindowedDecoratorKt.access$getLOG$p().isDebugEnabled()) {
            WindowedDecoratorKt.access$getLOG$p().debug("Windowed tool window " + info.getId() + " info has no bounds, not applying anything");
        }
    }

    @Override
    public void setLocationRelativeTo(@Nullable Component parentFrame) {
        this.getFrame().setLocationRelativeTo(parentFrame);
        Rectangle rectangle = this.getFrame().getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
        this.boundsHelper.setBounds(rectangle);
    }

    @Override
    @NotNull
    public Rectangle getVisibleWindowBounds() {
        Rectangle result2 = this.getFrame().getBounds();
        JBInsets.removeFrom((Rectangle)result2, (Insets)ToolWindowExternalDecoratorKt.getInvisibleInsets(this.getFrame()));
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    @Override
    public void setVisibleWindowBounds(@NotNull Rectangle value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.boundsHelper.setBounds(value);
        Rectangle newBounds = new Rectangle(value);
        JBInsets.addTo((Rectangle)newBounds, (Insets)ToolWindowExternalDecoratorKt.getInvisibleInsets(this.getFrame()));
        this.getFrame().setBounds(newBounds);
    }

    @Override
    @NotNull
    public Logger log() {
        return WindowedDecoratorKt.access$getLOG$p();
    }
}

