/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.header;

import com.intellij.CommonBundle;
import com.intellij.accessibility.AccessibilityUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.BorderPainterHolder;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomFrameTopBorder;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeaderKt;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomWindowHeaderUtil;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.DialogHeader;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.FrameHeader;
import com.intellij.openapi.wm.impl.headertoolbar.HeaderClickTransparentListener;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.ui.BorderPainter;
import com.intellij.ui.DefaultBorderPainter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.UIBundle;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextCache;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.jetbrains.JBR;
import com.jetbrains.WindowDecorations;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0002\b\u000b\b0\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0003KLMB\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020(H\u0014J\u0017\u0010)\u001a\u00070*\u00a2\u0006\u0002\b+2\b\b\u0002\u0010,\u001a\u00020\u0011H\u0014J(\u0010-\u001a\u00020%2\u000e\b\u0002\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00110/2\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020\u00110/H\u0004J\b\u00101\u001a\u00020%H\u0016J\b\u00107\u001a\u00020%H\u0016J\b\u00108\u001a\u00020%H\u0016J\b\u00109\u001a\u00020%H\u0014J\b\u0010:\u001a\u00020%H\u0014J\b\u0010;\u001a\u00020%H\u0014J\u0012\u0010<\u001a\u00020%2\b\u0010=\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u00020\u0011H\u0002J\b\u0010@\u001a\u00020%H\u0014J\b\u0010A\u001a\u00020%H\u0004J\b\u0010B\u001a\u00020\u0019H\u0002J\u0010\u0010C\u001a\u00020%2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020%2\u0006\u0010G\u001a\u00020HH\u0016J\b\u0010I\u001a\u00020JH\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0018\u001a\u00020\u00198DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001e\u001a\u00020\u001fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u00102\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u0082\u0001\u0002NO\u00a8\u0006P"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/application/impl/BorderPainterHolder;", "window", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "windowListener", "com/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$windowListener$1", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$windowListener$1;", "componentListener", "com/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$componentListener$1", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$componentListener$1;", "iconProvider", "Lcom/intellij/ui/scale/ScaleContextCache;", "Ljavax/swing/Icon;", "isActive", "", "customFrameTopBorder", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomFrameTopBorder;", "customTitleBar", "Lcom/jetbrains/WindowDecorations$CustomTitleBar;", "getCustomTitleBar", "()Lcom/jetbrains/WindowDecorations$CustomTitleBar;", "productIcon", "Ljavax/swing/JComponent;", "getProductIcon", "()Ljavax/swing/JComponent;", "productIcon$delegate", "Lkotlin/Lazy;", "borderPainter", "Lcom/intellij/ui/BorderPainter;", "getBorderPainter", "()Lcom/intellij/ui/BorderPainter;", "setBorderPainter", "(Lcom/intellij/ui/BorderPainter;)V", "updateUI", "", "updateSize", "calcHeight", "", "getHeaderBackground", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "active", "setCustomFrameTopBorder", "isTopNeeded", "Lkotlin/Function0;", "isBottomNeeded", "windowStateChanged", "added", "getAdded", "()Z", "setAdded", "(Z)V", "addNotify", "removeNotify", "installListeners", "uninstallListeners", "updateCustomTitleBar", "setCustomTitleBar", "titleBar", "setActive", "value", "updateActive", "close", "createProductIcon", "addMenuItems", "menu", "Ljavax/swing/JPopupMenu;", "paint", "g", "Ljava/awt/Graphics;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "Companion", "CustomFrameAction", "AccessibleCustomHeader", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/DialogHeader;", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/FrameHeader;", "intellij.platform.ide.impl"})
public abstract sealed class CustomHeader
extends JPanel
implements BorderPainterHolder
permits DialogHeader, FrameHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Window window;
    @NotNull
    private final windowListener.1 windowListener;
    @NotNull
    private final componentListener.1 componentListener;
    @NotNull
    private final ScaleContextCache<Icon> iconProvider;
    @JvmField
    public boolean isActive;
    @Nullable
    private CustomFrameTopBorder customFrameTopBorder;
    @ApiStatus.Internal
    @Nullable
    private final WindowDecorations.CustomTitleBar customTitleBar;
    @NotNull
    private final Lazy productIcon$delegate;
    @NotNull
    private BorderPainter borderPainter;
    private boolean added;

    private CustomHeader(Window window) {
        this.window = window;
        this.windowListener = new WindowAdapter(this){
            final /* synthetic */ CustomHeader this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowActivated(WindowEvent ev) {
                CustomHeader.access$setActive(this.this$0, true);
            }

            public void windowDeactivated(WindowEvent ev) {
                CustomHeader.access$setActive(this.this$0, false);
            }

            public void windowStateChanged(WindowEvent e) {
                this.this$0.windowStateChanged();
            }
        };
        this.componentListener = new ComponentAdapter(this){
            final /* synthetic */ CustomHeader this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(() -> componentListener.1.componentResized$lambda$0(this.this$0));
            }

            private static final void componentResized$lambda$0(CustomHeader this$0) {
                this$0.updateCustomTitleBar();
            }
        };
        this.iconProvider = new ScaleContextCache(CustomHeader::iconProvider$lambda$0);
        this.productIcon$delegate = LazyKt.lazy(() -> CustomHeader.productIcon_delegate$lambda$0(this));
        this.borderPainter = new DefaultBorderPainter();
        this.setOpaque(true);
        this.setBackground(CustomHeader.getHeaderBackground$default(this, false, 1, null));
        this.isActive = this.window.isActive();
        CustomHeader.setCustomFrameTopBorder$default(this, null, null, 3, null);
        WindowDecorations windowDecorations = JBR.getWindowDecorations();
        this.customTitleBar = windowDecorations != null ? windowDecorations.createCustomTitleBar() : null;
    }

    @Nullable
    public final WindowDecorations.CustomTitleBar getCustomTitleBar() {
        return this.customTitleBar;
    }

    @NotNull
    protected final JComponent getProductIcon() {
        Lazy lazy = this.productIcon$delegate;
        return (JComponent)lazy.getValue();
    }

    @Override
    @NotNull
    public BorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    @Override
    public void setBorderPainter(@NotNull BorderPainter borderPainter) {
        Intrinsics.checkNotNullParameter((Object)borderPainter, (String)"<set-?>");
        this.borderPainter = borderPainter;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        WindowDecorations.CustomTitleBar customTitleBar = this.customTitleBar;
        if (customTitleBar != null) {
            WindowDecorations.CustomTitleBar it = customTitleBar;
            boolean bl = false;
            Color color = this.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
            CustomHeaderKt.updateWinControlsTheme(color, it);
        }
        this.updateSize();
    }

    private final void updateSize() {
        if (!ExperimentalUI.Companion.isNewUI()) {
            return;
        }
        Dimension size2 = this.getPreferredSize();
        size2.height = this.calcHeight();
        this.setPreferredSize(size2);
        this.setMinimumSize(size2);
    }

    protected int calcHeight() {
        return CustomWindowHeaderUtil.INSTANCE.getPreferredWindowHeaderHeight(CustomWindowHeaderUtil.INSTANCE.isCompactHeader$intellij_platform_ide_impl());
    }

    @NotNull
    protected Color getHeaderBackground(boolean active) {
        Color color = JBUI.CurrentTheme.CustomFrameDecorations.titlePaneBackground((boolean)active);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"titlePaneBackground(...)");
        return color;
    }

    public static /* synthetic */ Color getHeaderBackground$default(CustomHeader customHeader, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getHeaderBackground");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return customHeader.getHeaderBackground(bl);
    }

    protected final void setCustomFrameTopBorder(@NotNull Function0<Boolean> isTopNeeded, @NotNull Function0<Boolean> isBottomNeeded) {
        Intrinsics.checkNotNullParameter(isTopNeeded, (String)"isTopNeeded");
        Intrinsics.checkNotNullParameter(isBottomNeeded, (String)"isBottomNeeded");
        this.customFrameTopBorder = new CustomFrameTopBorder(isTopNeeded, isBottomNeeded, this);
        this.setBorder(this.customFrameTopBorder);
    }

    public static /* synthetic */ void setCustomFrameTopBorder$default(CustomHeader customHeader, Function0 function0, Function0 function02, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setCustomFrameTopBorder");
        }
        if ((n & 1) != 0) {
            function0 = CustomHeader::setCustomFrameTopBorder$lambda$0;
        }
        if ((n & 2) != 0) {
            function02 = CustomHeader::setCustomFrameTopBorder$lambda$1;
        }
        customHeader.setCustomFrameTopBorder((Function0<Boolean>)function0, (Function0<Boolean>)function02);
    }

    public void windowStateChanged() {
        this.updateCustomTitleBar();
    }

    protected final boolean getAdded() {
        return this.added;
    }

    protected final void setAdded(boolean bl) {
        this.added = bl;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.added = true;
        this.installListeners();
        this.updateCustomTitleBar();
        CustomFrameTopBorder customFrameTopBorder = this.customFrameTopBorder;
        Intrinsics.checkNotNull((Object)customFrameTopBorder);
        customFrameTopBorder.addNotify();
    }

    @Override
    public void removeNotify() {
        this.added = false;
        super.removeNotify();
        this.uninstallListeners();
        CustomFrameTopBorder customFrameTopBorder = this.customFrameTopBorder;
        Intrinsics.checkNotNull((Object)customFrameTopBorder);
        customFrameTopBorder.removeNotify();
    }

    protected void installListeners() {
        this.updateActive();
        this.window.addWindowListener(this.windowListener);
        this.window.addWindowStateListener(this.windowListener);
        this.window.addComponentListener(this.componentListener);
    }

    protected void uninstallListeners() {
        this.window.removeWindowListener(this.windowListener);
        this.window.removeWindowStateListener(this.windowListener);
        this.window.removeComponentListener(this.componentListener);
    }

    protected void updateCustomTitleBar() {
        if (!this.added || this.customTitleBar == null) {
            return;
        }
        if (this.window instanceof JDialog && ((JDialog)this.window).isUndecorated() || this.window instanceof JFrame && ((JFrame)this.window).isUndecorated()) {
            this.setCustomTitleBar(null);
        } else {
            if (this.getHeight() == 0) {
                return;
            }
            this.customTitleBar.setHeight((float)(this.getHeight() - this.getInsets().bottom));
            this.setCustomTitleBar(this.customTitleBar);
        }
    }

    private final void setCustomTitleBar(WindowDecorations.CustomTitleBar titleBar) {
        block0: {
            WindowDecorations it;
            block1: {
                WindowDecorations windowDecorations = JBR.getWindowDecorations();
                if (windowDecorations == null) break block0;
                it = windowDecorations;
                boolean bl = false;
                if (!(this.window instanceof Dialog)) break block1;
                it.setCustomTitleBar((Dialog)this.window, titleBar);
                break block0;
            }
            if (!(this.window instanceof Frame)) break block0;
            it.setCustomTitleBar((Frame)this.window, titleBar);
        }
    }

    private final void setActive(boolean value) {
        this.isActive = value;
        this.updateActive();
        this.updateCustomTitleBar();
    }

    protected void updateActive() {
        block1: {
            CustomFrameTopBorder customFrameTopBorder = this.customFrameTopBorder;
            if (customFrameTopBorder != null) {
                customFrameTopBorder.repaintBorder();
            }
            Color headerBackground = this.getHeaderBackground(this.isActive);
            this.setBackground(headerBackground);
            WindowDecorations.CustomTitleBar customTitleBar = this.customTitleBar;
            if (customTitleBar == null) break block1;
            WindowDecorations.CustomTitleBar it = customTitleBar;
            boolean bl = false;
            CustomHeaderKt.updateWinControlsTheme(headerBackground, it);
        }
    }

    protected final void close() {
        this.window.dispatchEvent(new WindowEvent(this.window, 201));
    }

    private final JComponent createProductIcon() {
        JPopupMenu menu = new JPopupMenu();
        MnemonicHelper.init((Component)menu);
        JLabel ic2 = new JLabel(this){
            final /* synthetic */ CustomHeader this$0;
            {
                this.this$0 = $receiver;
            }

            public Icon getIcon() {
                Object object = CustomHeader.access$getIconProvider$p(this.this$0).getOrProvide(ScaleContext.Companion.create((Component)this.this$0.window));
                Intrinsics.checkNotNull((Object)object);
                return (Icon)object;
            }
        };
        Application application = ApplicationManager.getApplication();
        boolean bl = application != null ? application.isInternal() : false;
        if (bl) {
            ic2.getAccessibleContext().setAccessibleName("Application icon");
        }
        ic2.addMouseListener(new MouseAdapter(ic2, menu){
            final /* synthetic */ createProductIcon.ic.1 $ic;
            final /* synthetic */ JPopupMenu $menu;
            {
                this.$ic = $ic;
                this.$menu = $menu;
            }

            public void mousePressed(MouseEvent e) {
                JBPopupMenu.showBelow((Component)this.$ic, (JPopupMenu)this.$menu);
            }
        });
        menu.setFocusable(false);
        menu.setBorderPainted(true);
        this.addMenuItems(menu);
        return ic2;
    }

    public void addMenuItems(@NotNull JPopupMenu menu) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        JMenuItem closeMenuItem = menu.add(Companion.createCloseAction$intellij_platform_ide_impl(this));
        closeMenuItem.setFont(JBFont.label().deriveFont(1));
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paint(g);
        this.getBorderPainter().paintAfterChildren(this, g);
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCustomHeader();
            this.accessibleContext.setAccessibleName(UIBundle.message((String)"frame.header.accessible.group.name", (Object[])new Object[0]));
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    private static final Icon iconProvider$lambda$0(ScaleContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AppUIUtilKt.loadSmallApplicationIcon$default(it, 0, 2, null);
    }

    private static final JComponent productIcon_delegate$lambda$0(CustomHeader this$0) {
        return this$0.createProductIcon();
    }

    private static final boolean setCustomFrameTopBorder$lambda$0() {
        return true;
    }

    private static final boolean setCustomFrameTopBorder$lambda$1() {
        return false;
    }

    public /* synthetic */ CustomHeader(Window window, DefaultConstructorMarker $constructor_marker) {
        this(window);
    }

    public static final /* synthetic */ ScaleContextCache access$getIconProvider$p(CustomHeader $this) {
        return $this.iconProvider;
    }

    public static final /* synthetic */ void access$setActive(CustomHeader $this, boolean value) {
        $this.setActive(value);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$AccessibleCustomHeader;", "Ljavax/swing/JPanel$AccessibleJPanel;", "Ljavax/swing/JPanel;", "<init>", "(Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;)V", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "intellij.platform.ide.impl"})
    private final class AccessibleCustomHeader
    extends JPanel.AccessibleJPanel {
        public AccessibleCustomHeader() {
            super(CustomHeader.this);
        }

        @Override
        @NotNull
        public AccessibleRole getAccessibleRole() {
            return AccessibilityUtils.GROUPED_ELEMENTS;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$Companion;", "", "<init>", "()V", "H", "", "getH", "()I", "V", "getV", "LABEL_BORDER", "Lcom/intellij/util/ui/JBEmptyBorder;", "getLABEL_BORDER", "()Lcom/intellij/util/ui/JBEmptyBorder;", "createCloseAction", "Ljavax/swing/Action;", "header", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;", "createCloseAction$intellij_platform_ide_impl", "enableCustomHeader", "", "w", "Ljava/awt/Window;", "ensureClickTransparent", "originalComponent", "Ljava/awt/Component;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final int getH() {
            return 12;
        }

        public final int getV() {
            return 5;
        }

        @NotNull
        public final JBEmptyBorder getLABEL_BORDER() {
            JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)this.getV(), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
            return jBEmptyBorder;
        }

        @NotNull
        public final Action createCloseAction$intellij_platform_ide_impl(@NotNull CustomHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            String string = CommonBundle.getCloseButtonText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCloseButtonText(...)");
            Icon icon2 = AllIcons.Windows.CloseSmall;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"CloseSmall");
            return new CustomFrameAction(string, icon2, (Function0<Unit>)((Function0)new Function0<Unit>((Object)header){

                public final void invoke() {
                    ((CustomHeader)this.receiver).close();
                }
            }));
        }

        public final void enableCustomHeader(@NotNull Window w) {
            block0: {
                WindowDecorations.CustomTitleBar bar2;
                WindowDecorations it;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)w, (String)"w");
                    WindowDecorations windowDecorations = JBR.getWindowDecorations();
                    if (windowDecorations == null) break block0;
                    it = windowDecorations;
                    boolean bl = false;
                    bar2 = it.createCustomTitleBar();
                    bar2.setHeight(1.0f);
                    if (!(w instanceof Dialog)) break block1;
                    it.setCustomTitleBar((Dialog)w, bar2);
                    break block0;
                }
                if (!(w instanceof Frame)) break block0;
                it.setCustomTitleBar((Frame)w, bar2);
            }
        }

        public final void ensureClickTransparent(@NotNull Component originalComponent) {
            Intrinsics.checkNotNullParameter((Object)originalComponent, (String)"originalComponent");
            for (Container cmp = originalComponent.getParent(); cmp != null; cmp = cmp.getParent()) {
                if (!(cmp instanceof CustomHeader)) continue;
                WindowDecorations.CustomTitleBar customTitleBar = ((CustomHeader)cmp).getCustomTitleBar();
                if (customTitleBar != null) {
                    WindowDecorations.CustomTitleBar bar2 = customTitleBar;
                    boolean bl = false;
                    HeaderClickTransparentListener listener2 = new HeaderClickTransparentListener(bar2);
                    originalComponent.addMouseListener(listener2);
                    originalComponent.addMouseMotionListener(listener2);
                }
                return;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader$CustomFrameAction;", "Ljavax/swing/AbstractAction;", "name", "", "icon", "Ljavax/swing/Icon;", "action", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "e", "Ljava/awt/event/ActionEvent;", "intellij.platform.ide.impl"})
    protected static final class CustomFrameAction
    extends AbstractAction {
        @NotNull
        private final Function0<Unit> action;

        public CustomFrameAction(@NlsActions.ActionText @NotNull String name2, @NotNull Icon icon2, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            super(name2, icon2);
            this.action = action2;
        }

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.action.invoke();
        }
    }
}

