/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.collapsedActionGroup;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.SeparatorWithText;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CollapsibleGroupHeaderSeparator
extends SeparatorWithText {
    private GroupHeaderSeparatorState expandedState = GroupHeaderSeparatorState.NONE;

    public void setExpandedState(GroupHeaderSeparatorState state2) {
        this.expandedState = state2;
    }

    private Icon getIcon() {
        if (this.expandedState == GroupHeaderSeparatorState.NONE) {
            return null;
        }
        if (this.expandedState == GroupHeaderSeparatorState.EXPANDED) {
            return AllIcons.General.ArrowDown;
        }
        return AllIcons.General.ArrowRight;
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.getForeground());
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        String caption = this.getCaption();
        if (caption != null) {
            int hGap = CollapsibleGroupHeaderSeparator.getHgap();
            bounds.x += hGap;
            bounds.width -= hGap + hGap;
            Icon icon2 = this.getIcon();
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            FontMetrics fm = g.getFontMetrics();
            String label2 = SwingUtilities.layoutCompoundLabel(fm, caption, icon2, 0, this.myAlignment, 0, 11, bounds, iconR, textR, 4);
            textR.y += fm.getAscent();
            if (caption.equals(label2)) {
                int y = textR.y + (int)fm.getLineMetrics(label2, g).getStrikethroughOffset();
                this.paintLinePart(g, bounds.x, iconR.x, -hGap, y);
                this.paintLinePart(g, textR.x + textR.width, bounds.x + bounds.width, hGap, y);
            }
            UISettings.setupAntialiasing((Graphics)g);
            g.setColor(this.getTextForeground());
            g.drawString(label2, textR.x, textR.y);
            if (icon2 != null) {
                icon2.paintIcon((Component)((Object)this), g, iconR.x, iconR.y);
            }
        } else {
            this.paintLine(g, bounds.x, bounds.y, bounds.width);
        }
    }

    public static enum GroupHeaderSeparatorState {
        COLLAPSED,
        EXPANDED,
        NONE;

    }
}

