/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.util.Comparing;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class TreeExpansionMonitor<T> {
    private final Set<TreePath> myExpandedPaths = new HashSet<TreePath>();
    private List<T> mySelectionNodes = new ArrayList<T>();
    private final JTree myTree;
    private boolean myFrozen = false;

    public static TreeExpansionMonitor<DefaultMutableTreeNode> install(JTree tree2) {
        return TreeExpansionMonitor.install(tree2, (o1, o2) -> Comparing.equal((Object)o1.getUserObject(), (Object)o2.getUserObject()));
    }

    public static TreeExpansionMonitor<DefaultMutableTreeNode> install(final JTree tree2, final BiPredicate<? super DefaultMutableTreeNode, ? super DefaultMutableTreeNode> equality) {
        return new TreeExpansionMonitor<DefaultMutableTreeNode>(tree2){

            @Override
            protected TreePath findPathByNode(DefaultMutableTreeNode node) {
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)tree2.getModel().getRoot()).breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode child;
                    TreeNode nextElement = enumeration.nextElement();
                    if (!(nextElement instanceof DefaultMutableTreeNode) || !equality.test(child = (DefaultMutableTreeNode)nextElement, node)) continue;
                    return new TreePath(child.getPath());
                }
                return null;
            }
        };
    }

    protected TreeExpansionMonitor(JTree tree2) {
        this.myTree = tree2;
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (TreeExpansionMonitor.this.myFrozen) {
                    return;
                }
                TreeExpansionMonitor.this.mySelectionNodes = new ArrayList();
                TreePath[] paths = TreeExpansionMonitor.this.myTree.getSelectionPaths();
                if (paths != null) {
                    for (TreePath path : paths) {
                        TreeExpansionMonitor.this.mySelectionNodes.add(TreeExpansionMonitor.this.getLastNode(path));
                    }
                }
            }
        });
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (TreeExpansionMonitor.this.myFrozen) {
                    return;
                }
                TreePath path = event.getPath();
                if (path != null) {
                    TreeExpansionMonitor.this.myExpandedPaths.add(path);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                if (TreeExpansionMonitor.this.myFrozen) {
                    return;
                }
                TreePath path = event.getPath();
                if (path != null) {
                    TreePath[] allPaths;
                    for (TreePath treePath : allPaths = TreePathUtil.toTreePathArray(TreeExpansionMonitor.this.myExpandedPaths)) {
                        if (!treePath.equals(path) && !path.isDescendant(treePath)) continue;
                        TreeExpansionMonitor.this.myExpandedPaths.remove(treePath);
                    }
                }
            }
        });
    }

    public void freeze() {
        this.myFrozen = true;
    }

    public void unfreeze() {
        this.myFrozen = false;
    }

    public void restore() {
        this.freeze();
        for (TreePath myExpandedPath : this.myExpandedPaths) {
            this.myTree.expandPath(this.findPathByNode(this.getLastNode(myExpandedPath)));
        }
        for (TreePath mySelectionNode : this.mySelectionNodes) {
            this.myTree.getSelectionModel().addSelectionPath(this.findPathByNode(mySelectionNode));
        }
        int selected = this.myTree.getLeadSelectionRow();
        if (selected != -1) {
            TreeUtil.showRowCentered((JTree)this.myTree, (int)selected, (boolean)false);
        }
        this.myFrozen = false;
    }

    @ApiStatus.Internal
    public void restoreAsync() {
        new AsyncRestorer().restore();
    }

    protected abstract TreePath findPathByNode(T var1);

    public boolean isFreeze() {
        return this.myFrozen;
    }

    private T getLastNode(@NotNull TreePath path) {
        if (path == null) {
            TreeExpansionMonitor.$$$reportNull$$$0(0);
        }
        return (T)path.getLastPathComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/packageDependencies/ui/TreeExpansionMonitor", "getLastNode"));
    }

    private class AsyncRestorer {
        private final TreeModel initialModel;

        private AsyncRestorer() {
            this.initialModel = TreeExpansionMonitor.this.myTree.getModel();
        }

        private boolean isValidModel() {
            return TreeExpansionMonitor.this.myTree.getModel() == this.initialModel;
        }

        void restore() {
            TreeExpansionMonitor.this.freeze();
            Set nodesToExpand = TreeExpansionMonitor.this.myExpandedPaths.stream().map(TreeExpansionMonitor.this::getLastNode).collect(Collectors.toUnmodifiableSet());
            Set nodesToSelect = TreeExpansionMonitor.this.mySelectionNodes.stream().collect(Collectors.toUnmodifiableSet());
            HashSet pathsToExpand = new HashSet();
            HashSet pathsToSelect = new HashSet();
            TreeUtil.promiseVisit((JTree)TreeExpansionMonitor.this.myTree, path -> {
                if (!this.isValidModel()) {
                    return TreeVisitor.Action.INTERRUPT;
                }
                Object node = TreeExpansionMonitor.this.getLastNode(path);
                if (nodesToExpand.contains(node)) {
                    pathsToExpand.add(path);
                }
                if (nodesToSelect.contains(node)) {
                    pathsToSelect.add(path);
                }
                return TreeVisitor.Action.CONTINUE;
            }).onSuccess(ignored -> TreeUtil.promiseExpand((JTree)TreeExpansionMonitor.this.myTree, pathsToExpand.stream().map(x$0 -> new PathVisitor((TreePath)x$0)))).onSuccess(ignored -> TreeUtil.promiseSelect((JTree)TreeExpansionMonitor.this.myTree, pathsToSelect.stream().map(x$0 -> new PathVisitor((TreePath)x$0)))).onProcessed(ignored -> {
                if (this.isValidModel()) {
                    TreeExpansionMonitor.this.unfreeze();
                }
            });
        }

        private class PathVisitor
        implements TreeVisitor {
            @NotNull
            private final TreePath pathToActUpon;

            PathVisitor(TreePath pathToActUpon) {
                if (pathToActUpon == null) {
                    PathVisitor.$$$reportNull$$$0(0);
                }
                this.pathToActUpon = pathToActUpon;
            }

            @NotNull
            public TreeVisitor.Action visit(@NotNull TreePath path) {
                if (path == null) {
                    PathVisitor.$$$reportNull$$$0(1);
                }
                if (!AsyncRestorer.this.isValidModel()) {
                    TreeVisitor.Action action2 = TreeVisitor.Action.SKIP_SIBLINGS;
                    if (action2 == null) {
                        PathVisitor.$$$reportNull$$$0(2);
                    }
                    return action2;
                }
                if (path.equals(this.pathToActUpon)) {
                    TreeVisitor.Action action3 = TreeVisitor.Action.INTERRUPT;
                    if (action3 == null) {
                        PathVisitor.$$$reportNull$$$0(3);
                    }
                    return action3;
                }
                if (path.isDescendant(this.pathToActUpon)) {
                    TreeVisitor.Action action4 = TreeVisitor.Action.CONTINUE;
                    if (action4 == null) {
                        PathVisitor.$$$reportNull$$$0(4);
                    }
                    return action4;
                }
                TreeVisitor.Action action5 = TreeVisitor.Action.SKIP_CHILDREN;
                if (action5 == null) {
                    PathVisitor.$$$reportNull$$$0(5);
                }
                return action5;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pathToActUpon";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/packageDependencies/ui/TreeExpansionMonitor$AsyncRestorer$PathVisitor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/packageDependencies/ui/TreeExpansionMonitor$AsyncRestorer$PathVisitor";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        }
    }
}

