/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.WindowInfo;
import com.intellij.openapi.wm.impl.AbstractDroppableStripe;
import com.intellij.openapi.wm.impl.SquareStripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.toolWindow.MoreSquareStripeButton;
import com.intellij.toolWindow.StripeButtonManager;
import com.intellij.toolWindow.ToolWindowButtonManager;
import com.intellij.toolWindow.ToolWindowLeftToolbar;
import com.intellij.toolWindow.ToolWindowPane;
import com.intellij.toolWindow.ToolWindowPaneState;
import com.intellij.toolWindow.ToolWindowRightToolbar;
import com.intellij.toolWindow.ToolWindowToolbar;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.DevicePoint;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0016J\r\u0010\u001e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b!J'\u0010\"\u001a\u00020\u00162\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u0015H\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u00020\u00162\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u001bH\u0016J\b\u0010/\u001a\u00020\u0016H\u0016J\b\u00100\u001a\u00020\u0016H\u0016J\b\u00101\u001a\u000202H\u0016J\u001f\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u00108J\"\u00103\u001a\u0004\u0018\u0001042\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u0002042\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010<\u001a\u0002022\u0006\u00105\u001a\u000206H\u0016J\u0010\u0010=\u001a\u0002022\u0006\u00105\u001a\u000206H\u0016J\u000e\u0010>\u001a\u00020*2\u0006\u00105\u001a\u000206J\u000e\u0010?\u001a\u00020@2\u0006\u00105\u001a\u000206J\u0006\u0010A\u001a\u00020\u0016J\b\u0010B\u001a\u00020\u0016H\u0016J\b\u0010C\u001a\u00020\u0016H\u0016J\b\u0010D\u001a\u00020\u0016H\u0016J\u0006\u0010E\u001a\u00020\u0016J\u0018\u0010F\u001a\u00020*2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0002J\"\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\u0010\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0004J\b\u0010O\u001a\u00020\u0005H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006P"}, d2={"Lcom/intellij/toolWindow/ToolWindowPaneNewButtonManager;", "Lcom/intellij/toolWindow/ToolWindowButtonManager;", "paneId", "", "isPrimary", "", "<init>", "(Ljava/lang/String;Z)V", "(Ljava/lang/String;)V", "left", "Lcom/intellij/toolWindow/ToolWindowLeftToolbar;", "getLeft$intellij_platform_ide_impl", "()Lcom/intellij/toolWindow/ToolWindowLeftToolbar;", "right", "Lcom/intellij/toolWindow/ToolWindowRightToolbar;", "getRight$intellij_platform_ide_impl", "()Lcom/intellij/toolWindow/ToolWindowRightToolbar;", "showButtons", "isStripesOverlaid", "visibleToolbarsListeners", "", "Lkotlin/Function2;", "", "isNewUi", "()Z", "setupToolWindowPane", "pane", "Ljavax/swing/JComponent;", "wrapWithControls", "Lcom/intellij/toolWindow/ToolWindowPane;", "updateToolStripesVisibility", "state", "Lcom/intellij/toolWindow/ToolWindowPaneState;", "updateToolStripesVisibility$intellij_platform_ide_impl", "addVisibleToolbarsListener", "listener", "addVisibleToolbarsListener$intellij_platform_ide_impl", "initMoreButton", "project", "Lcom/intellij/openapi/project/Project;", "updateResizeState", "toolbar", "Lcom/intellij/toolWindow/ToolWindowToolbar;", "layout", "size", "Ljava/awt/Dimension;", "layeredPane", "validateAndRepaint", "revalidateNotEmptyStripes", "getBottomHeight", "", "getStripeFor", "Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "isSplit", "(Lcom/intellij/openapi/wm/ToolWindowAnchor;Ljava/lang/Boolean;)Lcom/intellij/openapi/wm/impl/AbstractDroppableStripe;", "devicePoint", "Lcom/intellij/ui/awt/DevicePoint;", "preferred", "getStripeWidth", "getStripeHeight", "getSquareStripeFor", "getMoreButton", "Lcom/intellij/toolWindow/MoreSquareStripeButton;", "updateMoreButtons", "startDrag", "stopDrag", "reset", "refreshUi", "findToolbar", "createStripeButton", "Lcom/intellij/toolWindow/StripeButtonManager;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "info", "Lcom/intellij/openapi/wm/WindowInfo;", "task", "Lcom/intellij/openapi/wm/RegisterToolWindowTask;", "hasButtons", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nToolWindowPaneNewButtonManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowPaneNewButtonManager.kt\ncom/intellij/toolWindow/ToolWindowPaneNewButtonManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n1869#2,2:231\n1#3:233\n*S KotlinDebug\n*F\n+ 1 ToolWindowPaneNewButtonManager.kt\ncom/intellij/toolWindow/ToolWindowPaneNewButtonManager\n*L\n71#1:231,2\n*E\n"})
public class ToolWindowPaneNewButtonManager
implements ToolWindowButtonManager {
    @NotNull
    private final ToolWindowLeftToolbar left;
    @NotNull
    private final ToolWindowRightToolbar right;
    private boolean showButtons;
    private boolean isStripesOverlaid;
    @NotNull
    private final List<Function2<Boolean, Boolean, Unit>> visibleToolbarsListeners;

    public ToolWindowPaneNewButtonManager(@NotNull String paneId, boolean isPrimary) {
        Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
        this.left = new ToolWindowLeftToolbar(paneId, isPrimary);
        this.right = new ToolWindowRightToolbar(paneId, isPrimary);
        this.showButtons = true;
        this.visibleToolbarsListeners = new ArrayList();
        this.left.addVisibleButtonsListener$intellij_platform_ide_impl((Function0<Unit>)((Function0)() -> ToolWindowPaneNewButtonManager._init_$lambda$0(this)));
        this.right.addVisibleButtonsListener$intellij_platform_ide_impl((Function0<Unit>)((Function0)() -> ToolWindowPaneNewButtonManager._init_$lambda$1(this)));
    }

    public ToolWindowPaneNewButtonManager(@NotNull String paneId) {
        Intrinsics.checkNotNullParameter((Object)paneId, (String)"paneId");
        this(paneId, true);
    }

    @NotNull
    public final ToolWindowLeftToolbar getLeft$intellij_platform_ide_impl() {
        return this.left;
    }

    @NotNull
    public final ToolWindowRightToolbar getRight$intellij_platform_ide_impl() {
        return this.right;
    }

    @Override
    public boolean isNewUi() {
        return true;
    }

    @Override
    public void setupToolWindowPane(@NotNull JComponent pane2) {
        Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
        this.left.getTopStripe$intellij_platform_ide_impl().setBottomAnchorDropAreaComponent(pane2);
        this.left.getBottomStripe$intellij_platform_ide_impl().setBottomAnchorDropAreaComponent(pane2);
        this.right.getTopStripe$intellij_platform_ide_impl().setBottomAnchorDropAreaComponent(pane2);
        this.right.getBottomStripe$intellij_platform_ide_impl().setBottomAnchorDropAreaComponent(pane2);
    }

    @Override
    @NotNull
    public JComponent wrapWithControls(@NotNull ToolWindowPane pane2) {
        JPanel jPanel;
        block0: {
            Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
            JPanel $this$wrapWithControls_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
            boolean bl = false;
            $this$wrapWithControls_u24lambda_u240.setBackground((Color)JBColor.namedColor((String)"MainWindow.background", (Color)JBColor.PanelBackground));
            $this$wrapWithControls_u24lambda_u240.add((Component)pane2, "Center");
            $this$wrapWithControls_u24lambda_u240.add((Component)((Object)this.left), "West");
            $this$wrapWithControls_u24lambda_u240.add((Component)((Object)this.right), "East");
            InternalUICustomization internalUICustomization = InternalUICustomization.Companion.getInstance();
            if (internalUICustomization == null) break block0;
            internalUICustomization.configureToolWindowPane$intellij_platform_ide_impl($this$wrapWithControls_u24lambda_u240, this);
        }
        return jPanel;
    }

    @Override
    public boolean updateToolStripesVisibility(boolean showButtons, @NotNull ToolWindowPaneState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.showButtons = showButtons;
        this.isStripesOverlaid = state2.isStripesOverlaid();
        return this.updateToolStripesVisibility$intellij_platform_ide_impl();
    }

    public final boolean updateToolStripesVisibility$intellij_platform_ide_impl() {
        boolean oldSquareVisible = this.left.isVisible() && this.right.isVisible();
        boolean visible = this.showButtons || this.isStripesOverlaid;
        boolean isLeftVisible = visible && this.left.hasVisibleButtons();
        boolean isRightVisible = visible && this.right.hasVisibleButtons();
        this.left.setVisible(isLeftVisible);
        this.right.setVisible(isRightVisible);
        this.left.updateNamedState();
        this.right.updateNamedState();
        Iterable $this$forEach$iv = this.visibleToolbarsListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 it = (Function2)element$iv;
            boolean bl = false;
            it.invoke((Object)isLeftVisible, (Object)isRightVisible);
        }
        return oldSquareVisible != visible;
    }

    public final void addVisibleToolbarsListener$intellij_platform_ide_impl(@NotNull Function2<? super Boolean, ? super Boolean, Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.visibleToolbarsListeners.add(listener2);
    }

    @Override
    public void initMoreButton(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.left.initMoreButton(project2);
        this.right.initMoreButton(project2);
    }

    @Override
    public void updateResizeState(@Nullable ToolWindowToolbar toolbar2) {
        this.left.updateResizeState(toolbar2);
        this.right.updateResizeState(toolbar2);
    }

    @Override
    public void layout(@NotNull Dimension size2, @NotNull JComponent layeredPane2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        Intrinsics.checkNotNullParameter((Object)layeredPane2, (String)"layeredPane");
        layeredPane2.setBounds(0, 0, size2.width, size2.height);
    }

    @Override
    public void validateAndRepaint() {
    }

    @Override
    public void revalidateNotEmptyStripes() {
    }

    @Override
    public int getBottomHeight() {
        return 0;
    }

    @Override
    @NotNull
    public AbstractDroppableStripe getStripeFor(@NotNull ToolWindowAnchor anchor, @Nullable Boolean isSplit) {
        Object object;
        block5: {
            ToolWindowAnchor toolWindowAnchor;
            block6: {
                block7: {
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
                        toolWindowAnchor = anchor;
                        if (!Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT)) break block4;
                        object = this.left.getStripeFor$intellij_platform_ide_impl(anchor);
                        break block5;
                    }
                    if (!Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM)) break block6;
                    object = isSplit;
                    if (object == null) break block7;
                    boolean it = (Boolean)object;
                    boolean bl = false;
                    AbstractDroppableStripe abstractDroppableStripe = it ? this.right.getStripeFor$intellij_platform_ide_impl(anchor) : this.left.getStripeFor$intellij_platform_ide_impl(anchor);
                    object = abstractDroppableStripe;
                    if (abstractDroppableStripe != null) break block5;
                }
                throw new IllegalArgumentException("Split mode isn't expected to be used here, anchor: " + anchor.getDisplayName());
            }
            if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
                object = this.right.getStripeFor$intellij_platform_ide_impl(anchor);
            } else {
                throw new IllegalArgumentException("Anchor=" + anchor);
            }
        }
        return object;
    }

    @Override
    @Nullable
    public AbstractDroppableStripe getStripeFor(@NotNull DevicePoint devicePoint, @NotNull AbstractDroppableStripe preferred, @NotNull JComponent pane2) {
        AbstractDroppableStripe abstractDroppableStripe;
        Intrinsics.checkNotNullParameter((Object)devicePoint, (String)"devicePoint");
        Intrinsics.checkNotNullParameter((Object)((Object)preferred), (String)"preferred");
        Intrinsics.checkNotNullParameter((Object)pane2, (String)"pane");
        Point screenPoint = devicePoint.getLocationOnScreen((Component)pane2);
        if (preferred.containsPoint(screenPoint)) {
            abstractDroppableStripe = preferred;
        } else {
            abstractDroppableStripe = this.left.getStripeFor$intellij_platform_ide_impl(screenPoint);
            if (abstractDroppableStripe == null) {
                abstractDroppableStripe = this.right.getStripeFor$intellij_platform_ide_impl(screenPoint);
            }
        }
        return abstractDroppableStripe;
    }

    @Override
    public int getStripeWidth(@NotNull ToolWindowAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (Intrinsics.areEqual((Object)anchor, (Object)ToolWindowAnchor.BOTTOM) || Intrinsics.areEqual((Object)anchor, (Object)ToolWindowAnchor.TOP)) {
            return 0;
        }
        AbstractDroppableStripe stripe = this.getStripeFor(anchor, null);
        return stripe.isVisible() && stripe.isShowing() ? stripe.getWidth() : 0;
    }

    @Override
    public int getStripeHeight(@NotNull ToolWindowAnchor anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return 0;
    }

    @NotNull
    public final ToolWindowToolbar getSquareStripeFor(@NotNull ToolWindowAnchor anchor) {
        ToolWindowToolbar toolWindowToolbar;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ToolWindowAnchor toolWindowAnchor = anchor;
        if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP) || Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
            toolWindowToolbar = this.right;
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM) || Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT)) {
            toolWindowToolbar = this.left;
        } else {
            throw new IllegalArgumentException("Anchor=" + anchor);
        }
        return toolWindowToolbar;
    }

    @NotNull
    public final MoreSquareStripeButton getMoreButton(@NotNull ToolWindowAnchor anchor) {
        MoreSquareStripeButton moreSquareStripeButton;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        ToolWindowAnchor toolWindowAnchor = anchor;
        if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT)) {
            moreSquareStripeButton = this.left.getMoreButton$intellij_platform_ide_impl();
        } else if (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT)) {
            moreSquareStripeButton = this.right.getMoreButton$intellij_platform_ide_impl();
        } else {
            throw new IllegalArgumentException("Anchor=" + anchor);
        }
        return moreSquareStripeButton;
    }

    public final void updateMoreButtons() {
        this.left.getMoreButton$intellij_platform_ide_impl().update();
        this.right.getMoreButton$intellij_platform_ide_impl().update();
    }

    @Override
    public void startDrag() {
        if (this.right.isVisible()) {
            this.right.startDrag();
        }
        if (this.left.isVisible()) {
            this.left.startDrag();
        }
    }

    @Override
    public void stopDrag() {
        if (this.right.isVisible()) {
            this.right.stopDrag();
        }
        if (this.left.isVisible()) {
            this.left.stopDrag();
        }
    }

    @Override
    public void reset() {
        this.left.reset();
        this.right.reset();
    }

    public final void refreshUi() {
        this.left.repaint();
        this.right.repaint();
    }

    private final ToolWindowToolbar findToolbar(ToolWindowAnchor anchor, boolean isSplit) {
        ToolWindowAnchor toolWindowAnchor = anchor;
        return Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT) ? (ToolWindowToolbar)this.left : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM) ? (isSplit ? (ToolWindowToolbar)this.right : (ToolWindowToolbar)this.left) : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT) ? (ToolWindowToolbar)this.right : (ToolWindowToolbar)this.left));
    }

    @Override
    @NotNull
    public StripeButtonManager createStripeButton(@NotNull ToolWindowImpl toolWindow2, @NotNull WindowInfo info, @Nullable RegisterToolWindowTask task) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        StripeButtonManager manager2 = this.createStripeButton(toolWindow2);
        this.findToolbar(toolWindow2.getAnchor(), toolWindow2.isSplitMode()).getStripeFor$intellij_platform_ide_impl(toolWindow2.getWindowInfo().getAnchor()).addButton(manager2);
        return manager2;
    }

    @NotNull
    protected final StripeButtonManager createStripeButton(@NotNull ToolWindowImpl toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        SquareStripeButton squareStripeButton = new SquareStripeButton(toolWindow2);
        return new StripeButtonManager(toolWindow2, squareStripeButton, this){
            private final String id;
            private final ToolWindowImpl toolWindow;
            final /* synthetic */ ToolWindowImpl $toolWindow;
            final /* synthetic */ SquareStripeButton $squareStripeButton;
            final /* synthetic */ ToolWindowPaneNewButtonManager this$0;
            {
                this.$toolWindow = $toolWindow;
                this.$squareStripeButton = $squareStripeButton;
                this.this$0 = $receiver;
                this.id = $toolWindow.getId();
                this.toolWindow = $toolWindow;
            }

            public String getId() {
                return this.id;
            }

            public ToolWindowImpl getToolWindow() {
                return this.toolWindow;
            }

            public WindowInfo getWindowDescriptor() {
                return this.$toolWindow.getWindowInfo();
            }

            public void updateState(ToolWindowImpl toolWindow2) {
                Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
                this.$squareStripeButton.updateIcon();
            }

            public void updatePresentation() {
                this.$squareStripeButton.updatePresentation();
            }

            public void updateIcon(Icon icon2) {
                this.$squareStripeButton.updatePresentation();
            }

            public void remove(ToolWindowAnchor anchor, boolean split) {
                Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
                ToolWindowPaneNewButtonManager.access$findToolbar(this.this$0, anchor, split).getStripeFor$intellij_platform_ide_impl(anchor).removeButton(this);
            }

            public SquareStripeButton getComponent() {
                return this.$squareStripeButton;
            }

            public String toString() {
                return "SquareStripeButtonManager(windowInfo=" + this.$toolWindow.getWindowInfo() + ")";
            }
        };
    }

    @Override
    public boolean hasButtons() {
        return this.left.hasButtons() || this.right.hasButtons();
    }

    private static final Unit _init_$lambda$0(ToolWindowPaneNewButtonManager this$0) {
        this$0.updateToolStripesVisibility$intellij_platform_ide_impl();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ToolWindowPaneNewButtonManager this$0) {
        this$0.updateToolStripesVisibility$intellij_platform_ide_impl();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ToolWindowToolbar access$findToolbar(ToolWindowPaneNewButtonManager $this, ToolWindowAnchor anchor, boolean isSplit) {
        return $this.findToolbar(anchor, isSplit);
    }
}

