/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.LoadingState;
import com.intellij.idea.AppMode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.popup.MovablePopup;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.MouseEventHandler;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractExpandableItemsHandler<KeyType, ComponentType extends JComponent>
implements ExpandableItemsHandler<KeyType> {
    protected final ComponentType myComponent;
    private final SingleEdtTaskScheduler updateAlarm;
    private final CellRendererPane myRendererPane;
    private final JComponent myTipComponent;
    private boolean myEnabled;
    private final MovablePopup myPopup;
    private KeyType myKey;
    private Rectangle myKeyItemBounds;
    private BufferedImage myImage;
    private int borderArc;
    private static final boolean RENDER_IN_POPUP = AppMode.isRemoteDevHost();

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public SingleEdtTaskScheduler getUpdateAlarm() {
        SingleEdtTaskScheduler singleEdtTaskScheduler = this.updateAlarm;
        if (singleEdtTaskScheduler == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(0);
        }
        return singleEdtTaskScheduler;
    }

    public static void setRelativeBounds(@NotNull Component parent, @NotNull Rectangle bounds, @NotNull Component child, @NotNull Container validationParent) {
        if (parent == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(1);
        }
        if (bounds == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(2);
        }
        if (child == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(3);
        }
        if (validationParent == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(4);
        }
        validationParent.add(parent);
        parent.setBounds(bounds);
        parent.validate();
        child.setLocation(SwingUtilities.convertPoint(child, 0, 0, parent));
        validationParent.remove(parent);
    }

    protected AbstractExpandableItemsHandler(@NotNull ComponentType component2) {
        if (component2 == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(5);
        }
        this.updateAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
        this.myRendererPane = new CellRendererPane();
        this.myTipComponent = new JComponent(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics g) {
                ToolTipDetails details;
                if (AbstractExpandableItemsHandler.this.myImage != null) {
                    UIUtil.drawImage((Graphics)g, (Image)AbstractExpandableItemsHandler.this.myImage, (int)0, (int)0, null);
                } else if (AbstractExpandableItemsHandler.this.myKey != null && (details = AbstractExpandableItemsHandler.this.calcToolTipDetails(AbstractExpandableItemsHandler.this.myKey)) != null) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    try {
                        if (details.clip != null) {
                            g2d.clip(details.clip);
                        }
                        details.painter.accept(g2d);
                    }
                    finally {
                        g2d.dispose();
                    }
                }
            }
        };
        this.myEnabled = LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is((String)"ide.expansion.hints.enabled");
        this.borderArc = 0;
        this.myComponent = component2;
        if (RENDER_IN_POPUP) {
            this.myTipComponent.add(this.myRendererPane);
        } else {
            ((Container)this.myComponent).add(this.myRendererPane);
            ((Container)this.myComponent).validate();
        }
        MovablePopup popup2 = new MovablePopup((Component)this.myComponent, this.myTipComponent);
        popup2.setHeavyWeight(!StartupUiUtil.isWaylandToolkit());
        this.myPopup = popup2;
        MouseEventHandler dispatcher = new MouseEventHandler(){

            protected void handle(MouseEvent event) {
                MouseEventAdapter.redispatch((MouseEvent)event, AbstractExpandableItemsHandler.this.myComponent);
            }

            public void mouseEntered(MouseEvent event) {
            }

            public void mouseExited(MouseEvent event) {
                if (((Component)AbstractExpandableItemsHandler.this.myComponent).getMousePosition() == null) {
                    AbstractExpandableItemsHandler.this.hideHint();
                }
            }
        };
        this.myTipComponent.addMouseListener((MouseListener)dispatcher);
        this.myTipComponent.addMouseMotionListener((MouseMotionListener)dispatcher);
        this.myTipComponent.addMouseWheelListener((MouseWheelListener)dispatcher);
        MouseEventHandler handler = new MouseEventHandler(){

            protected void handle(MouseEvent event) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(event, 503 != event.getID());
            }

            public void mouseClicked(MouseEvent event) {
            }

            public void mouseExited(MouseEvent event) {
                if (LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is((String)"ide.hide.expandable.tooltip.owner.mouse.exit") || AbstractExpandableItemsHandler.this.myTipComponent.getMousePosition() == null) {
                    AbstractExpandableItemsHandler.this.hideHint();
                }
            }
        };
        ((Component)this.myComponent).addMouseListener((MouseListener)handler);
        ((Component)this.myComponent).addMouseMotionListener((MouseMotionListener)handler);
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractExpandableItemsHandler.this.onFocusLost();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelectionOnMoveOrResize();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelectionOnMoveOrResize();
            }
        });
        ((Component)this.myComponent).addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelectionOnMoveOrResize();
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelectionOnMoveOrResize();
            }
        });
        ((Component)this.myComponent).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }
        });
    }

    protected void onFocusLost() {
        this.hideHint();
    }

    public void setEnabled(boolean enabled2) {
        this.myEnabled = enabled2;
        if (!this.isEnabled()) {
            this.hideHint();
        }
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    protected void setBorderArc(int borderArc) {
        this.borderArc = borderArc;
    }

    @NotNull
    public @Unmodifiable Collection<KeyType> getExpandedItems() {
        Collection<Object> collection = this.myKey == null ? Collections.emptyList() : Collections.singleton(this.myKey);
        if (collection == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private void updateCurrentSelectionOnMoveOrResize() {
        if (ClientProperty.isTrue(this.myComponent, (Object)IGNORE_ITEM_SELECTION)) {
            this.hideHint();
        } else {
            this.updateCurrentSelection();
        }
    }

    protected void updateCurrentSelection() {
        this.handleSelectionChange(this.myKey, true);
    }

    protected void handleMouseEvent(MouseEvent e, boolean forceUpdate) {
        if (ClientProperty.isTrue(this.myComponent, (Object)IGNORE_MOUSE_HOVER)) {
            return;
        }
        KeyType selected = this.getCellKeyForPoint(e.getPoint());
        if (forceUpdate || !Comparing.equal(this.myKey, selected)) {
            this.handleSelectionChange(selected, true);
        }
        if (e.getClickCount() == 2) {
            this.hideHint();
        }
    }

    protected void handleSelectionChange(KeyType selected) {
        this.handleSelectionChange(ClientProperty.isTrue(this.myComponent, (Object)IGNORE_ITEM_SELECTION) ? this.myKey : selected, false);
    }

    protected void handleSelectionChange(KeyType selected, boolean processIfUnfocused) {
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        this.updateAlarm.cancel();
        if (selected == null || !this.isHandleSelectionEnabled(selected, processIfUnfocused)) {
            this.hideHint();
            return;
        }
        if (!selected.equals(this.myKey)) {
            this.hideHint();
        }
        this.updateAlarm.request(10L, () -> this.doHandleSelectionChange(selected, processIfUnfocused));
    }

    private boolean isHandleSelectionEnabled(@NotNull KeyType selected, boolean processIfUnfocused) {
        if (selected == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(7);
        }
        return this.isEnabled() && !ScreenReader.isActive() && ((Component)this.myComponent).isEnabled() && ((Component)this.myComponent).isShowing() && ((JComponent)this.myComponent).getVisibleRect().intersects(this.getVisibleRect(selected)) && (processIfUnfocused || ((Component)this.myComponent).isFocusOwner());
    }

    private void doHandleSelectionChange(@NotNull KeyType selected, boolean processIfUnfocused) {
        if (selected == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(8);
        }
        if (!this.isHandleSelectionEnabled(selected, processIfUnfocused)) {
            this.hideHint();
            return;
        }
        this.myKey = selected;
        ToolTipDetails details = this.calcToolTipDetails(this.myKey);
        if (details == null) {
            this.hideHint();
        } else {
            this.myKeyItemBounds = details.keyItemBounds;
            Rectangle bounds = details.bounds;
            Shape clip = details.clip;
            this.myTipComponent.setPreferredSize(bounds.getSize());
            if (!RENDER_IN_POPUP) {
                this.myImage = this.createPopupContent(bounds, details.painter, clip);
            }
            this.myPopup.setTransparent(clip != null);
            this.myPopup.setBounds(bounds);
            this.myPopup.onAncestorFocusLost(() -> this.onFocusLost());
            this.myPopup.setVisible(this.noIntersections(bounds));
            this.repaintKeyItem();
        }
    }

    private BufferedImage createPopupContent(Rectangle bounds, Consumer<Graphics2D> painter, Shape clip) {
        BufferedImage img = UIUtil.createImage(this.myComponent, (int)bounds.width, (int)bounds.height, (int)1);
        Graphics2D g = img.createGraphics();
        painter.accept(g);
        g.dispose();
        if (clip == null) {
            return img;
        }
        BufferedImage clippedImg = UIUtil.createImage(this.myComponent, (int)bounds.width, (int)bounds.height, (int)2);
        Graphics2D g2 = clippedImg.createGraphics();
        g2.clip(clip);
        UIUtil.drawImage((Graphics)g2, (Image)img, (int)0, (int)0, null);
        g2.dispose();
        return clippedImg;
    }

    protected boolean isPopup() {
        Window window = SwingUtilities.getWindowAncestor(this.myComponent);
        return UIUtil.isSimpleWindow((Window)window) && !AbstractExpandableItemsHandler.isHintsAllowed(window);
    }

    private static boolean isHintsAllowed(Window window) {
        JRootPane pane2;
        if (window instanceof RootPaneContainer && (pane2 = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            return Boolean.TRUE.equals(pane2.getClientProperty("ShowHints"));
        }
        return false;
    }

    private static boolean isFocused(Window window) {
        return window != null && (window.isFocused() || AbstractExpandableItemsHandler.isFocused(window.getOwner()));
    }

    private boolean noIntersections(Rectangle bounds) {
        Window owner = SwingUtilities.getWindowAncestor(this.myComponent);
        Window popup2 = SwingUtilities.getWindowAncestor(this.myTipComponent);
        Window focus = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (focus == owner.getOwner()) {
            focus = null;
        }
        boolean focused = SystemInfo.isWindows || AbstractExpandableItemsHandler.isFocused(owner);
        for (Window other : owner.getOwnedWindows()) {
            if (!focused) {
                focused = other.isFocused();
            }
            if (popup2 != other && other.isVisible() && bounds.x + 10 >= other.getX() && bounds.intersects(other.getBounds())) {
                return false;
            }
            if (focus != other) continue;
            focus = null;
        }
        return focused && (focus == owner || focus == null || !owner.getBounds().intersects(focus.getBounds()));
    }

    private void hideHint() {
        this.updateAlarm.cancel();
        if (this.myPopup.isVisible()) {
            this.myPopup.setVisible(false);
            this.repaintKeyItem();
        }
        this.myKey = null;
    }

    public boolean isShowing() {
        return this.myPopup.isVisible();
    }

    private void repaintKeyItem() {
        if (this.myKeyItemBounds != null) {
            ((JComponent)this.myComponent).repaint(this.myKeyItemBounds);
        }
    }

    private static SelectablePanel findSelectablePanel(@NotNull JComponent renderer2) {
        SelectablePanel selectablePanel;
        if (renderer2 == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(9);
        }
        Component result2 = renderer2;
        while (result2 instanceof ExpandedItemRendererComponentWrapper) {
            result2 = ExpandedItemRendererComponentWrapper.unwrap((Component)result2);
        }
        if (result2 instanceof GroupedElementsRenderer.MyComponent) {
            GroupedElementsRenderer.MyComponent myComponent = (GroupedElementsRenderer.MyComponent)result2;
            result2 = myComponent.getRenderer().getItemComponent();
        }
        return result2 instanceof SelectablePanel ? (selectablePanel = (SelectablePanel)result2) : null;
    }

    @Nullable
    private ToolTipDetails calcToolTipDetails(@NotNull KeyType key) {
        SelectablePanel selectablePanel;
        Component delegate;
        if (key == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(10);
        }
        ClientProperty.put(this.myComponent, (Key)EXPANDED_RENDERER, (Object)true);
        Pair<Component, Rectangle> rendererAndBounds = this.getCellRendererAndBounds(key);
        ClientProperty.put(this.myComponent, (Key)EXPANDED_RENDERER, null);
        if (rendererAndBounds == null) {
            return null;
        }
        JComponent renderer2 = (JComponent)ObjectUtils.tryCast((Object)rendererAndBounds.first, JComponent.class);
        if (renderer2 == null) {
            return null;
        }
        if (ClientProperty.isTrue((Component)renderer2, (Object)RENDERER_DISABLED)) {
            return null;
        }
        if (renderer2 instanceof ExpandedItemRendererComponentWrapper && (delegate = ((ExpandedItemRendererComponentWrapper)renderer2).getDelegate()) != null && ClientProperty.isTrue((Component)delegate, (Object)RENDERER_DISABLED)) {
            return null;
        }
        Rectangle cellBounds = (Rectangle)rendererAndBounds.second;
        if (ClientProperty.isTrue((Component)renderer2, (Object)USE_RENDERER_BOUNDS)) {
            cellBounds.translate(renderer2.getX(), renderer2.getY());
            cellBounds.setSize(renderer2.getSize());
        }
        int arc = (selectablePanel = AbstractExpandableItemsHandler.findSelectablePanel(renderer2)) == null ? this.borderArc : selectablePanel.getSelectionArc();
        Rectangle visibleRect = this.getVisibleRect(key);
        if (cellBounds.y < visibleRect.y) {
            return null;
        }
        int cellMaxY = cellBounds.y + cellBounds.height;
        int visMaxY = visibleRect.y + visibleRect.height;
        if (cellMaxY > visMaxY) {
            return null;
        }
        int cellMaxX = cellBounds.x + cellBounds.width;
        int visMaxX = visibleRect.x + visibleRect.width;
        Point location = new Point(visMaxX, cellBounds.y);
        SwingUtilities.convertPointToScreen(location, this.myComponent);
        Rectangle screen = ScreenUtil.getScreenRectangle((Point)location);
        if (location.x == screen.x) {
            return null;
        }
        int borderSize = this.isPaintBorder() ? 1 : 0;
        int width = Math.min(screen.width + screen.x - location.x - borderSize, cellMaxX - visMaxX);
        int height = cellBounds.height;
        int cellY = 0;
        if (arc > 0 && selectablePanel != null) {
            renderer2.setBounds(cellBounds);
            Rectangle rect = AbstractExpandableItemsHandler.calcRectInParent((Container)selectablePanel, renderer2);
            width -= selectablePanel.getSelectionInsets().right;
            height = rect.height;
            cellY = rect.y;
            location.y += cellY;
        }
        if (width <= 0 || height <= 0) {
            return null;
        }
        location.y -= borderSize;
        int imgWidth = width += borderSize;
        int imgHeight = height += borderSize * 2;
        int xShift = cellBounds.x - visMaxX;
        int yShift = borderSize - cellY;
        Consumer<Graphics2D> painter = g -> {
            this.doFillBackground(imgHeight, imgWidth, (Graphics2D)g);
            double fractionalScaleCorrection = (double)location.y - PaintUtil.alignToInt((double)location.y, (Graphics2D)g, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND_FLOOR_BIAS);
            g.translate((double)xShift, (double)yShift + fractionalScaleCorrection);
            this.doPaintTooltipImage(renderer2, cellBounds, (Graphics2D)g, key);
            g.translate((double)(-xShift), (double)(-yShift) - fractionalScaleCorrection);
            if (borderSize > 0) {
                g.setColor(this.getBorderColor());
                if (arc > 0) {
                    Area area = new Area(new Rectangle(0, 0, imgWidth, imgHeight));
                    area.subtract(new Area(new RoundRectangle2D.Double(-arc + borderSize, borderSize, imgWidth + arc - borderSize * 2, imgHeight - borderSize * 2, arc, arc)));
                    g.fill(area);
                } else {
                    g.fillRect(0, 0, imgWidth, borderSize);
                    g.fillRect(0, imgHeight - borderSize, imgWidth, borderSize);
                    g.fillRect(imgWidth - borderSize, 0, borderSize, imgHeight);
                }
            }
        };
        RoundRectangle2D.Float clip = arc > 0 ? new RoundRectangle2D.Float(-arc, 0.0f, imgWidth + arc, imgHeight, arc, arc) : null;
        return new ToolTipDetails(new Rectangle(location.x, location.y, imgWidth, imgHeight), cellBounds, painter, clip);
    }

    protected boolean isPaintBorder() {
        return true;
    }

    protected Color getBorderColor() {
        return JBColor.border();
    }

    protected void doFillBackground(int height, int width, Graphics2D g) {
        g.setColor(((Component)this.myComponent).getBackground());
        g.fillRect(0, 0, width, height);
    }

    protected void doPaintTooltipImage(Component rComponent, Rectangle cellBounds, Graphics2D g, KeyType key) {
        this.myRendererPane.paintComponent(g, rComponent, (Container)this.myComponent, 0, 0, cellBounds.width, cellBounds.height, true);
        this.myRendererPane.remove(rComponent);
    }

    protected Rectangle getVisibleRect(KeyType key) {
        return ((JComponent)this.myComponent).getVisibleRect();
    }

    @Nullable
    protected abstract Pair<Component, Rectangle> getCellRendererAndBounds(KeyType var1);

    protected abstract KeyType getCellKeyForPoint(Point var1);

    @NotNull
    private static Rectangle calcRectInParent(@NotNull Container child, @NotNull JComponent parent) {
        if (child == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(11);
        }
        if (parent == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(12);
        }
        ArrayList<Container> chain = new ArrayList<Container>();
        Container container = child;
        while (container != parent) {
            chain.add(container);
            if ((container = container.getParent()) != null) continue;
            throw new IllegalArgumentException("Source is not part of " + String.valueOf(parent));
        }
        Rectangle result2 = new Rectangle();
        parent.doLayout();
        for (int i2 = chain.size() - 1; i2 >= 0; --i2) {
            Container c = (Container)chain.get(i2);
            c.doLayout();
            result2.x += c.getX();
            result2.y += c.getY();
        }
        result2.setSize(child.getSize());
        Rectangle rectangle = result2;
        if (rectangle == null) {
            AbstractExpandableItemsHandler.$$$reportNull$$$0(13);
        }
        return rectangle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/AbstractExpandableItemsHandler";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationParent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateAlarm";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/AbstractExpandableItemsHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedItems";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRectInParent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setRelativeBounds";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHandleSelectionEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doHandleSelectionChange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSelectablePanel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcToolTipDetails";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcRectInParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    private record ToolTipDetails(@NotNull Rectangle bounds, @Nullable Rectangle keyItemBounds, @NotNull Consumer<Graphics2D> painter, @Nullable Shape clip) {
        @NotNull
        private final Rectangle bounds;
        @NotNull
        private final Consumer<Graphics2D> painter;

        private ToolTipDetails(@NotNull Rectangle bounds, @Nullable Rectangle keyItemBounds, @NotNull Consumer<Graphics2D> painter, @Nullable Shape clip) {
            if (bounds == null) {
                ToolTipDetails.$$$reportNull$$$0(0);
            }
            if (painter == null) {
                ToolTipDetails.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Rectangle bounds() {
            Rectangle rectangle = this.bounds;
            if (rectangle == null) {
                ToolTipDetails.$$$reportNull$$$0(2);
            }
            return rectangle;
        }

        @NotNull
        public Consumer<Graphics2D> painter() {
            Consumer<Graphics2D> consumer = this.painter;
            if (consumer == null) {
                ToolTipDetails.$$$reportNull$$$0(3);
            }
            return consumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "painter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/AbstractExpandableItemsHandler$ToolTipDetails";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/AbstractExpandableItemsHandler$ToolTipDetails";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "bounds";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "painter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

