/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HintHint {
    private Component myOriginalComponent;
    private Point myOriginalPoint;
    private boolean myForcePopup;
    private boolean myAwtTooltip = false;
    private Balloon.Position myPreferredPosition = Balloon.Position.below;
    private boolean myContentActive = true;
    private boolean myQuickHint = false;
    private boolean myMayCenterTooltip = false;
    private Color myTextFg;
    private Color myTextBg;
    private Color myBorderColor;
    private Border myComponentBorder = null;
    private Insets myBorderInsets;
    private Font myFont;
    private Icon myStatusIcon;
    private int myCalloutShift;
    private boolean myExplicitClose;
    private int myPositionChangeX;
    private int myPositionChangeY;
    private boolean myShowImmediately = false;
    private boolean myAnimationEnabled;
    private boolean myRequestFocus;
    public static final String OVERRIDE_BORDER_KEY = "BorderInsets";

    public HintHint() {
    }

    public HintHint(MouseEvent e) {
        this(e.getComponent(), e.getPoint());
    }

    public HintHint(Editor editor2, Point point) {
        this(editor2.getContentComponent(), point);
    }

    public HintHint(Component originalComponent, Point originalPoint) {
        this.myOriginalComponent = originalComponent;
        this.myOriginalPoint = originalPoint;
    }

    public HintHint setAwtTooltip(boolean awtTooltip) {
        this.myAwtTooltip = awtTooltip;
        return this;
    }

    public HintHint setMayCenterPosition(boolean mayCenter) {
        this.myMayCenterTooltip = mayCenter;
        return this;
    }

    public boolean isMayCenterTooltip() {
        return this.myMayCenterTooltip;
    }

    public HintHint setPreferredPosition(Balloon.Position position) {
        this.myPreferredPosition = position;
        return this;
    }

    public boolean isAwtTooltip() {
        return this.myAwtTooltip;
    }

    public boolean isPopupForced() {
        return this.myForcePopup;
    }

    public HintHint setForcePopup(boolean forcePopup) {
        this.myForcePopup = forcePopup;
        return this;
    }

    public Component getOriginalComponent() {
        return this.myOriginalComponent;
    }

    public Point getOriginalPoint() {
        return this.myOriginalPoint;
    }

    public RelativePoint getTargetPoint() {
        return new RelativePoint(this.getOriginalComponent(), this.getOriginalPoint());
    }

    public Border getComponentBorder() {
        return this.myComponentBorder;
    }

    public void setComponentBorder(@Nullable Border border) {
        this.myComponentBorder = border;
    }

    public Balloon.Position getPreferredPosition() {
        return this.myPreferredPosition;
    }

    public Color getTextForeground() {
        return this.myTextFg != null ? this.myTextFg : HintHint.getTooltipManager().getTextForeground(this.myAwtTooltip);
    }

    public Color getTextBackground() {
        return this.myTextBg != null ? this.myTextBg : HintHint.getTooltipManager().getTextBackground(this.myAwtTooltip);
    }

    public Color getLinkForeground() {
        return HintHint.getTooltipManager().getLinkForeground(this.myAwtTooltip);
    }

    public boolean isOwnBorderAllowed() {
        return HintHint.getTooltipManager().isOwnBorderAllowed(this.myAwtTooltip);
    }

    @NotNull
    public Color getBorderColor() {
        Color color = this.myBorderColor != null ? this.myBorderColor : JBUI.CurrentTheme.Tooltip.borderColor();
        if (color == null) {
            HintHint.$$$reportNull$$$0(0);
        }
        return color;
    }

    public boolean isBorderColorSet() {
        return this.myBorderColor != null;
    }

    public Insets getBorderInsets() {
        return this.myBorderInsets;
    }

    public boolean isOpaqueAllowed() {
        return HintHint.getTooltipManager().isOpaqueAllowed(this.myAwtTooltip);
    }

    public Font getTextFont() {
        return this.myFont != null ? this.myFont : HintHint.getTooltipManager().getTextFont(this.myAwtTooltip);
    }

    public Icon getStatusIcon() {
        return this.myStatusIcon;
    }

    public String getUlImg() {
        return HintHint.getTooltipManager().getUlImg(this.myAwtTooltip);
    }

    public boolean isContentActive() {
        return this.myContentActive;
    }

    public boolean isExplicitClose() {
        return this.myExplicitClose;
    }

    public HintHint setContentActive(boolean active) {
        this.myContentActive = active;
        return this;
    }

    public HintHint setHighlighterType(boolean highlighter) {
        this.myQuickHint = highlighter;
        return this;
    }

    public boolean isHighlighterType() {
        return this.myQuickHint;
    }

    private static IdeTooltipManager getTooltipManager() {
        return IdeTooltipManager.getInstance();
    }

    public void initStyle(Component c, boolean includeChildren) {
        if (includeChildren) {
            for (Component component2 : UIUtil.uiTraverser((Component)c)) {
                this.doInit(component2);
            }
        } else {
            this.doInit(c);
        }
    }

    private void doInit(Component c) {
        c.setForeground(this.getTextForeground());
        c.setBackground(this.getTextBackground());
        c.setFont(this.getTextFont());
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.setOpaque(this.isOpaqueAllowed());
            jc.setBorder(this.isOwnBorderAllowed() ? BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(0, 5, 0, 5)) : null);
        }
    }

    public void initStyleFrom(JComponent component2) {
        Object insets;
        HintHint componentHintLabel;
        this.myTextFg = component2.getForeground();
        this.myTextBg = component2.getBackground();
        this.myFont = component2.getFont();
        boolean setDefaultStatus = true;
        HintUtil.HintLabel label2 = (HintUtil.HintLabel)UIUtil.findComponentOfType((JComponent)component2, HintUtil.HintLabel.class);
        if (label2 != null && (componentHintLabel = label2.getHintHint()) != null) {
            this.setBorderColor(componentHintLabel.getBorderColor());
            this.setBorderInsets(componentHintLabel.getBorderInsets());
            this.setComponentBorder(componentHintLabel.getComponentBorder());
            setDefaultStatus = false;
        }
        if (setDefaultStatus) {
            this.setStatus(Status.Info);
        }
        if ((insets = component2.getClientProperty(OVERRIDE_BORDER_KEY)) instanceof Insets) {
            Insets border = (Insets)insets;
            this.setBorderInsets(border);
        }
    }

    public HintHint setTextFg(Color textFg) {
        this.myTextFg = textFg;
        return this;
    }

    public HintHint setTextBg(Color textBg) {
        this.myTextBg = textBg;
        return this;
    }

    public HintHint setFont(Font font) {
        this.myFont = font;
        return this;
    }

    public HintHint setBorderColor(Color borderColor) {
        this.myBorderColor = borderColor;
        return this;
    }

    public HintHint setBorderInsets(Insets insets) {
        this.myBorderInsets = insets;
        return this;
    }

    public int getCalloutShift() {
        return this.myCalloutShift;
    }

    public HintHint setCalloutShift(int calloutShift) {
        this.myCalloutShift = calloutShift;
        return this;
    }

    public HintHint setExplicitClose(boolean explicitClose) {
        this.myExplicitClose = explicitClose;
        return this;
    }

    public HintHint setPositionChangeShift(int x, int y) {
        this.myPositionChangeX = x;
        this.myPositionChangeY = y;
        return this;
    }

    public HintHint setStatus(@NotNull Status status2) {
        if (status2 == null) {
            HintHint.$$$reportNull$$$0(1);
        }
        if (ExperimentalUI.isNewUI()) {
            this.applyStatus(status2);
        }
        return this;
    }

    public HintHint setStatus(@NotNull Status status2, @NotNull Insets borderInsets) {
        if (status2 == null) {
            HintHint.$$$reportNull$$$0(2);
        }
        if (borderInsets == null) {
            HintHint.$$$reportNull$$$0(3);
        }
        if (ExperimentalUI.isNewUI()) {
            this.applyStatus(status2);
            this.myBorderInsets = borderInsets;
        }
        return this;
    }

    public HintHint applyStatus(@NotNull Status status2) {
        if (status2 == null) {
            HintHint.$$$reportNull$$$0(4);
        }
        this.myTextFg = status2.foreground;
        this.myTextBg = status2.background;
        this.myBorderColor = status2.border;
        this.myStatusIcon = status2.icon;
        this.myBorderInsets = JBUI.insets((int)12, (int)12, (int)14, (int)12);
        this.myComponentBorder = JBUI.Borders.empty();
        return this;
    }

    public int getPositionChangeX() {
        return this.myPositionChangeX;
    }

    public int getPositionChangeY() {
        return this.myPositionChangeY;
    }

    public boolean isShowImmediately() {
        return this.myShowImmediately;
    }

    public HintHint setShowImmediately(boolean showImmediately) {
        this.myShowImmediately = showImmediately;
        return this;
    }

    public boolean isAnimationEnabled() {
        return this.myAnimationEnabled;
    }

    public HintHint setAnimationEnabled(boolean enabled2) {
        this.myAnimationEnabled = enabled2;
        return this;
    }

    public boolean isRequestFocus() {
        return this.myRequestFocus;
    }

    public HintHint setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/HintHint";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "borderInsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorderColor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/HintHint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setStatus";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyStatus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public static enum Status {
        Info(JBUI.CurrentTheme.Editor.Tooltip.FOREGROUND, JBUI.CurrentTheme.Editor.Tooltip.BACKGROUND, JBUI.CurrentTheme.Editor.Tooltip.BORDER, null),
        Success(JBUI.CurrentTheme.Editor.Tooltip.FOREGROUND, JBUI.CurrentTheme.Editor.Tooltip.SUCCESS_BACKGROUND, JBUI.CurrentTheme.Editor.Tooltip.SUCCESS_BORDER, AllIcons.Debugger.ThreadStates.Idle),
        Warning(JBUI.CurrentTheme.Editor.Tooltip.FOREGROUND, JBUI.CurrentTheme.Editor.Tooltip.WARNING_BACKGROUND, JBUI.CurrentTheme.Editor.Tooltip.WARNING_BORDER, AllIcons.General.BalloonWarning),
        Error(JBUI.CurrentTheme.Editor.Tooltip.FOREGROUND, JBUI.CurrentTheme.Editor.Tooltip.ERROR_BACKGROUND, JBUI.CurrentTheme.Editor.Tooltip.ERROR_BORDER, AllIcons.General.BalloonError);

        public final Color foreground;
        public final Color background;
        public final Color border;
        final Icon icon;

        private Status(@NotNull Color foreground, @Nullable Color background, Color border, Icon icon2) {
            if (foreground == null) {
                Status.$$$reportNull$$$0(0);
            }
            if (background == null) {
                Status.$$$reportNull$$$0(1);
            }
            if (border == null) {
                Status.$$$reportNull$$$0(2);
            }
            this.foreground = foreground;
            this.background = background;
            this.border = border;
            this.icon = icon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foreground";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "background";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "border";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/HintHint$Status";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

