/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationsConfigurable;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.CustomIconUtilKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBRectangle;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class NotificationBalloonActionProvider
implements BalloonImpl.ActionProvider {
    private final BalloonImpl myBalloon;
    private final BalloonLayoutData myLayoutData;
    private final Component myRepaintPanel;
    private final Notification myNotification;
    private BalloonImpl.ActionButton myMoreButton;
    private BalloonImpl.ActionButton myCloseButton;
    private List<BalloonImpl.ActionButton> myActions;
    private static final Rectangle CloseHoverBounds = new JBRectangle(5, 5, 12, 10);

    public NotificationBalloonActionProvider(@NotNull BalloonImpl balloon2, @Nullable Component repaintPanel, @NotNull BalloonLayoutData layoutData, @NotNull Notification notification2) {
        if (balloon2 == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(0);
        }
        if (layoutData == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(1);
        }
        if (notification2 == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(2);
        }
        this.myLayoutData = layoutData;
        this.myBalloon = balloon2;
        this.myRepaintPanel = repaintPanel;
        this.myNotification = notification2;
    }

    @Override
    @NotNull
    public List<BalloonImpl.ActionButton> createActions() {
        this.myActions = new ArrayList<BalloonImpl.ActionButton>();
        if (!this.myLayoutData.showSettingButton) {
            this.myMoreButton = null;
        } else {
            BalloonImpl balloonImpl = this.myBalloon;
            Objects.requireNonNull(balloonImpl);
            this.myMoreButton = new BalloonImpl.ActionButton(balloonImpl, AllIcons.Actions.More, null, IdeBundle.message((String)"tooltip.turn.notification.off", (Object[])new Object[0]), event -> this.myBalloon.runWithSmartFadeoutPause(() -> {
                if (!this.myBalloon.isDisposed()) {
                    this.showMorePopup();
                }
            })){
                {
                    BalloonImpl balloonImpl = x0;
                    Objects.requireNonNull(balloonImpl);
                    super(icon2, hoverIcon, hint, (Consumer<? super MouseEvent>)listener2);
                }

                @Override
                protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon2) {
                    if (g == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (icon2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (ExperimentalUI.isNewUI()) {
                        icon2 = NotificationBalloonActionProvider.paintHover(g, icon2, this.myButton, NotificationBalloonActionProvider.CloseHoverBounds.x, NotificationBalloonActionProvider.CloseHoverBounds.y);
                        icon2.paintIcon((Component)((Object)this), g, NotificationBalloonActionProvider.CloseHoverBounds.x, NotificationBalloonActionProvider.CloseHoverBounds.y);
                    } else {
                        super.paintIcon(g, icon2);
                    }
                }

                public void repaint() {
                    super.repaint();
                    if (NotificationBalloonActionProvider.this.myRepaintPanel != null) {
                        NotificationBalloonActionProvider.this.myRepaintPanel.repaint();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "g";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "icon";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ui/NotificationBalloonActionProvider$1";
                    objectArray[2] = "paintIcon";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myActions.add(this.myMoreButton);
            if (this.myRepaintPanel != null) {
                this.myLayoutData.showActions = () -> {
                    for (BalloonImpl.ActionButton action2 : this.myActions) {
                        if (action2.isShowing() && action2.hasPaint()) continue;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                };
            }
        }
        BalloonImpl balloonImpl = this.myBalloon;
        Objects.requireNonNull(balloonImpl);
        this.myCloseButton = new BalloonImpl.ActionButton(balloonImpl, AllIcons.Ide.Notification.Close, AllIcons.Ide.Notification.CloseHover, IdeBundle.message((String)"tooltip.close.notification", (Object[])new Object[]{SystemInfo.isMac ? "\u2325" : "Alt+"}), event -> {
            int modifiers = event.getModifiers();
            SwingUtilities.invokeLater(() -> {
                if ((modifiers & 8) != 0 && this.myLayoutData.closeAll != null) {
                    this.myLayoutData.closeAll.run();
                } else {
                    BalloonLayoutData.MergeInfo mergeInfo = this.myLayoutData.mergeData;
                    if (mergeInfo != null && mergeInfo.linkIds != null) {
                        for (BalloonLayoutData.ID id2 : mergeInfo.linkIds) {
                            NotificationCollector.getInstance().logNotificationBalloonClosedByUser(this.myLayoutData.project, id2.notificationId, id2.notificationDisplayId, this.myNotification.getGroupId());
                        }
                    }
                    NotificationCollector.getInstance().logNotificationBalloonClosedByUser(this.myLayoutData.project, this.myNotification.id, this.myNotification.getDisplayId(), this.myNotification.getGroupId());
                    this.myBalloon.hide(true);
                }
            });
        }){
            {
                BalloonImpl balloonImpl = x0;
                Objects.requireNonNull(balloonImpl);
                super(icon2, hoverIcon, hint, (Consumer<? super MouseEvent>)listener2);
            }

            @Override
            protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon2) {
                if (g == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (icon2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                icon2 = NotificationBalloonActionProvider.paintHover(g, icon2, this.myButton, NotificationBalloonActionProvider.CloseHoverBounds.x, NotificationBalloonActionProvider.CloseHoverBounds.y);
                icon2.paintIcon((Component)((Object)this), g, NotificationBalloonActionProvider.CloseHoverBounds.x, NotificationBalloonActionProvider.CloseHoverBounds.y);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "g";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/NotificationBalloonActionProvider$2";
                objectArray[2] = "paintIcon";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myActions.add(this.myCloseButton);
        List<BalloonImpl.ActionButton> list2 = this.myActions;
        if (list2 == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Icon paintHover(@NotNull Graphics g, @NotNull Icon icon2, @NotNull BaseButtonBehavior button2, int x, int y) {
        if (g == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(4);
        }
        if (icon2 == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(5);
        }
        if (button2 == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(6);
        }
        if (ExperimentalUI.isNewUI()) {
            if (button2.isHovered()) {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    float arc = DarculaUIUtil.BUTTON_ARC.getFloat();
                    float gap = JBUIScale.scale((int)2);
                    RoundRectangle2D.Float shape = new RoundRectangle2D.Float((float)x - gap, (float)y - gap, (float)icon2.getIconWidth() + 2.0f * gap, (float)icon2.getIconHeight() + 2.0f * gap, arc, arc);
                    g2.setColor(JBUI.CurrentTheme.Notification.ICON_HOVER_BACKGROUND);
                    g2.fill(shape);
                    g2.setColor(JBUI.CurrentTheme.ActionButton.hoverBorder());
                    g2.draw(shape);
                }
                finally {
                    g2.dispose();
                }
            }
            if (ColorUtil.isDark((Color)JBColor.namedColor((String)"MainToolbar.background")) && JBColor.isBright() && icon2 instanceof CachedImageIcon) {
                icon2 = CustomIconUtilKt.loadIconCustomVersionOrScale((CachedImageIcon)((CachedImageIcon)icon2), (int)16, (Boolean)true, (Boolean)true);
            }
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(7);
        }
        return icon3;
    }

    private void showMorePopup() {
        MyActionGroup group2 = new MyActionGroup();
        if (NotificationsConfigurationImpl.getInstanceImpl().isRegistered(this.myNotification.getGroupId())) {
            group2.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"notification.settings.action.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    NotificationBalloonActionProvider.this.doShowSettings();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/NotificationBalloonActionProvider$3", "actionPerformed"));
                }
            });
            group2.addSeparator();
        }
        group2.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"notifications.toolwindow.dont.show.again.for.this.project", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                NotificationBalloonActionProvider.this.handleDoNotAsk(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/NotificationBalloonActionProvider$4", "actionPerformed"));
            }
        });
        group2.add((AnAction)new DumbAwareAction(IdeBundle.message((String)"notifications.toolwindow.dont.show.again", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                NotificationBalloonActionProvider.this.handleDoNotAsk(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/NotificationBalloonActionProvider$5", "actionPerformed"));
            }
        });
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group2, DataManager.getInstance().getDataContext((Component)((Object)this.myMoreButton)), true, null, -1);
        Disposer.register((Disposable)this.myBalloon, (Disposable)popup2);
        popup2.showUnderneathOf((Component)((Object)this.myMoreButton));
    }

    private void doShowSettings() {
        NotificationCollector.getInstance().logNotificationSettingsClicked(this.myNotification.id, this.myNotification.getDisplayId(), this.myNotification.getGroupId());
        NotificationsConfigurable configurable = new NotificationsConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable(this.myLayoutData.project, (Configurable)configurable, () -> {
            Runnable runnable2 = configurable.enableSearch(this.myNotification.getGroupId());
            if (runnable2 != null) {
                runnable2.run();
            }
        });
    }

    private void handleDoNotAsk(boolean forProject) {
        this.myNotification.setDoNotAskFor(forProject ? this.myLayoutData.project : null);
        this.myNotification.expire();
    }

    @Override
    public void layout(@NotNull Rectangle bounds) {
        if (bounds == null) {
            NotificationBalloonActionProvider.$$$reportNull$$$0(8);
        }
        Dimension closeSize = this.myCloseButton.getPreferredSize();
        Insets borderInsets = this.myBalloon.getShadowBorderInsets();
        int x = bounds.x + bounds.width - borderInsets.right - closeSize.width - this.myLayoutData.configuration.rightActionsOffset.width;
        int y = bounds.y + borderInsets.top + this.myLayoutData.configuration.rightActionsOffset.height;
        this.myCloseButton.setBounds(x - NotificationBalloonActionProvider.CloseHoverBounds.x, y - NotificationBalloonActionProvider.CloseHoverBounds.y, closeSize.width + NotificationBalloonActionProvider.CloseHoverBounds.width, closeSize.height + NotificationBalloonActionProvider.CloseHoverBounds.height);
        if (this.myMoreButton != null) {
            Dimension size2 = this.myMoreButton.getPreferredSize();
            if (ExperimentalUI.isNewUI()) {
                this.myMoreButton.setBounds(x - size2.width - this.myLayoutData.configuration.gearCloseSpace - NotificationBalloonActionProvider.CloseHoverBounds.x, y - NotificationBalloonActionProvider.CloseHoverBounds.y, size2.width + NotificationBalloonActionProvider.CloseHoverBounds.width, size2.height + NotificationBalloonActionProvider.CloseHoverBounds.height);
            } else {
                this.myMoreButton.setBounds(x - size2.width - this.myLayoutData.configuration.gearCloseSpace, y, size2.width, size2.height);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "balloon";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/NotificationBalloonActionProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/NotificationBalloonActionProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "paintHover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paintHover";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }

    private static final class MyActionGroup
    extends DefaultActionGroup
    implements TooltipDescriptionProvider {
        private MyActionGroup() {
            this.setPopup(true);
        }
    }
}

