/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ide.IdeBundle;
import com.intellij.ui.colorpicker.AlphaFormat;
import com.intellij.ui.colorpicker.ButtonPanel;
import com.intellij.ui.colorpicker.ColorDocument;
import com.intellij.ui.colorpicker.ColorFormat;
import com.intellij.ui.colorpicker.ColorLabel;
import com.intellij.ui.colorpicker.ColorPickerBuilderKt;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorValueField;
import com.intellij.ui.colorpicker.ColorValuePanel;
import com.intellij.ui.colorpicker.ColorValuePanelKt;
import com.intellij.ui.colorpicker.DigitColorDocument;
import com.intellij.ui.colorpicker.HexColorDocument;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.SingleEdtTaskScheduler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 U2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001UB#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010?\u001a\u00020\u0007H\u0016J\b\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020AH\u0002J\u001a\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J\u001a\u0010H\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\b\u0010F\u001a\u0004\u0018\u00010GH\u0002J \u0010I\u001a\u00020A*\u00020J2\b\u0010K\u001a\u0004\u0018\u00010L2\b\u0010F\u001a\u0004\u0018\u00010GH\u0002J\u0010\u0010M\u001a\u00020A2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020A2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010Q\u001a\u00020A2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010R\u001a\u00020A2\u0006\u0010S\u001a\u00020JH\u0002J\u0012\u0010T\u001a\u00020A2\b\u0010S\u001a\u0004\u0018\u00010JH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00020\f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u00020\u00108\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00020\u00108\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u001e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0013\u0010#\u001a\u00020\u00108\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0012R\u000e\u0010%\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010'\u001a\u00020\u00108\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0012R\u000e\u0010)\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010+\u001a\u00020\u00108\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0012R\u000e\u0010-\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u00101\u001a\u0002002\u0006\u0010/\u001a\u0002008B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b2\u00103\"\u0004\b4\u00105R+\u00109\u001a\u0002082\u0006\u0010/\u001a\u0002088B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b>\u00107\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u00a8\u0006V"}, d2={"Lcom/intellij/ui/colorpicker/ColorValuePanel;", "Ljavax/swing/JPanel;", "Ljavax/swing/event/DocumentListener;", "Lcom/intellij/ui/picker/ColorListener;", "model", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "showAlpha", "", "showAlphaInPercent", "<init>", "(Lcom/intellij/ui/colorpicker/ColorPickerModel;ZZ)V", "updateAlarm", "Lcom/intellij/util/SingleEdtTaskScheduler;", "getUpdateAlarm", "()Lcom/intellij/util/SingleEdtTaskScheduler;", "alphaField", "Lcom/intellij/ui/colorpicker/ColorValueField;", "getAlphaField", "()Lcom/intellij/ui/colorpicker/ColorValueField;", "alphaHexDocument", "Lcom/intellij/ui/colorpicker/DigitColorDocument;", "alphaPercentageDocument", "hexField", "getHexField", "alphaLabel", "Lcom/intellij/ui/colorpicker/ColorLabel;", "colorLabel1", "colorLabel2", "colorLabel3", "alphaButtonPanel", "Lcom/intellij/ui/colorpicker/ButtonPanel;", "getAlphaButtonPanel", "()Lcom/intellij/ui/colorpicker/ButtonPanel;", "colorFormatButtonPanel", "getColorFormatButtonPanel", "colorField1", "getColorField1", "redDocument", "hueDocument", "colorField2", "getColorField2", "greenDocument", "saturationDocument", "colorField3", "getColorField3", "blueDocument", "brightnessDocument", "<set-?>", "Lcom/intellij/ui/colorpicker/AlphaFormat;", "currentAlphaFormat", "getCurrentAlphaFormat", "()Lcom/intellij/ui/colorpicker/AlphaFormat;", "setCurrentAlphaFormat", "(Lcom/intellij/ui/colorpicker/AlphaFormat;)V", "currentAlphaFormat$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lcom/intellij/ui/colorpicker/ColorFormat;", "currentColorFormat", "getCurrentColorFormat", "()Lcom/intellij/ui/colorpicker/ColorFormat;", "setCurrentColorFormat", "(Lcom/intellij/ui/colorpicker/ColorFormat;)V", "currentColorFormat$delegate", "requestFocusInWindow", "updateAlphaFormat", "", "updateColorFormat", "colorChanged", "color", "Ljava/awt/Color;", "source", "", "updateTextField", "setTextIfNeeded", "Ljavax/swing/JTextField;", "newText", "", "insertUpdate", "e", "Ljavax/swing/event/DocumentEvent;", "removeUpdate", "changedUpdate", "update", "src", "updateColorToColorModel", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nColorValuePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorValuePanel.kt\ncom/intellij/ui/colorpicker/ColorValuePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Delegates.kt\nkotlin/properties/Delegates\n*L\n1#1,650:1\n1#2:651\n33#3,3:652\n33#3,3:655\n*S KotlinDebug\n*F\n+ 1 ColorValuePanel.kt\ncom/intellij/ui/colorpicker/ColorValuePanel\n*L\n119#1:652,3\n125#1:655,3\n*E\n"})
public final class ColorValuePanel
extends JPanel
implements DocumentListener,
ColorListener {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ColorPickerModel model;
    private final boolean showAlpha;
    private final boolean showAlphaInPercent;
    @NotNull
    private final SingleEdtTaskScheduler updateAlarm;
    @NotNull
    private final ColorValueField alphaField;
    @NotNull
    private final DigitColorDocument alphaHexDocument;
    @NotNull
    private final DigitColorDocument alphaPercentageDocument;
    @NotNull
    private final ColorValueField hexField;
    @NotNull
    private final ColorLabel alphaLabel;
    @NotNull
    private final ColorLabel colorLabel1;
    @NotNull
    private final ColorLabel colorLabel2;
    @NotNull
    private final ColorLabel colorLabel3;
    @TestOnly
    @NotNull
    private final ButtonPanel alphaButtonPanel;
    @TestOnly
    @NotNull
    private final ButtonPanel colorFormatButtonPanel;
    @NotNull
    private final ColorValueField colorField1;
    @NotNull
    private final DigitColorDocument redDocument;
    @NotNull
    private final DigitColorDocument hueDocument;
    @NotNull
    private final ColorValueField colorField2;
    @NotNull
    private final DigitColorDocument greenDocument;
    @NotNull
    private final DigitColorDocument saturationDocument;
    @NotNull
    private final ColorValueField colorField3;
    @NotNull
    private final DigitColorDocument blueDocument;
    @NotNull
    private final DigitColorDocument brightnessDocument;
    @NotNull
    private final ReadWriteProperty currentAlphaFormat$delegate;
    @NotNull
    private final ReadWriteProperty currentColorFormat$delegate;

    /*
     * WARNING - void declaration
     */
    public ColorValuePanel(@NotNull ColorPickerModel model2, boolean showAlpha, boolean showAlphaInPercent) {
        void $this$brightnessDocument_u24lambda_u240;
        DigitColorDocument $this$blueDocument_u24lambda_u240;
        DigitColorDocument $this$saturationDocument_u24lambda_u240;
        DigitColorDocument $this$greenDocument_u24lambda_u240;
        DigitColorDocument $this$hueDocument_u24lambda_u240;
        DigitColorDocument $this$redDocument_u24lambda_u240;
        DigitColorDocument $this$alphaPercentageDocument_u24lambda_u240;
        DigitColorDocument $this$alphaHexDocument_u24lambda_u240;
        DigitColorDocument digitColorDocument;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(new GridBagLayout());
        this.model = model2;
        this.showAlpha = showAlpha;
        this.showAlphaInPercent = showAlphaInPercent;
        this.updateAlarm = SingleEdtTaskScheduler.Companion.createSingleEdtTaskScheduler$default((SingleEdtTaskScheduler.Companion)SingleEdtTaskScheduler.Companion, null, (int)1, null);
        this.alphaField = new ColorValueField(false, false, 3, null);
        DigitColorDocument digitColorDocument2 = digitColorDocument = new DigitColorDocument(this.alphaField, ColorValuePanelKt.access$getCOLOR_RANGE$p());
        ColorValuePanel colorValuePanel = this;
        boolean bl = false;
        $this$alphaHexDocument_u24lambda_u240.addDocumentListener(this);
        colorValuePanel.alphaHexDocument = digitColorDocument;
        $this$alphaHexDocument_u24lambda_u240 = digitColorDocument = new DigitColorDocument(this.alphaField, ColorValuePanelKt.access$getPERCENT_RANGE$p());
        colorValuePanel = this;
        boolean bl2 = false;
        $this$alphaPercentageDocument_u24lambda_u240.addDocumentListener(this);
        colorValuePanel.alphaPercentageDocument = digitColorDocument;
        this.hexField = new ColorValueField(true, this.showAlpha);
        this.alphaLabel = new ColorLabel(null, 1, null);
        this.colorLabel1 = new ColorLabel(null, 1, null);
        this.colorLabel2 = new ColorLabel(null, 1, null);
        this.colorLabel3 = new ColorLabel(null, 1, null);
        this.alphaButtonPanel = ColorValuePanel.Companion.createAlphaLabel(this.alphaLabel, (Function0<Unit>)() -> ColorValuePanel.alphaButtonPanel$lambda$0(this));
        this.colorFormatButtonPanel = ColorValuePanel.Companion.createFormatLabels(this.colorLabel1, this.colorLabel2, this.colorLabel3, (Function0<Unit>)() -> ColorValuePanel.colorFormatButtonPanel$lambda$0(this));
        this.colorField1 = new ColorValueField(false, false, 3, null);
        $this$alphaPercentageDocument_u24lambda_u240 = digitColorDocument = new DigitColorDocument(this.colorField1, ColorValuePanelKt.access$getCOLOR_RANGE$p());
        colorValuePanel = this;
        boolean bl3 = false;
        $this$redDocument_u24lambda_u240.addDocumentListener(this);
        colorValuePanel.redDocument = digitColorDocument;
        $this$redDocument_u24lambda_u240 = digitColorDocument = new DigitColorDocument(this.colorField1, ColorValuePanelKt.access$getHUE_RANGE$p());
        colorValuePanel = this;
        boolean bl4 = false;
        $this$hueDocument_u24lambda_u240.addDocumentListener(this);
        colorValuePanel.hueDocument = digitColorDocument;
        this.colorField2 = new ColorValueField(false, false, 3, null);
        $this$hueDocument_u24lambda_u240 = digitColorDocument = new DigitColorDocument(this.colorField2, ColorValuePanelKt.access$getCOLOR_RANGE$p());
        colorValuePanel = this;
        boolean bl5 = false;
        $this$greenDocument_u24lambda_u240.addDocumentListener(this);
        colorValuePanel.greenDocument = digitColorDocument;
        $this$greenDocument_u24lambda_u240 = digitColorDocument = new DigitColorDocument(this.colorField2, ColorValuePanelKt.access$getPERCENT_RANGE$p());
        colorValuePanel = this;
        boolean bl6 = false;
        $this$saturationDocument_u24lambda_u240.addDocumentListener(this);
        colorValuePanel.saturationDocument = digitColorDocument;
        this.colorField3 = new ColorValueField(false, false, 3, null);
        $this$saturationDocument_u24lambda_u240 = digitColorDocument = new DigitColorDocument(this.colorField3, ColorValuePanelKt.access$getCOLOR_RANGE$p());
        colorValuePanel = this;
        boolean bl7 = false;
        $this$blueDocument_u24lambda_u240.addDocumentListener(this);
        colorValuePanel.blueDocument = digitColorDocument;
        $this$blueDocument_u24lambda_u240 = digitColorDocument = new DigitColorDocument(this.colorField3, ColorValuePanelKt.access$getPERCENT_RANGE$p());
        colorValuePanel = this;
        boolean bl8 = false;
        $this$brightnessDocument_u24lambda_u240.addDocumentListener(this);
        colorValuePanel.brightnessDocument = digitColorDocument;
        digitColorDocument = Delegates.INSTANCE;
        Enum initialValue$iv = this.showAlphaInPercent ? AlphaFormat.PERCENTAGE : ColorValuePanelKt.access$loadAlphaFormatProperty();
        boolean $i$f$observable = false;
        this.currentAlphaFormat$delegate = (ReadWriteProperty)new ObservableProperty<AlphaFormat>((Object)initialValue$iv, this){
            final /* synthetic */ ColorValuePanel this$0;
            {
                this.this$0 = colorValuePanel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                AlphaFormat alphaFormat = (AlphaFormat)((Object)newValue);
                AlphaFormat cfr_ignored_0 = (AlphaFormat)((Object)oldValue);
                boolean bl = false;
                ColorValuePanel.access$updateAlphaFormat(this.this$0);
                ColorValuePanelKt.access$saveAlphaFormatProperty((AlphaFormat)newValue2);
                this.this$0.repaint();
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = ColorValuePanelKt.access$loadColorFormatProperty();
        $i$f$observable = false;
        this.currentColorFormat$delegate = (ReadWriteProperty)new ObservableProperty<ColorFormat>((Object)initialValue$iv, this){
            final /* synthetic */ ColorValuePanel this$0;
            {
                this.this$0 = colorValuePanel;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                ColorFormat colorFormat = (ColorFormat)((Object)newValue);
                ColorFormat cfr_ignored_0 = (ColorFormat)((Object)oldValue);
                boolean bl = false;
                ColorValuePanel.access$updateColorFormat(this.this$0);
                ColorValuePanelKt.access$saveColorFormatProperty((ColorFormat)newValue2);
                this.this$0.repaint();
            }
        };
        this.setBorder((Border)ColorValuePanelKt.access$getPANEL_BORDER$p());
        this.setPreferredSize((Dimension)ColorValuePanelKt.access$getPREFERRED_PANEL_SIZE$p());
        this.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        this.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.36;
        c.gridwidth = 3;
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)this.colorFormatButtonPanel, c);
        c.gridwidth = 1;
        c.weightx = 0.12;
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)this.colorField1, c);
        c.gridx = 2;
        c.gridy = 1;
        this.add((Component)this.colorField2, c);
        c.gridx = 3;
        c.gridy = 1;
        this.add((Component)this.colorField3, c);
        if (this.showAlpha) {
            c.weightx = 0.12;
            c.gridx = 4;
            c.gridy = 0;
            this.add((Component)this.alphaButtonPanel, c);
            c.gridy = 1;
            this.add((Component)this.alphaField, c);
        }
        c.gridheight = 1;
        c.weightx = 0.51;
        c.gridx = this.showAlpha ? 5 : 4;
        c.gridy = 0;
        String string = IdeBundle.message((String)"colorpicker.colorvaluepanel.hexlabel", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.add((Component)new ColorLabel(string), c);
        c.gridy = 1;
        this.add((Component)this.hexField, c);
        this.hexField.setDocument(new HexColorDocument(this.hexField));
        this.hexField.getDocument().addDocumentListener(this);
        this.updateAlphaFormat();
        this.updateColorFormat();
        this.model.addListener(this);
    }

    public /* synthetic */ ColorValuePanel(ColorPickerModel colorPickerModel, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(colorPickerModel, bl, bl2);
    }

    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public final SingleEdtTaskScheduler getUpdateAlarm() {
        return this.updateAlarm;
    }

    @TestOnly
    @NotNull
    public final ColorValueField getAlphaField() {
        return this.alphaField;
    }

    @TestOnly
    @NotNull
    public final ColorValueField getHexField() {
        return this.hexField;
    }

    @NotNull
    public final ButtonPanel getAlphaButtonPanel() {
        return this.alphaButtonPanel;
    }

    @NotNull
    public final ButtonPanel getColorFormatButtonPanel() {
        return this.colorFormatButtonPanel;
    }

    @TestOnly
    @NotNull
    public final ColorValueField getColorField1() {
        return this.colorField1;
    }

    @TestOnly
    @NotNull
    public final ColorValueField getColorField2() {
        return this.colorField2;
    }

    @TestOnly
    @NotNull
    public final ColorValueField getColorField3() {
        return this.colorField3;
    }

    private final AlphaFormat getCurrentAlphaFormat() {
        return (AlphaFormat)((Object)this.currentAlphaFormat$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    private final void setCurrentAlphaFormat(AlphaFormat alphaFormat) {
        this.currentAlphaFormat$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)alphaFormat);
    }

    private final ColorFormat getCurrentColorFormat() {
        return (ColorFormat)((Object)this.currentColorFormat$delegate.getValue((Object)this, $$delegatedProperties[1]));
    }

    private final void setCurrentColorFormat(ColorFormat colorFormat) {
        this.currentColorFormat$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)colorFormat);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.colorField1.requestFocusInWindow();
    }

    private final void updateAlphaFormat() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCurrentAlphaFormat().ordinal()]) {
            case 1: {
                this.alphaLabel.setText(IdeBundle.message((String)"colorpanel.label.alpha", (Object[])new Object[0]));
                this.alphaField.setDocument(this.alphaHexDocument);
                this.alphaField.setText(String.valueOf(this.model.getAlpha()));
                break;
            }
            case 2: {
                this.alphaLabel.setText(IdeBundle.message((String)"colorpanel.label.alpha.percent", (Object[])new Object[0]));
                this.alphaField.setDocument(this.alphaPercentageDocument);
                this.alphaField.setText(String.valueOf(MathKt.roundToInt((float)((float)this.model.getAlpha() * 100.0f / (float)255))));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.updateAlarm.cancel();
        this.repaint();
    }

    private final void updateColorFormat() {
        switch (WhenMappings.$EnumSwitchMapping$1[this.getCurrentColorFormat().ordinal()]) {
            case 1: {
                this.colorLabel1.setText(IdeBundle.message((String)"colorpanel.label.red", (Object[])new Object[0]));
                this.colorLabel2.setText(IdeBundle.message((String)"colorpanel.label.green", (Object[])new Object[0]));
                this.colorLabel3.setText(IdeBundle.message((String)"colorpanel.label.blue", (Object[])new Object[0]));
                this.colorField1.setDocument(this.redDocument);
                this.colorField2.setDocument(this.greenDocument);
                this.colorField3.setDocument(this.blueDocument);
                this.colorField1.setText(String.valueOf(this.model.getRed()));
                this.colorField2.setText(String.valueOf(this.model.getGreen()));
                this.colorField3.setText(String.valueOf(this.model.getBlue()));
                break;
            }
            case 2: {
                this.colorLabel1.setText(IdeBundle.message((String)"colorpanel.label.hue", (Object[])new Object[0]));
                this.colorLabel2.setText(IdeBundle.message((String)"colorpanel.label.saturation", (Object[])new Object[0]));
                this.colorLabel3.setText(IdeBundle.message((String)"colorpanel.label.brightness", (Object[])new Object[0]));
                this.colorField1.setDocument(this.hueDocument);
                this.colorField2.setDocument(this.saturationDocument);
                this.colorField3.setDocument(this.brightnessDocument);
                this.colorField1.setText(String.valueOf(MathKt.roundToInt((float)(this.model.getHue() * (float)360))));
                this.colorField2.setText(String.valueOf(MathKt.roundToInt((float)(this.model.getSaturation() * (float)100))));
                this.colorField3.setText(String.valueOf(MathKt.roundToInt((float)(this.model.getBrightness() * (float)100))));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.updateAlarm.cancel();
        this.repaint();
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.updateTextField(color, source);
    }

    private final void updateTextField(Color color, Object source) {
        if (this.getCurrentAlphaFormat() == AlphaFormat.BYTE) {
            this.setTextIfNeeded(this.alphaField, String.valueOf(color.getAlpha()), source);
        } else {
            this.setTextIfNeeded(this.alphaField, String.valueOf(MathKt.roundToInt((float)((float)color.getAlpha() * 100.0f / (float)255))), source);
        }
        if (this.getCurrentColorFormat() == ColorFormat.RGB) {
            this.setTextIfNeeded(this.colorField1, String.valueOf(color.getRed()), source);
            this.setTextIfNeeded(this.colorField2, String.valueOf(color.getGreen()), source);
            this.setTextIfNeeded(this.colorField3, String.valueOf(color.getBlue()), source);
        } else {
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.setTextIfNeeded(this.colorField1, String.valueOf(MathKt.roundToInt((float)(hsb[0] * (float)360))), source);
            this.setTextIfNeeded(this.colorField2, String.valueOf(MathKt.roundToInt((float)(hsb[1] * (float)100))), source);
            this.setTextIfNeeded(this.colorField3, String.valueOf(MathKt.roundToInt((float)(hsb[2] * (float)100))), source);
        }
        String string = "%02X";
        Object[] objectArray = new Object[]{color.getRed()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        string = "%02X";
        objectArray = new Object[]{color.getGreen()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        string = "%02X";
        objectArray = new Object[]{color.getBlue()};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        String hexStr = string2 + string3 + string4;
        if (this.showAlpha) {
            string = "%02X";
            objectArray = new Object[]{color.getAlpha()};
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            hexStr = hexStr + string5;
        }
        this.setTextIfNeeded(this.hexField, hexStr, source);
        this.updateAlarm.cancel();
    }

    private final void setTextIfNeeded(JTextField $this$setTextIfNeeded, String newText, Object source) {
        if (!(Intrinsics.areEqual((Object)$this$setTextIfNeeded.getText(), (Object)newText) || Intrinsics.areEqual((Object)source, (Object)this) && $this$setTextIfNeeded.isFocusOwner())) {
            $this$setTextIfNeeded.setText(newText);
        }
    }

    @Override
    public void insertUpdate(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Document document2 = e.getDocument();
        Intrinsics.checkNotNull((Object)document2, (String)"null cannot be cast to non-null type com.intellij.ui.colorpicker.ColorDocument");
        this.update(((ColorDocument)document2).getSrc$intellij_platform_ide_impl());
    }

    @Override
    public void removeUpdate(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Document document2 = e.getDocument();
        Intrinsics.checkNotNull((Object)document2, (String)"null cannot be cast to non-null type com.intellij.ui.colorpicker.ColorDocument");
        this.update(((ColorDocument)document2).getSrc$intellij_platform_ide_impl());
    }

    @Override
    public void changedUpdate(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    private final void update(JTextField src) {
        this.updateAlarm.cancelAndRequest(300L, () -> ColorValuePanel.update$lambda$0(this, src));
    }

    private final void updateColorToColorModel(JTextField src) {
        Color color;
        if (Intrinsics.areEqual((Object)src, (Object)this.hexField)) {
            String string = this.hexField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            color = ColorValuePanelKt.access$convertHexToColor(string);
        } else {
            int a = this.getCurrentAlphaFormat() == AlphaFormat.BYTE ? (this.showAlpha ? this.alphaField.getColorValue() : 255) : (this.showAlpha ? MathKt.roundToInt((float)((float)(this.alphaField.getColorValue() * 255) / 100.0f)) : 100);
            switch (WhenMappings.$EnumSwitchMapping$1[this.getCurrentColorFormat().ordinal()]) {
                case 1: {
                    int r = this.colorField1.getColorValue();
                    int g = this.colorField2.getColorValue();
                    int b = this.colorField3.getColorValue();
                    if (this.showAlpha) {
                        color = new Color(r, g, b, a);
                        break;
                    }
                    color = new Color(r, g, b);
                    break;
                }
                case 2: {
                    float h = (float)this.colorField1.getColorValue() / 360.0f;
                    float s = (float)this.colorField2.getColorValue() / 100.0f;
                    float b = (float)this.colorField3.getColorValue() / 100.0f;
                    color = new Color(a << 24 | 0xFFFFFF & Color.HSBtoRGB(h, s, b), this.showAlpha);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Color color2 = color;
        this.model.setColor(color2, this);
    }

    private static final Unit alphaButtonPanel$lambda$0(ColorValuePanel this$0) {
        this$0.setCurrentAlphaFormat(this$0.getCurrentAlphaFormat().next());
        return Unit.INSTANCE;
    }

    private static final Unit colorFormatButtonPanel$lambda$0(ColorValuePanel this$0) {
        this$0.setCurrentColorFormat(this$0.getCurrentColorFormat().next());
        return Unit.INSTANCE;
    }

    private static final void update$lambda$0(ColorValuePanel this$0, JTextField $src) {
        this$0.updateColorToColorModel($src);
    }

    public static final /* synthetic */ void access$updateAlphaFormat(ColorValuePanel $this) {
        $this.updateAlphaFormat();
    }

    public static final /* synthetic */ void access$updateColorFormat(ColorValuePanel $this) {
        $this.updateColorFormat();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ColorValuePanel.class, "currentAlphaFormat", "getCurrentAlphaFormat()Lcom/intellij/ui/colorpicker/AlphaFormat;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(ColorValuePanel.class, "currentColorFormat", "getCurrentColorFormat()Lcom/intellij/ui/colorpicker/ColorFormat;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\b\u0006*\u0002\u0005\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ3\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ui/colorpicker/ColorValuePanel$Companion;", "", "<init>", "()V", "createAlphaLabel", "com/intellij/ui/colorpicker/ColorValuePanel$Companion$createAlphaLabel$1", "alphaLabel", "Lcom/intellij/ui/colorpicker/ColorLabel;", "onClick", "Lkotlin/Function0;", "", "(Lcom/intellij/ui/colorpicker/ColorLabel;Lkotlin/jvm/functions/Function0;)Lcom/intellij/ui/colorpicker/ColorValuePanel$Companion$createAlphaLabel$1;", "createFormatLabels", "com/intellij/ui/colorpicker/ColorValuePanel$Companion$createFormatLabels$1", "label1", "label2", "label3", "(Lcom/intellij/ui/colorpicker/ColorLabel;Lcom/intellij/ui/colorpicker/ColorLabel;Lcom/intellij/ui/colorpicker/ColorLabel;Lkotlin/jvm/functions/Function0;)Lcom/intellij/ui/colorpicker/ColorValuePanel$Companion$createFormatLabels$1;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final createAlphaLabel.1 createAlphaLabel(ColorLabel alphaLabel, Function0<Unit> onClick) {
            return new ButtonPanel(alphaLabel, onClick){
                final /* synthetic */ Function0<Unit> $onClick;
                {
                    this.$onClick = $onClick;
                    this.setLayout(new GridLayout(1, 1));
                    this.add($alphaLabel);
                }

                public void clicked() {
                    this.$onClick.invoke();
                }
            };
        }

        private final createFormatLabels.1 createFormatLabels(ColorLabel label1, ColorLabel label2, ColorLabel label3, Function0<Unit> onClick) {
            return new ButtonPanel(label1, label2, label3, onClick){
                final /* synthetic */ Function0<Unit> $onClick;
                {
                    this.$onClick = $onClick;
                    this.setLayout(new GridLayout(1, 3));
                    this.add($label1);
                    this.add($label2);
                    this.add($label3);
                }

                public void clicked() {
                    this.$onClick.invoke();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AlphaFormat.values().length];
            try {
                nArray[AlphaFormat.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlphaFormat.PERCENTAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ColorFormat.values().length];
            try {
                nArray[ColorFormat.RGB.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorFormat.HSB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

