/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorPipette;
import com.intellij.ui.colorpicker.SaturationBrightnessComponentKt;
import com.intellij.ui.colorpicker.SaturationBrightnessImageProducer;
import com.intellij.ui.colorpicker.UtilsKt;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MultiResolutionImage;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.image.ToolkitImage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020 2\u0006\u0010.\u001a\u00020,H\u0014J\u001a\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020$2\b\u00101\u001a\u0004\u0018\u000102H\u0016J(\u00103\u001a\u00020 2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\t2\u0006\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020\u0011H\u0002J\u0010\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020$H\u0016J\u0010\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020$H\u0016J\b\u0010<\u001a\u00020 H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006="}, d2={"Lcom/intellij/ui/colorpicker/SaturationBrightnessComponent;", "Ljavax/swing/JComponent;", "Lcom/intellij/ui/picker/ColorListener;", "Lcom/intellij/ui/colorpicker/ColorPipette$Callback;", "myModel", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "<init>", "(Lcom/intellij/ui/colorpicker/ColorPickerModel;)V", "value", "", "brightness", "getBrightness", "()F", "hue", "getHue", "saturation", "getSaturation", "", "alpha", "getAlpha", "()I", "pipetteMode", "", "getPipetteMode", "()Z", "setPipetteMode", "(Z)V", "robot", "Ljava/awt/Robot;", "getRobot", "()Ljava/awt/Robot;", "handleMouseEvent", "", "e", "Ljava/awt/event/MouseEvent;", "getColorByPoint", "Ljava/awt/Color;", "p", "Ljava/awt/Point;", "getPreferredSize", "Ljava/awt/Dimension;", "getMinimumSize", "paintPipetteMode", "graphics", "Ljava/awt/Graphics;", "paintComponent", "g", "colorChanged", "color", "source", "", "setHSBAValue", "h", "s", "b", "a", "picked", "pickedColor", "update", "updatedColor", "cancel", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class SaturationBrightnessComponent
extends JComponent
implements ColorListener,
ColorPipette.Callback {
    @NotNull
    private final ColorPickerModel myModel;
    private float brightness;
    private float hue;
    private float saturation;
    private int alpha;
    private boolean pipetteMode;
    @NotNull
    private final Robot robot;

    public SaturationBrightnessComponent(@NotNull ColorPickerModel myModel) {
        Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
        this.myModel = myModel;
        this.brightness = 1.0f;
        this.hue = 1.0f;
        this.alpha = 255;
        this.robot = new Robot();
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        MouseAdapter mouseAdapter2 = new MouseAdapter(this){
            final /* synthetic */ SaturationBrightnessComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e);
            }

            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e);
            }
        };
        this.addMouseListener(mouseAdapter2);
        this.addMouseMotionListener(mouseAdapter2);
        this.myModel.addListener(this);
        if (Registry.Companion.is("ide.color.picker.new.pipette")) {
            this.myModel.addPipetteListener(this);
        }
    }

    public final float getBrightness() {
        return this.brightness;
    }

    public final float getHue() {
        return this.hue;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    public final boolean getPipetteMode() {
        return this.pipetteMode;
    }

    public final void setPipetteMode(boolean bl) {
        this.pipetteMode = bl;
    }

    @NotNull
    public final Robot getRobot() {
        return this.robot;
    }

    private final void handleMouseEvent(MouseEvent e) {
        Point point = e.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        this.myModel.setColor(this.getColorByPoint(point), this);
    }

    @NotNull
    public final Color getColorByPoint(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int x = Math.max(0, Math.min(p.x, this.getSize().width));
        int y = Math.max(0, Math.min(p.y, this.getSize().height));
        float saturation = (float)x / (float)this.getSize().width;
        float brightness = 1.0f - (float)y / (float)this.getSize().height;
        int argb = UtilsKt.ahsbToArgb(this.alpha, this.hue, saturation, brightness);
        return new Color(argb, true);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        JBDimension jBDimension = JBUI.size((int)300, (int)150);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.size((int)150, (int)140);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
        return (Dimension)jBDimension;
    }

    private final void paintPipetteMode(Graphics graphics) {
        graphics.setColor(this.getParent().getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics graphics2 = graphics.create();
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics2;
        Point p = MouseInfo.getPointerInfo().getLocation();
        double size2 = (double)this.getWidth() / 21.0;
        MultiResolutionImage img = this.robot.createMultiResolutionScreenCapture(new Rectangle(p.x - 10, p.y - 5, 21, 11));
        List<Image> list2 = img.getResolutionVariants();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getResolutionVariants(...)");
        Image image2 = (Image)CollectionsKt.last(list2);
        int iW = image2.getWidth(null);
        int iH = image2.getHeight(null);
        g.scale((double)this.getWidth() / 21.0, (double)this.getWidth() / 21.0);
        g.drawImage(image2, -((int)((double)(iW - 21) / 2.0)), -((int)Math.ceil((double)(iH - 11) / 2.0)), null);
        g.dispose();
        int xx = (int)Math.ceil(size2 * (double)10);
        int yy = (int)Math.ceil(size2 * (double)5);
        graphics.setColor(Color.white);
        graphics.drawRect(xx, yy, (int)(size2 - 1.0), (int)(size2 - 1.0));
        graphics.setColor(Color.black);
        graphics.drawRect(xx + 1, yy + 1, (int)(size2 - (double)3), (int)(size2 - (double)3));
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (Registry.Companion.is("ide.color.picker.new.pipette") && this.pipetteMode) {
            this.paintPipetteMode(g);
            return;
        }
        Rectangle component2 = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        Image image2 = this.createImage(new SaturationBrightnessImageProducer(this.getSize().width, this.getSize().height, this.hue));
        g.setColor(UIUtil.getPanelBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(image2, component2.x, component2.y, null);
        int knobX = Math.round(this.saturation * (float)component2.width);
        int knobY = Math.round((float)component2.height * (1.0f - this.brightness));
        if (image2 instanceof ToolkitImage && ((ToolkitImage)image2).getBufferedImage().getWidth() > knobX && ((ToolkitImage)image2).getBufferedImage().getHeight() > knobY) {
            int rgb = ((ToolkitImage)image2).getBufferedImage().getRGB(knobX, knobY);
            g.setColor(ColorUtil.isDark((Color)new Color(rgb)) ? Color.WHITE : Color.BLACK);
        } else {
            g.setColor(SaturationBrightnessComponentKt.access$getKNOB_COLOR$p());
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        g.drawOval(knobX - JBUI.scale((int)4), knobY - JBUI.scale((int)4), JBUI.scale((int)8), JBUI.scale((int)8));
        config.restore();
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float[] hsbValues = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.setHSBAValue(hsbValues[0], hsbValues[1], hsbValues[2], color.getAlpha());
    }

    private final void setHSBAValue(float h, float s, float b, int a) {
        this.hue = h;
        this.saturation = s;
        this.brightness = b;
        this.alpha = a;
        this.repaint();
    }

    @Override
    public void picked(@NotNull Color pickedColor) {
        Intrinsics.checkNotNullParameter((Object)pickedColor, (String)"pickedColor");
        this.pipetteMode = false;
    }

    @Override
    public void update(@NotNull Color updatedColor) {
        Intrinsics.checkNotNullParameter((Object)updatedColor, (String)"updatedColor");
        this.pipetteMode = true;
        this.repaint();
    }

    @Override
    public void cancel() {
        this.pipetteMode = false;
    }

    public static final /* synthetic */ void access$handleMouseEvent(SaturationBrightnessComponent $this, MouseEvent e) {
        $this.handleMouseEvent(e);
    }
}

