/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.components;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.builder.components.SegmentedButtonAction;
import com.intellij.ui.dsl.builder.components.SegmentedButtonLook;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/dsl/builder/components/SegmentedButton;", "T", "Lcom/intellij/openapi/actionSystem/impl/ActionButtonWithText;", "action", "Lcom/intellij/ui/dsl/builder/components/SegmentedButtonAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "spacing", "Lcom/intellij/ui/dsl/builder/SpacingConfiguration;", "<init>", "(Lcom/intellij/ui/dsl/builder/components/SegmentedButtonAction;Lcom/intellij/openapi/actionSystem/Presentation;Lcom/intellij/ui/dsl/builder/SpacingConfiguration;)V", "value", "", "selectedState", "getSelectedState", "()Z", "setSelectedState", "(Z)V", "setToolTipText", "", "toolTipText", "", "getPreferredSize", "Ljava/awt/Dimension;", "actionPerformed", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
final class SegmentedButton<T>
extends ActionButtonWithText {
    @NotNull
    private final SegmentedButtonAction<T> action;
    @NotNull
    private final SpacingConfiguration spacing;

    public SegmentedButton(@NotNull SegmentedButtonAction<T> action2, @NotNull Presentation presentation2, @NotNull SpacingConfiguration spacing) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        super((AnAction)action2, presentation2, "SegmentedButton", new Dimension(0, 0));
        this.action = action2;
        this.spacing = spacing;
        this.setLook(SegmentedButtonLook.INSTANCE);
    }

    public final boolean getSelectedState() {
        return Toggleable.isSelected((Presentation)this.myPresentation);
    }

    public final void setSelectedState(boolean value) {
        Toggleable.setSelected((Presentation)this.myPresentation, (boolean)value);
    }

    @Override
    public void setToolTipText(@Nullable String toolTipText) {
        this.setCustomToolTipText(toolTipText);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        int height = Math.max(preferredSize.height + JBUIScale.scale((int)this.spacing.getSegmentedButtonVerticalGap()) * 2, JBUI.CurrentTheme.Button.minimumSize().height - JBUIScale.scale((int)2));
        return new Dimension(preferredSize.width + JBUIScale.scale((int)this.spacing.getSegmentedButtonHorizontalGap()) * 2, height);
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.actionPerformed(event);
        this.setSelectedState(Intrinsics.areEqual(this.action.getParent().getSelectedItem(), this.action.getItem()));
    }
}

