/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.impl;

import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.UiSwitcher;
import com.intellij.ui.dsl.builder.CellBase;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.builder.impl.CellBaseImpl;
import com.intellij.ui.dsl.builder.impl.PlaceholderCellData;
import com.intellij.ui.dsl.builder.impl.RowImpl;
import com.intellij.ui.dsl.builder.impl.UtilsKt;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import java.awt.Component;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b!\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000bH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010!\u001a\u00020\u000bH\u0016J \u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u001cH\u0002J\b\u0010*\u001a\u00020\u001cH\u0002J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u000fJ\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\b\u00100\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lcom/intellij/ui/dsl/builder/impl/PlaceholderBaseImpl;", "T", "Lcom/intellij/ui/dsl/builder/CellBase;", "Lcom/intellij/ui/dsl/builder/impl/CellBaseImpl;", "parent", "Lcom/intellij/ui/dsl/builder/impl/RowImpl;", "<init>", "(Lcom/intellij/ui/dsl/builder/impl/RowImpl;)V", "placeholderCellData", "Lcom/intellij/ui/dsl/builder/impl/PlaceholderCellData;", "visible", "", "enabled", "uiSwitchers", "Ljava/util/LinkedHashSet;", "Lcom/intellij/openapi/ui/UiSwitcher;", "Lkotlin/collections/LinkedHashSet;", "componentField", "Ljavax/swing/JComponent;", "label", "Ljavax/swing/JLabel;", "value", "component", "getComponent", "()Ljavax/swing/JComponent;", "setComponent", "(Ljavax/swing/JComponent;)V", "enabledFromParent", "", "parentEnabled", "isEnabled", "visibleFromParent", "parentVisible", "isVisible", "init", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "constraints", "Lcom/intellij/ui/dsl/gridLayout/Constraints;", "spacing", "Lcom/intellij/ui/dsl/builder/SpacingConfiguration;", "removeComponent", "initInstalledComponent", "appendUiSwitcher", "uiSwitcher", "initLabelFor", "doVisible", "doEnabled", "invalidate", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public abstract class PlaceholderBaseImpl<T extends CellBase<? extends T>>
extends CellBaseImpl<T> {
    @NotNull
    private final RowImpl parent;
    @Nullable
    private PlaceholderCellData placeholderCellData;
    private boolean visible;
    private boolean enabled;
    @NotNull
    private final LinkedHashSet<UiSwitcher> uiSwitchers;
    @Nullable
    private JComponent componentField;
    @Nullable
    private JLabel label;

    public PlaceholderBaseImpl(@NotNull RowImpl parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(null);
        this.parent = parent;
        this.visible = true;
        this.enabled = true;
        this.uiSwitchers = new LinkedHashSet();
    }

    @Nullable
    public final JComponent getComponent() {
        return this.componentField;
    }

    public final void setComponent(@Nullable JComponent value) {
        block3: {
            if (this.componentField == value) break block3;
            this.removeComponent();
            if (value != null) {
                value.setVisible(value.isVisible() && this.visible && this.parent.isVisible());
                value.setEnabled(value.isEnabled() && this.enabled && this.parent.isEnabled());
                this.componentField = value;
                if (this.placeholderCellData != null) {
                    this.initInstalledComponent();
                }
                JLabel jLabel = this.label;
                if (jLabel != null) {
                    jLabel.setLabelFor(value);
                }
            }
        }
    }

    @Override
    public void enabledFromParent(boolean parentEnabled) {
        this.doEnabled(parentEnabled && this.enabled);
    }

    @Override
    @NotNull
    public CellBase<T> enabled(boolean isEnabled) {
        this.enabled = isEnabled;
        if (this.parent.isEnabled()) {
            this.doEnabled(this.enabled);
        }
        return this;
    }

    @Override
    public void visibleFromParent(boolean parentVisible) {
        this.doVisible(parentVisible && this.visible);
    }

    @Override
    @NotNull
    public CellBase<T> visible(boolean isVisible) {
        this.visible = isVisible;
        if (this.parent.isVisible()) {
            this.doVisible(this.visible);
        }
        return this;
    }

    public void init(@NotNull DialogPanel panel2, @NotNull Constraints constraints, @NotNull SpacingConfiguration spacing) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        this.placeholderCellData = new PlaceholderCellData(panel2, constraints, spacing);
        if (this.componentField != null) {
            this.initInstalledComponent();
        }
    }

    private final void removeComponent() {
        block3: {
            JComponent installedComponent = this.componentField;
            if (installedComponent == null) {
                return;
            }
            this.componentField = null;
            UiSwitcher.Companion.removeAll(installedComponent, (Set)this.uiSwitchers);
            PlaceholderCellData placeholderCellData = this.placeholderCellData;
            if (placeholderCellData != null) {
                PlaceholderCellData it = placeholderCellData;
                boolean bl = false;
                if (installedComponent instanceof DialogPanel) {
                    it.getPanel().unregisterIntegratedPanel((DialogPanel)installedComponent);
                }
                it.getPanel().remove((Component)installedComponent);
                this.invalidate();
            }
            JLabel jLabel = this.label;
            if (jLabel == null) break block3;
            jLabel.setLabelFor(null);
        }
    }

    private final void initInstalledComponent() {
        block4: {
            if (this.placeholderCellData == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            JComponent jComponent = this.componentField;
            if (jComponent == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            JComponent installedComponent = jComponent;
            UiSwitcher.Companion.appendAll(installedComponent, (Set)this.uiSwitchers);
            PlaceholderCellData placeholderCellData = this.placeholderCellData;
            if (placeholderCellData == null) break block4;
            PlaceholderCellData it = placeholderCellData;
            boolean bl = false;
            UnscaledGaps unscaledGaps = this.getCustomGaps();
            if (unscaledGaps == null) {
                unscaledGaps = UtilsKt.getComponentGaps(it.getConstraints().getGaps().getLeft(), it.getConstraints().getGaps().getRight(), installedComponent, it.getSpacing());
            }
            UnscaledGaps gaps = unscaledGaps;
            it.setConstraints(Constraints.copy$default((Constraints)it.getConstraints(), null, (int)0, (int)0, (int)0, (int)0, null, null, (boolean)false, (UnscaledGaps)gaps, (UnscaledGaps)UtilsKt.prepareVisualPaddings(installedComponent), null, null, (int)3327, null));
            it.getPanel().add((Component)installedComponent, (Object)it.getConstraints());
            if (installedComponent instanceof DialogPanel) {
                it.getPanel().registerIntegratedPanel((DialogPanel)installedComponent);
            }
            this.invalidate();
        }
    }

    public final void appendUiSwitcher(@NotNull UiSwitcher uiSwitcher) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)uiSwitcher, (String)"uiSwitcher");
            this.uiSwitchers.add(uiSwitcher);
            JComponent jComponent = this.getComponent();
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            UiSwitcher.Companion.append(it, uiSwitcher);
        }
    }

    public final void initLabelFor(@NotNull JLabel label2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            this.label = label2;
            JComponent jComponent = this.getComponent();
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            label2.setLabelFor(it);
        }
    }

    private final void doVisible(boolean isVisible) {
        block1: {
            JComponent jComponent = this.getComponent();
            if (jComponent == null) break block1;
            JComponent it = jComponent;
            boolean bl = false;
            if (it.isVisible() != isVisible) {
                it.setVisible(isVisible);
                this.invalidate();
            }
        }
    }

    private final void doEnabled(boolean isEnabled) {
        block0: {
            JComponent jComponent = this.getComponent();
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            it.setEnabled(isEnabled);
        }
    }

    private final void invalidate() {
        block0: {
            PlaceholderCellData placeholderCellData = this.placeholderCellData;
            if (placeholderCellData == null) break block0;
            PlaceholderCellData it = placeholderCellData;
            boolean bl = false;
            it.getPanel().revalidate();
            it.getPanel().repaint();
        }
    }
}

