/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.breadcrumbs.BreadcrumbsForceShownSettings;
import com.intellij.xml.breadcrumbs.BreadcrumbsPanel;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BreadcrumbsXmlWrapper
extends BreadcrumbsPanel
implements Border {
    @Nullable
    private final VirtualFile myFile;
    @NotNull
    private final FileBreadcrumbCollectorHolder myBreadcrumbsCollectorHolder;
    @ApiStatus.Internal
    @Topic.AppLevel
    public static final Topic<Runnable> FORCE_RELOAD_BREADCRUMBS = new Topic(Runnable.class, Topic.BroadcastDirection.TO_DIRECT_CHILDREN);

    public BreadcrumbsXmlWrapper(@NotNull Editor editor2) {
        if (editor2 == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(0);
        }
        super(editor2);
        this.myBreadcrumbsCollectorHolder = new FileBreadcrumbCollectorHolder();
        this.myFile = FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
        if (this.myFile != null) {
            this.myBreadcrumbsCollectorHolder.update(this.myFile);
        }
        if (ExperimentalUI.isNewUI()) {
            this.putClientProperty(FileEditorManager.SEPARATOR_DISABLED, Boolean.TRUE);
        }
        this.setBorder(this);
    }

    @Override
    @Nullable
    protected Iterable<? extends Crumb> computeCrumbs(int offset) {
        if (this.myFile == null) {
            return null;
        }
        this.myBreadcrumbsCollectorHolder.update(this.myFile);
        FileBreadcrumbsCollector breadcrumbsCollector = this.myBreadcrumbsCollectorHolder.getBreadcrumbsCollector();
        if (breadcrumbsCollector == null) {
            return null;
        }
        Document document2 = this.myEditor.getDocument();
        Boolean forcedShown = BreadcrumbsForceShownSettings.getForcedShown(this.myEditor);
        return breadcrumbsCollector.computeCrumbs(this.myFile, document2, offset, forcedShown);
    }

    public void navigate(NavigatableCrumb crumb, boolean withSelection) {
        this.myUserCaretChange = false;
        crumb.navigate(this.myEditor, withSelection);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(BreadcrumbsXmlWrapper.getBorderColor());
        RectanglePainter2D.DRAW.paint((Graphics2D)g, (double)x, (double)y, (double)width, (double)height, null, LinePainter2D.StrokeType.INSIDE, 1.0, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (ExperimentalUI.isNewUI()) {
            return this.breadcrumbs.above ? JBUI.insetsBottom((int)1) : JBUI.insetsTop((int)1);
        }
        return JBUI.emptyInsets();
    }

    private static Color getBorderColor() {
        return EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.BREADCRUMBS_BORDER_COLOR);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Nullable
    public static BreadcrumbsXmlWrapper getBreadcrumbWrapper(@NotNull Editor editor2) {
        BreadcrumbsPanel obj;
        if (editor2 == null) {
            BreadcrumbsXmlWrapper.$$$reportNull$$$0(1);
        }
        return (obj = BreadcrumbsPanel.getBreadcrumbsComponent(editor2)) instanceof BreadcrumbsXmlWrapper ? (BreadcrumbsXmlWrapper)obj : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBreadcrumbWrapper";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FileBreadcrumbCollectorHolder {
        @Nullable
        private volatile FileBreadcrumbsCollector myBreadcrumbsCollector;
        @NotNull
        private Disposable myCollectorListenerDisposable = Disposer.newDisposable();

        private FileBreadcrumbCollectorHolder() {
        }

        public void update(@NotNull VirtualFile file2) {
            FileBreadcrumbsCollector newCollector;
            if (file2 == null) {
                FileBreadcrumbCollectorHolder.$$$reportNull$$$0(0);
            }
            if ((newCollector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)BreadcrumbsXmlWrapper.this.myProject, (VirtualFile)BreadcrumbsXmlWrapper.this.myFile)) != this.myBreadcrumbsCollector) {
                Disposer.dispose((Disposable)this.myCollectorListenerDisposable);
                if (newCollector != null) {
                    Disposable newDisposable = Disposer.newDisposable((Disposable)BreadcrumbsXmlWrapper.this);
                    newCollector.watchForChanges(file2, BreadcrumbsXmlWrapper.this.myEditor, newDisposable, () -> BreadcrumbsXmlWrapper.this.queueUpdate());
                    this.myCollectorListenerDisposable = newDisposable;
                } else {
                    this.myCollectorListenerDisposable = Disposer.newDisposable();
                }
                this.myBreadcrumbsCollector = newCollector;
            }
        }

        @Nullable
        public FileBreadcrumbsCollector getBreadcrumbsCollector() {
            return this.myBreadcrumbsCollector;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/breadcrumbs/BreadcrumbsXmlWrapper$FileBreadcrumbCollectorHolder", "update"));
        }
    }
}

