// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.openapi.wm.impl

import kotlinx.collections.immutable.toImmutableList
import java.awt.event.ActionListener
import javax.swing.event.ChangeEvent
import javax.swing.event.ChangeListener

open class DefaultToolbarSplitButtonModel: ToolbarSplitButtonModel {

  private var myActionButtonSelected: Boolean = false
  private var myExpandButtonSelected: Boolean = false
  private val myActionListeners = mutableListOf<ActionListener>()
  private val myExpandListeners = mutableListOf<ActionListener>()
  private val myChangeListeners = mutableListOf<ChangeListener>()

  override fun isActionButtonSelected(): Boolean {
    return myActionButtonSelected
  }

  override fun setActionButtonSelected(b: Boolean) {
    myActionButtonSelected = b
    fireChangeListeners()
  }

  override fun isExpandButtonSelected(): Boolean {
    return myExpandButtonSelected
  }

  override fun setExpandButtonSelected(b: Boolean) {
    myExpandButtonSelected = b
    fireChangeListeners()
  }

  override fun addActionListener(listener: ActionListener) {
    myActionListeners.add(listener)
  }

  override fun removeActionListener(listener: ActionListener) {
    myActionListeners.remove(listener)
  }

  override fun addExpandListener(listener: ActionListener) {
    myExpandListeners.add(listener)
  }

  override fun removeExpandListener(listener: ActionListener) {
    myExpandListeners.remove(listener)
  }

  override fun getActionListeners(): List<ActionListener> = myActionListeners.toImmutableList()

  override fun getExpandListeners(): List<ActionListener> = myExpandListeners.toImmutableList()

  override fun addChangeListener(l: ChangeListener) {
    myChangeListeners.add(l)
  }

  override fun removeChangeListener(l: ChangeListener) {
    myChangeListeners.remove(l)
  }

  protected fun fireChangeListeners() {
    val event = ChangeEvent(this)
    myChangeListeners.forEach { it.stateChanged(event) }
  }
}