/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.colors.Groups;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class EditableSchemesCombo<T extends Scheme> {
    public static final int COMBO_WIDTH = 200;
    private SchemesCombo<T> myComboBox;
    private final JPanel myRootPanel;
    private final AbstractSchemesPanel<T, ?> mySchemesPanel;
    private final CardLayout myLayout;
    private final JTextField myNameEditorField;
    @Nullable
    private NameEditData myNameEditData;
    private static final KeyStroke ESC_KEY_STROKE = KeyStroke.getKeyStroke(27, 0, false);
    private static final KeyStroke ENTER_KEY_STROKE = KeyStroke.getKeyStroke(10, 0, false);
    private static final Color MODIFIED_ITEM_FOREGROUND = JBColor.namedColor((String)"ComboBox.modifiedItemForeground", (Color)JBColor.BLUE);

    public EditableSchemesCombo(@NotNull AbstractSchemesPanel<T, ?> schemesPanel) {
        if (schemesPanel == null) {
            EditableSchemesCombo.$$$reportNull$$$0(0);
        }
        this.mySchemesPanel = schemesPanel;
        this.myLayout = new CardLayout();
        this.myRootPanel = new JPanel(this.myLayout){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(JBUIScale.scale((int)200), super.getPreferredSize().height);
            }

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(JBUIScale.scale((int)200), Short.MAX_VALUE);
            }
        };
        this.myRootPanel.setOpaque(false);
        this.createCombo();
        this.myRootPanel.add((Component)((Object)this.myComboBox));
        this.myNameEditorField = this.createNameEditorField();
        this.myRootPanel.add(this.myNameEditorField);
    }

    private JTextField createNameEditorField() {
        JTextField nameEditorField = new JTextField();
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.revertSchemeName();
                EditableSchemesCombo.this.cancelEdit();
            }
        }, ESC_KEY_STROKE, 0);
        nameEditorField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.stopEdit();
            }
        }, ENTER_KEY_STROKE, 0);
        nameEditorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                EditableSchemesCombo.this.stopEdit();
            }
        });
        nameEditorField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                EditableSchemesCombo.this.validateOnTyping();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/schemes/EditableSchemesCombo$5", "textChanged"));
            }
        });
        return nameEditorField;
    }

    private void validateOnTyping() {
        String validationMessage;
        if (this.myNameEditData == null) {
            return;
        }
        String currName = this.myNameEditorField.getText();
        if (!currName.equals(this.myNameEditData.initialName) && (validationMessage = this.validateSchemeName(currName, this.myNameEditData.isProjectScheme)) != null) {
            this.mySchemesPanel.showInfo(validationMessage, MessageType.ERROR);
            return;
        }
        this.showHint();
    }

    private void showHint() {
        this.mySchemesPanel.showInfo(IdeBundle.message((String)"hint.scheme.editing", (Object[])new Object[0]), MessageType.INFO);
    }

    private void revertSchemeName() {
        if (this.myNameEditData != null) {
            this.myNameEditorField.setText(this.myNameEditData.initialName);
        }
    }

    public void updateSelected() {
        this.myComboBox.repaint();
    }

    private void stopEdit() {
        if (this.myNameEditData == null) {
            this.cancelEdit();
            return;
        }
        String newName = this.myNameEditorField.getText();
        String validationMessage = this.validateSchemeName(newName, this.myNameEditData.isProjectScheme);
        if (validationMessage != null) {
            this.mySchemesPanel.showInfo(validationMessage, MessageType.ERROR);
        } else {
            this.myNameEditData.nameConsumer.accept(newName);
            this.cancelEdit();
        }
    }

    public void cancelEdit() {
        this.mySchemesPanel.clearInfo();
        this.myLayout.first(this.myRootPanel);
        this.myNameEditData = null;
        IdeFocusManager focusManager = IdeFocusManager.getGlobalInstance();
        focusManager.doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myRootPanel, true));
    }

    private void createCombo() {
        this.myComboBox = new SchemesCombo<T>(){

            @Override
            protected boolean supportsProjectSchemes() {
                return EditableSchemesCombo.this.mySchemesPanel.supportsProjectSchemes();
            }

            @Override
            protected boolean isProjectScheme(@NotNull T scheme) {
                if (scheme == null) {
                    6.$$$reportNull$$$0(0);
                }
                return EditableSchemesCombo.this.mySchemesPanel.getModel().isProjectScheme(scheme);
            }

            @Override
            protected boolean isDefaultScheme(@NotNull T scheme) {
                if (scheme == null) {
                    6.$$$reportNull$$$0(1);
                }
                SchemesModel model2 = EditableSchemesCombo.this.mySchemesPanel.getModel();
                return model2.isDefaultScheme(scheme);
            }

            @Override
            protected int getIndent(@NotNull T scheme) {
                if (scheme == null) {
                    6.$$$reportNull$$$0(2);
                }
                return EditableSchemesCombo.this.mySchemesPanel.getIndent(scheme);
            }

            @Override
            @NotNull
            protected SimpleTextAttributes getSchemeAttributes(T scheme) {
                SimpleTextAttributes baseAttributes;
                SchemesModel model2 = EditableSchemesCombo.this.mySchemesPanel.getModel();
                SimpleTextAttributes simpleTextAttributes = baseAttributes = !EditableSchemesCombo.this.useBoldForNonRemovableSchemes() || model2.canDeleteScheme(scheme) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                if (EditableSchemesCombo.this.mySchemesPanel.highlightNonDefaultSchemes() && model2.canResetScheme(scheme) && model2.differsFromDefault(scheme)) {
                    SimpleTextAttributes simpleTextAttributes2 = baseAttributes.derive(-1, MODIFIED_ITEM_FOREGROUND, null, null);
                    if (simpleTextAttributes2 == null) {
                        6.$$$reportNull$$$0(3);
                    }
                    return simpleTextAttributes2;
                }
                SimpleTextAttributes simpleTextAttributes3 = baseAttributes;
                if (simpleTextAttributes3 == null) {
                    6.$$$reportNull$$$0(4);
                }
                return simpleTextAttributes3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/application/options/schemes/EditableSchemesCombo$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/application/options/schemes/EditableSchemesCombo$6";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSchemeAttributes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isProjectScheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isDefaultScheme";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getIndent";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4 -> new IllegalStateException(string);
                };
            }
        };
        this.myComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditableSchemesCombo.this.mySchemesPanel.getActions().onSchemeChanged(EditableSchemesCombo.this.getSelectedScheme());
            }
        });
        this.myComboBox.setOpaque(false);
    }

    public void startEdit(@NotNull String initialName, boolean isProjectScheme, @NotNull Consumer<? super String> nameConsumer) {
        if (initialName == null) {
            EditableSchemesCombo.$$$reportNull$$$0(1);
        }
        if (nameConsumer == null) {
            EditableSchemesCombo.$$$reportNull$$$0(2);
        }
        this.showHint();
        this.myNameEditData = new NameEditData(initialName, nameConsumer, isProjectScheme);
        this.myNameEditorField.setText(initialName);
        this.myLayout.last(this.myRootPanel);
        SwingUtilities.invokeLater(() -> {
            IdeFocusManager focusManager = IdeFocusManager.getGlobalInstance();
            focusManager.doWhenFocusSettlesDown(() -> focusManager.requestFocus((Component)this.myNameEditorField, true));
        });
    }

    public void resetSchemes(@NotNull Collection<? extends T> schemes) {
        if (schemes == null) {
            EditableSchemesCombo.$$$reportNull$$$0(3);
        }
        this.myComboBox.resetSchemes(schemes);
    }

    public void resetGroupedSchemes(@NotNull Groups<? extends T> schemeGroups) {
        if (schemeGroups == null) {
            EditableSchemesCombo.$$$reportNull$$$0(4);
        }
        this.myComboBox.resetGroupedSchemes(schemeGroups);
    }

    @Nullable
    public T getSelectedScheme() {
        return this.myComboBox.getSelectedScheme();
    }

    public void selectScheme(@Nullable T scheme) {
        this.myComboBox.selectScheme(scheme);
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    private boolean useBoldForNonRemovableSchemes() {
        return this.mySchemesPanel.useBoldForNonRemovableSchemes();
    }

    @Nullable
    @Nls
    private String validateSchemeName(@NotNull String name2, boolean isProjectScheme) {
        if (name2 == null) {
            EditableSchemesCombo.$$$reportNull$$$0(5);
        }
        if (this.myNameEditData != null && name2.equals(this.myNameEditData.initialName)) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)name2)) {
            return IdeBundle.message((String)"error.empty.name", (Object[])new Object[0]);
        }
        if (this.mySchemesPanel.getModel().containsScheme(name2, isProjectScheme)) {
            return IdeBundle.message((String)"error.name.already.exists", (Object[])new Object[0]);
        }
        return null;
    }

    public void setEnabled(boolean enabled2) {
        this.getComponent().setEnabled(enabled2);
        this.myComboBox.setEnabled(enabled2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemesPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeGroups";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/schemes/EditableSchemesCombo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "startEdit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resetSchemes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resetGroupedSchemes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSchemeName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class NameEditData {
        @NotNull
        private final String initialName;
        @NotNull
        private final Consumer<? super String> nameConsumer;
        private final boolean isProjectScheme;

        private NameEditData(@NotNull String name2, @NotNull Consumer<? super String> nameConsumer, boolean isProjectScheme) {
            if (name2 == null) {
                NameEditData.$$$reportNull$$$0(0);
            }
            if (nameConsumer == null) {
                NameEditData.$$$reportNull$$$0(1);
            }
            this.initialName = name2;
            this.nameConsumer = nameConsumer;
            this.isProjectScheme = isProjectScheme;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nameConsumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/application/options/schemes/EditableSchemesCombo$NameEditData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

