/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorFragmentComponent
extends JPanel {
    private static final Logger LOG = Logger.getInstance(EditorFragmentComponent.class);
    private static final Key<WeakReference<LightweightHint>> CURRENT_HINT = Key.create((String)"EditorFragmentComponent.currentHint");
    private static final int LINE_BORDER_THICKNESS = 1;
    private static final int EMPTY_BORDER_THICKNESS = 2;
    private final EditorEx myEditor;
    private final int myStartLine;
    private final int myEndLine;
    private final boolean myShowFolding;
    private final boolean myShowGutter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditorFragmentComponent(EditorEx editor2, int startLine, int endLine, boolean showFolding, boolean showGutter) {
        editor2.setPurePaintingMode(true);
        try {
            this.doInit(editor2, startLine, endLine, showFolding, showGutter);
        }
        finally {
            editor2.setPurePaintingMode(false);
        }
        this.myEditor = editor2;
        this.myStartLine = startLine;
        this.myEndLine = endLine;
        this.myShowFolding = showFolding;
        this.myShowGutter = showGutter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit(EditorEx editor2, int startLine, int endLine, boolean showFolding, boolean showGutter) {
        BufferedImage markersImage;
        int markersImageWidth;
        EditorGutterComponentEx rowHeader;
        BufferedImage textImage;
        int textImageHeight;
        int textImageWidth;
        FoldingModelEx foldingModel = editor2.getFoldingModel();
        boolean isFoldingEnabled = foldingModel.isFoldingEnabled();
        if (!showFolding) {
            foldingModel.setFoldingEnabled(false);
        }
        try {
            DocumentEx doc = editor2.getDocument();
            int endOffset = endLine < doc.getLineCount() ? doc.getLineEndOffset(Math.max(0, endLine - 1)) : doc.getTextLength();
            int widthAdjustment = EditorUtil.getSpaceWidth(0, editor2);
            textImageWidth = Math.min(editor2.getMaxWidthInRange(doc.getLineStartOffset(startLine), endOffset) + widthAdjustment, EditorFragmentComponent.getWidthLimit(editor2));
            int startVisualLine = editor2.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)startLine, (int)0)).line;
            int endVisualLine = editor2.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)Math.max((int)endLine, (int)(startLine + 1)), (int)0)).line;
            int y1 = editor2.visualLineToY(startVisualLine);
            int y2 = editor2.visualLineToY(endVisualLine) - EditorUtil.getInlaysHeight(editor2, endVisualLine, true);
            textImageHeight = y2 <= y1 ? editor2.getLineHeight() : y2 - y1;
            LOG.assertTrue(textImageHeight > 0, (Object)("Height: " + textImageHeight + "; startLine:" + startLine + "; endLine:" + endLine + "; y1:" + y1 + "; y2:" + y2));
            textImage = UIUtil.createImage((Component)editor2.getContentComponent(), (int)textImageWidth, (int)textImageHeight, (int)1);
            Graphics textGraphics = textImage.getGraphics();
            EditorUIUtil.setupAntialiasing(textGraphics);
            if (showGutter) {
                rowHeader = editor2.getGutterComponentEx();
                markersImageWidth = Math.max(1, rowHeader.getWidth());
                markersImage = UIUtil.createImage((Component)editor2.getComponent(), (int)markersImageWidth, (int)textImageHeight, (int)1);
                Graphics markerGraphics = markersImage.getGraphics();
                EditorUIUtil.setupAntialiasing(markerGraphics);
                markerGraphics.translate(0, -y1);
                markerGraphics.setClip(0, y1, rowHeader.getWidth(), textImageHeight);
                markerGraphics.setColor(EditorFragmentComponent.getBackgroundColor(editor2));
                markerGraphics.fillRect(0, y1, rowHeader.getWidth(), textImageHeight);
                rowHeader.paint(markerGraphics);
            } else {
                markersImageWidth = 0;
                rowHeader = null;
                markersImage = null;
            }
            textGraphics.translate(0, -y1);
            textGraphics.setClip(0, y1, textImageWidth, textImageHeight);
            boolean wasVisible = editor2.setCaretVisible(false);
            editor2.getContentComponent().paint(textGraphics);
            if (wasVisible) {
                editor2.setCaretVisible(true);
            }
        }
        finally {
            if (!showFolding) {
                foldingModel.setFoldingEnabled(isFoldingEnabled);
            }
        }
        JComponent component2 = new JComponent(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(textImageWidth + markersImageWidth, textImageHeight);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                if (markersImage != null) {
                    StartupUiUtil.drawImage((Graphics)graphics, (Image)markersImage, (int)0, (int)0, null);
                    StartupUiUtil.drawImage((Graphics)graphics, (Image)textImage, (int)rowHeader.getWidth(), (int)0, null);
                } else {
                    StartupUiUtil.drawImage((Graphics)graphics, (Image)textImage, (int)0, (int)0, null);
                }
            }
        };
        this.setLayout(new BorderLayout());
        this.add(component2);
        this.setBorder(EditorFragmentComponent.createEditorFragmentBorder(editor2));
    }

    @ApiStatus.Internal
    public EditorEx getEditor() {
        return this.myEditor;
    }

    @ApiStatus.Internal
    public int getStartLine() {
        return this.myStartLine;
    }

    @ApiStatus.Internal
    public int getEndLine() {
        return this.myEndLine;
    }

    @ApiStatus.Internal
    public boolean showFolding() {
        return this.myShowFolding;
    }

    @ApiStatus.Internal
    public boolean showGutter() {
        return this.myShowGutter;
    }

    private static int getWidthLimit(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorFragmentComponent.$$$reportNull$$$0(0);
        }
        JComponent component2 = editor2.getComponent();
        int screenWidth = ScreenUtil.getScreenRectangle((Component)component2).width;
        if (screenWidth > 0) {
            return screenWidth;
        }
        Window window = SwingUtilities.getWindowAncestor(component2);
        return window == null ? Integer.MAX_VALUE : window.getWidth();
    }

    @Nullable
    static LightweightHint showEditorFragmentHintAt(Editor editor2, TextRange range, int y, boolean showUpward, boolean showFolding, boolean hideByAnyKey, boolean useCaretRowBackground) {
        int endLine;
        char c;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        Document document2 = editor2.getDocument();
        int startOffset = range.getStartOffset();
        int startLine = document2.getLineNumber(startOffset);
        CharSequence text2 = document2.getCharsSequence();
        boolean incrementLine = false;
        int max = Math.min(range.getEndOffset(), text2.length());
        for (int offset = startOffset; offset < max && (incrementLine = StringUtil.isWhiteSpace((char)(c = text2.charAt(offset)))) && c != '\n'; ++offset) {
        }
        if (incrementLine) {
            ++startLine;
        }
        if (startLine >= (endLine = document2.getLineNumber(range.getEndOffset()) + 1)) {
            return null;
        }
        EditorFragmentComponent fragmentComponent = EditorFragmentComponent.createEditorFragmentComponent(editor2, startLine, endLine, showFolding, true, useCaretRowBackground);
        if (showUpward) {
            y -= fragmentComponent.getPreferredSize().height;
            y = Math.max(0, y);
        }
        JComponent c2 = editor2.getComponent();
        int x = SwingUtilities.convertPoint((Component)c2, (Point)new Point((int)JBUIScale.scale((int)-3), (int)0), (Component)UIUtil.getRootPane((Component)c2)).x;
        LightweightHint currentHint = (LightweightHint)SoftReference.dereference((Reference)((Reference)editor2.getUserData(CURRENT_HINT)));
        if (currentHint != null) {
            currentHint.hide();
        }
        Point p = new Point(x, y);
        MyComponentHint hint = new MyComponentHint(fragmentComponent);
        HintManagerImpl.getInstanceImpl().showEditorHint((LightweightHint)hint, editor2, p, (hideByAnyKey ? 2 : 0) | 0x20 | 8 | 0x100, 0, false, new HintHint(editor2, p));
        editor2.putUserData(CURRENT_HINT, new WeakReference<MyComponentHint>(hint));
        return hint;
    }

    public static EditorFragmentComponent createEditorFragmentComponent(Editor editor2, int startLine, int endLine, boolean showFolding, boolean showGutter) {
        return EditorFragmentComponent.createEditorFragmentComponent(editor2, startLine, endLine, showFolding, showGutter, true);
    }

    private static EditorFragmentComponent createEditorFragmentComponent(Editor editor2, int startLine, int endLine, boolean showFolding, boolean showGutter, boolean useCaretRowBackground) {
        EditorEx editorEx = (EditorEx)editor2;
        Color old = editorEx.getBackgroundColor();
        Color backColor = EditorFragmentComponent.getBackgroundColor(editor2, useCaretRowBackground);
        editorEx.setBackgroundColor(backColor);
        EditorFragmentComponent fragmentComponent = new EditorFragmentComponent(editorEx, startLine, endLine, showFolding, showGutter);
        fragmentComponent.setBackground(backColor);
        editorEx.setBackgroundColor(old);
        return fragmentComponent;
    }

    @Nullable
    public static LightweightHint showEditorFragmentHint(Editor editor2, TextRange range, boolean showFolding, boolean hideByAnyKey) {
        if (!(editor2 instanceof EditorEx)) {
            return null;
        }
        JRootPane rootPane = editor2.getComponent().getRootPane();
        if (rootPane == null) {
            return null;
        }
        JLayeredPane layeredPane2 = rootPane.getLayeredPane();
        int lineHeight = editor2.getLineHeight();
        int overhang = editor2.getScrollingModel().getVisibleArea().y - editor2.logicalPositionToXY((LogicalPosition)editor2.offsetToLogicalPosition((int)range.getEndOffset())).y;
        int yRelative = overhang > 0 && overhang < lineHeight ? lineHeight - overhang + JBUIScale.scale((int)3) : 0;
        Point point = SwingUtilities.convertPoint(((EditorEx)editor2).getScrollPane().getViewport(), -2, yRelative, layeredPane2);
        return EditorFragmentComponent.showEditorFragmentHintAt(editor2, range, point.y, true, showFolding, hideByAnyKey, false);
    }

    @NotNull
    public static Color getBackgroundColor(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorFragmentComponent.$$$reportNull$$$0(1);
        }
        return EditorFragmentComponent.getBackgroundColor(editor2, true);
    }

    @NotNull
    public static Color getBackgroundColor(@NotNull Editor editor2, boolean useCaretRowBackground) {
        if (editor2 == null) {
            EditorFragmentComponent.$$$reportNull$$$0(2);
        }
        EditorColorsScheme colorsScheme = editor2.getColorsScheme();
        Color color = colorsScheme.getColor(EditorColors.CARET_ROW_COLOR);
        if (!useCaretRowBackground || color == null) {
            color = editor2 instanceof EditorEx ? ((EditorEx)editor2).getBackgroundColor() : colorsScheme.getDefaultBackground();
        }
        Color color2 = color;
        if (color2 == null) {
            EditorFragmentComponent.$$$reportNull$$$0(3);
        }
        return color2;
    }

    @NotNull
    public static CompoundBorder createEditorFragmentBorder(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorFragmentComponent.$$$reportNull$$$0(4);
        }
        Color borderColor = editor2.getColorsScheme().getColor(EditorColors.SELECTED_TEARLINE_COLOR);
        Border outsideBorder = JBUI.Borders.customLine((Color)borderColor, (int)1);
        Border insideBorder = JBUI.Borders.empty((int)2);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outsideBorder, insideBorder);
        if (compoundBorder == null) {
            EditorFragmentComponent.$$$reportNull$$$0(5);
        }
        return compoundBorder;
    }

    public static int getAvailableVisualLinesAboveEditor(@NotNull Editor editor2) {
        Container contentPane;
        JRootPane rootPane;
        if (editor2 == null) {
            EditorFragmentComponent.$$$reportNull$$$0(6);
        }
        int availableVisualLines = 2;
        JComponent editorComponent = editor2.getComponent();
        Container editorComponentParent = editorComponent.getParent();
        if (editorComponentParent != null && (rootPane = editorComponent.getRootPane()) != null && (contentPane = rootPane.getContentPane()) != null) {
            int y = SwingUtilities.convertPoint((Component)editorComponentParent, (Point)editorComponent.getLocation(), (Component)contentPane).y;
            int visualLines = y / editor2.getLineHeight();
            availableVisualLines = Math.max(availableVisualLines, visualLines);
        }
        return availableVisualLines;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/EditorFragmentComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/EditorFragmentComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorFragmentBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWidthLimit";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBackgroundColor";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditorFragmentBorder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableVisualLinesAboveEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    private static final class MyComponentHint
    extends LightweightHint {
        MyComponentHint(JComponent component2) {
            super(component2);
            this.setForceLightweightPopup(true);
        }

        @Override
        public void hide() {
            SwingUtilities.invokeLater(() -> super.hide());
        }
    }
}

