/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HintUtil {
    @Deprecated(forRemoval=true)
    public static final Color INFORMATION_COLOR = new JBColor(0xF7F7F7, 0x4B4D4D);
    @Deprecated(forRemoval=true)
    public static final Color INFORMATION_BORDER_COLOR = JBColor.namedColor((String)"InformationHint.borderColor", (Color)new JBColor(0xE0E0E0, 6053473));
    public static final ColorKey INFORMATION_COLOR_KEY = ColorKey.createColorKey((String)"INFORMATION_HINT", (Color)INFORMATION_COLOR);
    public static final ColorKey QUESTION_COLOR_KEY = ColorKey.createColorKey((String)"QUESTION_HINT", (Color)new JBColor(11915515, 3632265));
    public static final ColorKey WARNING_COLOR_KEY = ColorKey.createColorKey((String)"WARNING_HINT", (Color)new JBColor(16775388, 6705172));
    public static final ColorKey ERROR_COLOR_KEY = ColorKey.createColorKey((String)"ERROR_HINT", (Color)new JBColor(0xFFDCDC, 7870258));
    public static final ColorKey HINT_BORDER_COLOR_KEY = ColorKey.createColorKey((String)"HINT_BORDER", (Color)new JBColor(13225174, 5922147));
    public static final Color QUESTION_UNDERSCORE_COLOR = JBColor.foreground();
    public static final ColorKey RECENT_LOCATIONS_SELECTION_KEY = ColorKey.createColorKey((String)"RECENT_LOCATIONS_SELECTION", (Color)new JBColor(15331061, 0x383838));
    public static final ColorKey PROMOTION_PANE_KEY = ColorKey.createColorKey((String)"PROMOTION_PANE", (Color)new JBColor(15134199, 2308435));

    private HintUtil() {
    }

    @NotNull
    public static Color getInformationColor() {
        if (ExperimentalUI.isNewUI()) {
            Color color = HintHint.Status.Info.background;
            if (color == null) {
                HintUtil.$$$reportNull$$$0(0);
            }
            return color;
        }
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)INFORMATION_COLOR_KEY), (Object)INFORMATION_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(1);
        }
        return color;
    }

    @NotNull
    public static Color getQuestionColor() {
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)QUESTION_COLOR_KEY), (Object)QUESTION_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(2);
        }
        return color;
    }

    @NotNull
    public static Color getWarningColor() {
        if (ExperimentalUI.isNewUI()) {
            Color color = HintHint.Status.Warning.background;
            if (color == null) {
                HintUtil.$$$reportNull$$$0(3);
            }
            return color;
        }
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)WARNING_COLOR_KEY), (Object)WARNING_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(4);
        }
        return color;
    }

    @NotNull
    public static Color getErrorColor() {
        if (ExperimentalUI.isNewUI()) {
            Color color = HintHint.Status.Error.background;
            if (color == null) {
                HintUtil.$$$reportNull$$$0(5);
            }
            return color;
        }
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)ERROR_COLOR_KEY), (Object)ERROR_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(6);
        }
        return color;
    }

    @NotNull
    public static Color getHintBorderColor() {
        Color color = (Color)ObjectUtils.notNull((Object)EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)HINT_BORDER_COLOR_KEY), (Object)HINT_BORDER_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(7);
        }
        return color;
    }

    @NotNull
    public static Color getRecentLocationsSelectionColor(EditorColorsScheme colorsScheme) {
        Color color = (Color)ObjectUtils.notNull((Object)colorsScheme.getColor(RECENT_LOCATIONS_SELECTION_KEY), (Object)RECENT_LOCATIONS_SELECTION_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(8);
        }
        return color;
    }

    public static JComponent createInformationLabel(@NlsContexts.HintText @NotNull String text2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(9);
        }
        return HintUtil.createInformationLabel(text2, null, null, null);
    }

    public static JComponent createInformationLabel(@NlsContexts.HintText @NotNull String text2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener2, @Nullable Ref<? super Consumer<@Nls String>> updatedTextConsumer) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(10);
        }
        HintHint hintHint = HintUtil.getInformationHint();
        HintLabel label2 = HintUtil.createLabel(text2, null, hintHint.getTextBackground(), hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, mouseListener2, updatedTextConsumer);
        return label2;
    }

    @NotNull
    public static HintHint getInformationHint() {
        HintHint hintHint = new HintHint().setBorderColor(HintUtil.getHintBorderColor()).setTextBg(HintUtil.getInformationColor()).setTextFg(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : Color.black).setFont(HintUtil.getBoldFont()).setAwtTooltip(true).setStatus(HintHint.Status.Info);
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(11);
        }
        return hintHint;
    }

    public static JComponent createWarningLabel(@NlsContexts.HintText @NotNull String text2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(12);
        }
        Color bg = HintUtil.getWarningColor();
        HintHint hintHint = HintUtil.getWarningHint();
        HintLabel label2 = HintUtil.createLabel(text2, null, bg, hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, mouseListener2, null);
        return label2;
    }

    @NotNull
    public static HintHint getWarningHint() {
        HintHint hintHint;
        HintHint hintHint2 = hintHint = new HintHint().setBorderColor(HintUtil.getHintBorderColor()).setTextBg(HintUtil.getWarningColor()).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true).setStatus(HintHint.Status.Warning);
        if (hintHint2 == null) {
            HintUtil.$$$reportNull$$$0(13);
        }
        return hintHint2;
    }

    @NotNull
    public static JComponent createWarningLabel(@NlsContexts.HintText @NotNull String text2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(14);
        }
        JComponent jComponent = HintUtil.createWarningLabel(text2, null, null);
        if (jComponent == null) {
            HintUtil.$$$reportNull$$$0(15);
        }
        return jComponent;
    }

    @NotNull
    public static HintHint getSuccessHint() {
        HintHint hintHint = new HintHint().setAwtTooltip(true).applyStatus(HintHint.Status.Success);
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(16);
        }
        return hintHint;
    }

    public static JComponent createSuccessLabel(@NlsContexts.HintText @NotNull String text2, @Nullable HyperlinkListener hyperlinkListener) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(17);
        }
        HintHint hintHint = HintUtil.getSuccessHint();
        HintLabel label2 = HintUtil.createLabel(text2, null, hintHint.getTextBackground(), hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, null, null);
        return label2;
    }

    @NotNull
    public static JComponent createSuccessLabel(@NlsContexts.HintText @NotNull String text2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(18);
        }
        JComponent jComponent = HintUtil.createSuccessLabel(text2, null);
        if (jComponent == null) {
            HintUtil.$$$reportNull$$$0(19);
        }
        return jComponent;
    }

    public static CompoundBorder createHintBorder() {
        return BorderFactory.createCompoundBorder(JBUI.Borders.customLine((Color)HintUtil.getHintBorderColor(), (int)1), JBUI.Borders.empty((int)2));
    }

    @NotNull
    public static JComponent createInformationLabel(SimpleColoredText text2) {
        return HintUtil.createInformationLabel(text2, null);
    }

    public static JComponent createQuestionLabel(@NlsContexts.HintText String text2) {
        Icon icon2 = AllIcons.General.ContextHelp;
        return HintUtil.createQuestionLabel(text2, icon2);
    }

    public static JComponent createQuestionLabel(@NlsContexts.HintText String text2, Icon icon2) {
        Color bg = HintUtil.getQuestionColor();
        HintHint hintHint = new HintHint().setTextBg(bg).setBorderColor(HintUtil.getHintBorderColor()).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true).setStatus(HintHint.Status.Info);
        return HintUtil.createLabel(text2, ExperimentalUI.isNewUI() ? null : icon2, bg, hintHint);
    }

    @Nullable
    public static String getHintLabel(JComponent hintComponent) {
        return hintComponent instanceof HintLabel ? ((HintLabel)hintComponent).getText() : null;
    }

    @Nullable
    public static Icon getHintIcon(JComponent hintComponent) {
        return hintComponent instanceof HintLabel ? ((HintLabel)hintComponent).getIcon() : null;
    }

    @NotNull
    public static SimpleColoredComponent createInformationComponent() {
        return HintUtil.fillInformationComponent(new SimpleColoredComponent());
    }

    @ApiStatus.Internal
    @NotNull
    public static SimpleColoredComponent fillInformationComponent(SimpleColoredComponent component2) {
        component2.setTransparentIconBackground(true);
        return HintUtil.installInformationProperties(component2);
    }

    @NotNull
    public static <T extends Component> T installInformationProperties(T component2) {
        component2.setBackground(HintUtil.getInformationColor());
        component2.setForeground(JBColor.foreground());
        component2.setFont(HintUtil.getBoldFont());
        T t = component2;
        if (t == null) {
            HintUtil.$$$reportNull$$$0(20);
        }
        return t;
    }

    @NotNull
    public static JComponent createInformationLabel(@NotNull SimpleColoredText text2, @Nullable Icon icon2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(21);
        }
        SimpleColoredComponent component2 = HintUtil.createInformationComponent();
        component2.setIcon(icon2);
        text2.appendToComponent((ColoredTextContainer)component2);
        return new HintLabel(component2);
    }

    public static JComponent createErrorLabel(@NlsContexts.HintText @NotNull String text2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(22);
        }
        Color bg = HintUtil.getErrorColor();
        HintHint hintHint = new HintHint().setBorderColor(HintUtil.getHintBorderColor()).setTextBg(bg).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true).setStatus(HintHint.Status.Error);
        HintLabel label2 = HintUtil.createLabel(text2, null, bg, hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, mouseListener2, null);
        return label2;
    }

    @NotNull
    public static JComponent createErrorLabel(@NlsContexts.HintText @NotNull String text2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(23);
        }
        JComponent jComponent = HintUtil.createErrorLabel(text2, null, null);
        if (jComponent == null) {
            HintUtil.$$$reportNull$$$0(24);
        }
        return jComponent;
    }

    @ApiStatus.Internal
    @NotNull
    public static HintLabel createLabel(@NlsContexts.HintText String text2, @Nullable Icon icon2, @NotNull Color color, @NotNull HintHint hintHint) {
        if (color == null) {
            HintUtil.$$$reportNull$$$0(25);
        }
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(26);
        }
        HintLabel label2 = new HintLabel();
        label2.setText(text2, hintHint);
        label2.setIcon(icon2 == null ? hintHint.getStatusIcon() : icon2);
        if (!hintHint.isAwtTooltip()) {
            label2.setBorder(HintUtil.createHintBorder());
            label2.setForeground(JBColor.foreground());
            label2.setFont(HintUtil.getBoldFont());
            label2.setBackground(color);
            label2.setOpaque(true);
        }
        HintLabel hintLabel = label2;
        if (hintLabel == null) {
            HintUtil.$$$reportNull$$$0(27);
        }
        return hintLabel;
    }

    private static Font getBoldFont() {
        return StartupUiUtil.getLabelFont().deriveFont(1);
    }

    @NotNull
    public static JLabel createAdComponent(@NlsContexts.PopupAdvertisement String bottomText, Border border, @JdkConstants.HorizontalAlignment int alignment) {
        JLabel label2 = new JLabel();
        label2.setText(bottomText);
        label2.setHorizontalAlignment(alignment);
        label2.setForeground(JBUI.CurrentTheme.Advertiser.foreground());
        label2.setBackground(JBUI.CurrentTheme.Advertiser.background());
        label2.setOpaque(true);
        label2.setFont(RelativeFont.NORMAL.scale(JBUI.CurrentTheme.Advertiser.FONT_SIZE_OFFSET.get(), JBUIScale.scale((float)11.0f)).derive(StartupUiUtil.getLabelFont()));
        if (bottomText != null) {
            label2.setBorder(border);
        }
        JLabel jLabel = label2;
        if (jLabel == null) {
            HintUtil.$$$reportNull$$$0(28);
        }
        return jLabel;
    }

    @NotNull
    @Nls
    public static String prepareHintText(@NlsContexts.HintText @NotNull String text2, @NotNull HintHint hintHint) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(29);
        }
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(30);
        }
        return HintUtil.prepareHintText(new Html(text2), hintHint);
    }

    @NotNull
    @Nls
    public static String prepareHintText(@NotNull Html text2, @NotNull HintHint hintHint) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(31);
        }
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(32);
        }
        String htmlBody = UIUtil.getHtmlBody((Html)text2);
        String style = UIUtil.getCssFontDeclaration((Font)hintHint.getTextFont(), (Color)hintHint.getTextForeground(), (Color)hintHint.getLinkForeground(), (String)hintHint.getUlImg());
        String string = HtmlChunk.html().children(new HtmlChunk[]{HtmlChunk.head().addRaw(style), HtmlChunk.body().addRaw(htmlBody)}).toString();
        if (string == null) {
            HintUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void configureLabel(@NotNull HintLabel label2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener2, @Nullable Ref<? super Consumer<@Nls String>> updatedTextConsumer) {
        if (label2 == null) {
            HintUtil.$$$reportNull$$$0(34);
        }
        if (hyperlinkListener != null) {
            label2.myPane.addHyperlinkListener(hyperlinkListener);
        }
        if (mouseListener2 != null) {
            label2.myPane.addMouseListener(mouseListener2);
        }
        if (updatedTextConsumer != null) {
            @Nls Consumer consumer = s -> {
                label2.myPane.setText((String)s);
                label2.setPreferredSize(null);
                label2.myPane.setPreferredSize(null);
            };
            updatedTextConsumer.set((Object)consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 9, 10, 12, 14, 17, 18, 21, 22, 23, 25, 26, 29, 30, 31, 32, 34 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/HintUtil";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 26: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintHint";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionColor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningColor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorColor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHintBorderColor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentLocationsSelectionColor";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/HintUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationHint";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningHint";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createWarningLabel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessHint";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuccessLabel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "installInformationProperties";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorLabel";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdComponent";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHintText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: 
            case 10: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createInformationLabel";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createWarningLabel";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSuccessLabel";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createErrorLabel";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "prepareHintText";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "configureLabel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 9, 10, 12, 14, 17, 18, 21, 22, 23, 25, 26, 29, 30, 31, 32, 34 -> new IllegalArgumentException(string);
        };
    }

    @ApiStatus.Internal
    public static final class HintLabel
    extends JPanel {
        private JEditorPane myPane;
        private SimpleColoredComponent myColored;
        private JLabel myIcon;
        @Nullable
        private HintHint hintHint;

        private HintLabel() {
            this.setLayout(new BorderLayout(ExperimentalUI.isNewUI() ? 6 : 0, 0));
        }

        private HintLabel(@NotNull SimpleColoredComponent component2) {
            if (component2 == null) {
                HintLabel.$$$reportNull$$$0(0);
            }
            this();
            this.setText(component2);
        }

        @ApiStatus.Internal
        @Nullable
        public JEditorPane getPane() {
            return this.myPane;
        }

        @Override
        public boolean requestFocusInWindow() {
            if (this.myPane != null) {
                return this.myPane.requestFocusInWindow();
            }
            if (this.myColored != null) {
                return this.myColored.requestFocusInWindow();
            }
            if (this.myIcon != null) {
                return this.myIcon.requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }

        public void setText(@NotNull SimpleColoredComponent colored) {
            if (colored == null) {
                HintLabel.$$$reportNull$$$0(1);
            }
            this.clearText();
            this.hintHint = null;
            this.myColored = colored;
            this.add((Component)this.myColored, "Center");
            this.setOpaque(true);
            this.setBackground(colored.getBackground());
            this.revalidate();
            this.repaint();
        }

        public void setText(@NlsContexts.Tooltip String s, HintHint hintHint) {
            this.clearText();
            this.hintHint = hintHint;
            if (s != null) {
                this.myPane = IdeTooltipManager.initPane(s, hintHint, null);
                this.add((Component)this.myPane, "Center");
            }
            this.setOpaque(true);
            this.setBackground(hintHint.getTextBackground());
            this.revalidate();
            this.repaint();
        }

        @Nullable
        public HintHint getHintHint() {
            return this.hintHint;
        }

        private void clearText() {
            if (this.myPane != null) {
                this.remove(this.myPane);
                this.myPane = null;
            }
            if (this.myColored != null) {
                this.remove((Component)this.myColored);
                this.myColored = null;
            }
        }

        public void setIcon(Icon icon2) {
            if (this.myIcon != null) {
                this.remove(this.myIcon);
            }
            if (icon2 != null) {
                this.myIcon = new JLabel(icon2, 0);
                this.myIcon.setVerticalAlignment(1);
                this.add((Component)this.myIcon, "West");
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public String toString() {
            return "Hint: text='" + this.getText() + "'";
        }

        public String getText() {
            return this.myPane != null ? this.myPane.getText() : "";
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon != null ? this.myIcon.getIcon() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colored";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/hint/HintUtil$HintLabel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

