/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.google.gson.stream.JsonReader;
import com.intellij.diagnostic.hprof.action.AnalysisRunnable;
import com.intellij.diagnostic.report.HeapReportProperties;
import com.intellij.diagnostic.report.MemoryReportReason;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/diagnostic/AnalyzePendingSnapshotActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
public final class AnalyzePendingSnapshotActivity
implements ProjectActivity {
    public AnalyzePendingSnapshotActivity() {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Object execute(@NotNull Project project2, @NotNull Continuation<? super Unit> $completion) {
        block27: {
            String[] stringArray = new String[]{"pending-snapshot.json"};
            Path jsonPath = Path.of(PathManager.getSystemPath(), stringArray);
            Intrinsics.checkNotNull((Object)jsonPath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(jsonPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                return Unit.INSTANCE;
            }
            String path = null;
            String liveStats = null;
            MemoryReportReason reason = null;
            try {
                Object object = jsonPath;
                OpenOption[] openOptionArray = new OpenOption[]{};
                Object object2 = Charsets.UTF_8;
                int n = 8192;
                JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n));
                object = (Closeable)reader;
                object2 = null;
                try {
                    JsonReader it = (JsonReader)object;
                    boolean bl = false;
                    it.beginObject();
                    while (it.hasNext()) {
                        String string = it.nextName();
                        if (string == null) continue;
                        int n2 = -1;
                        switch (string.hashCode()) {
                            case 3433509: {
                                if (string.equals("path")) {
                                    n2 = 1;
                                }
                                break;
                            }
                            case -934964668: {
                                if (string.equals("reason")) {
                                    n2 = 2;
                                }
                                break;
                            }
                            case 997906195: {
                                if (string.equals("liveStats")) {
                                    n2 = 3;
                                }
                                break;
                            }
                        }
                        switch (n2) {
                            case 1: {
                                path = it.nextString();
                                break;
                            }
                            case 2: {
                                String string2 = it.nextString();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                                reason = MemoryReportReason.valueOf(string2);
                                break;
                            }
                            case 3: {
                                liveStats = it.nextString();
                            }
                        }
                    }
                    it.endObject();
                    it = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    object2 = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                Files.deleteIfExists(jsonPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = path;
            if (string == null) break block27;
            String it = string;
            boolean bl = false;
            Path hprofPath = Path.of(it, new String[0]);
            Intrinsics.checkNotNull((Object)hprofPath);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(hprofPath, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                String string3;
                MemoryReportReason memoryReportReason = reason;
                if (memoryReportReason == null) {
                    memoryReportReason = MemoryReportReason.None;
                }
                if ((string3 = liveStats) == null) {
                    string3 = "";
                }
                HeapReportProperties heapProperties = new HeapReportProperties(memoryReportReason, string3);
                new AnalysisRunnable(hprofPath, heapProperties, true).run();
            }
        }
        return Unit.INSTANCE;
    }
}

