/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.EditMemorySettingsPanel;
import com.intellij.diagnostic.EditMemorySettingsService;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.IoErrorText;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@ApiStatus.NonExtendable
public class EditMemorySettingsDialog
extends DialogWrapper {
    private static final int MIN_VALUE = 256;
    private static final int HEAP_INCREMENT = 512;
    private final VMOptions.MemoryKind myOption;
    private final int myLowerBound;
    private final EditMemorySettingsPanel content;
    private Action mySaveAndExitAction;
    private Action mySaveAction;

    EditMemorySettingsDialog() {
        this(VMOptions.MemoryKind.HEAP, false);
    }

    EditMemorySettingsDialog(@NotNull VMOptions.MemoryKind option2) {
        if (option2 == null) {
            EditMemorySettingsDialog.$$$reportNull$$$0(0);
        }
        this(option2, true);
    }

    private EditMemorySettingsDialog(VMOptions.MemoryKind option2, boolean memoryLow) {
        super(true);
        this.myOption = option2;
        this.myLowerBound = Math.max(option2 == VMOptions.MemoryKind.HEAP ? VMOptions.readOption(VMOptions.MemoryKind.MIN_HEAP, false) : 0, 256);
        this.setTitle(DiagnosticBundle.message("change.memory.title", new Object[0]));
        this.content = new EditMemorySettingsPanel(option2, memoryLow, EditMemorySettingsDialog.getSuggestedValue(memoryLow, this.myOption));
        this.init();
        this.initValidation();
    }

    private static int getSuggestedValue(boolean memoryLow, VMOptions.MemoryKind option2) {
        int current = VMOptions.readOption(option2, true);
        int suggested = 0;
        if (memoryLow && option2 == VMOptions.MemoryKind.HEAP) {
            int cap = Registry.intValue((String)"max.suggested.heap.size");
            if (current > 0) {
                suggested = current + 512;
                if (suggested > cap) {
                    suggested = Math.max(cap, current);
                }
            } else {
                suggested = cap;
            }
        } else {
            suggested = VMOptions.readOption(option2, false);
            if (suggested <= 0) {
                suggested = current;
            }
            if (suggested <= 0) {
                suggested = 256;
            }
        }
        return suggested;
    }

    protected JComponent createCenterPanel() {
        return this.content.panel;
    }

    protected Action @NotNull [] createActions() {
        boolean canRestart = ApplicationManager.getApplication().isRestartCapable();
        this.mySaveAndExitAction = new DialogWrapper.DialogWrapperAction(DiagnosticBundle.message(canRestart ? "change.memory.apply" : "change.memory.exit", new Object[0])){

            protected void doAction(ActionEvent e) {
                if (EditMemorySettingsDialog.this.save()) {
                    ((ApplicationEx)ApplicationManager.getApplication()).restart(true);
                }
            }
        };
        this.mySaveAction = new DialogWrapper.DialogWrapperAction(IdeBundle.message((String)"button.save", (Object[])new Object[0])){

            protected void doAction(ActionEvent e) {
                if (EditMemorySettingsDialog.this.save()) {
                    EditMemorySettingsDialog.this.close(0);
                }
            }
        };
        Action[] actionArray = new Action[]{this.mySaveAndExitAction, this.mySaveAction, this.getCancelAction()};
        if (actionArray == null) {
            EditMemorySettingsDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo info = null;
        try {
            int value = Integer.parseInt(this.content.newValueField.getText());
            if (value <= this.myLowerBound) {
                info = new ValidationInfo(DiagnosticBundle.message("change.memory.low", this.myLowerBound), (JComponent)this.content.newValueField);
            }
        }
        catch (NumberFormatException e) {
            info = new ValidationInfo(UIBundle.message((String)"please.enter.a.number", (Object[])new Object[0]), (JComponent)this.content.newValueField);
        }
        this.mySaveAndExitAction.setEnabled(info == null);
        this.mySaveAction.setEnabled(info == null);
        return info;
    }

    private boolean save() {
        try {
            int value = Integer.parseInt(this.content.newValueField.getText());
            EditMemorySettingsService.getInstance().save(this.myOption, value);
            return true;
        }
        catch (IOException e) {
            Messages.showErrorDialog((Component)this.content.newValueField, (String)IoErrorText.message((Throwable)e), (String)OptionsBundle.message((String)"cannot.save.settings.default.dialog.title", (Object[])new Object[0]));
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/EditMemorySettingsDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/EditMemorySettingsDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

