/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class MessagePool {
    private static final int MAX_POOL_SIZE = 100;
    private final List<AbstractMessage> myErrors = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<MessagePoolListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public static MessagePool getInstance() {
        return MessagePoolHolder.ourInstance;
    }

    private MessagePool() {
    }

    @Deprecated(forRemoval=true)
    public void addIdeFatalMessage(@NotNull IdeaLoggingEvent event) {
        AbstractMessage abstractMessage;
        Object object;
        if (event == null) {
            MessagePool.$$$reportNull$$$0(0);
        }
        if ((object = event.getData()) instanceof AbstractMessage) {
            AbstractMessage am = (AbstractMessage)object;
            abstractMessage = am;
        } else {
            abstractMessage = new LogMessage(event.getThrowable(), event.getMessage(), List.of());
        }
        this.addIdeFatalMessage(abstractMessage);
    }

    public void addIdeFatalMessage(@NotNull AbstractMessage message) {
        if (message == null) {
            MessagePool.$$$reportNull$$$0(1);
        }
        if (this.myErrors.size() < 100) {
            this.doAddMessage(message);
        } else if (this.myErrors.size() == 100) {
            this.doAddMessage(new LogMessage(new TooManyErrorsException(), null, List.of()));
        }
    }

    @NotNull
    public State getState() {
        if (this.myErrors.isEmpty()) {
            State state2 = State.NoErrors;
            if (state2 == null) {
                MessagePool.$$$reportNull$$$0(2);
            }
            return state2;
        }
        for (AbstractMessage message : this.myErrors) {
            if (message.isRead()) continue;
            State state3 = State.UnreadErrors;
            if (state3 == null) {
                MessagePool.$$$reportNull$$$0(3);
            }
            return state3;
        }
        State state4 = State.ReadErrors;
        if (state4 == null) {
            MessagePool.$$$reportNull$$$0(4);
        }
        return state4;
    }

    @NotNull
    public List<AbstractMessage> getFatalErrors(boolean includeReadMessages, boolean includeSubmittedMessages) {
        ArrayList<AbstractMessage> result2 = new ArrayList<AbstractMessage>();
        for (AbstractMessage message : this.myErrors) {
            if (!includeReadMessages && message.isRead() || !includeSubmittedMessages && (message.isSubmitted() || message.getThrowable() instanceof TooManyErrorsException)) continue;
            result2.add(message);
        }
        ArrayList<AbstractMessage> arrayList = result2;
        if (arrayList == null) {
            MessagePool.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public void clearErrors() {
        for (AbstractMessage message : this.myErrors) {
            message.setRead(true);
        }
        this.myErrors.clear();
        this.notifyPoolCleared();
    }

    public void addListener(MessagePoolListener listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(MessagePoolListener listener2) {
        this.myListeners.remove(listener2);
    }

    private void notifyEntryAdded() {
        this.myListeners.forEach(MessagePoolListener::newEntryAdded);
    }

    private void notifyPoolCleared() {
        this.myListeners.forEach(MessagePoolListener::poolCleared);
    }

    private void notifyEntryRead() {
        this.myListeners.forEach(MessagePoolListener::entryWasRead);
    }

    private void doAddMessage(@NotNull AbstractMessage message) {
        if (message == null) {
            MessagePool.$$$reportNull$$$0(6);
        }
        for (MessagePoolListener listener2 : this.myListeners) {
            if (listener2.beforeEntryAdded(message)) continue;
            return;
        }
        if (ApplicationManager.getApplication().isInternal()) {
            message.getAllAttachments().forEach(attachment -> attachment.setIncluded(true));
        }
        if (MessagePool.shallAddSilently(message)) {
            message.setRead(true);
        }
        message.setOnReadCallback(() -> this.notifyEntryRead());
        this.myErrors.add(message);
        this.notifyEntryAdded();
    }

    private static boolean shallAddSilently(AbstractMessage message) {
        return SlowOperations.isMyMessage((String)message.getThrowable().getMessage());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/MessagePool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/MessagePool";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFatalErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addIdeFatalMessage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doAddMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class MessagePoolHolder {
        private static final MessagePool ourInstance = new MessagePool();

        private MessagePoolHolder() {
        }
    }

    public static final class TooManyErrorsException
    extends Exception {
        private TooManyErrorsException() {
            super(DiagnosticBundle.message("error.monitor.too.many.errors", new Object[0]));
        }
    }

    public static enum State {
        NoErrors,
        ReadErrors,
        UnreadErrors;

    }
}

