/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.CrashInfo;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.IdeaFreezeReporter;
import com.intellij.diagnostic.JBRCrash;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.LowMemoryNotifier;
import com.intellij.diagnostic.PerformanceListener;
import com.intellij.diagnostic.PerformanceWatcherImpl;
import com.intellij.diagnostic.PerformanceWatcherImplKt;
import com.intellij.diagnostic.SamplingTask;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.UList;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.Sanitize_nameKt;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ThreadInfo;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u000e\u0010\u0018\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001a\u001a\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0005H\u0002\u001a\u001a\u0010%\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0005H\u0002\u001a\u0018\u0010*\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010+\u001a\u00020 H\u0002\u001a\u0010\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0011H\u0002\u001a\b\u0010/\u001a\u00020\u0007H\u0002\u001a\u0010\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u000bH\u0002\u001a\u0010\u00104\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u001a/\u00105\u001a\b\u0012\u0004\u0012\u0002060\u001c2\f\u00107\u001a\b\u0012\u0004\u0012\u0002060\u001c2\f\u00108\u001a\b\u0012\u0004\u0012\u00020609H\u0000\u00a2\u0006\u0002\u0010:\u001a\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u0002062\u0006\u0010>\u001a\u000206H\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u000e\u0010\u001f\u001a\u00020 X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010&\u001a\u0004\u0018\u00010'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u000e\u0010.\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u00100\u001a\n \f*\u0004\u0018\u00010101X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "TOLERABLE_LATENCY", "", "THREAD_DUMPS_PREFIX", "", "DURATION_FILE_NAME", "PID_FILE_NAME", "ideStartTime", "Ljava/time/ZonedDateTime;", "kotlin.jvm.PlatformType", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/diagnostic/PerformanceListener;", "postProcessReportFolder", "Ljava/nio/file/Path;", "durationMs", "task", "Lcom/intellij/diagnostic/SamplingTask;", "dir", "logDir", "getFreezePlaceSuffix", "reportCrashesIfAny", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "MacOSDiagnosticReportDirectories", "", "getMacOSDiagnosticReportDirectories", "()Ljava/util/List;", "CRASH_MAX_SIZE", "", "collectCrashInfo", "Lcom/intellij/diagnostic/CrashInfo;", "pid", "lastModified", "findExtraLogFile", "publisher", "Lcom/intellij/diagnostic/IdePerformanceListener;", "getPublisher", "()Lcom/intellij/diagnostic/IdePerformanceListener;", "cleanOldFiles", "level", "ageInDays", "file", "samplingInterval", "buildName", "dateFormat", "Ljava/time/format/DateTimeFormatter;", "formatTime", "time", "cleanup", "getStacktraceCommonPart", "Ljava/lang/StackTraceElement;", "commonPart", "stackTraceElements", "", "(Ljava/util/List;[Ljava/lang/StackTraceElement;)Ljava/util/List;", "compareStackTraceElements", "", "el1", "el2", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPerformanceWatcherImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerformanceWatcherImpl.kt\ncom/intellij/diagnostic/PerformanceWatcherImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,728:1\n13#2:729\n1400#3,2:730\n1#4:732\n1563#5:733\n1634#5,3:734\n183#6,2:737\n*S KotlinDebug\n*F\n+ 1 PerformanceWatcherImpl.kt\ncom/intellij/diagnostic/PerformanceWatcherImplKt\n*L\n60#1:729\n495#1:730,2\n630#1:733\n630#1:734,3\n657#1:737,2\n*E\n"})
public final class PerformanceWatcherImplKt {
    private static final long TOLERABLE_LATENCY = 100L;
    @NotNull
    private static final String THREAD_DUMPS_PREFIX = "threadDumps-";
    @NotNull
    private static final String DURATION_FILE_NAME = ".duration";
    @NotNull
    private static final String PID_FILE_NAME = ".pid";
    private static final ZonedDateTime ideStartTime = ZonedDateTime.now();
    @NotNull
    private static final ExtensionPointName<PerformanceListener> EP_NAME = new ExtensionPointName("com.intellij.idePerformanceListener");
    private static final int CRASH_MAX_SIZE = 0x500000;
    private static final long samplingInterval = 1000L;
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerformanceWatcherImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final Path postProcessReportFolder(long durationMs, SamplingTask task, Path dir, Path logDir) {
        if (Files.notExists(dir, new LinkOption[0])) {
            return null;
        }
        PerformanceWatcherImplKt.cleanup(dir);
        Path reportDir = logDir.resolve(PathsKt.getName((Path)dir) + PerformanceWatcherImplKt.getFreezePlaceSuffix(task) + "-" + TimeUnit.MILLISECONDS.toSeconds(durationMs) + "sec");
        try {
            Files.move(dir, reportDir, new CopyOption[0]);
        }
        catch (IOException e) {
            PerformanceWatcherImplKt.getLOG().warn("Unable to create freeze folder " + reportDir, (Throwable)e);
            reportDir = dir;
        }
        String message = "UI was frozen for " + durationMs + "ms, details saved to " + reportDir;
        if (DebugAttachDetector.isAttached()) {
            PerformanceWatcherImplKt.getLOG().info(message);
        } else if (ApplicationManagerEx.isInIntegrationTest()) {
            PerformanceWatcherImplKt.getLOG().error(message);
        } else {
            PerformanceWatcherImplKt.getLOG().warn(message);
        }
        return reportDir;
    }

    private static final String getFreezePlaceSuffix(SamplingTask task) {
        List<StackTraceElement> stacktraceCommonPart = null;
        Object object = UList.asIterable-impl((Object[])task.getThreadInfos-8e-EdQE()).iterator();
        while (object.hasNext()) {
            Object[] edtStack;
            ThreadInfo edt;
            ThreadInfo threadInfo;
            block3: {
                ThreadInfo[] info;
                ThreadInfo[] $this$firstOrNull$iv = info = (ThreadInfo[])object.next();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int j = 0; j < n; ++j) {
                    ThreadInfo element$iv;
                    ThreadInfo p0 = element$iv = $this$firstOrNull$iv[j];
                    boolean bl = false;
                    if (!ThreadDumper.isEDT((ThreadInfo)p0)) continue;
                    threadInfo = element$iv;
                    break block3;
                }
                threadInfo = null;
            }
            if (threadInfo == null || (edt = threadInfo).getStackTrace() == null) continue;
            stacktraceCommonPart = stacktraceCommonPart == null ? ArraysKt.toList((Object[])edtStack) : PerformanceWatcherImplKt.getStacktraceCommonPart(stacktraceCommonPart, (StackTraceElement[])edtStack);
        }
        object = stacktraceCommonPart;
        if (object == null || object.isEmpty()) {
            return "";
        }
        StackTraceElement element = (StackTraceElement)CollectionsKt.first(stacktraceCommonPart);
        String string = StringUtilRt.getShortName((String)element.getClassName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        String string2 = Sanitize_nameKt.sanitizeFileName$default((String)string, null, (boolean)false, null, (int)14, null);
        String string3 = element.getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMethodName(...)");
        return "-" + string2 + "." + Sanitize_nameKt.sanitizeFileName$default((String)string3, null, (boolean)false, null, (int)14, null);
    }

    /*
     * Unable to fully structure code
     */
    private static final Object reportCrashesIfAny(Continuation<? super Unit> $completion) {
        if (!($completion instanceof reportCrashesIfAny.1)) ** GOTO lbl-1000
        var11_1 = $completion;
        if ((var11_1.label & -2147483648) != 0) {
            var11_1.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PerformanceWatcherImplKt.access$reportCrashesIfAny((Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                systemDir = Path.of(PathManager.getSystemPath(), new String[0]);
                appInfoFile = systemDir.resolve(".appinfo");
                pidFile = systemDir.resolve(".pid");
                if (!SystemInfo.isJetBrainsJvm || !Files.isRegularFile(appInfoFile, new LinkOption[0]) || !Files.isRegularFile(pidFile, new LinkOption[0])) ** GOTO lbl69
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)systemDir);
                $continuation.L$1 = appInfoFile;
                $continuation.L$2 = pidFile;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CrashInfo>, Object>(pidFile, appInfoFile, null){
                    int label;
                    final /* synthetic */ Path $pidFile;
                    final /* synthetic */ Path $appInfoFile;
                    {
                        this.$pidFile = $pidFile;
                        this.$appInfoFile = $appInfoFile;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                String pid = Files.readString(this.$pidFile);
                                long appInfoFileLastModified = Files.getLastModifiedTime(this.$appInfoFile, new LinkOption[0]).toMillis();
                                Intrinsics.checkNotNull((Object)pid);
                                return PerformanceWatcherImplKt.access$collectCrashInfo(pid, appInfoFileLastModified);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super CrashInfo> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var12_3) {
                    return var12_3;
                }
                ** GOTO lbl30
            }
            case 1: {
                pidFile = (Path)$continuation.L$2;
                appInfoFile = (Path)$continuation.L$1;
                systemDir = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                if ((crashInfo = (CrashInfo)v0) != null) {
                    attachments = new ArrayList<E>();
                    if (crashInfo.getJvmCrashContent() != null) {
                        IdeaFreezeReporter.Companion.checkProfilerCrash$intellij_platform_ide_impl(crashInfo.getJvmCrashContent());
                        var6_12 = attachments;
                        it = var7_13 = new Attachment("crash.txt", crashInfo.getJvmCrashContent());
                        $i$a$-also-PerformanceWatcherImplKt$reportCrashesIfAny$2 = false;
                        it.setIncluded(true);
                        var6_12.add(var7_13);
                    }
                    var6_12 = attachments;
                    it = var7_13 = new Attachment("plugins.txt", SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)PluginManagerCore.getLoadedPlugins()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, reportCrashesIfAny$lambda$1(com.intellij.ide.plugins.IdeaPluginDescriptor ), (Lcom/intellij/ide/plugins/IdeaPluginDescriptor;)Ljava/lang/Boolean;)()), (Function1)reportCrashesIfAny.4.INSTANCE), (Function1)reportCrashesIfAny.5.INSTANCE), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, reportCrashesIfAny$lambda$2(com.intellij.internal.statistic.utils.PluginInfo ), (Lcom/intellij/internal/statistic/utils/PluginInfo;)Ljava/lang/String;)()), (CharSequence)"\n", (CharSequence)"Extra plugins:\n", null, (int)0, null, null, (int)60, null));
                    $i$a$-also-PerformanceWatcherImplKt$reportCrashesIfAny$7 = false;
                    it.setIncluded(true);
                    var6_12.add(var7_13);
                    if (crashInfo.getExtraJvmLog() != null) {
                        if (StringsKt.contains$default((CharSequence)crashInfo.getExtraJvmLog(), (CharSequence)"java.lang.OutOfMemoryError: Java heap space", (boolean)false, (int)2, null)) {
                            LowMemoryNotifier.showNotificationFromCrashAnalysis();
                        }
                        var6_12 = attachments;
                        it = var7_13 = new Attachment("jbr_err.txt", crashInfo.getExtraJvmLog());
                        $i$a$-also-PerformanceWatcherImplKt$reportCrashesIfAny$8 = false;
                        it.setIncluded(true);
                        var6_12.add(var7_13);
                    }
                    if (crashInfo.getOsCrashContent() != null) {
                        var6_12 = attachments;
                        it = var7_13 = new Attachment("process_crash.txt", crashInfo.getOsCrashContent());
                        $i$a$-also-PerformanceWatcherImplKt$reportCrashesIfAny$9 = false;
                        it.setIncluded(true);
                        var6_12.add(var7_13);
                    }
                    if (((v1 = crashInfo.getJvmCrashContent()) == null || (v1 = StringsKt.substringBefore$default((String)v1, (String)"---------------  P R O C E S S  ---------------", null, (int)2, null)) == null) && (v1 = crashInfo.getExtraJvmLog()) == null && (v1 = crashInfo.getOsCrashContent()) == null) {
                        v1 = "<no crash info retrieved>";
                    }
                    message = v1;
                    event = new LogMessage(new JBRCrash(), message, attachments);
                    event.setAppInfo(Files.readString(appInfoFile));
                    IdeaFreezeReporter.Companion.report$intellij_platform_ide_impl(event);
                    LifecycleUsageTriggerCollector.onCrashDetected();
                }
lbl69:
                // 4 sources

                Intrinsics.checkNotNull((Object)appInfoFile);
                IdeaFreezeReporter.Companion.saveAppInfo$intellij_platform_ide_impl(appInfoFile, true);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)systemDir);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)appInfoFile);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)pidFile);
                $continuation.label = 2;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(pidFile, null){
                    int label;
                    final /* synthetic */ Path $pidFile;
                    {
                        this.$pidFile = $pidFile;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Files.createDirectories(this.$pidFile.getParent(), new FileAttribute[0]);
                                return Files.writeString(this.$pidFile, (CharSequence)String.valueOf(ProcessHandle.current().pid()), new OpenOption[0]);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var12_3) {
                    return var12_3;
                }
                ** GOTO lbl85
            }
            case 2: {
                pidFile = (Path)$continuation.L$2;
                appInfoFile = (Path)$continuation.L$1;
                systemDir = (Path)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl85:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final List<String> getMacOSDiagnosticReportDirectories() {
        Object[] objectArray = new String[]{SystemProperties.getUserHome() + "/Library/Logs/DiagnosticReports", SystemProperties.getUserHome() + "/Library/Logs/DiagnosticReports/Retired"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final CrashInfo collectCrashInfo(String pid, long lastModified) {
        Object $i$a$-runCatching-PerformanceWatcherImplKt$collectCrashInfo$jbrErrContent$22;
        Object object5;
        Object object2;
        Object object3;
        try {
            Object object4;
            block40: {
                Iterable iterable;
                boolean object5 = false;
                Path path = Path.of(SystemProperties.getUserHome(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                Path path2 = path;
                object3 = Files.newDirectoryStream(path2, "*");
                Throwable throwable = null;
                try {
                    iterable = (DirectoryStream)object3;
                    Intrinsics.checkNotNull((Object)iterable);
                    Sequence entries2 = CollectionsKt.asSequence((Iterable)iterable);
                    boolean bl = false;
                    iterable = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)entries2, arg_0 -> PerformanceWatcherImplKt.collectCrashInfo$lambda$0$0$0(pid, lastModified, arg_0)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
                }
                Iterable crashFiles = iterable;
                object2 = ((Iterable)crashFiles).iterator();
                while (object2.hasNext()) {
                    String string;
                    Object file2 = (Path)object2.next();
                    boolean bl = false;
                    if (Files.size((Path)file2) > 0x500000L) {
                        PerformanceWatcherImplKt.getLOG().info("Crash file " + (Path)file2 + " is too big to report");
                        string = null;
                    } else {
                        string = Files.readString((Path)file2);
                    }
                    if ((file2 = string) == null) continue;
                    object4 = file2;
                    break block40;
                }
                object4 = null;
            }
            object5 = Result.constructor-impl(object4);
        }
        catch (Throwable throwable) {
            object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        String javaCrashContent = (String)LoggerKt.getOrLogException((Object)object5, (Logger)PerformanceWatcherImplKt.getLOG());
        if (javaCrashContent != null && StringsKt.contains$default((CharSequence)javaCrashContent, (CharSequence)"fuck_the_regulations", (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            String string;
            boolean $i$a$-runCatching-PerformanceWatcherImplKt$collectCrashInfo$jbrErrContent$22 = false;
            Path path = PerformanceWatcherImplKt.findExtraLogFile(pid, lastModified);
            if (path != null) {
                Path it = path;
                boolean bl = false;
                string = Files.readString(it);
            } else {
                string = null;
            }
            $i$a$-runCatching-PerformanceWatcherImplKt$collectCrashInfo$jbrErrContent$22 = Result.constructor-impl(string);
        }
        catch (Throwable it) {
            $i$a$-runCatching-PerformanceWatcherImplKt$collectCrashInfo$jbrErrContent$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
        }
        String jbrErrContent = (String)LoggerKt.getOrLogException((Object)$i$a$-runCatching-PerformanceWatcherImplKt$collectCrashInfo$jbrErrContent$22, (Logger)PerformanceWatcherImplKt.getLOG());
        try {
            String string;
            block44: {
                boolean bl = false;
                if (!SystemInfoRt.isMac) {
                    string = null;
                } else {
                    for (String reportsDir : PerformanceWatcherImplKt.getMacOSDiagnosticReportDirectories()) {
                        String osCrashContent;
                        String string2;
                        block43: {
                            Iterable reportFiles;
                            Iterable iterable;
                            Object object6 = Path.of(reportsDir, new String[0]);
                            Path p0 = object6;
                            boolean bl22 = false;
                            Object object7 = object2 = Files.isDirectory(p0, new LinkOption[0]) ? object6 : null;
                            if (object2 != null) {
                                object6 = object2;
                                Closeable bl22 = Files.newDirectoryStream((Path)object6, "*");
                                Throwable throwable = null;
                                try {
                                    Iterable iterable2 = (DirectoryStream)bl22;
                                    Intrinsics.checkNotNull((Object)iterable2);
                                    Sequence entries3 = CollectionsKt.asSequence((Iterable)iterable2);
                                    boolean bl3 = false;
                                    iterable2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)entries3, arg_0 -> PerformanceWatcherImplKt.collectCrashInfo$lambda$2$0$0(lastModified, arg_0)));
                                    iterable = iterable2;
                                }
                                catch (Throwable throwable3) {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)bl22, (Throwable)throwable);
                                }
                            } else {
                                iterable = null;
                            }
                            Iterable iterable3 = reportFiles = iterable;
                            if (iterable3 != null) {
                                for (Path file3 : (Iterable)iterable3) {
                                    String string3;
                                    String string4;
                                    block42: {
                                        boolean bl4 = false;
                                        if (Files.size(file3) > 0x500000L) {
                                            PerformanceWatcherImplKt.getLOG().info("OS crash file " + file3 + " is too big to process or report");
                                            string4 = null;
                                        } else {
                                            String content2 = Files.readString(file3);
                                            Intrinsics.checkNotNull((Object)content2);
                                            if (!StringsKt.contains$default((CharSequence)content2, (CharSequence)pid, (boolean)false, (int)2, null)) {
                                                string4 = null;
                                            } else {
                                                block41: {
                                                    try {
                                                        void $this$mapTo$iv$iv;
                                                        void $this$map$iv;
                                                        Object object8 = new String[]{"\r\n", "\n", "\r"};
                                                        List jsonObjects = SequencesKt.toList((Sequence)StringsKt.splitToSequence$default((CharSequence)content2, (String[])object8, (boolean)false, (int)2, (int)2, null));
                                                        if (!(jsonObjects.size() == 2)) {
                                                            boolean $i$a$-check-PerformanceWatcherImplKt$collectCrashInfo$osCrashContent$1$osCrashContent$1$22 = false;
                                                            String $i$a$-check-PerformanceWatcherImplKt$collectCrashInfo$osCrashContent$1$osCrashContent$1$22 = content2;
                                                            throw new IllegalStateException($i$a$-check-PerformanceWatcherImplKt$collectCrashInfo$osCrashContent$1$osCrashContent$1$22.toString());
                                                        }
                                                        Iterable $i$a$-check-PerformanceWatcherImplKt$collectCrashInfo$osCrashContent$1$osCrashContent$1$22 = jsonObjects;
                                                        Json.Default default_ = Json.Default;
                                                        boolean $i$f$map = false;
                                                        void var21_42 = $this$map$iv;
                                                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                        boolean $i$f$mapTo = false;
                                                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                                            void p02;
                                                            String string5 = (String)item$iv$iv;
                                                            Collection collection = destination$iv$iv;
                                                            boolean bl5 = false;
                                                            collection.add(default_.parseToJsonElement((String)p02));
                                                        }
                                                        object8 = (List)destination$iv$iv;
                                                        JsonElement metadata = (JsonElement)object8.get(0);
                                                        JsonElement report = (JsonElement)object8.get(1);
                                                        Intrinsics.checkNotNull((Object)metadata, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                                                        JsonObject cfr_ignored_0 = (JsonObject)metadata;
                                                        Intrinsics.checkNotNull((Object)report, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
                                                        JsonObject cfr_ignored_1 = (JsonObject)report;
                                                        if (!Intrinsics.areEqual((Object)((JsonObject)metadata).get((Object)"bug_type"), (Object)JsonElementKt.JsonPrimitive((String)"309")) || !Intrinsics.areEqual((Object)((JsonObject)report).get((Object)"pid"), (Object)JsonElementKt.JsonPrimitive((Number)Integer.parseInt(pid)))) break block41;
                                                        string4 = content2;
                                                        break block42;
                                                    }
                                                    catch (Exception e) {
                                                        PerformanceWatcherImplKt.getLOG().warn("failed to process MacOS diagnostic report " + file3, (Throwable)e);
                                                    }
                                                }
                                                string4 = null;
                                            }
                                        }
                                    }
                                    if ((string3 = string4) == null) continue;
                                    string2 = string3;
                                    break block43;
                                }
                                string2 = null;
                            } else {
                                string2 = null;
                            }
                        }
                        if ((string = (osCrashContent = string2)) == null) {
                            continue;
                        }
                        break block44;
                    }
                    string = null;
                }
            }
            object3 = Result.constructor-impl(string);
        }
        catch (Throwable throwable) {
            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        String osCrashContent = (String)LoggerKt.getOrLogException((Object)object3, (Logger)PerformanceWatcherImplKt.getLOG());
        return javaCrashContent != null || jbrErrContent != null || osCrashContent != null ? new CrashInfo(javaCrashContent, jbrErrContent, osCrashContent) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Path findExtraLogFile(String pid, long lastModified) {
        Object v1;
        block4: {
            void $this$firstOrNull$iv;
            if (!SystemInfo.isMac) {
                return null;
            }
            String logFileName = "jbr_err_pid" + pid + ".log";
            Sequence sequence = new Path[2];
            String[] stringArray = new String[]{logFileName};
            sequence[0] = Path.of(SystemProperties.getUserHome(), stringArray);
            sequence[1] = Path.of(logFileName, new String[0]);
            sequence = SequencesKt.sequenceOf((Object[])sequence);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                Path file2 = (Path)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)file2);
                if (PathKt.basicAttributesIfExists((Path)file2) != null) {
                    BasicFileAttributes it;
                    boolean bl3 = false;
                    bl = it.isRegularFile() && it.lastModifiedTime().toMillis() > lastModified;
                } else {
                    bl = false;
                }
                if (!bl) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        return v1;
    }

    private static final IdePerformanceListener getPublisher() {
        Application app = ApplicationManager.getApplication();
        return app == null || app.isDisposed() ? null : (IdePerformanceListener)app.getMessageBus().syncPublisher(IdePerformanceListener.TOPIC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void cleanOldFiles(Path dir, int level) {
        Object object;
        try {
            Iterable it;
            object = Files.newDirectoryStream(dir, arg_0 -> PerformanceWatcherImplKt.cleanOldFiles$lambda$1(arg_0 -> PerformanceWatcherImplKt.cleanOldFiles$lambda$0(level, arg_0), arg_0));
            Throwable throwable = null;
            try {
                it = (DirectoryStream)object;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                it = CollectionsKt.sorted((Iterable)it);
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = it;
        }
        catch (NoSuchFileException noSuchFileException) {
            return;
        }
        Closeable children2 = object;
        object = ((Iterable)((Object)children2)).iterator();
        int n = 0;
        while (object.hasNext()) {
            Path child;
            block12: {
                block11: {
                    int i2 = n++;
                    child = (Path)object.next();
                    if (i2 < children2.size() - 100) break block11;
                    Intrinsics.checkNotNull((Object)child);
                    if (PerformanceWatcherImplKt.ageInDays(child) <= 10L) break block12;
                }
                NioFiles.deleteRecursively((Path)child);
                continue;
            }
            if (level >= 3 || !Files.isDirectory(child, new LinkOption[0])) continue;
            PerformanceWatcherImplKt.cleanOldFiles(child, level + 1);
        }
    }

    private static final long ageInDays(Path file2) {
        return Duration.getInWholeDays-impl((long)DurationKt.toDuration((long)(System.currentTimeMillis() - Files.getLastModifiedTime(file2, new LinkOption[0]).toMillis()), (DurationUnit)DurationUnit.MILLISECONDS));
    }

    private static final String buildName() {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final String formatTime(ZonedDateTime time) {
        String string = dateFormat.format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private static final void cleanup(Path dir) {
        Files.deleteIfExists(dir.resolve(DURATION_FILE_NAME));
    }

    @NotNull
    public static final List<StackTraceElement> getStacktraceCommonPart(@NotNull List<StackTraceElement> commonPart, @NotNull StackTraceElement[] stackTraceElements) {
        Intrinsics.checkNotNullParameter(commonPart, (String)"commonPart");
        Intrinsics.checkNotNullParameter((Object)stackTraceElements, (String)"stackTraceElements");
        for (int i2 = 0; i2 < commonPart.size() && i2 < stackTraceElements.length; ++i2) {
            StackTraceElement el2;
            StackTraceElement el1 = commonPart.get(commonPart.size() - i2 - 1);
            if (PerformanceWatcherImplKt.compareStackTraceElements(el1, el2 = stackTraceElements[stackTraceElements.length - i2 - 1])) continue;
            return commonPart.subList(commonPart.size() - i2, commonPart.size());
        }
        return commonPart;
    }

    public static final boolean compareStackTraceElements(@NotNull StackTraceElement el1, @NotNull StackTraceElement el2) {
        Intrinsics.checkNotNullParameter((Object)el1, (String)"el1");
        Intrinsics.checkNotNullParameter((Object)el2, (String)"el2");
        return el1 == el2 || Intrinsics.areEqual((Object)el1.getClassName(), (Object)el2.getClassName()) && Intrinsics.areEqual((Object)el1.getMethodName(), (Object)el2.getMethodName()) && Intrinsics.areEqual((Object)el1.getFileName(), (Object)el2.getFileName());
    }

    private static final boolean reportCrashesIfAny$lambda$1(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isEnabled() && !it.isBundled();
    }

    private static final String reportCrashesIfAny$lambda$2(PluginInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getId() + " (" + it.getVersion() + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean collectCrashInfo$lambda$0$0$0(String $pid, long $lastModified, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)it), (String)"java_error_in", (boolean)false, (int)2, null)) return false;
        if (!StringsKt.endsWith$default((String)PathsKt.getName((Path)it), (String)($pid + ".log"), (boolean)false, (int)2, null)) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        FileTime fileTime = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
        if (fileTime.toMillis() <= $lastModified) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean collectCrashInfo$lambda$2$0$0(long $lastModified, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!StringsKt.endsWith$default((String)PathsKt.getName((Path)it), (String)".ips", (boolean)false, (int)2, null)) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        FileTime fileTime = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
        if (fileTime.toMillis() <= $lastModified) return false;
        return true;
    }

    private static final boolean cleanOldFiles$lambda$0(int $level, Path it) {
        return $level > 0 || StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)THREAD_DUMPS_PREFIX, (boolean)false, (int)2, null);
    }

    private static final boolean cleanOldFiles$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return PerformanceWatcherImplKt.getLOG();
    }

    public static final /* synthetic */ void access$cleanOldFiles(Path dir, int level) {
        PerformanceWatcherImplKt.cleanOldFiles(dir, level);
    }

    public static final /* synthetic */ ExtensionPointName access$getEP_NAME$p() {
        return EP_NAME;
    }

    public static final /* synthetic */ String access$formatTime(ZonedDateTime time) {
        return PerformanceWatcherImplKt.formatTime(time);
    }

    public static final /* synthetic */ ZonedDateTime access$getIdeStartTime$p() {
        return ideStartTime;
    }

    public static final /* synthetic */ String access$buildName() {
        return PerformanceWatcherImplKt.buildName();
    }

    public static final /* synthetic */ IdePerformanceListener access$getPublisher() {
        return PerformanceWatcherImplKt.getPublisher();
    }

    public static final /* synthetic */ Path access$postProcessReportFolder(long durationMs, SamplingTask task, Path dir, Path logDir) {
        return PerformanceWatcherImplKt.postProcessReportFolder(durationMs, task, dir, logDir);
    }

    public static final /* synthetic */ Object access$reportCrashesIfAny(Continuation $completion) {
        return PerformanceWatcherImplKt.reportCrashesIfAny((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ CrashInfo access$collectCrashInfo(String pid, long lastModified) {
        return PerformanceWatcherImplKt.collectCrashInfo(pid, lastModified);
    }
}

