/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.ShowTextPopupHyperlinkInfo;
import com.intellij.openapi.util.NlsSafe;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B!\b\u0016\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u001c\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/execution/filters/ArgumentFileFilter;", "Lcom/intellij/execution/filters/Filter;", "<init>", "()V", "filePath", "", "fileText", "(Ljava/lang/String;Ljava/lang/String;)V", "triggered", "", "setPath", "", "path", "charset", "Ljava/nio/charset/Charset;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "intellij.platform.ide.impl"})
public final class ArgumentFileFilter
implements Filter {
    @NlsSafe
    @Nullable
    private volatile String filePath;
    @NlsSafe
    @Nullable
    private volatile String fileText;
    private boolean triggered;

    public ArgumentFileFilter() {
    }

    public ArgumentFileFilter(@NlsSafe @Nullable String filePath, @NlsSafe @Nullable String fileText) {
        this();
        this.filePath = filePath;
        this.fileText = fileText;
    }

    @JvmOverloads
    public final void setPath(@NlsSafe @NotNull String path, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.filePath = path;
        this.fileText = FilesKt.readText((File)new File(path), (Charset)charset);
    }

    public static /* synthetic */ void setPath$default(ArgumentFileFilter argumentFileFilter, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        argumentFileFilter.setPath(string, charset);
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!this.triggered) {
            String path = this.filePath;
            String text2 = this.fileText;
            if (path == null || text2 == null) {
                this.triggered = true;
            } else {
                int p = StringsKt.indexOf$default((CharSequence)line, (String)path, (int)0, (boolean)false, (int)6, null);
                if (p > 0) {
                    this.triggered = true;
                    int offset = entireLength - line.length() + p;
                    return new Filter.Result(offset, offset + path.length(), (HyperlinkInfo)new ShowTextPopupHyperlinkInfo(path, text2));
                }
            }
        }
        return null;
    }

    @JvmOverloads
    public final void setPath(@NlsSafe @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ArgumentFileFilter.setPath$default(this, path, null, 2, null);
    }
}

