/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.impl.EditorHyperlinkEffectSupplier;
import com.intellij.execution.impl.EditorHyperlinkEffectSupport;
import com.intellij.execution.impl.EditorTextDecoration;
import com.intellij.execution.impl.EditorTextDecorationApplier;
import com.intellij.execution.impl.EditorTextDecorationApplierKt;
import com.intellij.execution.impl.EditorTextDecorationId;
import com.intellij.execution.impl.HighlightedTextDecoration;
import com.intellij.execution.impl.HyperlinkDecoration;
import com.intellij.execution.impl.HyperlinkOrHighlightingImpl;
import com.intellij.execution.impl.InlayDecorationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SlowOperations;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0003)*+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0016\u0010\u0018\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0016H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0016H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\nH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\r\u001a&\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\tj\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/execution/impl/EditorTextDecorationApplierImpl;", "Lcom/intellij/execution/impl/EditorTextDecorationApplier;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/Disposable;)V", "highlightersById", "Ljava/util/HashMap;", "Lcom/intellij/execution/impl/EditorTextDecorationId;", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "Lkotlin/collections/HashMap;", "inlaysById", "Lcom/intellij/openapi/editor/Inlay;", "effectSupport", "Lcom/intellij/execution/impl/EditorHyperlinkEffectSupport;", "hoveredHyperlink", "Lcom/intellij/execution/impl/HyperlinkDecoration;", "addDecorations", "", "decorations", "", "Lcom/intellij/execution/impl/EditorTextDecoration;", "removeDecorations", "decorationIds", "getHoveredHyperlink", "addHyperlinkOrHighlighting", "decoration", "Lcom/intellij/execution/impl/HyperlinkOrHighlightingImpl;", "addInlays", "inlays", "Lcom/intellij/execution/impl/InlayDecorationImpl;", "removeDecoration", "decorationId", "findDecoration", "Lcom/intellij/execution/impl/HighlightedTextDecoration;", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "offset", "", "MyMouseListener", "MyMouseMotionListener", "MyEffectSupplier", "intellij.platform.ide.impl"})
final class EditorTextDecorationApplierImpl
implements EditorTextDecorationApplier {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final HashMap<EditorTextDecorationId, RangeHighlighterEx> highlightersById;
    @NotNull
    private final HashMap<EditorTextDecorationId, Inlay<?>> inlaysById;
    @NotNull
    private final EditorHyperlinkEffectSupport effectSupport;
    @Nullable
    private HyperlinkDecoration hoveredHyperlink;

    public EditorTextDecorationApplierImpl(@NotNull EditorEx editor2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.editor = editor2;
        this.highlightersById = new HashMap();
        this.inlaysById = new HashMap();
        this.effectSupport = new EditorHyperlinkEffectSupport(this.editor, new MyEffectSupplier());
        this.editor.addEditorMouseListener(new MyMouseListener(), parentDisposable);
        this.editor.addEditorMouseMotionListener(new MyMouseMotionListener(), parentDisposable);
    }

    @Override
    public void addDecorations(@NotNull Collection<? extends EditorTextDecoration> decorations) {
        Intrinsics.checkNotNullParameter(decorations, (String)"decorations");
        List inlays = new ArrayList();
        for (EditorTextDecoration editorTextDecoration : decorations) {
            if (((Map)this.highlightersById).containsKey(editorTextDecoration.getId())) {
                EditorTextDecorationApplierKt.access$getLOG$p().warn("There's already a highlighter with the id " + editorTextDecoration.getId());
                continue;
            }
            if (((Map)this.inlaysById).containsKey(editorTextDecoration.getId())) {
                EditorTextDecorationApplierKt.access$getLOG$p().warn("There's already an inlay with the id " + editorTextDecoration.getId());
                continue;
            }
            EditorTextDecoration editorTextDecoration2 = editorTextDecoration;
            if (editorTextDecoration2 instanceof HyperlinkOrHighlightingImpl) {
                this.addHyperlinkOrHighlighting((HyperlinkOrHighlightingImpl)editorTextDecoration);
                continue;
            }
            if (editorTextDecoration2 instanceof InlayDecorationImpl) {
                ((Collection)inlays).add(editorTextDecoration);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        this.addInlays(inlays);
    }

    @Override
    public void removeDecorations(@NotNull Collection<? extends EditorTextDecorationId> decorationIds) {
        Intrinsics.checkNotNullParameter(decorationIds, (String)"decorationIds");
        for (EditorTextDecorationId editorTextDecorationId : decorationIds) {
            this.removeDecoration(editorTextDecorationId);
        }
    }

    @Override
    @Nullable
    public HyperlinkDecoration getHoveredHyperlink() {
        return this.hoveredHyperlink;
    }

    private final void addHyperlinkOrHighlighting(HyperlinkOrHighlightingImpl decoration) {
        this.editor.getMarkupModel().addRangeHighlighterAndChangeAttributes((TextAttributesKey)(decoration.getAction() != null ? CodeInsightColors.HYPERLINK_ATTRIBUTES : null), decoration.getStart(), decoration.getEnd(), decoration.getLayer(), HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> EditorTextDecorationApplierImpl.addHyperlinkOrHighlighting$lambda$1(arg_0 -> EditorTextDecorationApplierImpl.addHyperlinkOrHighlighting$lambda$0(decoration, this, arg_0), arg_0));
    }

    private final void addInlays(Collection<InlayDecorationImpl> inlays) {
        if (inlays.isEmpty()) {
            return;
        }
        this.editor.getInlayModel().execute(inlays.size() > 100, () -> EditorTextDecorationApplierImpl.addInlays$lambda$0(inlays, this));
    }

    private final void removeDecoration(EditorTextDecorationId decorationId) {
        RangeHighlighterEx highlighter = this.highlightersById.remove(decorationId);
        Inlay<?> inlay = this.inlaysById.remove(decorationId);
        if (highlighter == null && inlay == null) {
            EditorTextDecorationApplierKt.access$getLOG$p().warn("Decoration " + decorationId + " not found");
        } else if (highlighter != null && inlay != null) {
            EditorTextDecorationApplierKt.access$getLOG$p().warn("The ID " + decorationId + " corresponds to both an inlay and a highlighter");
        }
        if (highlighter != null) {
            this.editor.getMarkupModel().removeHighlighter((RangeHighlighter)highlighter);
        }
        if (inlay != null) {
            Disposer.dispose((Disposable)((Disposable)inlay));
        }
    }

    private final HighlightedTextDecoration findDecoration(EditorMouseEvent event) {
        if (!Intrinsics.areEqual((Object)event.getArea(), (Object)EditorMouseEventArea.EDITING_AREA) || !event.isOverText()) {
            return null;
        }
        return this.findDecoration(event.getOffset());
    }

    private final HighlightedTextDecoration findDecoration(int offset) {
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        this.editor.getMarkupModel().processRangeHighlightersOverlappingWith(offset, offset, arg_0 -> EditorTextDecorationApplierImpl.findDecoration$lambda$1(arg_0 -> EditorTextDecorationApplierImpl.findDecoration$lambda$0(offset, result2, arg_0), arg_0));
        return (HighlightedTextDecoration)result2.element;
    }

    private static final Unit addHyperlinkOrHighlighting$lambda$0(HyperlinkOrHighlightingImpl $decoration, EditorTextDecorationApplierImpl this$0, RangeHighlighterEx highlighter) {
        if ($decoration.getAttributes() != null) {
            highlighter.setTextAttributes($decoration.getAttributes());
        }
        highlighter.putUserData(EditorTextDecorationApplierKt.access$getHYPERLINK_OR_HIGHLIGHTING$p(), (Object)$decoration);
        ((Map)this$0.highlightersById).put($decoration.getId(), highlighter);
        return Unit.INSTANCE;
    }

    private static final void addHyperlinkOrHighlighting$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void addInlays$lambda$0(Collection $inlays, EditorTextDecorationApplierImpl this$0) {
        for (InlayDecorationImpl inlayFromFilter : $inlays) {
            Inlay<?> inlay = inlayFromFilter.getInlayProvider().createInlay(this$0.editor, inlayFromFilter.getOffset());
            if (inlay == null) continue;
            ((Map)this$0.inlaysById).put(inlayFromFilter.getId(), inlay);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findDecoration$lambda$0(int $offset, Ref.ObjectRef $result, RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNull((Object)highlighter);
        HyperlinkOrHighlightingImpl hyperlink = EditorTextDecorationApplierKt.access$getHyperlinkOrNull(highlighter);
        if (!highlighter.isValid()) return true;
        if (hyperlink == null) return true;
        int n = highlighter.getStartOffset();
        if ($offset >= highlighter.getEndOffset()) return true;
        if (n > $offset) return true;
        boolean bl = true;
        if (!bl) return true;
        $result.element = new HighlightedTextDecoration(hyperlink, highlighter);
        return false;
    }

    private static final boolean findDecoration$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/impl/EditorTextDecorationApplierImpl$MyEffectSupplier;", "Lcom/intellij/execution/impl/EditorHyperlinkEffectSupplier;", "<init>", "()V", "getFollowedHyperlinkAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "getHoveredHyperlinkAttributes", "intellij.platform.ide.impl"})
    private static final class MyEffectSupplier
    implements EditorHyperlinkEffectSupplier {
        @Override
        @Nullable
        public TextAttributes getFollowedHyperlinkAttributes(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            return EditorTextDecorationApplierKt.access$getHyperlink(highlighter).getFollowedAttributes();
        }

        @Override
        @Nullable
        public TextAttributes getHoveredHyperlinkAttributes(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            return EditorTextDecorationApplierKt.access$getHyperlink(highlighter).getHoveredAttributes();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/impl/EditorTextDecorationApplierImpl$MyMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "<init>", "(Lcom/intellij/execution/impl/EditorTextDecorationApplierImpl;)V", "mousePressedEvent", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mousePressed", "", "event", "mouseReleased", "mouseExited", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nEditorTextDecorationApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTextDecorationApplier.kt\ncom/intellij/execution/impl/EditorTextDecorationApplierImpl$MyMouseListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,495:1\n122#2,4:496\n*S KotlinDebug\n*F\n+ 1 EditorTextDecorationApplier.kt\ncom/intellij/execution/impl/EditorTextDecorationApplierImpl$MyMouseListener\n*L\n442#1:496,4\n*E\n"})
    private final class MyMouseListener
    implements EditorMouseListener {
        @Nullable
        private EditorMouseEvent mousePressedEvent;

        public void mousePressed(@NotNull EditorMouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.mousePressedEvent = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void mouseReleased(@NotNull EditorMouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EditorMouseEvent editorMouseEvent = this.mousePressedEvent;
            MouseEvent mousePressedEvent = editorMouseEvent != null ? editorMouseEvent.getMouseEvent() : null;
            this.mousePressedEvent = null;
            MouseEvent mouseEvent = event.getMouseEvent();
            Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
            MouseEvent mouseReleasedEvent = mouseEvent;
            int sensitivity = EditorImpl.dragSensitivity();
            if (mouseReleasedEvent.getButton() == 1 && !mouseReleasedEvent.isPopupTrigger() && mousePressedEvent != null && Intrinsics.areEqual((Object)mousePressedEvent.getComponent(), (Object)mouseReleasedEvent.getComponent()) && Math.abs(mousePressedEvent.getPoint().x - mouseReleasedEvent.getPoint().x) < sensitivity && Math.abs(mousePressedEvent.getPoint().y - mouseReleasedEvent.getPoint().y) < sensitivity) {
                Function1<EditorMouseEvent, Unit> action2;
                HighlightedTextDecoration hyperlink = EditorTextDecorationApplierImpl.this.findDecoration(event);
                Object object = hyperlink;
                Function1<EditorMouseEvent, Unit> function1 = object != null && (object = ((HighlightedTextDecoration)object).getLink()) != null ? ((HyperlinkOrHighlightingImpl)object).getAction() : (action2 = null);
                if (action2 != null) {
                    void $this$getOrHandleException$iv;
                    Object $this$mouseReleased_u24lambda_u240;
                    Object object2 = this;
                    try {
                        $this$mouseReleased_u24lambda_u240 = object2;
                        boolean bl = false;
                        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.startSection((String)"action.perform");
                        Throwable throwable = null;
                        try {
                            AccessToken it = (AccessToken)autoCloseable;
                            boolean bl2 = false;
                            action2.invoke((Object)event);
                            it = Unit.INSTANCE;
                        }
                        catch (Throwable bl2) {
                            throwable = bl2;
                            throw bl2;
                        }
                        finally {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        }
                        $this$mouseReleased_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        $this$mouseReleased_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object2 = $this$mouseReleased_u24lambda_u240;
                    boolean $i$f$getOrHandleException = false;
                    void var9_12 = $this$getOrHandleException$iv;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)var9_12);
                    if (throwable != null) {
                        Throwable e$iv = throwable;
                        boolean bl = false;
                        LoggerKt.rethrowControlFlowException((Throwable)e$iv);
                        Throwable e = e$iv;
                        boolean bl3 = false;
                        EditorTextDecorationApplierKt.access$getLOG$p().error("The hyperlink handler threw an exception, hyperlink = " + hyperlink, e);
                    }
                    if (Result.isFailure-impl((Object)var9_12)) {
                        // empty if block
                    }
                    EditorTextDecorationApplierImpl.this.effectSupport.linkFollowed((RangeHighlighter)hyperlink.getHighlighter());
                    event.consume();
                }
            }
        }

        public void mouseExited(@NotNull EditorMouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EditorTextDecorationApplierImpl.this.effectSupport.linkHovered(null);
            EditorTextDecorationApplierImpl.this.hoveredHyperlink = null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/impl/EditorTextDecorationApplierImpl$MyMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "<init>", "(Lcom/intellij/execution/impl/EditorTextDecorationApplierImpl;)V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.platform.ide.impl"})
    private final class MyMouseMotionListener
    implements EditorMouseMotionListener {
        public void mouseMoved(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            HighlightedTextDecoration highlightedLink = EditorTextDecorationApplierImpl.this.findDecoration(e);
            Object object = highlightedLink;
            if ((object != null && (object = ((HighlightedTextDecoration)object).getLink()) != null ? ((HyperlinkOrHighlightingImpl)object).getAction() : null) == null) {
                EditorTextDecorationApplierImpl.this.editor.setCustomCursor(EditorTextDecorationApplierImpl.class, null);
                EditorTextDecorationApplierImpl.this.effectSupport.linkHovered(null);
                EditorTextDecorationApplierImpl.this.hoveredHyperlink = null;
            } else {
                EditorTextDecorationApplierImpl.this.editor.setCustomCursor(EditorTextDecorationApplierImpl.class, Cursor.getPredefinedCursor(12));
                EditorTextDecorationApplierImpl.this.effectSupport.linkHovered((RangeHighlighter)highlightedLink.getHighlighter());
                EditorTextDecorationApplierImpl.this.hoveredHyperlink = highlightedLink.getLink();
            }
        }
    }
}

