/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl.ui;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WindowsRootsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getBestWindowsPathFromLinuxPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "distro", "Lcom/intellij/execution/wsl/WSLDistribution;", "linuxPath", "", "getRootsForFileDescriptor", "", "accessWindowsFs", "", "createFileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWslPathBrowserModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslPathBrowserModel.kt\ncom/intellij/execution/wsl/ui/WslPathBrowserModelKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1#2:65\n1#2:76\n1617#3,9:66\n1869#3:75\n1870#3:77\n1626#3:78\n*S KotlinDebug\n*F\n+ 1 WslPathBrowserModel.kt\ncom/intellij/execution/wsl/ui/WslPathBrowserModelKt\n*L\n51#1:76\n51#1:66,9\n51#1:75\n51#1:77\n51#1:78\n*E\n"})
public final class WslPathBrowserModelKt {
    @NotNull
    private static final Logger logger;

    @Nullable
    public static final VirtualFile getBestWindowsPathFromLinuxPath(@NotNull WSLDistribution distro, @NotNull String linuxPath) {
        Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem fs = localFileSystem;
        VirtualFile file2 = null;
        String linuxPath2 = ((Object)StringsKt.trim((CharSequence)linuxPath)).toString();
        logger.info("Open " + linuxPath2 + " in " + distro.getUNCRootPath() + FileUtil.toSystemDependentName((String)FileUtil.normalize((String)linuxPath2)));
        String it = distro.getWindowsPath(linuxPath2);
        boolean bl = false;
        String fileName = it;
        while (file2 == null && fileName != null) {
            file2 = fs.findFileByPath(fileName);
            fileName = new File(fileName).getParent();
        }
        if (file2 == null) {
            logger.warn("Failed to find file " + linuxPath2);
        }
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> getRootsForFileDescriptor(@NotNull WSLDistribution distro, boolean accessWindowsFs) {
        VirtualFile it;
        Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem fs = localFileSystem;
        List roots = new ArrayList();
        VirtualFile virtualFile = fs.findFileByNioFile(distro.getUNCRootPath());
        if (virtualFile != null) {
            it = virtualFile;
            boolean bl = false;
            roots.add(it);
        }
        if (accessWindowsFs) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = WindowsRootsKt.listWindowsLocalDriveRoots();
            List list2 = roots;
            boolean $i$f$mapNotNull = false;
            it = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Path it2 = (Path)element$iv$iv;
                boolean bl2 = false;
                if (fs.findFileByNioFile(it2) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2.addAll((List)destination$iv$iv);
        }
        return roots;
    }

    @NotNull
    public static final FileChooserDescriptor createFileChooserDescriptor(@NotNull WSLDistribution distro, boolean accessWindowsFs) {
        FileChooserDescriptor fileChooserDescriptor2;
        Intrinsics.checkNotNullParameter((Object)distro, (String)"distro");
        List<VirtualFile> roots = WslPathBrowserModelKt.getRootsForFileDescriptor(distro, accessWindowsFs);
        FileChooserDescriptor $this$createFileChooserDescriptor_u24lambda_u240 = fileChooserDescriptor2 = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
        boolean bl = false;
        $this$createFileChooserDescriptor_u24lambda_u240.withRoots(roots);
        FileChooserDescriptor fileChooserDescriptor3 = fileChooserDescriptor2;
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor3, (String)"apply(...)");
        return fileChooserDescriptor3;
    }

    static {
        Logger logger = Logger.getInstance((String)"WslPathBrowser");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WslPathBrowserModelKt.logger = logger;
    }
}

