/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.CompletionStatistics;
import com.intellij.featureStatistics.CumulativeStatistics;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeaturesRegistryListener;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.local.ActionsLocalSummary;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FeatureUsageStatistics", storages={@Storage(value="features.usage.statistics.xml", roamingType=RoamingType.DISABLED, usePathMacroManager=false), @Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED, deprecated=true)})
@ApiStatus.Internal
public final class FeatureUsageTrackerImpl
extends FeatureUsageTracker
implements PersistentStateComponent<Element> {
    public static final String FEATURES_USAGE_STATISTICS_XML = "features.usage.statistics.xml";
    private static final int HOUR = 3600000;
    private static final long DAY = 86400000L;
    private long FIRST_RUN_TIME = 0L;
    private CompletionStatistics myCompletionStats = new CompletionStatistics();
    private CumulativeStatistics myFixesStats = new CumulativeStatistics();
    boolean HAVE_BEEN_SHOWN = false;
    @NonNls
    private static final String FEATURE_TAG = "feature";
    @NonNls
    private static final String ATT_SHOW_IN_OTHER = "show-in-other";
    @NonNls
    private static final String ATT_SHOW_IN_COMPILATION = "show-in-compilation";
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_FIRST_RUN = "first-run";
    @NonNls
    private static final String COMPLETION_STATS_TAG = "completionStatsTag";
    @NonNls
    private static final String FIXES_STATS_TAG = "fixesStatsTag";
    @NonNls
    private static final String ATT_HAVE_BEEN_SHOWN = "have-been-shown";

    public boolean isToBeShown(String featureId, Project project2) {
        return this.isToBeShown(featureId, project2, 86400000L);
    }

    private boolean isToBeShown(String featureId, Project project2, long timeUnit) {
        ApplicabilityFilter[] filters;
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        if (registry == null) {
            return false;
        }
        FeatureDescriptor descriptor = registry.getFeatureDescriptor(featureId);
        if (descriptor == null || !descriptor.isUnused()) {
            return false;
        }
        String[] dependencyFeatures = descriptor.getDependencyFeatures();
        boolean locked = dependencyFeatures.length > 0;
        for (int i2 = 0; locked && i2 < dependencyFeatures.length; ++i2) {
            if (registry.getFeatureDescriptor(dependencyFeatures[i2]).isUnused()) continue;
            locked = false;
        }
        if (locked) {
            return false;
        }
        for (ApplicabilityFilter filter2 : filters = registry.getMatchingFilters(featureId)) {
            if (filter2.isApplicable(featureId, project2)) continue;
            return false;
        }
        long current = System.currentTimeMillis();
        long succesive_interval = (long)descriptor.getDaysBetweenSuccessiveShowUps() * timeUnit + (long)descriptor.getShownCount() * 2L;
        long firstShowUpInterval = (long)descriptor.getDaysBeforeFirstShowUp() * timeUnit;
        long lastTimeUsed = descriptor.getLastTimeUsed();
        long lastTimeShown = descriptor.getLastTimeShown();
        return lastTimeShown == 0L && firstShowUpInterval + this.getFirstRunTime() < current || lastTimeShown > 0L && current - lastTimeShown > succesive_interval && current - lastTimeUsed > succesive_interval;
    }

    public boolean isToBeAdvertisedInLookup(@NonNls String featureId, Project project2) {
        FeatureDescriptor descriptor;
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        if (registry != null && (descriptor = registry.getFeatureDescriptor(featureId)) != null && System.currentTimeMillis() - descriptor.getLastTimeUsed() > 864000000L) {
            return true;
        }
        return this.isToBeShown(featureId, project2, 3600000L);
    }

    @NotNull
    public CompletionStatistics getCompletionStatistics() {
        CompletionStatistics completionStatistics = this.myCompletionStats;
        if (completionStatistics == null) {
            FeatureUsageTrackerImpl.$$$reportNull$$$0(0);
        }
        return completionStatistics;
    }

    public CumulativeStatistics getFixesStats() {
        return this.myFixesStats;
    }

    public long getFirstRunTime() {
        if (this.FIRST_RUN_TIME == 0L) {
            this.FIRST_RUN_TIME = System.currentTimeMillis();
        }
        return this.FIRST_RUN_TIME;
    }

    public void loadState(@NotNull Element element) {
        Element fStats;
        ProductivityFeaturesRegistry featureRegistry;
        List featuresList;
        if (element == null) {
            FeatureUsageTrackerImpl.$$$reportNull$$$0(1);
        }
        if (!(featuresList = element.getChildren(FEATURE_TAG)).isEmpty() && (featureRegistry = ProductivityFeaturesRegistry.getInstance()) != null) {
            for (Element itemElement : featuresList) {
                FeatureDescriptor descriptor = featureRegistry.getFeatureDescriptor(itemElement.getAttributeValue(ATT_ID));
                if (descriptor == null) continue;
                descriptor.readStatistics(itemElement);
            }
        }
        FeatureUsageTrackerImpl.adjustFeatureUsageInfo();
        try {
            this.FIRST_RUN_TIME = Long.parseLong(element.getAttributeValue(ATT_FIRST_RUN));
        }
        catch (NumberFormatException e) {
            this.FIRST_RUN_TIME = 0L;
        }
        Element stats = element.getChild(COMPLETION_STATS_TAG);
        if (stats != null) {
            this.myCompletionStats = (CompletionStatistics)com.intellij.util.xmlb.XmlSerializer.deserialize((Element)stats, CompletionStatistics.class);
        }
        if ((fStats = element.getChild(FIXES_STATS_TAG)) != null) {
            this.myFixesStats = (CumulativeStatistics)com.intellij.util.xmlb.XmlSerializer.deserialize((Element)fStats, CumulativeStatistics.class);
        }
        this.HAVE_BEEN_SHOWN = Boolean.valueOf(element.getAttributeValue(ATT_HAVE_BEEN_SHOWN));
        this.SHOW_IN_OTHER_PROGRESS = Boolean.valueOf(element.getAttributeValue(ATT_SHOW_IN_OTHER, Boolean.toString(true)));
        this.SHOW_IN_COMPILATION_PROGRESS = Boolean.valueOf(element.getAttributeValue(ATT_SHOW_IN_COMPILATION, Boolean.toString(true)));
    }

    private static void adjustFeatureUsageInfo() {
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        if (registry == null) {
            return;
        }
        ActionsLocalSummary actionsSummary = (ActionsLocalSummary)ApplicationManager.getApplication().getService(ActionsLocalSummary.class);
        registry.getFeatureIds().stream().map(id2 -> registry.getFeatureDescriptor(id2)).forEach(feature -> {
            List summary = ContainerUtil.mapNotNull((Collection)feature.getActionEvents(), action2 -> actionsSummary.getActionStatsById(action2.getActionId()));
            int adjustedUsageCount = summary.stream().map(s -> s.usageCount).reduce(Integer::sum).orElse(0);
            long adjustedLastTimeUsed = summary.stream().map(s -> s.lastUsedTimestamp).max(Long::compare).orElse(0L);
            feature.adjustUsageInfo(adjustedUsageCount, adjustedLastTimeUsed);
        });
    }

    public Element getState() {
        Element element = new Element("state");
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        if (registry != null) {
            Set ids = registry.getFeatureIds();
            for (String id2 : ids) {
                Element featureElement = new Element(FEATURE_TAG);
                featureElement.setAttribute(ATT_ID, id2);
                FeatureDescriptor descriptor = registry.getFeatureDescriptor(id2);
                descriptor.writeStatistics(featureElement);
                element.addContent(featureElement);
            }
        }
        Element statsTag = new Element(COMPLETION_STATS_TAG);
        XmlSerializer.getJdomSerializer().serializeObjectInto((Object)this.myCompletionStats, statsTag, (SerializationFilter)XmlSerializer.getJdomSerializer().getDefaultSerializationFilter());
        element.addContent(statsTag);
        Element fstatsTag = new Element(FIXES_STATS_TAG);
        XmlSerializer.getJdomSerializer().serializeObjectInto((Object)this.myFixesStats, fstatsTag, (SerializationFilter)XmlSerializer.getJdomSerializer().getDefaultSerializationFilter());
        element.addContent(fstatsTag);
        element.setAttribute(ATT_FIRST_RUN, String.valueOf(this.getFirstRunTime()));
        element.setAttribute(ATT_HAVE_BEEN_SHOWN, String.valueOf(this.HAVE_BEEN_SHOWN));
        element.setAttribute(ATT_SHOW_IN_OTHER, String.valueOf(this.SHOW_IN_OTHER_PROGRESS));
        element.setAttribute(ATT_SHOW_IN_COMPILATION, String.valueOf(this.SHOW_IN_COMPILATION_PROGRESS));
        return element;
    }

    public void triggerFeatureUsed(@NotNull String featureId) {
        ProductivityFeaturesRegistry registry;
        FeatureDescriptor descriptor;
        if (featureId == null) {
            FeatureUsageTrackerImpl.$$$reportNull$$$0(2);
        }
        FeatureDescriptor featureDescriptor = descriptor = (registry = ProductivityFeaturesRegistry.getInstance()) == null ? null : registry.getFeatureDescriptor(featureId);
        if (descriptor == null) {
            return;
        }
        descriptor.triggerUsed();
        Class provider = descriptor.getProvider();
        String id2 = provider == null || PluginInfoDetectorKt.getPluginInfo((Class)provider).isDevelopedByJetBrains() ? descriptor.getId() : "third.party";
        ProductivityUsageCollector.FEATURE_USED.log((Object)id2, (Object)StringUtil.notNullize((String)descriptor.getGroupId(), (String)"unknown"), (Object)(provider == null ? null : PluginInfoDetectorKt.getPluginInfo((Class)provider)));
        ((FeaturesRegistryListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(FeaturesRegistryListener.TOPIC)).featureUsed(descriptor);
    }

    public void triggerFeatureUsedByAction(@NotNull String actionId) {
        if (actionId == null) {
            FeatureUsageTrackerImpl.$$$reportNull$$$0(3);
        }
        FeatureUsageTrackerImpl.triggerFeatureUsed((Function<? super ProductivityFeaturesRegistry, ? extends FeatureDescriptor>)((Function)registry -> registry.findFeatureByAction(actionId)));
    }

    public void triggerFeatureUsedByIntention(@NotNull Class<?> intentionClass) {
        if (intentionClass == null) {
            FeatureUsageTrackerImpl.$$$reportNull$$$0(4);
        }
        FeatureUsageTrackerImpl.triggerFeatureUsed((Function<? super ProductivityFeaturesRegistry, ? extends FeatureDescriptor>)((Function)registry -> registry.findFeatureByIntention(intentionClass)));
    }

    public void triggerFeatureShown(String featureId) {
        FeatureDescriptor descriptor;
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        if (registry != null && (descriptor = registry.getFeatureDescriptor(featureId)) != null) {
            descriptor.triggerShown();
        }
    }

    private static void triggerFeatureUsed(Function<? super ProductivityFeaturesRegistry, ? extends FeatureDescriptor> featureGetter) {
        FeatureDescriptor feature;
        ProductivityFeaturesRegistry featuresRegistry = ProductivityFeaturesRegistry.getInstance();
        if (featuresRegistry != null && (feature = (FeatureDescriptor)featureGetter.fun((Object)featuresRegistry)) != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(feature.getId());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/FeatureUsageTrackerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionStatistics";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/FeatureUsageTrackerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "triggerFeatureUsed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "triggerFeatureUsedByAction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "triggerFeatureUsedByIntention";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static final class ProductivityUsageCollector
    extends CounterUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("productivity", 59);
        private static final EventId3<String, String, PluginInfo> FEATURE_USED = GROUP.registerEvent("feature.used", (EventField)EventFields.StringValidatedByCustomRule((String)"id", ProductivityUtilValidator.class), (EventField)EventFields.StringValidatedByCustomRule((String)"group", ProductivityUtilValidator.class), (EventField)EventFields.PluginInfo);

        private ProductivityUsageCollector() {
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }
    }

    @ApiStatus.Internal
    public static final class ProductivityUtilValidator
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "productivity";
        }

        public boolean acceptRuleId(@Nullable String ruleId) {
            return this.getRuleId().equals(ruleId) || "productivity_group".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            String group2;
            if (data2 == null) {
                ProductivityUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ProductivityUtilValidator.$$$reportNull$$$0(1);
            }
            if (ProductivityUtilValidator.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    ProductivityUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            String id2 = this.getEventDataField(context, FeatureUsageTrackerImpl.ATT_ID);
            if (ProductivityUtilValidator.isValid(data2, id2, group2 = this.getEventDataField(context, "group"))) {
                FeatureDescriptor descriptor;
                ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
                FeatureDescriptor featureDescriptor = descriptor = registry == null ? null : registry.getFeatureDescriptor(id2);
                if (descriptor != null) {
                    String actualGroup = descriptor.getGroupId();
                    if (StringUtil.equals((CharSequence)group2, (CharSequence)"unknown") || StringUtil.equals((CharSequence)group2, (CharSequence)actualGroup)) {
                        Class provider = descriptor.getProvider();
                        PluginInfo info = provider == null ? PluginInfoDetectorKt.getPlatformPlugin() : PluginInfoDetectorKt.getPluginInfo((Class)provider);
                        ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                        if (validationResultType == null) {
                            ProductivityUtilValidator.$$$reportNull$$$0(3);
                        }
                        return validationResultType;
                    }
                }
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                ProductivityUtilValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static boolean isValid(@NotNull String data2, String id2, String group2) {
            if (data2 == null) {
                ProductivityUtilValidator.$$$reportNull$$$0(5);
            }
            return id2 != null && group2 != null && (data2.equals(id2) || data2.equals(group2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/featureStatistics/FeatureUsageTrackerImpl$ProductivityUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/featureStatistics/FeatureUsageTrackerImpl$ProductivityUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

