/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.diagnostic.PlatformMemoryUtil;
import com.intellij.ide.AppIdleMemoryCleanerKt;
import com.intellij.ide.AppIdleMemoryCleanerUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.DirectByteBufferAllocator;
import java.lang.management.ManagementFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0086\b\u00f8\u0001\u0000J\u001a\u0010\u0013\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0086\b\u00f8\u0001\u0000J\u0006\u0010\u0014\u001a\u00020\u0004J\b\u0010\u0015\u001a\u00020\u0004H\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0002J\u0006\u0010\u0017\u001a\u00020\u0010J\b\u0010\u0018\u001a\u00020\u0010H\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0012\u0010\b\u001a\u00060\tR\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/MemoryCleaningStats;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "durationSinceLastCleanupNanos", "", "<init>", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "memStatsProvider", "Lcom/intellij/diagnostic/PlatformMemoryUtil$MemoryStatsProvider;", "Lcom/intellij/diagnostic/PlatformMemoryUtil;", "memoryUsageBytesBeforeCleanup", "gcDurationNanos", "gcCleanedMb", "directBuffersCleanedMb", "measureGc", "", "action", "Lkotlin/Function0;", "measureDirectBuffers", "getDirectBuffersAllocatedBytes", "getCommittedHeapBytes", "getTotal2MemoryUsage", "logToFus", "close", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAppIdleMemoryCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppIdleMemoryCleaner.kt\ncom/intellij/ide/MemoryCleaningStats\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,285:1\n45#2,3:286\n1#3:289\n60#4,5:290\n*S KotlinDebug\n*F\n+ 1 AppIdleMemoryCleaner.kt\ncom/intellij/ide/MemoryCleaningStats\n*L\n242#1:286,3\n276#1:290,5\n*E\n"})
final class MemoryCleaningStats
implements AutoCloseable {
    @Nullable
    private final Long durationSinceLastCleanupNanos;
    @NotNull
    private final PlatformMemoryUtil.MemoryStatsProvider memStatsProvider;
    private final long memoryUsageBytesBeforeCleanup;
    private long gcDurationNanos;
    private long gcCleanedMb;
    private long directBuffersCleanedMb;

    public MemoryCleaningStats(@Nullable Long durationSinceLastCleanupNanos) {
        this.durationSinceLastCleanupNanos = durationSinceLastCleanupNanos;
        this.memStatsProvider = PlatformMemoryUtil.Companion.getInstance().newMemoryStatsProvider();
        this.memoryUsageBytesBeforeCleanup = this.getTotal2MemoryUsage();
        this.gcDurationNanos = -1L;
        this.gcCleanedMb = -1L;
        this.directBuffersCleanedMb = -1L;
    }

    public final void measureGc(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$measureGc = false;
        long oldUsage = this.getCommittedHeapBytes();
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        MemoryCleaningStats memoryCleaningStats = this;
        boolean bl = false;
        action2.invoke();
        memoryCleaningStats.gcDurationNanos = System.nanoTime() - start$iv;
        this.gcCleanedMb = AppIdleMemoryCleanerKt.access$toMB(oldUsage - this.getCommittedHeapBytes());
    }

    public final void measureDirectBuffers(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$measureDirectBuffers = false;
        long oldUsage = this.getDirectBuffersAllocatedBytes();
        action2.invoke();
        this.directBuffersCleanedMb = AppIdleMemoryCleanerKt.access$toMB(oldUsage - this.getDirectBuffersAllocatedBytes());
    }

    public final long getDirectBuffersAllocatedBytes() {
        return DirectByteBufferAllocator.ALLOCATOR.getStatistics().totalSizeOfBuffersAllocatedInBytes;
    }

    private final long getCommittedHeapBytes() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getCommitted();
    }

    private final long getTotal2MemoryUsage() {
        PlatformMemoryUtil.MemoryStats memoryStats = this.memStatsProvider.getCurrentProcessMemoryStats();
        return memoryStats != null ? memoryStats.getRamPlusSwapMinusFileMappings() : 0L;
    }

    /*
     * WARNING - void declaration
     */
    public final void logToFus() {
        long l;
        AppIdleMemoryCleanerUsagesCollector appIdleMemoryCleanerUsagesCollector;
        long memoryUsageBytesAfterCleanup = this.getTotal2MemoryUsage();
        AppIdleMemoryCleanerUsagesCollector appIdleMemoryCleanerUsagesCollector2 = AppIdleMemoryCleanerUsagesCollector.INSTANCE;
        Long l2 = this.durationSinceLastCleanupNanos;
        if (l2 != null) {
            void it;
            long l3 = ((Number)l2).longValue();
            appIdleMemoryCleanerUsagesCollector = appIdleMemoryCleanerUsagesCollector2;
            boolean bl = false;
            void var11_6 = it / (long)1000000;
            appIdleMemoryCleanerUsagesCollector2 = appIdleMemoryCleanerUsagesCollector;
            l = var11_6;
        } else {
            l = -1L;
        }
        appIdleMemoryCleanerUsagesCollector2.memoryCleanupPerformed$intellij_platform_ide_impl(l, this.gcDurationNanos / (long)1000000, AppIdleMemoryCleanerKt.access$toMB(this.memoryUsageBytesBeforeCleanup), AppIdleMemoryCleanerKt.access$toMB(memoryUsageBytesAfterCleanup), this.gcCleanedMb, this.directBuffersCleanedMb);
        long totalCleanedMb = AppIdleMemoryCleanerKt.access$toMB(this.memoryUsageBytesBeforeCleanup - memoryUsageBytesAfterCleanup);
        Logger $this$debug_u24default$iv = AppIdleMemoryCleanerKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            appIdleMemoryCleanerUsagesCollector = $this$debug_u24default$iv;
            boolean bl = false;
            appIdleMemoryCleanerUsagesCollector.debug("Performed memory cleanup. Cleaned: " + totalCleanedMb + " MB", e$iv);
        }
    }

    @Override
    public void close() {
        this.memStatsProvider.close();
    }
}

