/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ProjectGroup;
import com.intellij.openapi.util.text.NaturalComparator;
import java.util.Comparator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/ProjectGroupComparator;", "Ljava/util/Comparator;", "Lcom/intellij/ide/ProjectGroup;", "Lkotlin/Comparator;", "projectPaths", "", "", "<init>", "(Ljava/util/Set;)V", "compare", "", "o1", "o2", "getGroupIndex", "group", "intellij.platform.ide.impl"})
final class ProjectGroupComparator
implements Comparator<ProjectGroup> {
    @NotNull
    private final Set<String> projectPaths;

    public ProjectGroupComparator(@NotNull Set<String> projectPaths) {
        Intrinsics.checkNotNullParameter(projectPaths, (String)"projectPaths");
        this.projectPaths = projectPaths;
    }

    @Override
    public int compare(@NotNull ProjectGroup o1, @NotNull ProjectGroup o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        int index1 = this.getGroupIndex(o1);
        int index2 = this.getGroupIndex(o2);
        return index1 == index2 ? NaturalComparator.INSTANCE.compare(o1.getName(), o2.getName()) : index1 - index2;
    }

    private final int getGroupIndex(ProjectGroup group2) {
        int index = Integer.MAX_VALUE;
        for (String path : group2.getProjects()) {
            int i2 = CollectionsKt.indexOf((Iterable)this.projectPaths, (Object)path);
            boolean bl = 0 <= i2 ? i2 < index : false;
            if (!bl) continue;
            index = i2;
        }
        return index;
    }
}

